/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import weblogic.corba.rmic.IDLKeywords;

public class IDLMangler
implements IDLKeywords {
    private static String SEQ = "seq";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";
    public static final String GETTER = "_get_";
    public static final String SETTER = "_set_";
    public static final String DOT = ".";
    public static final String DOUBLEUNDERSCORE = "__";
    public static final String UNDERSCORE = "_";
    public static String BOXED_IDL = ".org.omg.boxedIDL.";
    public static String BOXED_RMI = ".org.omg.boxedRMI";
    private static final java.lang.Object[][] typeMapping = new java.lang.Object[][]{{null, ""}, {Void.TYPE, "void"}, {Boolean.TYPE, "boolean"}, {Character.TYPE, "wchar"}, {Byte.TYPE, "octet"}, {Short.TYPE, "short"}, {Integer.TYPE, "long"}, {Long.TYPE, "long long"}, {Float.TYPE, "float"}, {Double.TYPE, "double"}, {String.class, ".CORBA.WStringValue"}, {java.lang.Object.class, ".java.lang._Object"}, {Class.class, ".javax.rmi.CORBA.ClassDesc"}, {Serializable.class, ".java.io.Serializable"}, {Externalizable.class, ".java.io.Externalizable"}, {Object.class, "Object"}};
    private static final String[] ILLEGAL_CHARS = new String[]{"$", "U0024"};

    public static boolean isIDLEntity(Class clazz) {
        return !IDLEntity.class.equals((java.lang.Object)clazz) && IDLEntity.class.isAssignableFrom(clazz);
    }

    public static String normalizeClassToIDLName(Class clazz) {
        int n;
        for (int i = 0; i < typeMapping.length; ++i) {
            if (!clazz.equals(typeMapping[i][0])) continue;
            return (String)typeMapping[i][1];
        }
        String string = clazz.getName();
        if (clazz.getComponentType() != null) {
            return IDLMangler.getSequenceTypeName(clazz);
        }
        if (IDLMangler.isIDLEntity(clazz)) {
            return BOXED_IDL + IDLMangler.normalizeJavaName(string);
        }
        StringBuffer stringBuffer = new StringBuffer(DOT);
        int n2 = string.lastIndexOf(DOT);
        if (n2 >= 0) {
            stringBuffer.append(string.substring(0, ++n2));
        } else {
            n2 = 0;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((n = string.indexOf(36, n2)) >= 0) {
            stringBuffer2.append(string.substring(n2, n)).append(DOUBLEUNDERSCORE);
            n2 = n + 1;
        }
        stringBuffer2.append(string.substring(n2));
        stringBuffer.append(IDLMangler.normalizeJavaName(stringBuffer2.toString()));
        return stringBuffer.toString();
    }

    public static String normalizeJavaName(String string) {
        String string2 = string;
        if (string.startsWith(UNDERSCORE)) {
            string2 = "J" + string2;
        } else {
            for (int i = 0; i < KEYWORDS.length; ++i) {
                if (!string.equalsIgnoreCase(KEYWORDS[i])) continue;
                string2 = UNDERSCORE + string2;
            }
        }
        return IDLMangler.convertIllegalCharacters(string2);
    }

    public static String accessorToAttribute(String string) {
        String string2;
        int n = 3;
        if (string.startsWith(IS)) {
            n = 2;
        }
        if ((string2 = string.substring(n)).length() == 1 || string2.length() >= 2 && (!Character.isUpperCase(string2.charAt(0)) || !Character.isUpperCase(string2.charAt(1)))) {
            string2 = Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
        }
        return IDLMangler.normalizeJavaName(string2);
    }

    public static String convertOverloadedName(String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer(IDLMangler.normalizeJavaName(string));
        for (int i = 0; i < classArray.length; ++i) {
            int n;
            stringBuffer.append(DOUBLEUNDERSCORE);
            String string2 = IDLMangler.normalizeClassToIDLName(classArray[i]);
            while ((n = string2.lastIndexOf(DOT)) >= 0 && string2.length() > n + 1 && string2.charAt(n + 1) == '_') {
                string2 = string2.substring(0, n) + string2.substring(n + 1);
            }
            while (string2.startsWith(UNDERSCORE) || string2.startsWith(DOT)) {
                string2 = string2.substring(1);
            }
            string2 = string2.replace('.', '_');
            string2 = string2.replace(' ', '_');
            stringBuffer.append(string2);
        }
        if (classArray.length == 0) {
            stringBuffer.append(DOUBLEUNDERSCORE);
        }
        return stringBuffer.toString();
    }

    public static String convertOverloadedName(Method method) {
        return IDLMangler.convertOverloadedName(method.getName(), method.getParameterTypes());
    }

    public static int isOverloaded(Class clazz, Method method) {
        int n;
        Class<?>[] classArray;
        int n2;
        if (clazz == null || clazz.equals(java.lang.Object.class)) {
            return 0;
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        Class<?>[] classArray2 = method.getParameterTypes();
        for (int i = 0; i < methodArray.length; ++i) {
            if (method.getName().equals(methodArray[i].getName())) {
                n2 = 1;
                classArray = methodArray[i].getParameterTypes();
                if (classArray.length != classArray2.length) {
                    n2 = 0;
                } else {
                    for (n = 0; n < classArray.length; ++n) {
                        if (classArray[n] == classArray2[n]) continue;
                        n2 = 0;
                    }
                }
                if (n2 != 0) continue;
                return 1;
            }
            if (!method.getName().equalsIgnoreCase(methodArray[i].getName())) continue;
            return 2;
        }
        if (method.getName().equalsIgnoreCase(clazz.getName()) && !method.getName().equals(clazz.getName())) {
            return 2;
        }
        Class clazz2 = clazz.getSuperclass();
        n2 = IDLMangler.isOverloaded(clazz2, method);
        if (n2 > 0) {
            return n2;
        }
        classArray = clazz.getInterfaces();
        for (n = 0; n < classArray.length; ++n) {
            n2 = IDLMangler.isOverloaded(classArray[n], method);
            if (n2 <= 0) continue;
            return n2;
        }
        return 0;
    }

    public static boolean methodThrowsRemoteException(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(RemoteException.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean methodThrowsCheckedException(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!Exception.class.isAssignableFrom(classArray[i]) || RemoteException.class.isAssignableFrom(classArray[i]) || RuntimeException.class.isAssignableFrom(classArray[i])) continue;
            return true;
        }
        return false;
    }

    public static final String getMangledMethodName(Method method) {
        return IDLMangler.getMangledMethodName(method, null);
    }

    public static final String getMangledMethodName(Method method, Class clazz) {
        Class<?> clazz2 = method.getDeclaringClass();
        Method[] methodArray = clazz2.getDeclaredMethods();
        String string = method.getName();
        if (clazz == null) {
            clazz = clazz2;
        }
        if (Object.class.isAssignableFrom(clazz) || Object.class.isAssignableFrom(method.getDeclaringClass())) {
            return string;
        }
        int n = IDLMangler.isOverloaded(clazz2, method);
        string = n == 1 ? IDLMangler.convertOverloadedName(method) : (n == 2 ? IDLMangler.convertCaseSensitiveName(method) : IDLMangler.normalizeJavaName(string));
        if (!IDLMangler.methodThrowsCheckedException(method)) {
            if (IDLMangler.isIsser(method)) {
                string = GETTER + IDLMangler.unescape(IDLMangler.accessorToAttribute(string));
            } else if (IDLMangler.isGetter(method)) {
                string = GETTER + IDLMangler.unescape(IDLMangler.accessorToAttribute(string));
            } else if (IDLMangler.isSetter(method)) {
                string = SETTER + IDLMangler.unescape(IDLMangler.accessorToAttribute(string));
            }
        }
        return string;
    }

    private static final String unescape(String string) {
        while (string.startsWith(UNDERSCORE)) {
            string = string.substring(1, string.length());
        }
        return string;
    }

    public static String stripPackage(String string) {
        String string2 = string;
        int n = string.lastIndexOf(DOT);
        if (n >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static boolean isIsser(Method method) {
        String string = method.getName();
        return string.startsWith(IS) && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 0 && !IDLMangler.methodThrowsCheckedException(method);
    }

    public static boolean isGetter(Method method) {
        String string = method.getName();
        if (string.startsWith(GET) && string.length() > GET.length() && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0 && !IDLMangler.methodThrowsCheckedException(method)) {
            StringBuffer stringBuffer = new StringBuffer(IS);
            stringBuffer.append(string.substring(GET.length()));
            try {
                Method method2 = method.getDeclaringClass().getDeclaredMethod(stringBuffer.toString(), Void.TYPE);
                if (method2.getReturnType() != method.getReturnType()) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSetter(Method method) {
        Method method2;
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        if (!string.startsWith(SET) || method.getReturnType() != Void.TYPE || classArray.length != 1 || IDLMangler.methodThrowsCheckedException(method)) {
            return false;
        }
        String string2 = IS + string.substring(SET.length());
        try {
            method2 = method.getDeclaringClass().getDeclaredMethod(string2, null);
            if (method2.getReturnType() == classArray[0]) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            string2 = GET + string.substring(SET.length());
            method2 = method.getDeclaringClass().getDeclaredMethod(string2, null);
            if (method2.getReturnType() == classArray[0]) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private static String convertCaseSensitiveName(Method method) {
        String string = method.getName();
        StringBuffer stringBuffer = new StringBuffer(IDLMangler.normalizeJavaName(string));
        boolean bl = true;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (!Character.isUpperCase(stringBuffer.charAt(i))) continue;
            stringBuffer.append(UNDERSCORE);
            stringBuffer.append(i);
            bl = false;
        }
        if (bl) {
            stringBuffer.append(UNDERSCORE);
        }
        return stringBuffer.toString();
    }

    private static String getSequenceTypeName(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer(BOXED_RMI);
        Class<?> clazz2 = clazz.getComponentType();
        while (clazz2.getComponentType() != null) {
            clazz2 = clazz2.getComponentType();
        }
        String string = IDLMangler.normalizeClassToIDLName(clazz2);
        String string2 = clazz.toString();
        int n = string2.lastIndexOf(91) - string2.indexOf(91) + 1;
        int n2 = string.lastIndexOf(DOT);
        if (n2 >= 0) {
            stringBuffer.append(string.substring(0, n2 + 1));
        } else {
            stringBuffer.append(DOT);
        }
        stringBuffer.append(SEQ).append(Integer.toString(n)).append(UNDERSCORE).append(string.substring(n2 + 1));
        return stringBuffer.toString().replace(' ', '_');
    }

    public static String convertIllegalCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = 0; j < ILLEGAL_CHARS.length; j += 2) {
                int n;
                if (c == '\\') {
                    if ('u' == string.charAt(i + 1)) {
                        stringBuffer.append("U");
                        for (n = i + 2; n < i + 5; ++n) {
                            stringBuffer.append(Character.toUpperCase(string.charAt(n)));
                        }
                    }
                    i += 4;
                    bl = true;
                    continue;
                }
                n = ILLEGAL_CHARS[j].charAt(0);
                if (c != n) continue;
                stringBuffer.append(ILLEGAL_CHARS[j + 1]);
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void p(String string) {
        System.out.println("***<IDLMangler> " + string);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("weblogic.corba.rmic.IDLMangler <class> <method>");
        } else {
            Class<?> clazz = Class.forName(stringArray[0]);
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (stringArray.length != 1 && !methodArray[i].getName().equals(stringArray[1])) continue;
                System.out.println(IDLMangler.getMangledMethodName(methodArray[i]));
            }
        }
    }

    public static interface Overloaded {
        public static final int FALSE = 0;
        public static final int TRUE = 1;
        public static final int IGNORING_CASE = 2;
    }
}

