/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import weblogic.corba.rmic.IDLOptions;
import weblogic.iiop.IDLUtils;
import weblogic.iiop.Utils;
import weblogic.utils.compiler.CodeGenerationException;

public final class IDLMethod
implements Cloneable {
    Class m_class = null;
    String m_mangledName = null;
    String m_name = null;
    Class m_returnType = null;
    Class[] m_parameterTypes = null;
    Class[] m_exceptionTypes = null;

    public IDLMethod(Class clazz, String string, String string2, Class clazz2, Class[] classArray, Class[] classArray2) {
        this.m_class = clazz;
        this.m_name = string;
        this.m_mangledName = string2;
        this.m_returnType = clazz2;
        this.m_parameterTypes = classArray;
        this.m_exceptionTypes = classArray2;
    }

    public String getName() {
        return this.m_name;
    }

    public Class getReturnType() {
        return this.m_returnType;
    }

    public Class[] getExceptionTypes() {
        return this.m_exceptionTypes;
    }

    public Class[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public String getMangledName() {
        return this.m_mangledName;
    }

    public boolean isRequired() throws CodeGenerationException {
        block7: {
            int n;
            block6: {
                int n2;
                if (!IDLOptions.getNoAbstract()) break block6;
                if (Utils.isAbstractInterface(this.m_returnType)) {
                    return false;
                }
                for (n2 = 0; n2 < this.m_parameterTypes.length; ++n2) {
                    if (!Utils.isAbstractInterface(this.m_parameterTypes[n2])) continue;
                    return false;
                }
                for (n2 = 0; n2 < this.m_exceptionTypes.length; ++n2) {
                    if (!Utils.isAbstractInterface(this.m_exceptionTypes[n2])) continue;
                    return false;
                }
                break block7;
            }
            if (!IDLOptions.getNoValueTypes()) break block7;
            if (IDLUtils.isValueType(this.m_returnType)) {
                return false;
            }
            for (n = 0; n < this.m_parameterTypes.length; ++n) {
                if (!IDLUtils.isValueType(this.m_parameterTypes[n])) continue;
                return false;
            }
            for (n = 0; n < this.m_exceptionTypes.length; ++n) {
                if (!IDLUtils.isValueType(this.m_exceptionTypes[n])) continue;
                return false;
            }
        }
        return true;
    }

    public String toIDL() {
        String string = null;
        String string2 = this.m_mangledName;
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.m_returnType) {
            stringBuffer.append(IDLUtils.getIDLType(this.m_returnType)).append(" ");
        }
        stringBuffer.append(string2).append("(");
        for (int i = 0; i < this.m_parameterTypes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(" in ").append(IDLUtils.getIDLType(this.m_parameterTypes[i])).append(" arg").append(i);
        }
        stringBuffer.append(")");
        Class[] classArray = this.m_exceptionTypes;
        switch (classArray.length) {
            case 0: {
                break;
            }
            case 1: {
                if (!IDLUtils.isACheckedException(classArray[0])) break;
                String string3 = IDLUtils.exceptionToEx(IDLUtils.getIDLType(classArray[0]));
                stringBuffer.append(IDLUtils.RAISES).append(string3).append(")");
                break;
            }
            default: {
                boolean bl = false;
                for (int i = 0; i < classArray.length; ++i) {
                    if (!IDLUtils.isACheckedException(classArray[i])) continue;
                    if (bl) {
                        stringBuffer.append(",");
                    } else {
                        stringBuffer.append(IDLUtils.RAISES);
                    }
                    String string4 = IDLUtils.exceptionToEx(IDLUtils.getIDLType(classArray[i]));
                    stringBuffer.append(string4);
                    bl = true;
                }
                if (!bl) break;
                stringBuffer.append(")");
            }
        }
        stringBuffer.append(";");
        string = stringBuffer.toString();
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

