/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import weblogic.corba.rmic.IDLAttribute;
import weblogic.corba.rmic.IDLExtraLine;
import weblogic.corba.rmic.IDLField;
import weblogic.corba.rmic.IDLMethod;
import weblogic.corba.rmic.IDLOptions;
import weblogic.corba.rmic.IDLTypeAbstractInterface;
import weblogic.corba.rmic.IDLTypeEntity;
import weblogic.corba.rmic.IDLTypeEx;
import weblogic.corba.rmic.IDLTypeNonConformant;
import weblogic.corba.rmic.IDLTypeRemote;
import weblogic.corba.rmic.IDLTypeSequence;
import weblogic.corba.rmic.IDLTypeSpecial;
import weblogic.corba.rmic.IDLTypeValueType;
import weblogic.corba.rmic.StructureTokenizer;
import weblogic.corba.rmic.TypeTraits;
import weblogic.iiop.IDLUtils;
import weblogic.utils.Debug;
import weblogic.utils.compiler.CodeGenerationException;

public abstract class IDLType {
    private static boolean debug = false;
    private static boolean verbose = false;
    protected static Hashtable m_usedTypes = new Hashtable();
    private static final boolean DEBUG = false;
    protected Class m_class;
    protected Class m_enclosingClass;
    Hashtable m_methods = new Hashtable();
    Hashtable m_attributes = new Hashtable();
    Hashtable m_extraLines = new Hashtable();
    String m_directory;
    private static TypeOverride typeOverrides = new TypeOverride();

    public IDLType(Class clazz, Class clazz2) {
        this(clazz, clazz2, null);
    }

    public IDLType(Class clazz, Class clazz2, String string) {
        Debug.assertion((null != clazz ? 1 : 0) != 0);
        this.m_class = clazz;
        this.m_enclosingClass = clazz2;
        this.m_directory = string;
        this.init();
    }

    public String getDirectory() {
        return this.m_directory;
    }

    public String getFileName() {
        String string = IDLUtils.javaTypeToPath(this.m_directory, this.m_class);
        return string;
    }

    public static Hashtable getUsedTypes() {
        return m_usedTypes;
    }

    public static void resetUsedTypes() {
        m_usedTypes = new Hashtable();
    }

    static void getAll(Class clazz, Hashtable hashtable, boolean bl) {
        IDLType.getAll(clazz, hashtable, bl, true);
    }

    static void getAll(Class clazz, Hashtable hashtable, boolean bl, boolean bl2) {
        Class[] classArray = IDLUtils.getClasses(clazz, bl, bl2);
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            if (IDLOptions.getNoAbstract() && IDLUtils.isAbstractInterface(clazz2)) continue;
            IDLType iDLType = IDLType.createType(clazz2, clazz);
            hashtable.put(iDLType.getClassName(), iDLType);
        }
    }

    public static IDLType createType(Class clazz, Class clazz2) {
        IDLType iDLType = null;
        if (null != IDLTypeSpecial.TRAITS.getValidClass(clazz, clazz2)) {
            iDLType = new IDLTypeSpecial(clazz, clazz2);
        } else if (null != IDLTypeEntity.TRAITS.getValidClass(clazz, clazz2)) {
            iDLType = new IDLTypeEntity(clazz, clazz2);
        } else if (null != IDLTypeRemote.TRAITS.getValidClass(clazz, clazz2)) {
            iDLType = new IDLTypeRemote(clazz, clazz2);
        } else if (null != IDLTypeEx.TRAITS.getValidClass(clazz, clazz2)) {
            IDLTypeValueType iDLTypeValueType = new IDLTypeValueType(clazz, clazz2);
            iDLType = new IDLTypeEx(clazz, clazz2, iDLTypeValueType);
            m_usedTypes.put(iDLTypeValueType.getFileName(), iDLTypeValueType);
        } else if (null != IDLTypeValueType.TRAITS.getValidClass(clazz, clazz2)) {
            iDLType = new IDLTypeValueType(clazz, clazz2);
        } else if (null != IDLTypeSequence.TRAITS.getValidClass(clazz, clazz2)) {
            iDLType = new IDLTypeSequence(clazz, clazz2);
        } else if (null != IDLTypeNonConformant.TRAITS.getValidClass(clazz, clazz2)) {
            iDLType = new IDLTypeNonConformant(clazz, clazz2);
        } else if (null != IDLTypeAbstractInterface.TRAITS.getValidClass(clazz, clazz2)) {
            iDLType = new IDLTypeAbstractInterface(clazz, clazz2);
        }
        m_usedTypes.put(iDLType.getFileName(), iDLType);
        return iDLType;
    }

    public static void registerOverride(String string, String string2) {
        typeOverrides.registerMethodOverride(string, string2);
    }

    public static void clearOverrides() {
        typeOverrides = new TypeOverride();
    }

    public boolean isRequired() throws CodeGenerationException {
        if (!IDLOptions.getNoValueTypes() && !IDLOptions.getNoAbstract() && typeOverrides.isEmpty()) {
            return true;
        }
        if (IDLOptions.getNoValueTypes() && typeOverrides.isEmpty()) {
            return !IDLUtils.mustSkipClass(this.getClass(), this.getOpeningDeclaration());
        }
        if (typeOverrides.isClassRequired(this.m_class)) {
            return true;
        }
        return !IDLUtils.mustSkipClass(this.getClass(), this.getOpeningDeclaration());
    }

    public boolean isAssignableFrom(IDLType iDLType) throws CodeGenerationException {
        return this.getJavaClass().isAssignableFrom(iDLType.getJavaClass());
    }

    public void init() {
        this.initMethods();
        this.initAttributes();
    }

    public void initAttributes() {
        block8: {
            block7: {
                this.m_attributes = new Hashtable();
                try {
                    if (!(this instanceof IDLTypeValueType)) {
                        IDLUtils.getAttributesFromMethods(this.m_class, this.m_attributes);
                    }
                    IDLUtils.getAttributesFromFields(this.m_class, this.m_attributes);
                }
                catch (CodeGenerationException codeGenerationException) {
                    if (!debug) break block7;
                    codeGenerationException.printStackTrace();
                }
            }
            if (IDLOptions.getNoValueTypes() || IDLOptions.getNoAbstract()) {
                Enumeration enumeration = this.m_attributes.elements();
                try {
                    while (enumeration.hasMoreElements()) {
                        IDLField iDLField = (IDLField)enumeration.nextElement();
                        if (!IDLUtils.mustSkipClass(iDLField.getType()) && null == IDLUtils.getNonConformantType(iDLField.getType()) || typeOverrides.isClassRequired(iDLField.getType())) continue;
                        Object v = this.m_attributes.remove(iDLField.getMangledName());
                        Debug.assertion((null != v ? 1 : 0) != 0);
                    }
                }
                catch (Exception exception) {
                    if (!debug) break block8;
                    exception.printStackTrace();
                }
            }
        }
    }

    public void initMethods() {
        this.m_methods = new Hashtable();
        Method[] methodArray = this.m_class.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            try {
                boolean bl;
                Method method = methodArray[i];
                boolean bl2 = true;
                if (IDLOptions.getNoValueTypes() && this.methodContainsValueTypes(method) && !typeOverrides.isMethodRequired(method)) {
                    bl2 = false;
                }
                boolean bl3 = IDLUtils.isValid(method);
                if (!bl2 || !bl3 || (bl = IDLUtils.isMethodForAnAttribute(this.m_class, method))) continue;
                IDLMethod iDLMethod = new IDLMethod(this.m_class, method.getName(), IDLUtils.getMangledMethodName(method, methodArray), method.getReturnType(), method.getParameterTypes(), method.getExceptionTypes());
                this.m_methods.put(iDLMethod.getMangledName(), iDLMethod);
                continue;
            }
            catch (CodeGenerationException codeGenerationException) {
                if (!debug) continue;
                codeGenerationException.printStackTrace();
            }
        }
    }

    private static void p(String string) {
        System.out.println("<IDLType>: " + string);
    }

    boolean methodContainsValueTypes(Method method) {
        Class<?> clazz = method.getReturnType();
        if (IDLUtils.mustSkipClass(clazz)) {
            return true;
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (!IDLUtils.mustSkipClass(classArray[i])) continue;
            return true;
        }
        return false;
    }

    public Hashtable getMethods() {
        return this.m_methods;
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }

    public Hashtable getExtraLines() {
        return this.m_extraLines;
    }

    public Class getJavaClass() {
        return this.m_class;
    }

    public Class getEnclosingClass() {
        return this.m_enclosingClass;
    }

    public Class[] getInheritedClasses() {
        Class<?>[] classArray = this.getJavaClass().getInterfaces();
        Vector vector = new Vector();
        Class clazz = this.getJavaClass().getSuperclass();
        if (clazz != null && IDLUtils.isValid(clazz) && !clazz.equals(Object.class)) {
            vector.addElement(clazz);
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (!IDLUtils.isValid(classArray[i])) continue;
            vector.addElement(classArray[i]);
        }
        Object[] objectArray = new Class[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean canHaveSubtype(IDLType iDLType) {
        return true;
    }

    public String getPackageName() {
        return null;
    }

    public String getClassName() {
        return this.m_class.getName();
    }

    public String beforeMainDeclaration() {
        return "";
    }

    public String afterMainDeclaration() {
        return "";
    }

    public Hashtable getReferencedTypes() {
        Hashtable<Class, IDLType> hashtable = new Hashtable<Class, IDLType>();
        Hashtable hashtable2 = new Hashtable();
        Class[] classArray = IDLUtils.getClasses(this.m_class, false, true);
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            IDLType iDLType = IDLType.createType(clazz, this.getEnclosingClass());
            hashtable.put(clazz, iDLType);
        }
        return hashtable;
    }

    public abstract String getIncludeDeclaration() throws CodeGenerationException;

    public abstract String getForwardDeclaration() throws CodeGenerationException;

    public abstract void getReferences(Hashtable var1);

    public String getInheritKeyword(IDLType iDLType) {
        return ":";
    }

    public String getOpeningDeclaration() throws CodeGenerationException {
        return "";
    }

    public final String generateMethods() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = this.getMethods();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            IDLMethod iDLMethod = (IDLMethod)enumeration.nextElement();
            if (!iDLMethod.isRequired()) continue;
            if (!this.checkInheritedMethod(this.getJavaClass(), this.getJavaClass(), iDLMethod)) {
                stringBuffer.append("    " + iDLMethod.toIDL() + "\n");
                continue;
            }
            if (IDLOptions.getIDLStrict()) continue;
            stringBuffer.append("//  clash with parent on " + iDLMethod.toIDL()).append("\n//");
        }
        return stringBuffer.toString();
    }

    boolean checkInheritedMethod(Class clazz, Class clazz2, IDLMethod iDLMethod) {
        Class clazz3;
        if (clazz2 == null || clazz2.equals(Object.class)) {
            return false;
        }
        if (clazz2 != clazz) {
            try {
                Method method = clazz2.getMethod(iDLMethod.getName(), iDLMethod.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.checkInheritedMethod(clazz, clazz3 = clazz2.getSuperclass(), iDLMethod)) {
            return true;
        }
        Class<?>[] classArray = clazz2.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!this.checkInheritedMethod(clazz, classArray[i], iDLMethod)) continue;
            return true;
        }
        return false;
    }

    public final String generateAttributes() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList linkedList = new LinkedList(this.getAttributes().values());
        Collections.sort(linkedList, new Comparator(){

            public int compare(Object object, Object object2) {
                IDLField iDLField = (IDLField)object;
                IDLField iDLField2 = (IDLField)object2;
                if (iDLField instanceof IDLAttribute && !(iDLField2 instanceof IDLAttribute)) {
                    return 1;
                }
                if (!(iDLField instanceof IDLAttribute) && iDLField2 instanceof IDLAttribute) {
                    return -1;
                }
                if (iDLField.isConst() && !iDLField2.isConst()) {
                    return -1;
                }
                if (iDLField2.isConst() && !iDLField.isConst()) {
                    return 1;
                }
                if (iDLField.isPrimitive() && !iDLField2.isPrimitive()) {
                    return -1;
                }
                if (!iDLField.isPrimitive() && iDLField2.isPrimitive()) {
                    return 1;
                }
                return iDLField.getName().compareTo(iDLField2.getName());
            }
        });
        for (IDLField iDLField : linkedList) {
            stringBuffer.append("    " + iDLField.toIDL() + "\n");
        }
        return stringBuffer.toString();
    }

    public final String generateExtraLines() {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = this.getExtraLines();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            IDLExtraLine iDLExtraLine = (IDLExtraLine)enumeration.nextElement();
            stringBuffer.append("    " + iDLExtraLine.toIDL() + "\n");
        }
        return stringBuffer.toString();
    }

    public static String getOpeningDecl(IDLType iDLType, Class clazz, Class[] classArray, String string, TypeTraits typeTraits) throws CodeGenerationException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("  " + string);
        String string2 = IDLUtils.stripPackage(IDLUtils.getIDLType(iDLType.getJavaClass()), "::");
        stringBuffer.append(" " + string2);
        Vector<IDLType> vector = new Vector<IDLType>();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < classArray.length; ++i) {
            String string3;
            Class clazz2 = classArray[i];
            if (IDLOptions.getNoAbstract() && IDLUtils.isAbstractInterface(clazz2)) continue;
            object = IDLType.createType(clazz2, clazz);
            if (iDLType instanceof IDLTypeValueType && object instanceof IDLTypeEx) {
                object = ((IDLTypeEx)object).getEnclosed();
            }
            if (":".equals(string3 = ((IDLType)object).getInheritKeyword(iDLType))) {
                vector.addElement((IDLType)object);
                continue;
            }
            if ("supports".equals(string3)) {
                vector2.addElement(object);
                continue;
            }
            throw new CodeGenerationException("Unknown inheritance keyword for " + ((IDLType)object).toString());
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                IDLType iDLType = (IDLType)object;
                IDLType iDLType2 = (IDLType)object2;
                if (iDLType instanceof IDLTypeValueType && !(iDLType2 instanceof IDLTypeValueType)) {
                    return -1;
                }
                if (iDLType instanceof IDLTypeRemote && !(iDLType2 instanceof IDLTypeRemote)) {
                    return -1;
                }
                if (!(iDLType instanceof IDLTypeValueType) && iDLType2 instanceof IDLTypeValueType) {
                    return 1;
                }
                if (!(iDLType instanceof IDLTypeRemote) && iDLType2 instanceof IDLTypeRemote) {
                    return 1;
                }
                return 0;
            }
        });
        Vector[] vectorArray = new Vector[]{vector, vector2};
        for (int i = 0; i < vectorArray.length; ++i) {
            object = vectorArray[i];
            boolean bl = true;
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                IDLType iDLType2 = (IDLType)enumeration.nextElement();
                Class clazz3 = iDLType2.getJavaClass();
                if (!iDLType2.canHaveSubtype(iDLType)) continue;
                if (bl) {
                    bl = false;
                    stringBuffer.append(" ").append(iDLType2.getInheritKeyword(iDLType));
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(" ").append(IDLUtils.getIDLType(clazz3));
            }
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public String getPragmaID() {
        return IDLUtils.getPragmaID(this.getJavaClass());
    }

    public String getOpenBrace() {
        return "{\n";
    }

    public String getCloseBrace() {
        return "\n};\n";
    }

    public String getGuardName(String string) {
        return IDLUtils.generateGuard(this.m_class, string);
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.m_class.getName() + ")";
    }

    static class TypeOverride {
        ArrayList typeOverrides = new ArrayList();
        HashMap methodOverrides = new HashMap();
        Class remoteInterface = null;

        TypeOverride() {
        }

        void registerMethodOverride(String string, String string2) {
            try {
                this.methodOverrides.put(string, StructureTokenizer.getParameterTypes(string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        boolean isClassRequired(Class clazz) {
            return true;
        }

        boolean isMethodRequired(Method method) {
            block3: {
                Class<?>[] classArray;
                Class[] classArray2;
                Object v = this.methodOverrides.get(method.getName());
                if (v != null && (classArray2 = (Class[])v).length == (classArray = method.getParameterTypes()).length) {
                    for (int i = 0; i < classArray2.length; ++i) {
                        if (classArray2[i].equals(classArray[i])) {
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
            }
            return false;
        }

        boolean isEmpty() {
            return this.methodOverrides.size() == 0;
        }
    }
}

