/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import weblogic.corba.rmic.IDLOptions;
import weblogic.corba.rmic.IDLType;
import weblogic.corba.rmic.IDLTypeRemote;
import weblogic.corba.rmic.IDLTypeValueType;
import weblogic.corba.rmic.TypeTraits;
import weblogic.iiop.IDLUtils;
import weblogic.utils.compiler.CodeGenerationException;

public class IDLTypeAbstractInterface
extends IDLTypeRemote {
    public static final String OPENING_DECLARATION = "abstract interface";
    public static final TypeTraits TRAITS = new TypeTraits(){

        public Class getValidClass(Class clazz, Class clazz2) {
            if (IDLUtils.isAbstractInterface(clazz)) {
                return clazz;
            }
            return null;
        }

        public IDLType createType(Class clazz, Class clazz2) {
            return new IDLTypeAbstractInterface(clazz, clazz2);
        }
    };

    public String getOpeningDeclarationString() {
        return OPENING_DECLARATION;
    }

    public IDLTypeAbstractInterface(Class clazz, Class clazz2) {
        super(clazz, clazz2);
    }

    public String getIncludeDeclaration() throws CodeGenerationException {
        if (!IDLOptions.getNoAbstract()) {
            return super.getIncludeDeclaration();
        }
        return "// abstract interface " + this.getClassName() + " omitted.\n";
    }

    public String getForwardDeclaration() throws CodeGenerationException {
        if (!IDLOptions.getNoAbstract()) {
            return super.getForwardDeclaration();
        }
        return "// abstract interface " + this.getClassName() + " omitted.\n";
    }

    public String getInheritKeyword(IDLType iDLType) {
        if (IDLTypeValueType.class.isAssignableFrom(iDLType.getClass())) {
            return "supports";
        }
        return super.getInheritKeyword(iDLType);
    }

    public String getOpeningDeclaration() throws CodeGenerationException {
        String string = "";
        Class clazz = this.getEnclosingClass();
        string = IDLType.getOpeningDecl(this, clazz, this.getInheritedClasses(), OPENING_DECLARATION, TRAITS);
        return string;
    }
}

