/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.util.Hashtable;
import weblogic.corba.rmic.IDLExtraLine;
import weblogic.corba.rmic.IDLOptions;
import weblogic.corba.rmic.IDLType;
import weblogic.corba.rmic.IDLTypeValueType;
import weblogic.corba.rmic.TypeTraits;
import weblogic.iiop.IDLUtils;
import weblogic.utils.compiler.CodeGenerationException;

public class IDLTypeEx
extends IDLType {
    String m_exName = null;
    String m_exceptionName = null;
    Class m_class = this.getJavaClass();
    String m_guard = null;
    IDLTypeValueType m_enclosed;
    public static final TypeTraits TRAITS = new TypeTraits(){

        public Class getValidClass(Class clazz, Class clazz2) {
            Class clazz3 = null;
            if (IDLUtils.isValid(clazz) && IDLUtils.isException(clazz)) {
                clazz3 = clazz;
            }
            return clazz3;
        }

        public IDLType createType(Class clazz, Class clazz2) {
            IDLTypeValueType iDLTypeValueType = new IDLTypeValueType(clazz, clazz2);
            IDLType.m_usedTypes.put(iDLTypeValueType.getFileName(), iDLTypeValueType);
            return new IDLTypeEx(clazz, clazz2, iDLTypeValueType);
        }
    };
    private static final String IDL_EXT = ".idl";

    public IDLTypeEx(Class clazz, Class clazz2, IDLTypeValueType iDLTypeValueType) {
        super(clazz, clazz2);
        this.m_exceptionName = IDLUtils.stripPackage(IDLUtils.getIDLType(this.m_class), "::");
        this.m_exName = IDLUtils.exceptionToEx(this.m_exceptionName);
        this.m_guard = IDLUtils.exceptionToEx(IDLUtils.getIDLType(this.m_class, "_"));
        this.m_enclosed = iDLTypeValueType;
    }

    public String getIncludeDeclaration() throws CodeGenerationException {
        return "";
    }

    public String getForwardDeclaration() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = IDLUtils.javaTypeToPath(null, this.m_class);
        string = string.substring(0, string.length() - IDL_EXT.length());
        string = IDLUtils.exceptionToEx(string) + IDL_EXT;
        stringBuffer.append("#include \"" + string + "\"\n");
        return stringBuffer.toString();
    }

    public String beforeMainDeclaration() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!IDLOptions.getNoValueTypes()) {
            stringBuffer.append(IDLUtils.generateGuard(this.m_class, "#ifndef"));
            stringBuffer.append(IDLUtils.openModule(this.m_class));
            stringBuffer.append("  valuetype ").append(this.m_exceptionName).append(";\n");
            stringBuffer.append(IDLUtils.closeModule(this.m_class));
            stringBuffer.append(IDLUtils.generateGuard(this.m_class, "#endif //"));
        }
        return stringBuffer.toString();
    }

    public IDLType getEnclosed() {
        return this.m_enclosed;
    }

    public String afterMainDeclaration() {
        String string = new String();
        if (!IDLOptions.getNoValueTypes()) {
            string = IDLUtils.generateInclude(null, this.m_class);
        }
        return string;
    }

    public String getOpeningDeclaration() throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer("exception ").append(this.m_exName).append(" ");
        return stringBuffer.toString();
    }

    public Hashtable getMethods() {
        return new Hashtable();
    }

    public Hashtable getAttributes() {
        return new Hashtable();
    }

    public Hashtable getExtraLines() {
        Hashtable<String, IDLExtraLine> hashtable = new Hashtable<String, IDLExtraLine>();
        String string = "value";
        String string2 = IDLOptions.getNoValueTypes() ? "::CORBA::WStringValue" : this.m_exceptionName;
        IDLExtraLine iDLExtraLine = new IDLExtraLine(string, string2 + " " + string + ";\n");
        hashtable.put(iDLExtraLine.getMangledName(), iDLExtraLine);
        return hashtable;
    }

    public String getGuardName(String string) {
        String string2 = IDLUtils.generateGuard(this.m_guard, string);
        return string2;
    }

    public void getReferences(Hashtable hashtable) {
    }

    public String getFileName() {
        String string = IDLUtils.javaTypeToPath(this.getDirectory(), this.getJavaClass());
        string = string.substring(0, string.length() - IDL_EXT.length());
        return IDLUtils.exceptionToEx(string) + IDL_EXT;
    }

    public String getPragmaID() {
        return "";
    }

    public boolean canHaveSubtype(IDLType iDLType) {
        return false;
    }
}

