/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.io.Externalizable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import weblogic.corba.rmic.IDLField;
import weblogic.corba.rmic.IDLMangler;
import weblogic.corba.rmic.IDLMethod;
import weblogic.corba.rmic.IDLOptions;
import weblogic.corba.rmic.IDLType;
import weblogic.corba.rmic.TypeTraits;
import weblogic.corba.utils.ClassInfo;
import weblogic.iiop.IDLUtils;
import weblogic.utils.compiler.CodeGenerationException;

public class IDLTypeValueType
extends IDLType {
    private boolean opaque = false;
    private boolean custom = false;
    public static final TypeTraits TRAITS = new TypeTraits(){

        public Class getValidClass(Class clazz, Class clazz2) {
            if (IDLUtils.isConcreteValueType(clazz)) {
                return clazz;
            }
            return null;
        }

        public IDLType createType(Class clazz, Class clazz2) {
            return new IDLTypeValueType(clazz, clazz2);
        }
    };

    public IDLTypeValueType(Class clazz, Class clazz2) {
        super(clazz, clazz2);
        if (Externalizable.class.isAssignableFrom(clazz)) {
            this.opaque = true;
        } else {
            this.custom = ClassInfo.findClassInfo(clazz).getDescriptor().isCustomMarshaled();
        }
    }

    public String getIncludeDeclaration() throws CodeGenerationException {
        String string = new String();
        if (!IDLUtils.isException(this.getJavaClass()) || this.getEnclosingClass() != null && this.getEnclosingClass().isArray()) {
            string = IDLUtils.generateInclude(this.getDirectory(), this.getJavaClass());
        }
        return string;
    }

    public String getForwardDeclaration() throws CodeGenerationException {
        return this.getForwardDeclaration(true);
    }

    public String getForwardDeclaration(boolean bl) throws CodeGenerationException {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = this.getJavaClass();
        if (IDLUtils.isException(clazz) && (this.getEnclosingClass() == null || !this.getEnclosingClass().isArray())) {
            return IDLUtils.generateInclude(this.getDirectory(), clazz);
        }
        if (this.isRequired()) {
            if (bl) {
                stringBuffer.append(IDLUtils.generateGuard(clazz, "#ifndef"));
            }
            stringBuffer.append(IDLUtils.openModule(clazz));
            stringBuffer.append("  " + this.getOpeningKeyword(true) + " " + IDLUtils.stripPackage(IDLUtils.getIDLType(this.m_class, "."))).append(";\n");
            stringBuffer.append(IDLUtils.closeModule(clazz));
            if (bl) {
                stringBuffer.append(IDLUtils.generateGuard(clazz, "#endif //"));
            }
        }
        return stringBuffer.toString();
    }

    private String getOpeningKeyword(boolean bl) {
        return (this.opaque || this.custom) && !bl ? "custom valuetype" : "valuetype";
    }

    public String getOpeningDeclaration() throws CodeGenerationException {
        Class clazz = this.getEnclosingClass();
        String string = IDLType.getOpeningDecl(this, clazz, this.getInheritedClasses(), this.getOpeningKeyword(false), TRAITS);
        return string;
    }

    public void getReferences(Hashtable hashtable) {
        Class clazz = this.getJavaClass();
        IDLTypeValueType.getAll(clazz, hashtable, false, false);
    }

    public Hashtable getAttributes() {
        Hashtable hashtable = super.getAttributes();
        if (this.opaque) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                IDLField iDLField = (IDLField)enumeration.nextElement();
                if (iDLField.isPublic()) continue;
                hashtable.remove(iDLField.getMangledName());
            }
        }
        return hashtable;
    }

    public Hashtable getMethods() {
        Hashtable<String, IDLMethod> hashtable = new Hashtable<String, IDLMethod>();
        if (IDLOptions.getFactories()) {
            StringBuffer stringBuffer = new StringBuffer();
            Constructor<?>[] constructorArray = this.getJavaClass().getConstructors();
            if (constructorArray.length <= 1) {
                Class[] classArray = constructorArray.length == 0 ? new Class[]{} : constructorArray[0].getParameterTypes();
                IDLMethod iDLMethod = new IDLMethod(this.getJavaClass(), this.getJavaClass().getName(), "factory create", null, classArray, new Class[0]);
                hashtable.put(iDLMethod.getMangledName(), iDLMethod);
            } else {
                for (int i = 0; i < constructorArray.length; ++i) {
                    Constructor<?> constructor = constructorArray[i];
                    String string = "factory " + IDLMangler.convertOverloadedName("create", constructor.getParameterTypes());
                    IDLMethod iDLMethod = new IDLMethod(this.getJavaClass(), this.getJavaClass().getName(), string, null, constructor.getParameterTypes(), new Class[0]);
                    hashtable.put(iDLMethod.getMangledName(), iDLMethod);
                }
            }
        }
        return hashtable;
    }
}

