/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.rmic.Main;
import weblogic.corba.rmi.Stub;
import weblogic.corba.rmic.StubGenerator;
import weblogic.kernel.Kernel;
import weblogic.rmi.extensions.server.DescriptorHelper;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.rmic.Remote2JavaConstants;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.CodeGenerator;

public final class Remote2Corba
extends CodeGenerator
implements Remote2JavaConstants {
    private static final boolean debug = false;
    private boolean verbose = false;
    private Getopt2 opts;
    private String iiopDirectory;
    private boolean triesToUseClassLoader = false;
    private boolean disableHotCodGen = false;
    public static final String IIOP_VERBOSE = "verbose";

    public Remote2Corba(Getopt2 getopt2) {
        super(getopt2);
        Remote2Corba.addGeneratorOptions(getopt2);
        this.opts = getopt2;
        if (this.verbose) {
            Debug.say((String)"opts ok");
        }
    }

    public static void addGeneratorOptions(Getopt2 getopt2) {
        getopt2.addFlag("iiop", "Generate iiop stubs from servers");
        getopt2.addFlag("iiopTie", "Generate CORBA skeletons, uses Sun's rmic.");
        getopt2.addFlag("iiopSun", "Use Sun's rmic for generating CORBA stubs.");
        getopt2.addOption("iiopDirectory", "directory", "Specify the directory where IIOP proxy classes will be written (overrides target directory)");
    }

    String getIIOPDirectory() {
        return this.iiopDirectory;
    }

    protected void extractOptionValues(Getopt2 getopt2) {
        this.iiopDirectory = getopt2.getOption("iiopDirectory", null);
        this.verbose = getopt2.hasOption(IIOP_VERBOSE);
        this.disableHotCodGen = getopt2.hasOption("disableHotCodeGen");
        if (Utilities.getClassLoader() != null && this.iiopDirectory != null) {
            this.triesToUseClassLoader = true;
            this.iiopDirectory = super.getRootDirectoryName();
        }
        if (null == this.iiopDirectory) {
            this.iiopDirectory = super.getRootDirectoryName();
        }
        if (null == this.iiopDirectory) {
            this.iiopDirectory = ".";
        }
    }

    public Enumeration outputs(Object[] objectArray) throws Exception {
        Kernel.ensureInitialized();
        String[] stringArray = (String[])objectArray;
        boolean bl = this.opts.hasOption("keepgenerated");
        boolean bl2 = this.opts.hasOption("iiopTie");
        boolean bl3 = this.opts.hasOption("iiopSun") || bl2;
        String string = this.getIIOPDirectory();
        String string2 = this.opts.getOption("classpath");
        if (bl3) {
            int n;
            Object[] objectArray2;
            int n2;
            if (this.opts.hasOption("descriptor")) {
                System.err.println("WARNING: -descriptor not supported in combination with -iiopTie or -iiopSun, ignored.");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-iiop");
            arrayList.add("-always");
            if (bl) {
                arrayList.add("-keepgenerated");
            }
            if (string2 != null) {
                arrayList.add("-classpath");
                arrayList.add(string2);
            }
            if (string != null) {
                arrayList.add("-d");
                arrayList.add(string);
            }
            if (bl2) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    arrayList.add(stringArray[n2]);
                }
            } else {
                arrayList.add("-nolocalstubs");
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    objectArray2 = StubGenerator.getAllInterfaces(Utilities.classForName((String)stringArray[n2]));
                    for (n = 0; n < objectArray2.length; ++n) {
                        arrayList.add(((Class)objectArray2[n]).getName());
                    }
                }
            }
            String[] stringArray2 = new String[arrayList.size()];
            objectArray2 = arrayList.toArray();
            for (n = 0; n < objectArray2.length; ++n) {
                stringArray2[n] = (String)objectArray2[n];
            }
            if (this.verbose) {
                StringBuffer stringBuffer = new StringBuffer("sun.rmi.rmic ");
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringBuffer.append(stringArray2[i] + " ");
                }
                Debug.say((String)stringBuffer.toString());
            }
            if (this.triesToUseClassLoader) {
                System.err.println("WARNING: iiopDirectory not supported in combination with this classloader, ignored.");
            }
            Main main = new Main((OutputStream)System.out, "rmic");
            main.compile(stringArray2);
        } else {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                Class clazz;
                if (this.verbose) {
                    Debug.say((String)("weblogic.rmic -iiop -d " + this.getIIOPDirectory() + " " + stringArray[n]));
                }
                if (!(clazz = Utilities.classForName((String)stringArray[n])).isInterface()) {
                    this.generateStub(clazz);
                }
                Class[] classArray = StubGenerator.getAllInterfaces(clazz);
                for (int i = 0; i < classArray.length; ++i) {
                    this.generateStub(classArray[i]);
                }
            }
            if (this.disableHotCodGen) {
                for (n = 0; n < stringArray.length; ++n) {
                    this.generateIIOPStub(stringArray[n]);
                }
            }
        }
        return new Hashtable().elements();
    }

    private void generateStub(Class clazz) throws Exception {
        if (this.verbose) {
            Debug.say((String)("weblogic.rmic -iiop -d " + this.getIIOPDirectory() + clazz.getName()));
        }
        StubGenerator stubGenerator = new StubGenerator(clazz);
        String string = stubGenerator.getClassName().replace('.', File.separatorChar) + ".class";
        Remote2Corba.ensureDirectoryExists(this.getIIOPDirectory(), string);
        FileOutputStream fileOutputStream = new FileOutputStream(this.getIIOPDirectory() + File.separatorChar + string);
        stubGenerator.write(fileOutputStream);
        fileOutputStream.close();
    }

    private static void ensureDirectoryExists(String string, String string2) {
        String string3 = "";
        int n = string2.lastIndexOf(File.separatorChar);
        if (n != -1) {
            string3 = string2.substring(0, n);
        }
        String string4 = string + File.separatorChar + string3;
        File file = new File(string4);
        file.mkdirs();
    }

    public void generateIIOPStubs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateIIOPStub(String string) throws ClassNotFoundException {
        FileOutputStream fileOutputStream = null;
        try {
            File file;
            Class<?> clazz;
            block15: {
                Kernel.ensureInitialized();
                ClassLoader classLoader = Utilities.getClassLoader();
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (classLoader == null) break block15;
                    clazz = classLoader.loadClass(string);
                }
            }
            RuntimeDescriptor runtimeDescriptor = DescriptorHelper.getDescriptor(clazz);
            weblogic.rmi.internal.StubGenerator stubGenerator = new weblogic.rmi.internal.StubGenerator(runtimeDescriptor, string + "_IIOP_WLStub", Stub.class.getName());
            String string2 = stubGenerator.getClassName().replace('.', File.separatorChar);
            File file2 = new File(super.getRootDirectoryName());
            file2.mkdir();
            file2 = new File(super.getRootDirectoryName() + File.separatorChar + string2 + ".class");
            String string3 = file2.getParent();
            if (string3 != null && !(file = new File(string3)).exists()) {
                file.mkdirs();
            }
            fileOutputStream = new FileOutputStream(file2);
            stubGenerator.write((OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

