/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class Structure {
    public String name;
    public Hashtable elements;
    int indentLevel = 0;
    final String SPACES = "                                                     ";

    public String spaces() {
        return "                                                     ".substring(0, this.indentLevel * 2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.spaces() + "(" + this.name + "\n");
        Enumeration enumeration = this.elements.keys();
        while (enumeration.hasMoreElements()) {
            ++this.indentLevel;
            String string = (String)enumeration.nextElement();
            Object v = this.elements.get(string);
            if (v instanceof Structure) {
                stringBuffer.append(v);
            } else if (v instanceof String) {
                stringBuffer.append(this.spaces() + string + ": " + (String)v + "\n");
            } else if (v instanceof Vector) {
                stringBuffer.append(this.spaces() + string + ": [ ");
                Vector vector = (Vector)v;
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append((String)vector.elementAt(i) + " ");
                }
                stringBuffer.append("]\n");
            }
            --this.indentLevel;
        }
        stringBuffer.append(this.spaces() + ")\n");
        return stringBuffer.toString();
    }
}

