/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import weblogic.corba.rmic.ParseException;
import weblogic.corba.rmic.Structure;
import weblogic.rmi.utils.Utilities;

final class StructureTokenizer
extends StreamTokenizer {
    boolean eofOK = false;
    String currFile = "[none]";
    int nestingLevel = 0;
    final boolean verbose = false;
    int errors = 0;

    StructureTokenizer(Reader reader) {
        super(reader);
        this.init();
    }

    StructureTokenizer(Reader reader, String string) {
        this(reader);
        this.currFile = string;
    }

    void init() {
        this.resetSyntax();
        this.whitespaceChars(0, 32);
        this.wordChars(33, 126);
        this.eolIsSignificant(false);
        this.commentChar(59);
        this.ordinaryChar(40);
        this.ordinaryChar(41);
        this.ordinaryChar(91);
        this.ordinaryChar(93);
        this.quoteChar(34);
    }

    void aargh(String string) throws Exception {
        ++this.errors;
        System.err.println(this.currFile + ": " + string);
        if (this.errors > 20) {
            throw new ParseException("Exceeded 20 errors. Aborted.");
        }
    }

    Structure parseStructure() throws Exception {
        this.match('(');
        this.eofOK = false;
        ++this.nestingLevel;
        Structure structure = new Structure();
        structure.name = this.nextWord();
        structure.elements = this.parseElements();
        this.match(')');
        --this.nestingLevel;
        if (this.nestingLevel == 0) {
            this.eofOK = true;
        }
        return structure;
    }

    public int nextToken() throws IOException {
        int n = super.nextToken();
        if (n == 34) {
            n = -3;
        }
        if (n == -1 && !this.eofOK) {
            System.err.println("Unexpected end of file in '" + this.currFile + "'");
            Runtime.getRuntime().exit(-1);
        }
        return n;
    }

    Hashtable parseElements() throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (true) {
            Object object;
            String string;
            int n;
            char c;
            if ((c = (char)(n = this.nextToken())) == ')') {
                this.putBack();
                return hashtable;
            }
            if (c == '(') {
                this.putBack();
                Structure structure = this.parseStructure();
                string = structure.name;
                object = structure.elements;
            } else {
                string = this.sval;
                object = this.parseValue();
            }
            hashtable.put(string, object);
        }
    }

    Object parseValue() throws Exception {
        int n = this.nextToken();
        char c = (char)n;
        if (c == '[') {
            this.putBack();
            return this.parseStringVector();
        }
        if (n == -3) {
            return this.sval;
        }
        this.fatalError("Expected word or '[' words ']'. Got " + this.interpret());
        return this.sval;
    }

    Vector parseStringVector() throws Exception {
        Vector<String> vector = new Vector<String>();
        this.match('[');
        int n;
        char c;
        while ((c = (char)(n = this.nextToken())) != ']') {
            if (n == -3) {
                vector.addElement(this.sval);
                continue;
            }
            this.fatalError("Expected string or ']'. Got " + this.interpret());
        }
        return vector;
    }

    void match(char c) throws Exception {
        int n = this.nextToken();
        if ((char)n == c) {
            return;
        }
        this.fatalError("Expected '" + c + "'. Got " + this.interpret());
    }

    void fatalError(String string) throws ParseException {
        throw new ParseException(this.lineno(), string);
    }

    String nextWord() throws Exception {
        int n = this.nextToken();
        if (n == -3) {
            return this.sval;
        }
        this.fatalError("Expected a word. Got " + this.interpret());
        return null;
    }

    String interpret() {
        switch (this.ttype) {
            case -2: {
                return "number (" + this.nval + ")";
            }
            case -3: 
            case 34: {
                return "word (" + this.sval + ")";
            }
            case 10: {
                return "end of line";
            }
        }
        return "character '" + (char)this.ttype + "'";
    }

    void putBack() throws Exception {
        this.pushBack();
    }

    static Class[] getParameterTypes(String string) throws ClassNotFoundException {
        if (string == null) {
            return new Class[0];
        }
        if (string.equals("")) {
            return new Class[0];
        }
        int n = string.indexOf(44);
        if (n == -1) {
            return new Class[]{StructureTokenizer.getParameterType(string)};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        Class[] classArray = new Class[n2];
        for (int i = 0; i < n2; ++i) {
            classArray[i] = StructureTokenizer.getParameterType(stringTokenizer.nextToken());
        }
        return classArray;
    }

    private static Class getParameterType(String string) throws ClassNotFoundException {
        if (string.charAt(string.length() - 1) == ']') {
            int n = string.lastIndexOf(91);
            int n2 = string.indexOf(91);
            int[] nArray = new int[(n - n2) / 2 + 1];
            string = string.substring(0, n2);
            return Array.newInstance(StructureTokenizer.getParameterType(string), nArray).getClass();
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        return Utilities.classForName((String)string);
    }

    private static Method getMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuffer.append(c);
        }
        string = stringBuffer.toString();
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("Method " + string + " in " + clazz + " not found. Skipping.");
            throw noSuchMethodException;
        }
    }

    static Method getMethod(Class clazz, String string, String string2) throws NoSuchMethodException, ClassNotFoundException {
        return StructureTokenizer.getMethod(clazz, string, StructureTokenizer.getParameterTypes(string2));
    }
}

