/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashSet;
import javax.rmi.CORBA.Stub;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import weblogic.corba.rmic.IDLMangler;
import weblogic.corba.utils.RemoteInfo;
import weblogic.iiop.IDLUtils;
import weblogic.iiop.Utils;
import weblogic.kernel.Kernel;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.utils.AssertionError;
import weblogic.utils.Getopt2;
import weblogic.utils.classfile.ClassFile;
import weblogic.utils.classfile.CodeAttribute;
import weblogic.utils.classfile.CodeGenHelper;
import weblogic.utils.classfile.MethodInfo;
import weblogic.utils.classfile.Scope;
import weblogic.utils.classfile.Type;
import weblogic.utils.classfile.cp.CPFieldref;
import weblogic.utils.classfile.cp.CPMemberType;
import weblogic.utils.classfile.cp.CPMethodref;
import weblogic.utils.classfile.cp.ConstantPool;
import weblogic.utils.classfile.expr.AssignStatement;
import weblogic.utils.classfile.expr.CastExpression;
import weblogic.utils.classfile.expr.CatchExceptionExpression;
import weblogic.utils.classfile.expr.CompoundStatement;
import weblogic.utils.classfile.expr.Const;
import weblogic.utils.classfile.expr.ConstStringExpression;
import weblogic.utils.classfile.expr.Expression;
import weblogic.utils.classfile.expr.ExpressionStatement;
import weblogic.utils.classfile.expr.IfStatement;
import weblogic.utils.classfile.expr.InvokeSpecialExpression;
import weblogic.utils.classfile.expr.LHSExpression;
import weblogic.utils.classfile.expr.LocalVariableExpression;
import weblogic.utils.classfile.expr.MemberVarExpression;
import weblogic.utils.classfile.expr.NewArrayExpression;
import weblogic.utils.classfile.expr.NewExpression;
import weblogic.utils.classfile.expr.ReturnStatement;
import weblogic.utils.classfile.expr.Statement;
import weblogic.utils.classfile.expr.ThrowStatement;
import weblogic.utils.classfile.expr.TryCatchStatement;
import weblogic.utils.reflect.MethodSignatureBuilder;

public class StubGenerator
extends ClassFile {
    private static final String STUB_PACKAGE_PREFIX = "org.omg.stub.";
    public static final String IIOP = "iiop";
    public static final String IIOP_DIRECTORY = "iiopDirectory";
    private static final String TYPE_IDS_FIELD = "_type_ids";
    private final Class remoteInterface;
    private final RuntimeDescriptor descriptor;
    private final Class[] allInterfaces;
    private static boolean initialized;
    private static Method REQUEST_METHOD;
    private static Method INVOKE_METHOD;
    private static Method RELEASE_REPLY_METHOD;
    private Scope scope;
    private static final Expression[] VOIDPARAMS;
    private static Class INPUT_STREAM_23;

    public StubGenerator(Class clazz) {
        StubGenerator.init();
        this.remoteInterface = clazz;
        this.descriptor = RemoteInfo.findRemoteInfo(clazz).getDescriptor();
        this.setClassName(this.generateClassName());
        this.setSuperClassName(Stub.class.getName());
        this.allInterfaces = StubGenerator.getAllInterfaces(this.remoteInterface);
        for (int i = 0; i < this.allInterfaces.length; ++i) {
            this.addInterface(this.allInterfaces[i].getName());
        }
        this.addDefaultConstructor();
        this.addIds();
        this.addGetIdsMethod();
        this.addMethods();
    }

    private String generateClassName() {
        int n;
        String string = this.remoteInterface.getName();
        if (string.startsWith("javax.") || string.startsWith("java.")) {
            string = STUB_PACKAGE_PREFIX + string;
        }
        if ((n = string.lastIndexOf(".")) == -1) {
            return "_" + this.remoteInterface.getName() + "_Stub";
        }
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1, string.length());
        return string2 + "_" + string3 + "_Stub";
    }

    static synchronized void init() {
        if (initialized) {
            return;
        }
        try {
            Class[] classArray = new Class[]{String.class, Boolean.TYPE};
            REQUEST_METHOD = ObjectImpl.class.getMethod("_request", classArray);
            classArray = new Class[]{org.omg.CORBA.portable.OutputStream.class};
            INVOKE_METHOD = ObjectImpl.class.getMethod("_invoke", classArray);
            classArray = new Class[]{org.omg.CORBA.portable.InputStream.class};
            RELEASE_REPLY_METHOD = ObjectImpl.class.getMethod("_releaseReply", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Throwable)noSuchMethodException);
        }
        initialized = true;
    }

    private static Class[] getAllInterfaces(Class[] classArray) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < classArray.length; ++i) {
            StubGenerator.addSuperRemoteInterfaces(classArray[i], hashSet);
        }
        return hashSet.toArray(new Class[hashSet.size()]);
    }

    public static Class[] getAllInterfaces(Class clazz) {
        HashSet hashSet = new HashSet();
        StubGenerator.addSuperRemoteInterfaces(clazz, hashSet);
        return hashSet.toArray(new Class[hashSet.size()]);
    }

    private static void addSuperRemoteInterfaces(Class clazz, HashSet hashSet) {
        if (StubGenerator.isRemoteInterface(clazz) && !hashSet.contains(clazz)) {
            hashSet.add(clazz);
        }
        if (clazz.getSuperclass() != null) {
            StubGenerator.addSuperRemoteInterfaces(clazz.getSuperclass(), hashSet);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!StubGenerator.isRemoteInterface(classArray[i]) || hashSet.contains(classArray[i])) continue;
            hashSet.add(classArray[i]);
            StubGenerator.addSuperRemoteInterfaces(classArray[i], hashSet);
        }
    }

    private static boolean isRemoteInterface(Class clazz) {
        return clazz.isInterface() && Remote.class.isAssignableFrom(clazz) && !clazz.equals(Remote.class);
    }

    private void addDefaultConstructor() {
        MethodInfo methodInfo = this.addMethod("<init>", "()V", 1);
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        CPMethodref cPMethodref = this.cp.getMethodref("javax/rmi/CORBA/Stub", "<init>", "()V");
        codeAttribute.setCode((Statement)new ReturnStatement((Expression)new InvokeSpecialExpression((CPMemberType)cPMethodref, Const.THIS, VOIDPARAMS)));
    }

    private void addIds() {
        this.addField(TYPE_IDS_FIELD, "[Ljava/lang/String;", 10);
        MethodInfo methodInfo = this.addMethod("<clinit>", "()V", 8);
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        CPFieldref cPFieldref = this.cp.getFieldref(this.getClassName(), TYPE_IDS_FIELD, "[Ljava/lang/String;");
        int n = StubGenerator.isRemoteInterface(this.remoteInterface) ? 0 : 1;
        Expression[] expressionArray = new Expression[this.allInterfaces.length + n];
        if (n > 0) {
            expressionArray[0] = Const.get((String)IDLUtils.getTypeID(this.remoteInterface));
        }
        for (int i = 0; i < this.allInterfaces.length; ++i) {
            expressionArray[i + n] = Const.get((String)IDLUtils.getTypeID(this.allInterfaces[i]));
        }
        CompoundStatement compoundStatement = new CompoundStatement();
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)new MemberVarExpression(cPFieldref), (Expression)new NewArrayExpression(String.class, expressionArray)));
        compoundStatement.add((Statement)new ReturnStatement());
        codeAttribute.setCode((Statement)compoundStatement);
    }

    private void addGetIdsMethod() {
        MethodInfo methodInfo = this.addMethod("_ids", "()[Ljava/lang/String;", 1);
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        ConstantPool constantPool = methodInfo.getConstantPool();
        CPFieldref cPFieldref = constantPool.getFieldref(this.getClassName(), TYPE_IDS_FIELD, "[Ljava/lang/String;");
        ReturnStatement returnStatement = new ReturnStatement((Expression)new MemberVarExpression(cPFieldref));
        codeAttribute.setCode((Statement)new ReturnStatement((Expression)new MemberVarExpression(cPFieldref)));
    }

    public void addMethods() {
        if (this.remoteInterface.isInterface()) {
            Method[] methodArray = this.remoteInterface.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                this.addMethod(methodArray[i]);
            }
        } else {
            HashSet<Method> hashSet = new HashSet<Method>();
            Class<?>[] classArray = this.remoteInterface.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!StubGenerator.isRemoteInterface(classArray[i])) continue;
                Method[] methodArray = classArray[i].getMethods();
                for (int j = 0; j < methodArray.length; ++j) {
                    if (hashSet.contains(methodArray[j])) continue;
                    hashSet.add(methodArray[j]);
                    this.addMethod(methodArray[j]);
                }
            }
        }
    }

    private void addMethod(Method method) {
        int n = method.getModifiers();
        n &= 7;
        MethodInfo methodInfo = this.addMethod(method, n |= 0x10);
        this.scope = methodInfo.getScope();
        methodInfo.addException(this.cp.getClass("java/rmi/RemoteException"));
        methodInfo.getCodeAttribute().setCode(this.getCodeForMethod(method));
    }

    private Statement getCodeForMethod(Method method) {
        CompoundStatement compoundStatement = new CompoundStatement();
        compoundStatement.add(this.generateOuterTryCatch(method));
        compoundStatement.add((Statement)new ReturnStatement());
        return compoundStatement;
    }

    private Statement generateOuterTryCatch(Method method) {
        TryCatchStatement tryCatchStatement = new TryCatchStatement();
        tryCatchStatement.setBody(this.generateInnerTryCatch(method));
        tryCatchStatement.addHandler("org/omg/CORBA/SystemException", this.generateHandleSystemException());
        return tryCatchStatement;
    }

    private Statement generateInnerTryCatch(Method method) {
        LocalVariableExpression localVariableExpression = this.scope.createLocalVar(Type.OBJECT);
        CompoundStatement compoundStatement = new CompoundStatement();
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)localVariableExpression, Const.NULL));
        TryCatchStatement tryCatchStatement = new TryCatchStatement();
        tryCatchStatement.setBody(this.genMarshalingCode(method, localVariableExpression));
        tryCatchStatement.addHandler("org/omg/CORBA/portable/ApplicationException", this.generateHandleApplicationException(method, localVariableExpression));
        tryCatchStatement.addHandler("org/omg/CORBA/portable/RemarshalException", this.generateHandleRemarshalException(method));
        tryCatchStatement.setFinally(this.generateReleaseReply(localVariableExpression));
        compoundStatement.add((Statement)tryCatchStatement);
        return compoundStatement;
    }

    private boolean isOneway(Method method) {
        if (this.descriptor == null) {
            return false;
        }
        return this.descriptor.getClientMethodDescriptor(MethodSignatureBuilder.compute((Method)method)).isOneway();
    }

    private boolean hasNonPrimitiveParam(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].isPrimitive()) continue;
            return true;
        }
        return false;
    }

    private Statement genMarshalingCode(Method method, LocalVariableExpression localVariableExpression) {
        Class[] classArray = method.getParameterTypes();
        Expression[] expressionArray = this.scope.getArgs();
        CompoundStatement compoundStatement = new CompoundStatement();
        LocalVariableExpression localVariableExpression2 = this.scope.createLocalVar(Type.OBJECT);
        Expression expression = this.getRequest(method);
        if (this.hasNonPrimitiveParam(classArray)) {
            expression = new CastExpression(OutputStream.class, expression);
        }
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)localVariableExpression2, expression));
        for (int i = 0; i < classArray.length; ++i) {
            compoundStatement.add((Statement)new ExpressionStatement(this.genWriteParam((Expression)localVariableExpression2, classArray[i], expressionArray[i])));
        }
        Expression expression2 = this.getInvoke((Expression)localVariableExpression2);
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.TYPE || this.isOneway(method)) {
            compoundStatement.add((Statement)new ExpressionStatement(expression2));
            return compoundStatement;
        }
        if (!clazz.isPrimitive()) {
            expression2 = new CastExpression(INPUT_STREAM_23, expression2);
        }
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)localVariableExpression, expression2));
        compoundStatement.add((Statement)new ReturnStatement(this.genReadParam((Expression)localVariableExpression, clazz)));
        return compoundStatement;
    }

    private Expression genWriteParam(Expression expression, Class clazz, Expression expression2) {
        if (clazz.isPrimitive()) {
            return this.genWritePrimitive(expression, clazz, expression2);
        }
        if (Remote.class.isAssignableFrom(clazz) || Object.class.isAssignableFrom(clazz)) {
            return this.genWriteRemote(expression, expression2);
        }
        if (clazz.equals(java.lang.Object.class) || clazz.equals(Serializable.class) || clazz.equals(Externalizable.class)) {
            return this.genWriteAny(expression, expression2);
        }
        if (Utils.isAbstractInterface(clazz)) {
            return this.genWriteAbstractInterface(expression, expression2);
        }
        return this.genWriteValue(expression, clazz, expression2);
    }

    private Expression genReadParam(Expression expression, Class clazz) {
        if (clazz.isPrimitive()) {
            return this.genReadPrimitive(expression, clazz);
        }
        if (clazz.equals(java.lang.Object.class) || clazz.equals(Serializable.class) || clazz.equals(Externalizable.class)) {
            return this.genReadAny(expression, clazz);
        }
        if (Remote.class.isAssignableFrom(clazz) || Object.class.isAssignableFrom(clazz)) {
            return this.genReadRemote(expression, clazz);
        }
        if (Utils.isAbstractInterface(clazz)) {
            return this.genReadAbstractInterface(expression, clazz);
        }
        return this.genReadValue(expression, clazz);
    }

    private Expression genWritePrimitive(Expression expression, Class clazz, Expression expression2) {
        CPMethodref cPMethodref = null;
        if (clazz == Integer.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_long", "(I)V");
        } else if (clazz == Byte.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_octet", "(B)V");
        } else if (clazz == Boolean.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_boolean", "(Z)V");
        } else if (clazz == Short.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_short", "(S)V");
        } else if (clazz == Long.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_longlong", "(J)V");
        } else if (clazz == Float.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_float", "(F)V");
        } else if (clazz == Character.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_wchar", "(C)V");
        } else if (clazz == Double.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.OutputStream.class, "write_double", "(D)V");
        } else {
            throw new AssertionError("Unknown primitive: " + clazz);
        }
        return cPMethodref.invoke(expression, new Expression[]{expression2});
    }

    private Expression genReadPrimitive(Expression expression, Class clazz) {
        CPMethodref cPMethodref = null;
        if (clazz == Integer.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_long", "()I");
        } else if (clazz == Byte.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_octet", "()B");
        } else if (clazz == Boolean.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_boolean", "()Z");
        } else if (clazz == Short.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_short", "()S");
        } else if (clazz == Long.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_longlong", "()J");
        } else if (clazz == Float.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_float", "()F");
        } else if (clazz == Character.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_wchar", "()C");
        } else if (clazz == Double.TYPE) {
            cPMethodref = this.cp.getMethodref(org.omg.CORBA.portable.InputStream.class, "read_double", "()D");
        } else {
            throw new AssertionError("Unknown primitive: " + clazz);
        }
        return cPMethodref.invoke(expression, VOIDPARAMS);
    }

    private Expression genWriteRemote(Expression expression, Expression expression2) {
        CPMethodref cPMethodref = this.cp.getMethodref("javax/rmi/CORBA/Util", "writeRemoteObject", "(Lorg/omg/CORBA/portable/OutputStream;Ljava/lang/Object;)V");
        return cPMethodref.invokeStatic(new Expression[]{expression, expression2});
    }

    private Expression genReadRemote(Expression expression, Class clazz) {
        CPMethodref cPMethodref = this.cp.getMethodref("javax/rmi/PortableRemoteObject", "narrow", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
        return new CastExpression(clazz, cPMethodref.invokeStatic(new Expression[]{this.genReadObject(expression, clazz), Const.get((Class)clazz)}));
    }

    private Expression genWriteAny(Expression expression, Expression expression2) {
        CPMethodref cPMethodref = this.cp.getMethodref("javax/rmi/CORBA/Util", "writeAny", "(Lorg/omg/CORBA/portable/OutputStream;Ljava/lang/Object;)V");
        return cPMethodref.invokeStatic(new Expression[]{expression, expression2});
    }

    private Expression genWriteAbstractInterface(Expression expression, Expression expression2) {
        CPMethodref cPMethodref = this.cp.getMethodref("javax/rmi/CORBA/Util", "writeAbstractObject", "(Lorg/omg/CORBA/portable/OutputStream;Ljava/lang/Object;)V");
        return cPMethodref.invokeStatic(new Expression[]{expression, expression2});
    }

    private Expression genReadAny(Expression expression, Class clazz) {
        CPMethodref cPMethodref = this.cp.getMethodref("javax/rmi/CORBA/Util", "readAny", "(Lorg/omg/CORBA/portable/InputStream;)Ljava/lang/Object;");
        return new CastExpression(clazz, cPMethodref.invokeStatic(new Expression[]{expression}));
    }

    private Expression genReadAbstractInterface(Expression expression, Class clazz) {
        CPMethodref cPMethodref = this.cp.getMethodref("org/omg/CORBA_2_3/portable/InputStream", "read_abstract_interface", "()Ljava/lang/Object;");
        return new CastExpression(clazz, cPMethodref.invoke(expression, VOIDPARAMS));
    }

    private Expression genReadObject(Expression expression, Class clazz) {
        CPMethodref cPMethodref = this.cp.getMethodref("org/omg/CORBA/portable/InputStream", "read_Object", "()Lorg/omg/CORBA/Object;");
        return new CastExpression(clazz, cPMethodref.invoke(expression, VOIDPARAMS));
    }

    private Expression genWriteValue(Expression expression, Class clazz, Expression expression2) {
        CPMethodref cPMethodref = this.cp.getMethodref("org/omg/CORBA_2_3/portable/OutputStream", "write_value", "(Ljava/io/Serializable;Ljava/lang/Class;)V");
        return cPMethodref.invoke(expression, new Expression[]{expression2, Const.get((Class)clazz)});
    }

    private Expression genReadValue(Expression expression, Class clazz) {
        CPMethodref cPMethodref = this.cp.getMethodref("org/omg/CORBA_2_3/portable/InputStream", "read_value", "(Ljava/lang/Class;)Ljava/io/Serializable;");
        return new CastExpression(clazz, cPMethodref.invoke(expression, new Expression[]{Const.get((Class)clazz)}));
    }

    private Statement generateHandleSystemException() {
        CPMethodref cPMethodref = this.cp.getMethodref("javax/rmi/CORBA/Util", "mapSystemException", "(Lorg/omg/CORBA/SystemException;)Ljava/rmi/RemoteException;");
        CompoundStatement compoundStatement = new CompoundStatement();
        LocalVariableExpression localVariableExpression = this.scope.createLocalVar(Type.OBJECT);
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)localVariableExpression, (Expression)new CatchExceptionExpression()));
        compoundStatement.add((Statement)new ThrowStatement(cPMethodref.invokeStatic(new Expression[]{localVariableExpression})));
        this.scope.freeLocalVar(localVariableExpression);
        return compoundStatement;
    }

    private Statement generateHandleApplicationException(Method method, LocalVariableExpression localVariableExpression) {
        CPMethodref cPMethodref = this.cp.getMethodref("org/omg/CORBA/portable/ApplicationException", "getInputStream", "()Lorg/omg/CORBA/portable/InputStream;");
        CPMethodref cPMethodref2 = this.cp.getMethodref("org/omg/CORBA/portable/InputStream", "read_string", "()Ljava/lang/String;");
        CPMethodref cPMethodref3 = this.cp.getMethodref("java/rmi/UnexpectedException", "<init>", "(Ljava/lang/String;)V");
        CompoundStatement compoundStatement = new CompoundStatement();
        LocalVariableExpression localVariableExpression2 = this.scope.createLocalVar(Type.OBJECT);
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)localVariableExpression2, (Expression)new CatchExceptionExpression()));
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)localVariableExpression, (Expression)new CastExpression(INPUT_STREAM_23, cPMethodref.invoke((Expression)localVariableExpression2, VOIDPARAMS))));
        LocalVariableExpression localVariableExpression3 = this.scope.createLocalVar(Type.OBJECT);
        compoundStatement.add((Statement)new AssignStatement((LHSExpression)localVariableExpression3, cPMethodref2.invoke((Expression)localVariableExpression, VOIDPARAMS)));
        Class[] classArray = this.getCheckedExceptions(method);
        compoundStatement.add(this.genCheckedExceptions(classArray, (Expression)localVariableExpression, (Expression)localVariableExpression3));
        compoundStatement.add((Statement)new ThrowStatement((Expression)new NewExpression(cPMethodref3, new Expression[]{localVariableExpression3})));
        this.scope.freeLocalVar(localVariableExpression2);
        return compoundStatement;
    }

    private Statement genCheckedExceptions(Class[] classArray, Expression expression, Expression expression2) {
        CompoundStatement compoundStatement = new CompoundStatement();
        CPMethodref cPMethodref = this.cp.getMethodref("java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
        for (int i = 0; i < classArray.length; ++i) {
            ConstStringExpression constStringExpression = Const.get((String)Utils.getIDFromException(classArray[i]));
            compoundStatement.add((Statement)new IfStatement(cPMethodref.invoke(expression2, new Expression[]{constStringExpression}), (Statement)new ThrowStatement((Expression)new CastExpression(classArray[i], this.genReadValue(expression, classArray[i])))));
        }
        return compoundStatement;
    }

    private Class[] getCheckedExceptions(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        int n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            if (this.isCheckedException(classArray[i])) {
                ++n;
                continue;
            }
            classArray[i] = null;
        }
        Class[] classArray2 = new Class[n];
        n = 0;
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == null) continue;
            classArray2[n++] = classArray[i];
        }
        return classArray2;
    }

    private boolean isCheckedException(Class clazz) {
        return !RemoteException.class.isAssignableFrom(clazz);
    }

    private Statement generateHandleRemarshalException(Method method) {
        CPMethodref cPMethodref = this.cp.getMethodref(this.getClassName(), method.getName(), CodeGenHelper.getMethodDescriptor((Method)method));
        CompoundStatement compoundStatement = new CompoundStatement();
        compoundStatement.add((Statement)new ExpressionStatement((Expression)new CatchExceptionExpression()));
        if (method.getReturnType() == Void.TYPE) {
            compoundStatement.add((Statement)new ExpressionStatement(cPMethodref.invoke(this.scope.getArgs())));
        } else {
            compoundStatement.add((Statement)new ReturnStatement(cPMethodref.invoke(this.scope.getArgs())));
        }
        return compoundStatement;
    }

    private Statement generateReleaseReply(LocalVariableExpression localVariableExpression) {
        CPMethodref cPMethodref = this.cp.getMethodref(RELEASE_REPLY_METHOD);
        Expression[] expressionArray = new Expression[]{localVariableExpression};
        return new ExpressionStatement(cPMethodref.invoke(expressionArray));
    }

    private Expression getRequest(Method method) {
        CPMethodref cPMethodref = this.cp.getMethodref(REQUEST_METHOD);
        Expression[] expressionArray = new Expression[]{this.getMangledName(method), Const.get((!this.isOneway(method) ? 1 : 0) != 0)};
        return cPMethodref.invoke(expressionArray);
    }

    private Expression getMangledName(Method method) {
        return Const.get((String)IDLMangler.getMangledMethodName(method, this.remoteInterface));
    }

    private Expression getInvoke(Expression expression) {
        CPMethodref cPMethodref = this.cp.getMethodref(INVOKE_METHOD);
        Expression[] expressionArray = new Expression[]{expression};
        return cPMethodref.invoke(expressionArray);
    }

    public static void addOpts(Getopt2 getopt2) {
        getopt2.addFlag(IIOP, "Generate iiop stubs from servers");
        getopt2.addOption(IIOP_DIRECTORY, "directory", "Specify the directory where IIOP proxy classes will be written (overrides target directory)");
    }

    private static void ensureDirectoryExists(String string, String string2) {
        String string3 = "";
        int n = string2.lastIndexOf(File.separatorChar);
        if (n != -1) {
            string3 = string2.substring(0, n);
        }
        String string4 = string + File.separatorChar + string3;
        File file = new File(string4);
        file.mkdirs();
    }

    public static void generate(Getopt2 getopt2) throws Exception {
        String string = getopt2.getOption(IIOP_DIRECTORY, null);
        if (string == null) {
            string = getopt2.getOption("d", null);
        }
        if (string == null) {
            string = ".";
        }
        Kernel.ensureInitialized();
        String[] stringArray = getopt2.args();
        Class[] classArray = new Class[stringArray.length];
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = StubGenerator.class.getClassLoader();
        }
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i], true, classLoader);
        }
        Class[] classArray2 = StubGenerator.getAllInterfaces(classArray);
        for (int i = 0; i < classArray2.length; ++i) {
            StubGenerator stubGenerator = new StubGenerator(classArray2[i]);
            String string2 = stubGenerator.getClassName().replace('.', File.separatorChar) + ".class";
            StubGenerator.ensureDirectoryExists(string, string2);
            stubGenerator.write(new FileOutputStream(string + File.separatorChar + string2));
        }
    }

    public static void main(String[] stringArray) {
        try {
            Getopt2 getopt2 = new Getopt2();
            getopt2.grok(stringArray);
            StubGenerator.generate(getopt2);
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception);
            exception.printStackTrace();
        }
    }

    static {
        VOIDPARAMS = new Expression[0];
        INPUT_STREAM_23 = InputStream.class;
    }
}

