/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.util.Arrays;
import java.util.Random;
import weblogic.corba.utils.IndirectionHashtable;

public final class AlternateIndirectionHashtable {
    private static final boolean DEBUG = false;
    private int[] bucketToHandleMap;
    private Object[] handleToObjectMap;
    private int[] handleMap;
    private int count;
    private float loadFactor;
    private int threshold;
    private int capacity;

    public AlternateIndirectionHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.bucketToHandleMap = new int[this.capacity];
        this.handleToObjectMap = new Object[this.capacity];
        this.handleMap = new int[this.capacity * 2];
        this.threshold = (int)(f * (float)this.capacity);
        this.clear();
    }

    public AlternateIndirectionHashtable() {
        this(16, 3.0f);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private static final int hash(int n) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    public Object get(int n) {
        int n2 = AlternateIndirectionHashtable.hash(n) & this.bucketToHandleMap.length - 1;
        int n3 = this.bucketToHandleMap[n2];
        while (n3 >= 0) {
            if (this.handleMap[n3 + this.capacity] == n) {
                return this.handleToObjectMap[n3];
            }
            n3 = this.handleMap[n3];
        }
        return null;
    }

    public Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.putUnchecked(n, object);
    }

    private Object putUnchecked(int n, Object object) {
        if (this.count >= this.capacity) {
            this.increaseCapacity();
        }
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int n2 = AlternateIndirectionHashtable.hash(n) & this.bucketToHandleMap.length - 1;
        this.handleToObjectMap[this.count] = object;
        this.handleMap[this.count] = this.bucketToHandleMap[n2];
        this.handleMap[this.count + this.capacity] = n;
        this.bucketToHandleMap[n2] = this.count++;
        return object;
    }

    public int reserve(int n) {
        this.putUnchecked(n, null);
        return this.count - 1;
    }

    public void putReserved(int n, int n2, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.handleToObjectMap[n] = object;
    }

    private void increaseCapacity() {
        int n = this.capacity * 2 + 1;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.handleToObjectMap, 0, objectArray, 0, this.count);
        this.handleToObjectMap = objectArray;
        int[] nArray = new int[n * 2];
        System.arraycopy(this.handleMap, 0, nArray, 0, this.count);
        System.arraycopy(this.handleMap, this.capacity, nArray, n, this.count);
        this.handleMap = nArray;
        this.capacity = n;
    }

    private void rehash() {
        int n = this.bucketToHandleMap.length << 1;
        this.bucketToHandleMap = new int[n];
        Arrays.fill(this.bucketToHandleMap, -1);
        this.threshold = (int)((float)n * this.loadFactor);
        int n2 = 0;
        while (n2 < this.count) {
            int n3 = this.handleMap[n2 + this.capacity];
            int n4 = AlternateIndirectionHashtable.hash(n3) & n - 1;
            this.handleMap[n2] = this.bucketToHandleMap[n4];
            this.bucketToHandleMap[n4] = n2++;
        }
    }

    public void clear() {
        Arrays.fill(this.bucketToHandleMap, -1);
        Arrays.fill(this.handleToObjectMap, 0, this.count, null);
        this.count = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append("" + this.handleMap[i + this.capacity] + "=" + this.handleToObjectMap[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        IndirectionHashtable indirectionHashtable = new IndirectionHashtable();
        Random random = new Random(System.currentTimeMillis());
        int n2 = random.nextInt();
        int[] nArray = new int[63];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n2 + n * 3;
            object = String.valueOf(nArray[n]);
            indirectionHashtable.put(nArray[n], object);
            System.out.println("put: " + nArray[n] + ", '" + object + "'");
        }
        System.out.println("TABLE: \n" + indirectionHashtable);
        for (n = 0; n < nArray.length; ++n) {
            object = indirectionHashtable.get(nArray[n]);
            if (object == null) {
                System.err.println("not found: " + nArray[n]);
                continue;
            }
            if (!object.equals(String.valueOf(nArray[n]))) {
                System.err.println(object + "!=" + String.valueOf(nArray[n]));
                continue;
            }
            System.out.println("OK: " + object);
        }
    }
}

