/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.ValueBase;
import weblogic.corba.utils.RepositoryId;
import weblogic.ejb.spi.PortableReplaceable;
import weblogic.iiop.IDLUtils;
import weblogic.iiop.Utils;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.collections.WeakConcurrentHashMap;
import weblogic.utils.io.ObjectStreamClass;

public final class ClassInfo {
    private static final Class[] NO_ARGS_METHOD = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class[] WRITE_OBJECT_ARGS = new Class[]{ObjectOutputStream.class};
    private static final boolean DEBUG = false;
    private static boolean useFullRepositoyIdList = false;
    private RepositoryId repId;
    private RepositoryId localRepId;
    private RepositoryId[] repIdList;
    private Class theClass;
    private Class idlHelper;
    private Method idlWriter;
    private Method idlReader;
    private boolean abstractInterface = false;
    private boolean portableReplaceable = false;
    private boolean idlEntity = false;
    private boolean streamable = false;
    private boolean valuebase = false;
    private boolean string = false;
    private ObjectStreamClass osc;
    private static WeakConcurrentHashMap classInfoMap = new WeakConcurrentHashMap();
    private static ConcurrentHashMap repositoryIdMap = new ConcurrentHashMap();

    public ClassInfo(RepositoryId repositoryId) {
        this(repositoryId, (String)null);
    }

    public ClassInfo(RepositoryId repositoryId, String string) {
        this.repId = repositoryId;
        this.theClass = Utils.getClassFromID(repositoryId, string);
        this.init();
    }

    public ClassInfo(Class clazz) {
        this.theClass = clazz;
        this.localRepId = this.repId = new RepositoryId(clazz);
        this.init();
    }

    private ClassInfo(RepositoryId repositoryId, Class clazz) {
        this.theClass = clazz;
        this.repId = repositoryId;
        this.localRepId = repositoryId;
        this.init();
    }

    private void init() {
        if (this.theClass != null) {
            this.osc = ObjectStreamClass.lookup((Class)this.theClass);
            this.abstractInterface = IDLUtils.isAbstractInterface(this.theClass);
            this.portableReplaceable = PortableReplaceable.class.isAssignableFrom(this.theClass);
            this.idlEntity = IDLEntity.class.isAssignableFrom(this.theClass);
            this.streamable = Streamable.class.isAssignableFrom(this.theClass);
            this.valuebase = ValueBase.class.isAssignableFrom(this.theClass);
            this.string = String.class.isAssignableFrom(this.theClass);
            if (this.localRepId == null) {
                this.repId.setClassLoader(this.theClass.getClassLoader());
                this.localRepId = new RepositoryId(this.theClass);
                if (this.localRepId.equals(this.repId)) {
                    this.localRepId = this.repId;
                }
            }
            if (this.osc != null && this.osc.isCustomMarshaled() && useFullRepositoyIdList) {
                this.repIdList = RepositoryId.getRepositoryIdList(this.theClass);
            }
        }
        if (this.repId != RepositoryId.STRING && this.repId.isIDLType()) {
            try {
                this.idlHelper = Utils.loadClass(this.repId.getClassName() + "Helper");
                this.idlReader = Utils.getDeclaredMethod(this.idlHelper, "read", Utils.READ_METHOD_ARGS);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public ObjectStreamClass getDescriptor() {
        return this.osc;
    }

    public Serializable writeReplace(Object object) {
        ObjectStreamClass objectStreamClass = this.osc;
        Class<?> clazz = this.theClass;
        try {
            while (objectStreamClass.hasWriteReplace() && (object = objectStreamClass.writeReplace(object)) != null && object.getClass() != clazz) {
                clazz = object.getClass();
                objectStreamClass = ObjectStreamClass.lookup(clazz);
            }
            return (Serializable)object;
        }
        catch (IOException iOException) {
            throw (MARSHAL)new MARSHAL(iOException.getMessage()).initCause((Throwable)iOException);
        }
    }

    public Class forClass() {
        return this.theClass;
    }

    public RepositoryId getRepositoryId() {
        return this.repId;
    }

    public RepositoryId getLocalRepositoryId() {
        return this.localRepId;
    }

    public RepositoryId[] getRepositoryIdList() {
        return this.repIdList;
    }

    public static final RepositoryId getRepositoryId(String string) {
        ClassInfo classInfo = ClassInfo.findClassInfo(new RepositoryId(string));
        return classInfo.getRepositoryId();
    }

    public Class getIDLHelper() {
        return this.idlHelper;
    }

    public Method getIDLReader() {
        return this.idlReader;
    }

    public Method getIDLWriter(Class clazz) {
        if (this.idlWriter == null && this.idlHelper != null) {
            this.idlWriter = this.getDeclaredMethod(this.idlHelper, "write", new Class[]{OutputStream.class, clazz});
        }
        return this.idlWriter;
    }

    public boolean isAbstractInterface() {
        return this.abstractInterface;
    }

    public boolean isPortableReplaceable() {
        return this.portableReplaceable;
    }

    public boolean isIDLEntity() {
        return this.idlEntity;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public boolean isValueBase() {
        return this.valuebase;
    }

    public boolean isString() {
        return this.string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            ClassInfo classInfo = (ClassInfo)object;
            return classInfo.theClass == this.theClass && classInfo.repId.equals(this.repId);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.repId == null ? 0 : this.repId.hashCode();
    }

    public String toString() {
        return "ClassInfo[" + this.repId.toPrettyString() + " => " + this.theClass + ", " + this.localRepId + "]";
    }

    private Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if (!method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static void putClassInfo(RepositoryId repositoryId, Class clazz) {
        ClassInfo classInfo = new ClassInfo(repositoryId, clazz);
        classInfo.addToMap(clazz);
        repositoryIdMap.put((Object)repositoryId, (Object)new ClassInfoReference(classInfo));
    }

    public static final ClassInfo findClassInfo(RepositoryId repositoryId) {
        return ClassInfo.findClassInfo(repositoryId, null);
    }

    public static final ClassInfo findClassInfo(RepositoryId repositoryId, String string) {
        ClassInfo classInfo;
        if (repositoryId == null) {
            return null;
        }
        ClassInfoReference classInfoReference = (ClassInfoReference)repositoryIdMap.get((Object)repositoryId);
        Object var3_3 = null;
        if (classInfoReference != null) {
            Object t = classInfoReference.get();
            var3_3 = t;
            if (t != null) {
                return var3_3;
            }
        }
        String string2 = Utils.getAnnotation(null);
        if (repositoryId.getAnnotation() == null && string2 != null) {
            repositoryId = new RepositoryId(repositoryId, string2);
            classInfoReference = (ClassInfoReference)repositoryIdMap.get((Object)repositoryId);
            classInfo = null;
            if (classInfoReference != null && (classInfo = classInfoReference.get()) != null) {
                ClassInfo classInfo2 = classInfo;
                if (classInfo2.theClass != null) {
                    if (classInfo2.theClass.getClassLoader() == Thread.currentThread().getContextClassLoader()) {
                        return classInfo2;
                    }
                    classInfoMap.remove((Object)classInfo2.theClass);
                } else {
                    return classInfo2;
                }
            }
        }
        classInfo = new ClassInfo(repositoryId, string);
        repositoryIdMap.put((Object)repositoryId, (Object)new ClassInfoReference(classInfo));
        if (!(classInfo.theClass == null || classInfoMap.get((Object)classInfo.theClass) != null || repositoryId != classInfo.getLocalRepositoryId() && classInfo.isValueType())) {
            classInfo.addToMap(classInfo.theClass);
        }
        return classInfo;
    }

    private final boolean isValueType() {
        if (this.theClass.isPrimitive() || IDLUtils.isRemote(this.theClass) || IDLUtils.isARemote(this.theClass) || IDLEntity.class.equals((Object)this.theClass)) {
            return false;
        }
        if (this.theClass.isInterface() && !this.isAbstractInterface()) {
            return true;
        }
        if (this.theClass.getComponentType() != null) {
            return false;
        }
        return Serializable.class.isAssignableFrom(this.theClass);
    }

    public static final ClassInfo findClassInfo(Class clazz) {
        ClassInfo classInfo = null;
        ClassInfoReference classInfoReference = (ClassInfoReference)classInfoMap.get((Object)clazz);
        Object var3_3 = null;
        if (classInfoReference != null) {
            Object t = classInfoReference.get();
            var3_3 = t;
            if (t != null) {
                classInfo = var3_3;
            }
        }
        if (classInfo == null) {
            classInfo = new ClassInfo(clazz);
            repositoryIdMap.put((Object)classInfo.repId, (Object)new ClassInfoReference(classInfo));
            classInfo.addToMap(clazz);
        }
        return classInfo;
    }

    private final void addToMap(Class clazz) {
        classInfoMap.put((Object)clazz, (Object)new ClassInfoReference(this));
    }

    public static final void initialize(boolean bl) {
        useFullRepositoyIdList = bl;
    }

    private static void p(String string) {
        System.out.println("<ClassInfo>: " + string);
    }

    static {
        ClassInfo.putClassInfo(RepositoryId.STRING, String.class);
    }

    private static class ClassInfoReference
    extends WeakReference {
        private int hash;

        ClassInfoReference(Object object) {
            super(object);
            this.hash = object.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClassInfoReference)) {
                return false;
            }
            ClassInfoReference classInfoReference = (ClassInfoReference)object;
            Object t = this.get();
            Object t2 = classInfoReference.get();
            return this.hash == classInfoReference.hash && (t == null ? t2 == null : t.equals(t2));
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

