/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.util.Random;

public final class IndirectionHashtable {
    private IndirectionTableEntry table;
    private IndirectionTableEntry tail;
    private int count;
    private final int tableSize;
    private static final int DEFAULT_TABLE_SIZE = 16;
    private static final Object NULL_OBJECT = new Object();

    public IndirectionHashtable(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.tableSize = n;
        this.table = this.tail = new IndirectionTableEntry(n);
    }

    public IndirectionHashtable() {
        this(16);
    }

    public boolean isEmpty() {
        return this.table.count == 0;
    }

    public Object get(int n) {
        IndirectionTableEntry indirectionTableEntry = this.table;
        if (indirectionTableEntry.count == 0) {
            return null;
        }
        while (indirectionTableEntry != null && indirectionTableEntry.positions[indirectionTableEntry.count - 1] < n) {
            indirectionTableEntry = indirectionTableEntry.next;
        }
        if (indirectionTableEntry == null) {
            return null;
        }
        int n2 = 0;
        int n3 = indirectionTableEntry.count - 1;
        while (indirectionTableEntry.positions[n2] < n && n < indirectionTableEntry.positions[n3]) {
            int n4 = (n3 - n2) / 2;
            if (n4 == 0) {
                return null;
            }
            if (n < indirectionTableEntry.positions[n2 + n4]) {
                n3 = n2 + n4;
                continue;
            }
            n2 += n4;
        }
        Object object = null;
        if (indirectionTableEntry.positions[n2] == n) {
            object = indirectionTableEntry.values[n2];
        } else if (indirectionTableEntry.positions[n3] == n) {
            object = indirectionTableEntry.values[n3];
        } else {
            return null;
        }
        return object == NULL_OBJECT ? null : object;
    }

    public Object remove(int n) {
        IndirectionTableEntry indirectionTableEntry = this.table;
        if (indirectionTableEntry.count == 0) {
            return null;
        }
        if (this.tail.positions[this.tail.count - 1] == n) {
            --this.tail.count;
            Object object = this.tail.values[this.tail.count];
            this.tail.values[this.tail.count] = null;
            this.tail.positions[this.tail.count] = 0;
            if (this.tail.count == 0 && indirectionTableEntry != this.tail) {
                while (indirectionTableEntry.next != this.tail) {
                    indirectionTableEntry = indirectionTableEntry.next;
                }
                this.tail = indirectionTableEntry;
                indirectionTableEntry.next = null;
            }
            return object;
        }
        while (indirectionTableEntry != null && indirectionTableEntry.positions[indirectionTableEntry.count - 1] < n) {
            indirectionTableEntry = indirectionTableEntry.next;
        }
        if (indirectionTableEntry == null) {
            return null;
        }
        int n2 = 0;
        int n3 = indirectionTableEntry.count - 1;
        while (indirectionTableEntry.positions[n2] < n && n < indirectionTableEntry.positions[n3]) {
            int n4 = (n3 - n2) / 2;
            if (n4 == 0) {
                return null;
            }
            if (n < indirectionTableEntry.positions[n2 + n4]) {
                n3 = n2 + n4;
                continue;
            }
            n2 += n4;
        }
        Object object = null;
        if (indirectionTableEntry.positions[n2] == n) {
            object = indirectionTableEntry.values[n2];
            indirectionTableEntry.values[n2] = null;
        } else if (indirectionTableEntry.positions[n3] == n) {
            object = indirectionTableEntry.values[n3];
            indirectionTableEntry.values[n3] = null;
        }
        return object == NULL_OBJECT ? null : object;
    }

    public Object put(int n, Object object) {
        if (object == null) {
            object = NULL_OBJECT;
        }
        if (this.tail.count > 0 && n < this.tail.positions[this.tail.count - 1]) {
            throw new IllegalArgumentException("Out of order key: " + n + " " + this.toString());
        }
        if (this.tail.count >= this.tableSize) {
            this.tail.next = new IndirectionTableEntry(this.tableSize);
            this.tail.next.prev = this.tail;
            this.tail = this.tail.next;
        }
        this.tail.positions[this.tail.count] = n;
        this.tail.values[this.tail.count++] = object;
        return object;
    }

    public int reserve(int n) {
        if (this.tail.count > 0 && n < this.tail.positions[this.tail.count - 1]) {
            throw new IllegalArgumentException("Out of order key: " + n + " " + this.toString());
        }
        if (this.tail.count >= this.tableSize) {
            this.tail.next = new IndirectionTableEntry(this.tableSize);
            this.tail.next.prev = this.tail;
            this.tail = this.tail.next;
        }
        this.tail.positions[this.tail.count] = n;
        this.tail.values[this.tail.count++] = null;
        return this.tail.count - 1;
    }

    public void putReserved(int n, int n2, Object object) {
        if (object == null) {
            object = NULL_OBJECT;
        }
        IndirectionTableEntry indirectionTableEntry = this.tail;
        while (indirectionTableEntry.count < n || indirectionTableEntry.positions[n] != n2) {
            indirectionTableEntry = indirectionTableEntry.prev;
        }
        if (indirectionTableEntry.count < n || indirectionTableEntry.positions[n] != n2) {
            throw new IllegalArgumentException("No reserved slot for: " + n);
        }
        indirectionTableEntry.values[n] = object;
    }

    public void clear() {
        this.table.next = null;
        this.tail = this.table;
        for (int i = 0; i < this.table.count; ++i) {
            this.table.positions[i] = 0;
            this.table.values[i] = null;
        }
        this.table.count = 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        IndirectionTableEntry indirectionTableEntry = this.table;
        while (indirectionTableEntry != null) {
            for (int i = 0; i < indirectionTableEntry.count; ++i) {
                stringBuffer.append("" + indirectionTableEntry.positions[i] + "=" + indirectionTableEntry.values[i]);
                stringBuffer.append(", ");
            }
            indirectionTableEntry = indirectionTableEntry.next;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        IndirectionHashtable indirectionHashtable = new IndirectionHashtable();
        Random random = new Random(System.currentTimeMillis());
        int n2 = random.nextInt();
        int[] nArray = new int[63];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n2 + n * 3;
            object = String.valueOf(nArray[n]);
            indirectionHashtable.put(nArray[n], object);
            System.out.println("put: " + nArray[n] + ", '" + object + "'");
        }
        System.out.println("TABLE: \n" + indirectionHashtable);
        for (n = 0; n < nArray.length; ++n) {
            object = indirectionHashtable.get(nArray[n]);
            if (object == null) {
                System.err.println("not found: " + nArray[n]);
                continue;
            }
            if (!object.equals(String.valueOf(nArray[n]))) {
                System.err.println(object + "!=" + String.valueOf(nArray[n]));
                continue;
            }
            System.out.println("OK: " + object);
        }
    }

    static final class IndirectionTableEntry {
        int count = 0;
        final int[] positions;
        final Object[] values;
        IndirectionTableEntry next;
        IndirectionTableEntry prev;

        IndirectionTableEntry(int n) {
            this.positions = new int[n];
            this.values = new Object[n];
        }
    }
}

