/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.util.Arrays;
import java.util.Random;

public final class IndirectionValueHashtable {
    private static final boolean DEBUG = false;
    private int[] bucketToHandleMap;
    private Object[] handleToObjectMap;
    private int[] handleMap;
    private int count;
    private int threshold;
    private int capacity;
    private float loadFactor;

    public IndirectionValueHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.bucketToHandleMap = new int[n];
        this.handleToObjectMap = new Object[n];
        this.handleMap = new int[n * 3];
        this.threshold = (int)((float)n * f);
        this.capacity = n;
        this.clear();
    }

    public IndirectionValueHashtable(int n) {
        this(n, 3.0f);
    }

    public IndirectionValueHashtable() {
        this(10, 3.0f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private static final int hash(Object object, int n) {
        if (object instanceof String) {
            return object.hashCode() + n & Integer.MAX_VALUE;
        }
        return System.identityHashCode(object) + n & Integer.MAX_VALUE;
    }

    public int get(Object object, int n) {
        int n2 = IndirectionValueHashtable.hash(object, n);
        int n3 = this.bucketToHandleMap[n2 % this.bucketToHandleMap.length];
        while (n3 >= 0) {
            if (object instanceof String && object.equals(this.handleToObjectMap[n3])) {
                return this.handleMap[n3 + this.capacity];
            }
            if (this.handleToObjectMap[n3] == object) {
                return this.handleMap[n3 + this.capacity];
            }
            n3 = this.handleMap[n3];
        }
        return -n2;
    }

    private void increaseCapacity() {
        int n = this.capacity * 2 + 1;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.handleToObjectMap, 0, objectArray, 0, this.count);
        this.handleToObjectMap = objectArray;
        int[] nArray = new int[n * 3];
        System.arraycopy(this.handleMap, 0, nArray, 0, this.count);
        System.arraycopy(this.handleMap, this.capacity, nArray, n, this.count);
        System.arraycopy(this.handleMap, this.capacity * 2, nArray, n * 2, this.count);
        this.handleMap = nArray;
        this.capacity = n;
    }

    private void rehash() {
        int n = this.bucketToHandleMap.length * 2 + 1;
        this.bucketToHandleMap = new int[n];
        Arrays.fill(this.bucketToHandleMap, -1);
        this.threshold = (int)((float)n * this.loadFactor);
        int n2 = 0;
        while (n2 < this.count) {
            Object object = this.handleToObjectMap[n2];
            int n3 = this.handleMap[n2 + this.capacity * 2] % this.bucketToHandleMap.length;
            this.handleMap[n2] = this.bucketToHandleMap[n3];
            this.bucketToHandleMap[n3] = n2++;
        }
    }

    public void put(Object object, int n, int n2, int n3) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.capacity) {
            this.increaseCapacity();
        }
        if (this.count >= this.threshold) {
            this.rehash();
        }
        n3 = n3 == 0 ? IndirectionValueHashtable.hash(object, n) : -n3;
        int n4 = n3 % this.bucketToHandleMap.length;
        this.handleToObjectMap[this.count] = object;
        this.handleMap[this.count] = this.bucketToHandleMap[n4];
        this.handleMap[this.count + this.capacity] = n2;
        this.handleMap[this.count + this.capacity * 2] = n3;
        this.bucketToHandleMap[n4] = this.count++;
    }

    public void put(Object object, int n, int n2) {
        this.put(object, n, n2, 0);
    }

    public void clear() {
        Arrays.fill(this.bucketToHandleMap, -1);
        Arrays.fill(this.handleToObjectMap, 0, this.count, null);
        this.count = 0;
    }

    public static void main(String[] stringArray) {
        int n;
        IndirectionValueHashtable indirectionValueHashtable = new IndirectionValueHashtable();
        Random random = new Random(System.currentTimeMillis());
        int n2 = random.nextInt();
        Object[] objectArray = new Object[127];
        int[] nArray = new int[127];
        for (n = 0; n < objectArray.length; ++n) {
            nArray[n] = random.nextInt();
            objectArray[n] = String.valueOf(nArray[n]);
            indirectionValueHashtable.put(objectArray[n], n % 2, nArray[n]);
        }
        System.out.println("TABLE: \n" + indirectionValueHashtable);
        for (n = 0; n < objectArray.length; ++n) {
            int n3 = indirectionValueHashtable.get(objectArray[n], n % 2);
            if (n3 == 0) {
                System.err.println("not found: " + objectArray[n]);
                continue;
            }
            if (n3 != nArray[n]) {
                System.err.println(n3 + "!=" + nArray[n]);
                continue;
            }
            System.out.println("OK: " + objectArray[n]);
        }
    }
}

