/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.Serializable;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class MarshaledString
implements Serializable {
    static final int MAX_STRING_SIZE = 524288;
    public static final MarshaledString EMPTY = new MarshaledString("");
    protected byte[] encodedString;
    private String string;
    protected int hash;

    public MarshaledString(InputStream inputStream, int n) {
        this.read(inputStream, n);
    }

    MarshaledString(MarshaledString marshaledString) {
        this.encodedString = marshaledString.encodedString;
        this.string = marshaledString.string;
        this.hash = marshaledString.hash;
    }

    public MarshaledString(InputStream inputStream) {
        this.read(inputStream, inputStream.read_ulong());
    }

    MarshaledString() {
    }

    public MarshaledString(String string) {
        this.string = string;
        int n = this.string.length();
        this.encodedString = new byte[n];
        this.string.getBytes(0, n, this.encodedString, 0);
    }

    public final int length() {
        return this.encodedString.length;
    }

    public final byte[] getEncoded() {
        return this.encodedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.hash == 0) {
            MarshaledString marshaledString = this;
            synchronized (marshaledString) {
                if (this.hash == 0) {
                    int n = 0;
                    int n2 = this.encodedString.length;
                    for (int i = 0; i < n2; ++i) {
                        n = 31 * n + this.encodedString[i];
                    }
                    this.hash = n;
                }
            }
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MarshaledString)) {
            return false;
        }
        MarshaledString marshaledString = (MarshaledString)object;
        return this.compareStrings(marshaledString);
    }

    public boolean compareStrings(MarshaledString marshaledString) {
        if (marshaledString == this) {
            return true;
        }
        if (marshaledString == null || this.hashCode() != marshaledString.hashCode()) {
            return false;
        }
        if (marshaledString.encodedString.length == this.encodedString.length) {
            int n = this.encodedString.length;
            while (n-- > 0) {
                if (this.encodedString[n] == marshaledString.encodedString[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final String toString() {
        if (this.string == null) {
            this.string = new String(this.encodedString, 0);
        }
        return this.string;
    }

    public final void write(OutputStream outputStream) {
        outputStream.write_ulong(this.encodedString.length + 1);
        outputStream.write_octet_array(this.encodedString, 0, this.encodedString.length);
        outputStream.write_octet((byte)0);
    }

    public final void read(InputStream inputStream, int n) {
        if (n > 524288) {
            throw new MARSHAL("Stream corrupted: tried to read string of length " + Integer.toHexString(n));
        }
        this.encodedString = new byte[n - 1];
        inputStream.read_octet_array(this.encodedString, 0, this.encodedString.length);
        inputStream.read_octet();
    }
}

