/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import weblogic.corba.rmic.StubGenerator;
import weblogic.corba.utils.RepositoryId;
import weblogic.iiop.Utils;
import weblogic.rmi.internal.DescriptorManager;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.collections.WeakConcurrentHashMap;

public final class RemoteInfo {
    private RepositoryId repId;
    private Class theClass;
    private boolean idlInterface = false;
    private RuntimeDescriptor descriptor = null;
    private static WeakConcurrentHashMap classInfoMap = new WeakConcurrentHashMap();
    private static ConcurrentHashMap repositoryIdMap = new ConcurrentHashMap();

    public RemoteInfo(RepositoryId repositoryId) {
        this.repId = repositoryId;
        this.theClass = Utils.getClassFromID(repositoryId);
        this.init();
    }

    public RemoteInfo(Class clazz) {
        this.theClass = clazz;
        this.repId = new RepositoryId(clazz);
        this.init();
    }

    private RemoteInfo(RepositoryId repositoryId, Class clazz) {
        this.repId = repositoryId;
        this.theClass = clazz;
        this.init();
    }

    private void init() {
        this.idlInterface = Utils.isIDLInterface(this.theClass);
        this.repId.setClassLoader(this.theClass.getClassLoader());
        try {
            Class clazz;
            this.descriptor = DescriptorManager.createRuntimeDescriptor((Class)this.theClass);
            if (this.descriptor == null && (clazz = Utils.getClassFromID(this.repId)) != null && clazz != this.theClass) {
                this.descriptor = DescriptorManager.createRuntimeDescriptor((Class)clazz);
            }
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)remoteException);
        }
    }

    public Class getTheClass() {
        return this.theClass;
    }

    public RuntimeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public RepositoryId getRepositoryId() {
        return this.repId;
    }

    public String getClassName() {
        return this.theClass.getName();
    }

    public boolean isIDLInterface() {
        return this.idlInterface;
    }

    public static final RepositoryId getRepositoryId(String string) {
        RemoteInfo remoteInfo = RemoteInfo.findRemoteInfo(new RepositoryId(string));
        return remoteInfo.getRepositoryId();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            RemoteInfo remoteInfo = (RemoteInfo)object;
            return remoteInfo.theClass == this.theClass && remoteInfo.repId.equals(this.repId);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.repId == null ? 0 : this.repId.hashCode();
    }

    public String toString() {
        return this.repId.toString();
    }

    public static final RemoteInfo findRemoteInfo(RepositoryId repositoryId) {
        return RemoteInfo.findRemoteInfo(repositoryId, (String)null);
    }

    public static final RemoteInfo findRemoteInfo(RepositoryId repositoryId, String string) {
        Object object;
        RemoteInfoReference remoteInfoReference = (RemoteInfoReference)repositoryIdMap.get((Object)repositoryId);
        if (remoteInfoReference == null && repositoryId.getAnnotation() == null && (object = Utils.getAnnotation(null)) != null && (remoteInfoReference = (RemoteInfoReference)repositoryIdMap.get((Object)new RepositoryId(repositoryId, (String)object))) != null) {
            repositoryId.setAnnotation((String)object);
        }
        Object object2 = object = remoteInfoReference != null ? (RemoteInfo)remoteInfoReference.get() : null;
        if (object == null) {
            Debug.assertion((repositoryId != null ? 1 : 0) != 0);
            Class clazz = Utils.getClassFromID(repositoryId, string);
            if (clazz == null) {
                return null;
            }
            object = RemoteInfo.createRemoteInfo(repositoryId, clazz);
            classInfoMap.put((Object)clazz, object);
        }
        return object;
    }

    public static final RemoteInfo findRemoteInfo(RepositoryId repositoryId, Class clazz) {
        RemoteInfo remoteInfo;
        RemoteInfoReference remoteInfoReference = (RemoteInfoReference)repositoryIdMap.get((Object)repositoryId);
        RemoteInfo remoteInfo2 = remoteInfo = remoteInfoReference != null ? (RemoteInfo)remoteInfoReference.get() : null;
        if (remoteInfo == null) {
            remoteInfo = RemoteInfo.createRemoteInfo(repositoryId, clazz);
        }
        return remoteInfo;
    }

    private static final RemoteInfo createRemoteInfo(RepositoryId repositoryId, Class clazz) {
        Debug.assertion((repositoryId != null && clazz != null ? 1 : 0) != 0);
        RemoteInfo remoteInfo = new RemoteInfo(repositoryId, clazz);
        Class clazz2 = Utils.getClassFromID(repositoryId);
        if (clazz2 == null || clazz2 == clazz) {
            repositoryIdMap.put((Object)repositoryId, (Object)new RemoteInfoReference(remoteInfo));
        }
        return remoteInfo;
    }

    public static final RemoteInfo findRemoteInfo(Class clazz) {
        RemoteInfo remoteInfo = (RemoteInfo)classInfoMap.get((Object)clazz);
        if (remoteInfo == null) {
            remoteInfo = new RemoteInfo(clazz);
            Class clazz2 = Utils.getClassFromID(remoteInfo.repId);
            if (clazz2 == null || clazz2 == clazz) {
                repositoryIdMap.put((Object)remoteInfo.repId, (Object)new RemoteInfoReference(remoteInfo));
            }
            classInfoMap.put((Object)clazz, (Object)remoteInfo);
        }
        return remoteInfo;
    }

    public static final void createStubs(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (!(classLoader instanceof GenericClassLoader)) {
            classLoader = AugmentableClassLoaderManager.getAugmentableSystemClassLoader();
        }
        RemoteInfo.createStubs(clazz, classLoader);
    }

    public static final void createStubs(Class clazz, ClassLoader classLoader) {
        if (!clazz.isInterface()) {
            new StubGenerator(clazz).generateClass(classLoader);
        }
        Class[] classArray = StubGenerator.getAllInterfaces(clazz);
        for (int i = 0; i < classArray.length; ++i) {
            StubGenerator stubGenerator = new StubGenerator(classArray[i]);
            stubGenerator.generateClass(classLoader);
        }
    }

    private static class RemoteInfoReference
    extends WeakReference {
        private int hash;

        RemoteInfoReference(Object object) {
            super(object);
            this.hash = object.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RemoteInfoReference)) {
                return false;
            }
            RemoteInfoReference remoteInfoReference = (RemoteInfoReference)object;
            Object t = this.get();
            Object t2 = remoteInfoReference.get();
            return this.hash == remoteInfoReference.hash && (t == null ? t2 == null : t.equals(t2));
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

