/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.rmi.CORBA.ClassDesc;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.portable.InputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.SendingContext.CodeBaseHelper;
import weblogic.corba.cos.naming.NamingContextAnyHelper;
import weblogic.corba.rmic.IDLMangler;
import weblogic.corba.utils.MarshaledString;
import weblogic.iiop.IIOPService;
import weblogic.iiop.Utils;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.ObjectStreamField;

public final class RepositoryId
extends MarshaledString {
    private String annotation;
    private static final String[] ILLEGAL_CHARS = new String[]{"\\U0024", "__"};
    private static final String[] LEGAL_CHARS = new String[]{"$", "$"};
    public static final RepositoryId CLASS_DESC = new RepositoryId(ClassDesc.class);
    private static final String STRING_ID = "IDL:omg.org/CORBA/WStringValue:1.0";
    public static final RepositoryId STRING = new RepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
    public static final RepositoryId NULL = new RepositoryId("IDL:omg.org/CORBA/AbstractBase:1.0");
    public static final RepositoryId EMPTY = new RepositoryId("");
    public static final RepositoryId OBJECT = new RepositoryId("IDL:omg.org/CORBA/Object:1.0");
    public static final RepositoryId NAMING = new RepositoryId(NamingContextHelper.id());
    public static final RepositoryId NAMING_EXT = new RepositoryId("IDL:omg.org/CosNaming/NamingContextExt:1.0");
    public static final RepositoryId NAMING_ANY = new RepositoryId(NamingContextAnyHelper.id());
    public static final RepositoryId CODEBASE = new RepositoryId(CodeBaseHelper.id());
    private static final boolean ASSERT = false;
    public static final RepositoryId INT_ID = new RepositoryId("RMI:int:0000000000000000");
    public static final RepositoryId BYTE_ID = new RepositoryId("RMI:byte:0000000000000000");
    public static final RepositoryId LONG_ID = new RepositoryId("RMI:long:0000000000000000");
    public static final RepositoryId FLOAT_ID = new RepositoryId("RMI:float:0000000000000000");
    public static final RepositoryId DOUBLE_ID = new RepositoryId("RMI:double:0000000000000000");
    public static final RepositoryId SHORT_ID = new RepositoryId("RMI:short:0000000000000000");
    public static final RepositoryId CHAR_ID = new RepositoryId("RMI:char:0000000000000000");
    public static final RepositoryId BOOLEAN_ID = new RepositoryId("RMI:boolean:0000000000000000");
    public static final HashMap PRIMITIVE_MAP = new HashMap(31);
    private static ConcurrentHashMap classNameMap;
    public static final RepositoryId OLD_EJB_EXCEPTION;
    public static final RepositoryId EJB_EXCEPTION;

    public RepositoryId(InputStream inputStream, int n) {
        super(inputStream, n);
        this.initHash();
    }

    public RepositoryId(InputStream inputStream) {
        super(inputStream);
        this.initHash();
    }

    public RepositoryId(String string) {
        super(string);
        this.initHash();
    }

    RepositoryId(RepositoryId repositoryId, String string) {
        super(repositoryId);
        this.annotation = string;
        this.hash = repositoryId.hash;
    }

    RepositoryId(Class clazz) {
        super(RepositoryId.createRMIRepositoryID(clazz));
        this.setClassLoader(clazz.getClassLoader());
        this.initHash();
    }

    void setClassLoader(ClassLoader classLoader) {
        if (this.annotation == null) {
            this.annotation = Utils.getAnnotation(classLoader);
        }
    }

    public boolean isIDLType() {
        return this.encodedString.length > 3 && this.encodedString[0] == 73 && this.encodedString[1] == 68 && this.encodedString[2] == 76;
    }

    public static final RepositoryId createFromRemote(Class clazz) {
        return new RepositoryId(RepositoryId.getIDFromRemote(clazz));
    }

    public static final RepositoryId createFromValueType(Class clazz) {
        return new RepositoryId(RepositoryId.createRMIRepositoryID(clazz));
    }

    private static final String getIDFromRemote(Class clazz) {
        String string = null;
        Class clazz2 = clazz;
        while (Utilities.isARemote((Class)clazz2)) {
            Class<?>[] classArray = clazz2.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz3 = classArray[i];
                if (!Utilities.isARemote(clazz3)) continue;
                string = Utils.isIDLInterface(clazz3) ? RepositoryId.getIDFromIDLEntity(clazz3) : RepositoryId.createRMIRepositoryID(clazz3);
                return string;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    public static final RepositoryId[] getRepositoryIdList(Class clazz) {
        if (clazz == null || clazz.getSuperclass() == null || clazz.getSuperclass().isInterface() || !Serializable.class.isAssignableFrom(clazz.getSuperclass())) {
            return null;
        }
        ArrayList<RepositoryId> arrayList = new ArrayList<RepositoryId>();
        while (clazz != null && !clazz.isInterface() && Serializable.class.isAssignableFrom(clazz)) {
            arrayList.add(new RepositoryId(clazz));
            clazz = clazz.getSuperclass();
        }
        return arrayList.toArray(new RepositoryId[0]);
    }

    private static final String getIDFromIDLEntity(Class clazz) {
        String string = clazz.getName();
        String string2 = string.startsWith("org.omg.") ? "IDL:omg.org/" + string.substring("org.omg.".length()).replace('.', '/') + ":1.0" : "IDL:" + clazz.getName().replace('.', '/') + ":1.0";
        return string2;
    }

    private static final String unconvertIllegalCharacters(String string) {
        for (int i = 0; i < ILLEGAL_CHARS.length; ++i) {
            int n = string.indexOf(ILLEGAL_CHARS[i]);
            int n2 = 0;
            if (n < 0) continue;
            StringBuffer stringBuffer = new StringBuffer();
            while (n >= 0) {
                stringBuffer.append(string.substring(n2, n)).append(LEGAL_CHARS[i]);
                n2 = n + ILLEGAL_CHARS[i].length();
                n = string.indexOf(ILLEGAL_CHARS[i], n2);
            }
            string = stringBuffer.append(string.substring(n2, string.length() - 1)).toString();
        }
        return string;
    }

    public String getClassName() {
        String string = (String)classNameMap.get((Object)this);
        if (string == null) {
            String string2 = this.toString();
            if (string2.startsWith("IDL:omg.org/")) {
                string2 = "org.omg." + string2.substring("IDL:omg.org/".length());
                int n = string2.indexOf(58);
                if (n <= 0) {
                    return null;
                }
                string = string2.substring(0, n).replace('/', '.');
            } else {
                string2 = RepositoryId.unconvertIllegalCharacters(string2);
                int n = string2.indexOf(58);
                int n2 = string2.indexOf(58, n + 1);
                if (n <= 0 || n2 <= 0) {
                    return null;
                }
                string = string2.substring(n + 1, n2).replace('/', '.');
            }
            if (string != null) {
                classNameMap.put((Object)this, (Object)string);
            }
        }
        return string;
    }

    private void initHash() {
        int n = 0;
        int n2 = this.encodedString.length;
        if (n2 > 21 && this.encodedString[0] == 82) {
            n2 -= 17;
        }
        for (int i = 4; i < n2; ++i) {
            n = 31 * n + this.encodedString[i];
        }
        this.hash = n;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof RepositoryId)) {
            return false;
        }
        RepositoryId repositoryId = (RepositoryId)object;
        return this.compareStrings(repositoryId) && (repositoryId.annotation == this.annotation || this.annotation != null && repositoryId.annotation != null && this.annotation.equals(repositoryId.annotation));
    }

    private static ValueHandler getValueHandler() {
        IIOPService.load();
        return Util.createValueHandler();
    }

    public static String createRMIRepositoryID(Class clazz) {
        if (IDLMangler.isIDLEntity(clazz)) {
            return Utils.createIDFromIDLEntity(clazz);
        }
        String string = null;
        if (clazz == String.class) {
            string = STRING_ID;
        } else if (clazz == Class.class) {
            string = RepositoryId.createRMIRepositoryID(ClassDesc.class);
        } else {
            ObjectStreamClass objectStreamClass;
            StringBuffer stringBuffer = new StringBuffer("RMI:");
            stringBuffer.append(RepositoryId.convertIllegalCharacters(clazz.getName()));
            stringBuffer.append(":");
            Class<?> clazz2 = clazz;
            if (clazz2.isArray()) {
                while (clazz2.getComponentType() != null) {
                    clazz2 = clazz2.getComponentType();
                }
            }
            if ((objectStreamClass = ObjectStreamClass.lookup((Class)clazz2)) == null || clazz2.isInterface() || objectStreamClass.isArray() && objectStreamClass.forClass().getComponentType().isPrimitive()) {
                stringBuffer.append(RepositoryId.toHexString(0L));
                string = stringBuffer.toString();
            } else {
                stringBuffer.append(RepositoryId.toHexString(RepositoryId.computeHashCode(objectStreamClass, clazz2)));
                stringBuffer.append(":");
                stringBuffer.append(RepositoryId.toHexString(objectStreamClass.getObjectStreamClass().getSerialVersionUID()));
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String toHexString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Long.toHexString(l).toUpperCase();
        int n = 16 - string.length();
        while (n-- > 0) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static String convertIllegalCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if ('u' == string.charAt(i + 1)) {
                        stringBuffer.append("U");
                        for (int j = i + 2; j < i + 5; ++j) {
                            stringBuffer.append(Character.toUpperCase(string.charAt(j)));
                        }
                        i += 4;
                        continue block4;
                    }
                    stringBuffer.append(c);
                    continue block4;
                }
                case '$': {
                    stringBuffer.append("\\U0024");
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static long computeHashCode(ObjectStreamClass objectStreamClass, Class clazz) {
        try {
            if (!Serializable.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(clazz)) {
                return 1L;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                dataOutputStream.writeLong(RepositoryId.computeHashCode(objectStreamClass.getSuperclass(), clazz2));
            }
            if (objectStreamClass.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            ObjectStreamField[] objectStreamFieldArray = (ObjectStreamField[])objectStreamClass.getFields().clone();
            Arrays.sort(objectStreamFieldArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((ObjectStreamField)object).getName().compareTo(((ObjectStreamField)object2).getName());
                }
            });
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                dataOutputStream.writeUTF(objectStreamFieldArray[i].getName());
                dataOutputStream.writeUTF(objectStreamFieldArray[i].getSignature());
            }
            dataOutputStream.flush();
            long l = 0L;
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
            return l;
        }
        catch (IOException iOException) {
            return -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return -1L;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Class<?> clazz = Class.forName(stringArray[0]);
        System.out.println(Util.createValueHandler().getRMIRepositoryID(clazz));
        System.out.println(RepositoryId.createRMIRepositoryID(clazz));
    }

    private static void addToMap(RepositoryId repositoryId, String string) {
        classNameMap.put((Object)repositoryId, (Object)string);
    }

    private static final void initialize() {
        RepositoryId.addToMap(NAMING, "org.omg.CosNaming.NamingContext");
        RepositoryId.addToMap(STRING, "java.lang.String");
        RepositoryId.addToMap(NAMING_ANY, "weblogic.corba.cos.naming.NamingContextAny");
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.org.omg.SendingContext.CodeBase");
            RepositoryId.addToMap(CODEBASE, "com.sun.org.omg.SendingContext.CodeBase");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName("com.ibm.org.omg.SendingContext.CodeBase");
                RepositoryId.addToMap(CODEBASE, "com.ibm.org.omg.SendingContext.CodeBase");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                // empty catch block
            }
        }
    }

    public boolean isClassDesc() {
        return this.compareStrings(CLASS_DESC);
    }

    public String toPrettyString() {
        return this.toString() + "@" + this.getAnnotation();
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String string) {
        this.annotation = string;
    }

    static {
        PRIMITIVE_MAP.put(INT_ID, Integer.TYPE);
        PRIMITIVE_MAP.put(BYTE_ID, Byte.TYPE);
        PRIMITIVE_MAP.put(LONG_ID, Long.TYPE);
        PRIMITIVE_MAP.put(FLOAT_ID, Float.TYPE);
        PRIMITIVE_MAP.put(DOUBLE_ID, Double.TYPE);
        PRIMITIVE_MAP.put(SHORT_ID, Short.TYPE);
        PRIMITIVE_MAP.put(CHAR_ID, Character.TYPE);
        PRIMITIVE_MAP.put(BOOLEAN_ID, Boolean.TYPE);
        classNameMap = new ConcurrentHashMap();
        OLD_EJB_EXCEPTION = new RepositoryId("RMI:javax.ejb.EJBException:0E3E8C42D0E83868:800C4C7C598DF61F");
        EJB_EXCEPTION = new RepositoryId("RMI:javax.ejb.EJBException:0E3E8C42D0E83868:0B0EB2FF36CB22F6");
        RepositoryId.initialize();
    }
}

