/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.SendingContext.RunTime;
import weblogic.corba.utils.ClassInfo;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.utils.io.ObjectInput;
import weblogic.utils.io.ObjectOutput;
import weblogic.utils.io.ObjectStreamClass;

public class ValueHandlerImpl
implements ValueHandlerMultiFormat {
    private static final boolean DEBUG = false;

    public void writeValue(OutputStream outputStream, Serializable serializable) {
        this.writeValue(outputStream, serializable, (byte)1);
    }

    public Serializable readValue(InputStream inputStream, int n, Class clazz, String string, RunTime runTime) {
        try {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup((Class)clazz);
            Object object = ValueHandlerImpl.allocateValue(inputStream, objectStreamClass);
            return (Serializable)ValueHandlerImpl.readValue((IIOPInputStream)inputStream, objectStreamClass, object);
        }
        catch (IOException iOException) {
            throw (MARSHAL)new MARSHAL(iOException.getMessage()).initCause((Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (MARSHAL)new MARSHAL(classNotFoundException.getMessage()).initCause((Throwable)classNotFoundException);
        }
    }

    public static Object allocateValue(InputStream inputStream, ObjectStreamClass objectStreamClass) throws IOException {
        Class clazz = objectStreamClass.forClass();
        if (objectStreamClass.isArray()) {
            return Array.newInstance(clazz.getComponentType(), inputStream.read_ulong());
        }
        return objectStreamClass.newInstance();
    }

    public static Object readValue(IIOPInputStream iIOPInputStream, ObjectStreamClass objectStreamClass, Object object) throws IOException, ClassNotFoundException {
        if (objectStreamClass.isArray()) {
            return ValueHandlerImpl.readArray(iIOPInputStream, objectStreamClass, object);
        }
        if (objectStreamClass.isExternalizable()) {
            byte by = iIOPInputStream.read_octet();
            ((Externalizable)object).readExternal((java.io.ObjectInput)((Object)iIOPInputStream));
        } else {
            ValueHandlerImpl.readValueData(iIOPInputStream, object, objectStreamClass);
        }
        return objectStreamClass.readResolve(object);
    }

    public String getRMIRepositoryID(Class clazz) {
        return ValueHandlerImpl.getRepositoryID(clazz);
    }

    public static String getRepositoryID(Class clazz) {
        ClassInfo classInfo = ClassInfo.findClassInfo(clazz);
        return classInfo == null ? null : classInfo.getRepositoryId().toString();
    }

    public boolean isCustomMarshaled(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup((Class)clazz);
        return objectStreamClass == null ? false : objectStreamClass.isCustomMarshaled();
    }

    public RunTime getRunTimeCodeBase() {
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        try {
            return (Serializable)this.writeReplace((Object)serializable);
        }
        catch (IOException iOException) {
            throw (MARSHAL)new MARSHAL("writeReplace()").initCause((Throwable)iOException);
        }
    }

    public Object writeReplace(Object object) throws IOException {
        Class<?> clazz = object.getClass();
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        while (objectStreamClass.hasWriteReplace() && (object = objectStreamClass.writeReplace(object)) != null && object.getClass() != clazz) {
            clazz = object.getClass();
            objectStreamClass = ObjectStreamClass.lookup(clazz);
        }
        return object;
    }

    public byte getMaximumStreamFormatVersion() {
        return 2;
    }

    public void writeValue(OutputStream outputStream, Serializable serializable, byte by) {
        ClassInfo classInfo = ClassInfo.findClassInfo(serializable.getClass());
        try {
            ValueHandlerImpl.writeValue((IIOPOutputStream)outputStream, serializable, by, classInfo);
        }
        catch (IOException iOException) {
            throw (MARSHAL)new MARSHAL(iOException.getMessage() + " at " + ((IIOPOutputStream)outputStream).pos()).initCause((Throwable)iOException);
        }
    }

    public static void writeValue(IIOPOutputStream iIOPOutputStream, Object object, byte by, ClassInfo classInfo) throws IOException {
        ObjectStreamClass objectStreamClass = classInfo.getDescriptor();
        if (objectStreamClass.isExternalizable()) {
            iIOPOutputStream.write_octet(by);
            ((Externalizable)object).writeExternal((java.io.ObjectOutput)((Object)iIOPOutputStream));
        } else if (!ObjectStreamClass.supportsUnsafeSerialization()) {
            ValueHandler valueHandler = Util.createValueHandler();
            if (valueHandler instanceof ValueHandlerMultiFormat) {
                ((ValueHandlerMultiFormat)valueHandler).writeValue((OutputStream)iIOPOutputStream, (Serializable)object, by);
            } else {
                valueHandler.writeValue((OutputStream)iIOPOutputStream, (Serializable)object);
            }
        } else if (objectStreamClass.isArray()) {
            ValueHandlerImpl.writeArray(iIOPOutputStream, object, objectStreamClass, classInfo.forClass());
        } else {
            ValueHandlerImpl.writeValueData(iIOPOutputStream, object, objectStreamClass, by);
        }
    }

    private static void writeValueData(IIOPOutputStream iIOPOutputStream, Object object, ObjectStreamClass objectStreamClass, byte by) throws IOException {
        if (objectStreamClass.getSuperclass() != null) {
            ValueHandlerImpl.writeValueData(iIOPOutputStream, object, objectStreamClass.getSuperclass(), by);
        }
        if (objectStreamClass.hasWriteObject()) {
            iIOPOutputStream.write_octet(by);
            ObjectOutputStream objectOutputStream = iIOPOutputStream.getObjectOutputStream(object, objectStreamClass, by);
            objectStreamClass.writeObject(object, objectOutputStream);
            objectOutputStream.close();
        } else {
            objectStreamClass.writeFields(object, (ObjectOutput)iIOPOutputStream);
        }
    }

    private static void readValueData(IIOPInputStream iIOPInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (objectStreamClass.getSuperclass() != null) {
            ValueHandlerImpl.readValueData(iIOPInputStream, object, objectStreamClass.getSuperclass());
        }
        boolean bl = true;
        byte by = 1;
        if (objectStreamClass.hasWriteObject()) {
            by = iIOPInputStream.read_octet();
            bl = iIOPInputStream.read_boolean();
        }
        if (objectStreamClass.hasReadObject()) {
            boolean bl2 = false;
            if (!bl && by > 1) {
                bl2 = iIOPInputStream.startValue();
            }
            ObjectInputStream objectInputStream = iIOPInputStream.getObjectInputStream(object, objectStreamClass, bl, by);
            objectStreamClass.readObject(object, objectInputStream);
            objectInputStream.close();
            if (bl2) {
                iIOPInputStream.end_value();
            }
        } else {
            if (!bl) {
                throw new StreamCorruptedException("defaultWriteObject() was not called, but " + objectStreamClass.forClass().getName() + " has no readObject() method");
            }
            objectStreamClass.readFields(object, (ObjectInput)iIOPInputStream);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeArray(IIOPOutputStream iIOPOutputStream, Object object, ObjectStreamClass objectStreamClass, Class clazz) throws IOException {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])object;
                iIOPOutputStream.write_ulong(nArray.length);
                iIOPOutputStream.write_long_array(nArray, 0, nArray.length);
                return;
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                iIOPOutputStream.write_ulong(byArray.length);
                iIOPOutputStream.write_octet_array(byArray, 0, byArray.length);
                return;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])object;
                iIOPOutputStream.write_ulong(lArray.length);
                iIOPOutputStream.write_longlong_array(lArray, 0, lArray.length);
                return;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])object;
                iIOPOutputStream.write_ulong(fArray.length);
                iIOPOutputStream.write_float_array(fArray, 0, fArray.length);
                return;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                iIOPOutputStream.write_ulong(dArray.length);
                iIOPOutputStream.write_double_array(dArray, 0, dArray.length);
                return;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])object;
                iIOPOutputStream.write_ulong(sArray.length);
                iIOPOutputStream.write_short_array(sArray, 0, sArray.length);
                return;
            } else if (clazz2 == Character.TYPE) {
                char[] cArray = (char[])object;
                iIOPOutputStream.write_ulong(cArray.length);
                iIOPOutputStream.write_wchar_array(cArray, 0, cArray.length);
                return;
            } else {
                if (clazz2 != Boolean.TYPE) throw new StreamCorruptedException("Invalid component type");
                boolean[] blArray = (boolean[])object;
                iIOPOutputStream.write_ulong(blArray.length);
                iIOPOutputStream.write_boolean_array(blArray, 0, blArray.length);
            }
            return;
        } else {
            Object[] objectArray = (Object[])object;
            iIOPOutputStream.write_ulong(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                iIOPOutputStream.writeObject(objectArray[i], clazz2);
            }
        }
    }

    private static Object readArray(IIOPInputStream iIOPInputStream, ObjectStreamClass objectStreamClass, Object object) throws IOException, ClassNotFoundException {
        Class<?> clazz = objectStreamClass.forClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                iIOPInputStream.read_long_array(nArray, 0, nArray.length);
                return nArray;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                iIOPInputStream.read_octet_array(byArray, 0, byArray.length);
                return byArray;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                iIOPInputStream.read_longlong_array(lArray, 0, lArray.length);
                return lArray;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                iIOPInputStream.read_float_array(fArray, 0, fArray.length);
                return fArray;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                iIOPInputStream.read_double_array(dArray, 0, dArray.length);
                return dArray;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                iIOPInputStream.read_short_array(sArray, 0, sArray.length);
                return sArray;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                iIOPInputStream.read_wchar_array(cArray, 0, cArray.length);
                return cArray;
            }
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                iIOPInputStream.read_boolean_array(blArray, 0, blArray.length);
                return blArray;
            }
            throw new StreamCorruptedException("Invalid component type");
        }
        Object[] objectArray = (Object[])object;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = iIOPInputStream.readObject(clazz);
        }
        return objectArray;
    }

    private static void p(String string) {
        System.err.println("<ValueHandlerImpl>: " + string);
    }
}

