/*
 * Decompiled with CFR 0.152.
 */
package weblogic.dbeans.internal;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.ejb.FinderException;
import weblogic.dbeans.ConversationImpl;
import weblogic.dbeans.DataBeansException;
import weblogic.dbeans.Query;
import weblogic.dbeans.internal.DataBeansUtils;
import weblogic.ejb.container.InternalException;
import weblogic.ejb.container.manager.BaseEntityManager;
import weblogic.ejb20.internal.WLQueryPropertiesImpl;

public class QueryImpl
implements Query {
    private ConversationImpl conversation = null;
    private BaseEntityManager manager = null;
    private String sql = null;
    private String sqlShapeName = null;
    private Map arguments = new TreeMap();
    private int maxElements = 0;
    private static Method getCollectionMethod = null;

    public QueryImpl(ConversationImpl conversationImpl, BaseEntityManager baseEntityManager, String string) {
        this.conversation = conversationImpl;
        this.manager = baseEntityManager;
        this.sql = string;
    }

    public QueryImpl(ConversationImpl conversationImpl, BaseEntityManager baseEntityManager, String string, String string2) {
        this.conversation = conversationImpl;
        this.manager = baseEntityManager;
        this.sql = string;
        this.sqlShapeName = string2;
    }

    public Collection getCollection() {
        Collection collection = null;
        WLQueryPropertiesImpl wLQueryPropertiesImpl = new WLQueryPropertiesImpl();
        try {
            wLQueryPropertiesImpl.setSqlShapeName(this.sqlShapeName);
            wLQueryPropertiesImpl.setMaxElements(this.maxElements);
        }
        catch (FinderException finderException) {
            throw new AssertionError((Object)"should never get here");
        }
        try {
            collection = (Collection)this.manager.dynamicSqlQuery(this.sql, this.prepareArguments(this.arguments), wLQueryPropertiesImpl, getCollectionMethod, true, Collection.class, this.conversation);
        }
        catch (InternalException internalException) {
            DataBeansUtils.throwDataBeansException(internalException);
        }
        return collection;
    }

    public void setMaxElements(int n) {
        this.maxElements = n;
    }

    public Object getObject() {
        return null;
    }

    public ResultSet getResultSet() {
        return null;
    }

    public void setString(int n, String string) {
        this.setParameter(n, string);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.setParameter(n, bigDecimal);
    }

    public void setBigInteger(int n, BigInteger bigInteger) {
        this.setParameter(n, bigInteger);
    }

    public void setBinary(int n, byte[] byArray) {
        this.setParameter(n, byArray);
    }

    public void setBoolean(int n, boolean bl) {
        this.setParameter(n, new Boolean(bl));
    }

    public void setByte(int n, byte by) {
        this.setParameter(n, new Byte(by));
    }

    public void setCharacter(int n, char c) {
        this.setParameter(n, new Character(c));
    }

    public void setShort(int n, short s) {
        this.setParameter(n, new Short(s));
    }

    public void setInt(int n, int n2) {
        this.setParameter(n, new Integer(n2));
    }

    public void setLong(int n, long l) {
        this.setParameter(n, new Long(l));
    }

    public void setFloat(int n, float f) {
        this.setParameter(n, new Float(f));
    }

    public void setDouble(int n, double d) {
        this.setParameter(n, new Double(d));
    }

    public void setDate(int n, Date date) {
        this.setParameter(n, date);
    }

    public void setDate(int n, java.util.Date date) {
        this.setParameter(n, date);
    }

    public void setTime(int n, Time time) {
        this.setParameter(n, time);
    }

    public void setTime(int n, java.util.Date date) {
        this.setParameter(n, date);
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.setParameter(n, timestamp);
    }

    public void setTimestamp(int n, java.util.Date date) {
        this.setParameter(n, date);
    }

    public void setCalender(int n, Calendar calendar) {
        this.setParameter(n, calendar);
    }

    private Object[] prepareArguments(Map map) {
        Iterator iterator = map.entrySet().iterator();
        Object[] objectArray = new Object[map.size()];
        int n = 1;
        int n2 = -1;
        int n3 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            int n4 = (Integer)entry.getKey();
            if (n2 == -1 && n4 == 0) {
                n = 0;
            }
            if (n4 != n) {
                if (n2 == -1) {
                    throw new DataBeansException("Missing value for first parameter.  The first parameter index specified was at index '" + n4 + "' instead '0' or '1'.");
                }
                throw new DataBeansException("Missing value for parameter '" + n + "'.  There is a missing parameter between parameters '" + n2 + "' and '" + n4 + "'.");
            }
            objectArray[n3++] = entry.getValue();
            n2 = n++;
        }
        return objectArray;
    }

    private void setParameter(int n, Object object) {
        Integer n2 = new Integer(n);
        Object object2 = this.arguments.put(n2, object);
        if (object2 != null) {
            this.arguments.put(n2, object2);
            throw new DataBeansException("Attempt to set more than one value for query parameter '" + n2 + "'.  Previous value was '" + object2 + "'.");
        }
    }

    static {
        try {
            getCollectionMethod = Query.class.getMethod("getCollection", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

