/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import weblogic.application.Type;
import weblogic.application.compiler.AppMerge;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.LibrarySpec;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.utils.compiler.ToolFailureException;

public abstract class AppMerger {
    private static final boolean debug = Debug.isDebug("config");
    private File app;
    private File plan;
    private File plandir;
    private LibrarySpec[] libs;
    private boolean basicView = false;
    private AppMerge appMerge = null;
    private String lightWeightAppName = null;

    public abstract DescriptorSupport getDescriptorSupport();

    public WebLogicDeployableObject getMergedApp(File file, File file2, File file3, LibrarySpec[] librarySpecArray, String string, WebLogicDeployableObjectFactory webLogicDeployableObjectFactory) throws IOException {
        return this.getMergedApp(file, file2, file3, librarySpecArray, webLogicDeployableObjectFactory, false, string);
    }

    public WebLogicDeployableObject getMergedApp(File file, File file2, File file3, LibrarySpec[] librarySpecArray, WebLogicDeployableObjectFactory webLogicDeployableObjectFactory, boolean bl, String string) throws IOException {
        this.app = file;
        this.plan = file2;
        this.plandir = file3;
        this.libs = librarySpecArray;
        this.basicView = bl;
        this.lightWeightAppName = string;
        try {
            return this.merge(webLogicDeployableObjectFactory);
        }
        catch (ToolFailureException toolFailureException) {
            if (debug && toolFailureException.getCause() != null) {
                Debug.say(toolFailureException.getCause().getMessage());
            }
            IOException iOException = new IOException(toolFailureException.getMessage());
            iOException.initCause(toolFailureException);
            throw iOException;
        }
    }

    private WebLogicDeployableObject merge(WebLogicDeployableObjectFactory webLogicDeployableObjectFactory) throws IOException, ToolFailureException {
        String[] stringArray = this.createMergeCommand();
        if (debug) {
            this.dumpAppMergeArgs(stringArray);
        }
        boolean bl = this.libs == null;
        this.appMerge = new AppMerge(stringArray, webLogicDeployableObjectFactory, bl, false, true, this.basicView);
        return (WebLogicDeployableObject)((Object)this.appMerge.merge());
    }

    public AppMerge getAppMerge() {
        return this.appMerge;
    }

    private void dumpAppMergeArgs(String[] stringArray) {
        if (debug) {
            Debug.say("invokinging appmerge with");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Debug.say("  " + string);
            }
        }
    }

    private String[] createMergeCommand() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.lightWeightAppName != null) {
            arrayList.add("-lightweight");
            arrayList.add(this.lightWeightAppName);
        }
        arrayList.add("-noexit");
        arrayList.add("-nopackage");
        if (debug) {
            arrayList.add("-verbose");
        }
        if (this.plan != null) {
            arrayList.add("-plan");
            arrayList.add(this.plan.getAbsolutePath());
        }
        if (this.plandir != null) {
            arrayList.add("-plandir");
            arrayList.add(this.plandir.getAbsolutePath());
        }
        int n = 0;
        String string = "";
        if (this.libs != null) {
            for (int i = 0; i < this.libs.length; ++i) {
                LibrarySpec librarySpec = this.libs[i];
                if (n++ > 0) {
                    string = string + ",";
                }
                String string2 = librarySpec.getLocation().getAbsolutePath();
                String string3 = librarySpec.getSpecVersion();
                String string4 = librarySpec.getImplVersion();
                String string5 = librarySpec.getName();
                string = string + string2;
                if (string5 != null) {
                    string = string + "@name=" + string5;
                }
                if (string3 != null) {
                    string = string + "@libspecver=" + string3;
                }
                if (string4 == null) continue;
                string = string + "@libimplver=" + string4;
            }
            if (string.length() > 0) {
                arrayList.add("-library");
                arrayList.add(string);
            }
        }
        arrayList.add("-readonly");
        arrayList.add(this.app.getPath());
        return arrayList.toArray(new String[0]);
    }

    protected abstract LibraryRefBean[] getLibraryRefs(DescriptorBean var1);

    class MyLibraryDefinition
    extends LibraryDefinition {
        MyLibraryDefinition(LibraryData libraryData, Type type) {
            super(libraryData, type);
        }
    }
}

