/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.io.IOException;
import java.util.ArrayList;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.utils.classloaders.ClassFinder;

public class ClassLoaderControl {
    private ClassLoader oldCL = null;
    private WebLogicDeployableObject wldObject;
    private ArrayList resources = new ArrayList();
    private ClassLoader cl = null;

    protected void finalize() throws Throwable {
        if (this.cl != null) {
            this.close();
        }
    }

    public ClassLoaderControl(WebLogicDeployableObject webLogicDeployableObject, ClassLoader classLoader) {
        this.wldObject = webLogicDeployableObject;
        this.oldCL = classLoader;
    }

    public ClassLoaderControl(WebLogicDeployableObject webLogicDeployableObject) {
        this(webLogicDeployableObject, Thread.currentThread().getContextClassLoader());
    }

    public ClassLoader getClassLoader() throws IOException {
        if (this.cl == null) {
            this.cl = this.createClassLoader();
        }
        return this.cl;
    }

    private ClassLoader createClassLoader() throws IOException {
        return this.wldObject.getOrCreateGCL();
    }

    public void restoreClassloader() {
        this.close();
        Thread.currentThread().setContextClassLoader(this.oldCL);
    }

    public void close() {
        for (int i = 0; i < this.resources.size(); ++i) {
            ClassFinder classFinder = (ClassFinder)this.resources.get(i);
            classFinder.close();
        }
        this.resources.clear();
        this.cl = null;
    }
}

