/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.validators.DeploymentPlanBeanValidator;
import weblogic.logging.Loggable;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class ConfigHelper {
    public static File getConfigRootFile(DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean != null && deploymentPlanBean.getConfigRoot() != null) {
            return new File(deploymentPlanBean.getConfigRoot());
        }
        return null;
    }

    public static File getAppRootFromPlan(DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean != null && deploymentPlanBean.getConfigRoot() != null) {
            File file = new File(deploymentPlanBean.getConfigRoot()).getParentFile();
            return file;
        }
        return null;
    }

    public static void initPlanDirFromPlan(DeploymentPlanBean deploymentPlanBean, InstallDir installDir) {
        if (deploymentPlanBean != null && deploymentPlanBean.getConfigRoot() != null) {
            File file = new File(deploymentPlanBean.getConfigRoot()).getAbsoluteFile();
            try {
                DeploymentPlanBeanValidator.validateConfigRoot((String)deploymentPlanBean.getConfigRoot());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (file.exists() && file.isDirectory()) {
                installDir.setConfigDir(file);
                deploymentPlanBean.setConfigRoot(installDir.getConfigDir().getPath());
            } else {
                installDir.setConfigDir(null);
                deploymentPlanBean.setConfigRoot(installDir.getConfigDir().getPath());
            }
        } else {
            installDir.setConfigDir(null);
        }
    }

    public static String getText(DDBean dDBean) {
        String string = dDBean.getText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String getNSPrefix(DDBean dDBean, String string) {
        if (dDBean instanceof DDBeanRoot) {
            String string2 = dDBean.getText();
            if (string2 == null) {
                return null;
            }
            int n = string2.indexOf(string);
            if (n == -1) {
                return null;
            }
            int n2 = string2.indexOf("xmlns");
            if (n2 == -1) {
                return null;
            }
            if (string2.charAt(n2 + "xmlns".length()) == '=') {
                return null;
            }
            return string2.substring(n2 + "xmlns".length() + 1, n - 2);
        }
        return ConfigHelper.getNSPrefix((DDBean)dDBean.getRoot(), string);
    }

    public static String applyNamespace(String string, String string2) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.indexOf(":") == -1) {
                    stringBuffer.append(string + ":");
                }
                stringBuffer.append(string3);
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append("/");
            }
            return stringBuffer.toString();
        }
        return string2;
    }

    public static void beanWalker(DDBeanRoot dDBeanRoot, DConfigBeanRoot dConfigBeanRoot) throws ConfigurationException {
        ConfigHelper.checkParam("DDBeanRoot", dDBeanRoot);
        ConfigHelper.checkParam("DConfigBeanRoot", dConfigBeanRoot);
        ConfigHelper.beanWalker((DDBean)dDBeanRoot, (DConfigBean)dConfigBeanRoot);
    }

    private static void beanWalker(DDBean dDBean, DConfigBean dConfigBean) throws ConfigurationException {
        if (dConfigBean == null) {
            return;
        }
        String[] stringArray = dConfigBean.getXpaths();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            DDBean[] dDBeanArray = dDBean.getChildBean(stringArray[i]);
            if (dDBeanArray == null) continue;
            for (int j = 0; j < dDBeanArray.length; ++j) {
                DConfigBean dConfigBean2 = dConfigBean.getDConfigBean(dDBeanArray[j]);
                ConfigHelper.beanWalker(dDBeanArray[j], dConfigBean2);
            }
        }
    }

    public static void checkParam(String string, Object object) {
        if (object == null) {
            Loggable loggable = SPIDeployerLogger.logNullParamLoggable((String)string);
            loggable.log();
            throw new IllegalArgumentException(loggable.getMessage());
        }
    }

    private static String extractLibraryName(File file, DeploymentOptions deploymentOptions) {
        try {
            if (deploymentOptions != null && deploymentOptions.isLibrary() && file != null) {
                VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
                return ApplicationVersionUtils.getLibName(virtualJarFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if ("/".equals(File.separator)) {
            if (string.length() >= 2 && string.charAt(1) == ':') {
                string = string.substring(2);
            }
            return string.replace('\\', File.separatorChar);
        }
        return string.replace('/', File.separatorChar);
    }

    public static File normalize(File file) {
        if (file == null) {
            return null;
        }
        String string = ConfigHelper.normalize(file.getPath());
        return new File(string);
    }

    public static String getAppName(DeploymentOptions deploymentOptions, File file, DeploymentPlanBean deploymentPlanBean) {
        String string = null;
        string = ConfigHelper.extractLibraryName(file, deploymentOptions);
        if (string != null) {
            return string;
        }
        if (deploymentOptions != null && deploymentOptions.getName() != null) {
            return ConfigHelper.appendVersionToAppName(deploymentOptions.getName(), deploymentOptions);
        }
        if (deploymentPlanBean != null && deploymentPlanBean.getApplicationName() != null && deploymentPlanBean.getApplicationName().length() > 0) {
            return deploymentPlanBean.getApplicationName();
        }
        if (file != null) {
            string = ConfigHelper.normalize(file).getName();
        }
        return ConfigHelper.appendVersionToAppName(string, deploymentOptions);
    }

    private static String appendVersionToAppName(String string, DeploymentOptions deploymentOptions) {
        if (string != null && deploymentOptions != null && deploymentOptions.getArchiveVersion() != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('#');
            stringBuffer.append(deploymentOptions.getArchiveVersion());
            if (deploymentOptions.getPlanVersion() != null) {
                stringBuffer.append('#');
                stringBuffer.append(deploymentOptions.getPlanVersion());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String getAppName(TargetModuleID[] targetModuleIDArray, DeploymentOptions deploymentOptions) {
        if (deploymentOptions != null && deploymentOptions.getName() != null) {
            return deploymentOptions.getName();
        }
        if (targetModuleIDArray == null || targetModuleIDArray.length == 0) {
            throw new IllegalArgumentException(SPIDeployerLogger.nullTmids());
        }
        return ConfigHelper.getAppName(targetModuleIDArray[0]);
    }

    public static String getAppName(TargetModuleID targetModuleID) {
        return targetModuleID.getModuleID();
    }
}

