/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.io.PrintStream;

public class Debug {
    public static final String DEBUG_PROP = "weblogic.deployer.debug";
    public static final String CONFIG = "config";
    public static final String DEPLOY = "deploy";
    public static final String STATUS = "status";
    public static final String FACTORY = "factory";
    public static final String MODEL = "model";
    public static final String UTILS = "utils";
    public static final String ALL = "all";
    public static final String INTERNAL = "internal";
    private static String flags;
    private static final PrintStream out;
    private static final boolean DEBUG = false;
    private static final boolean FORCE_DEBUG = false;
    private static final boolean CLASSINFO = true;
    private static final String DEBUG_DEBUG = "";

    public static boolean isDebug(String string) {
        if (flags.indexOf(ALL) != -1 && !INTERNAL.equals(string)) {
            return true;
        }
        return flags.indexOf(string) != -1;
    }

    public static void say(String string) {
        try {
            out.println(new StackTrace().location(0).tag(0) + string);
        }
        catch (Throwable throwable) {
            out.println("[unknown]" + string);
        }
    }

    static {
        out = System.err;
        flags = System.getProperty(DEBUG_PROP, DEBUG_DEBUG);
        if (DEBUG_DEBUG.equals(flags)) {
            flags = DEBUG_DEBUG;
        }
    }

    static final class StackTrace {
        private final Location[] stack;

        StackTrace() {
            StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
            this.stack = new Location[stackTraceElementArray.length - 2];
            for (int i = 2; i < stackTraceElementArray.length; ++i) {
                this.stack[i - 2] = new Location(stackTraceElementArray[i]);
            }
        }

        public Location location(int n) throws ArrayIndexOutOfBoundsException {
            return this.stack[n];
        }

        public void dump(PrintStream printStream, String string) {
            printStream.println(string);
            for (int i = 0; i < this.stack.length; ++i) {
                printStream.flush();
                printStream.println("  " + this.location(i).dump());
            }
        }
    }

    static final class Location {
        private static final String UNKNOWN = "<unknown>";
        private final String pkg;
        private final String clazz;
        private final String method;
        private final String linenum;
        private final String fullClass;
        private final String sourcefile;

        Location(StackTraceElement stackTraceElement) {
            this.fullClass = stackTraceElement.getClassName();
            this.method = stackTraceElement.getMethodName();
            int n = this.fullClass.lastIndexOf(".");
            if (n == -1) {
                this.pkg = UNKNOWN;
                this.clazz = this.fullClass;
            } else {
                this.pkg = this.fullClass.substring(0, n);
                this.clazz = this.fullClass.substring(n + 1);
            }
            this.sourcefile = stackTraceElement.getFileName();
            int n2 = stackTraceElement.getLineNumber();
            this.linenum = n2 > 0 ? String.valueOf(n2) : UNKNOWN;
        }

        public String tag(int n) {
            return "[" + this.clazz + "." + this.method + "()" + ":" + this.linenum + "] " + (n != 0 ? "(" + n + ")" : Debug.DEBUG_DEBUG) + ": ";
        }

        public String dump() {
            return this.fullname() + '(' + this.sourcefile + ':' + this.linenum + ')';
        }

        public String caller() {
            return this.fullname() + "(), line " + this.linenum;
        }

        private String fullname() {
            return this.fullClass + '.' + this.method;
        }
    }
}

