/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.management.DomainDir;

public class InstallDir {
    private static final boolean debug = Debug.isDebug("utils");
    public static final String CONFIG_DIR = "plan";
    public static final String APP_DIR = "app";
    private static final String DEFAULT_INSTALL_DIR = DomainDir.getDeploymentsDirNonCanonical();
    private File installDir;
    private String appName;
    private File configDir = null;
    private File appDir = null;
    private File plan = null;
    private File app = null;

    public InstallDir(String string, String string2) throws IOException {
        this(string, string2 == null ? null : new File(string2));
    }

    public InstallDir(String string, File file) throws IOException {
        this(string, file, true);
    }

    public InstallDir(String string, File file, boolean bl) throws IOException {
        ConfigHelper.checkParam("appName", string);
        this.appName = string;
        this.installDir = file;
        boolean bl2 = true;
        if (this.installDir == null) {
            this.installDir = this.create();
            if (!bl) {
                bl2 = false;
            }
        }
        if (bl2) {
            if (!this.installDir.exists()) {
                this.installDir.mkdirs();
            }
            if (!this.installDir.exists()) {
                this.installDir.mkdirs();
            }
            if (!this.installDir.exists() || this.installDir.isFile()) {
                throw new IOException(SPIDeployerLogger.invalidInstallDir((String)this.installDir.getPath()));
            }
        }
        this.installDir = this.installDir.getAbsoluteFile();
        if (debug) {
            Debug.say("Install dir defined at " + this.installDir.getPath());
        }
    }

    public InstallDir(File file) throws IOException {
        this(file.getName(), file);
    }

    public File getDDFile(String string, String string2) {
        return new File(new File(this.getConfigDir(), string), string2);
    }

    public File getAppDDFile(String string) {
        return new File(new File(this.getConfigDir(), string).getPath());
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public void resetInstallDir(File file) {
        this.installDir = file;
        this.configDir = null;
        this.appDir = null;
        this.app = null;
        this.plan = null;
    }

    public File getConfigDir() {
        if (this.configDir == null) {
            this.configDir = new File(this.installDir, CONFIG_DIR);
        }
        return this.configDir;
    }

    public void setConfigDir(File file) {
        this.configDir = file;
    }

    public File getAppDir() {
        if (this.appDir == null) {
            this.appDir = new File(this.installDir, APP_DIR);
        }
        return this.appDir;
    }

    public void setAppDir(File file) {
        this.appDir = file;
    }

    public File getArchive() {
        if (this.app == null) {
            this.app = new File(this.getAppDir(), this.appName);
        }
        return this.app;
    }

    public void setArchive(File file) {
        this.app = file;
    }

    public File getPlan() {
        return this.plan;
    }

    public void setPlan(File file) {
        this.plan = file;
    }

    public boolean isInAppDir(File file) {
        if (file == null) {
            return true;
        }
        File file2 = new File(file.getAbsolutePath());
        return file2.getParentFile().equals(this.getAppDir().getAbsoluteFile());
    }

    public boolean isInConfigDir(File file) {
        if (file == null) {
            return true;
        }
        File file2 = null;
        file2 = new File(file.getAbsolutePath());
        return file2.getParentFile().equals(this.getConfigDir().getAbsoluteFile());
    }

    public boolean isInInstallDir(File file) {
        if (file == null) {
            return true;
        }
        File file2 = null;
        file2 = new File(file.getAbsolutePath());
        return file2.getParentFile().equals(this.getInstallDir());
    }

    public FileOutputStream getOutputStream(File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return new FileOutputStream(file);
    }

    private File create() {
        File file = new File(DEFAULT_INSTALL_DIR);
        String string = System.getProperty("user.name");
        if (!file.exists() && !file.isAbsolute()) {
            file = new File(file, string);
            String string2 = System.getProperty("java.io.tmpdir");
            if (string2 == null) {
                string2 = "/tmp";
            }
            file = new File(string2, string);
            file = new File(file, DEFAULT_INSTALL_DIR);
        }
        return new File(file, this.appName);
    }

    public boolean isProper() {
        return this.isInInstallDir(this.getAppDir()) && this.isInInstallDir(this.getConfigDir()) && this.isInAppDir(this.getArchive()) && this.isInConfigDir(this.getPlan());
    }
}

