/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.mail.internet.MimeUtility;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import weblogic.deploy.api.internal.utils.DeployerHelperException;
import weblogic.management.DeploymentNotification;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.utils.DeployerHelperTextFormatter;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.EditAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.servlet.ConnectionSigner;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.io.UnsyncByteArrayOutputStream;

public class JMXDeployerHelper {
    public static final String HTTP_STRING = "http";
    public static final String HTTPS_STRING = "https";
    public static final String T3_STRING = "t3";
    public static final String T3S_STRING = "t3s";
    public static final String IIOP_STRING = "iiop";
    public static final String IIOPS_STRING = "iiops";
    private static final String MIME_BOUNDARY = "---------------------------7d01b33320494";
    private static final String TEMP_FILE_PREFIX = "wl_comp";
    private static final String TEMP_FILE_EXT = ".jar";
    private static final boolean UPLOAD_LARGEFILE = Boolean.getBoolean("weblogic.deploy.UploadLargeFile");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final MBeanServerConnection mBeanServer;
    private Vector notifications = null;
    private DeployerRuntimeMBean deployer;
    private static final DeployerHelperTextFormatter textFormatter = new DeployerHelperTextFormatter();
    private static final boolean debug = false;
    private DomainRuntimeMBean domainRuntime = null;
    private AppRuntimeStateRuntimeMBean appRT = null;
    private DomainRuntimeServiceMBean drsb;
    private DomainMBean domain;
    private JMXConnector connector = null;
    private ConfigurationManagerMBean configMgr = null;

    public JMXDeployerHelper(JMXConnector jMXConnector) throws DeployerHelperException {
        if (jMXConnector != null) {
            this.connector = jMXConnector;
            MBeanServerConnection mBeanServerConnection = null;
            try {
                mBeanServerConnection = jMXConnector.getMBeanServerConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mBeanServer = mBeanServerConnection;
        } else {
            this.mBeanServer = null;
        }
        try {
            this.init();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new DeployerHelperException(instanceNotFoundException.toString(), instanceNotFoundException);
        }
    }

    public JMXDeployerHelper(MBeanServerConnection mBeanServerConnection) throws DeployerHelperException {
        this.mBeanServer = mBeanServerConnection;
        try {
            this.init();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new DeployerHelperException(instanceNotFoundException.toString(), instanceNotFoundException);
        }
    }

    private void init() throws InstanceNotFoundException {
        try {
            if (this.mBeanServer == null) {
                DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
                this.domainRuntime = domainAccess.getDomainRuntime();
                this.deployer = this.domainRuntime.getDeployerRuntime();
                this.appRT = this.domainRuntime.getAppRuntimeStateRuntime();
            } else {
                ObjectName objectName = new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME);
                this.drsb = this.connector == null ? (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)this.mBeanServer, (ObjectName)objectName) : (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((JMXConnector)this.connector, (ObjectName)objectName);
                this.domainRuntime = this.drsb.getDomainRuntime();
                this.deployer = this.domainRuntime.getDeployerRuntime();
                this.appRT = this.domainRuntime.getAppRuntimeStateRuntime();
            }
        }
        catch (Throwable throwable) {
            InstanceNotFoundException instanceNotFoundException = new InstanceNotFoundException(throwable.toString());
            instanceNotFoundException.initCause(throwable);
            throw instanceNotFoundException;
        }
    }

    public ConfigurationManagerMBean getConfigMgr() {
        return this.configMgr;
    }

    public boolean needsNonExclusiveLock() {
        if (this.getConfigMgr() != null) {
            return this.getConfigMgr().isEditor() && !this.getConfigMgr().isCurrentEditorExclusive();
        }
        EditAccess editAccess = ManagementServiceRestricted.getEditAccess(kernelId);
        return editAccess != null && editAccess.isEditor() && !editAccess.isEditorExclusive();
    }

    public boolean isEditing() {
        if (this.getConfigMgr() != null) {
            return this.getConfigMgr().getCurrentEditor() != null;
        }
        EditAccess editAccess = ManagementServiceRestricted.getEditAccess(kernelId);
        return editAccess != null && editAccess.getEditor() != null;
    }

    public void setConfigMgr(ConfigurationManagerMBean configurationManagerMBean) {
        this.configMgr = configurationManagerMBean;
    }

    public DomainMBean getDomain() {
        if (this.mBeanServer != null) {
            this.domain = this.drsb.getDomainPending();
            if (this.domain == null) {
                this.domain = this.drsb.getDomainConfiguration();
            }
        } else {
            try {
                this.domain = ManagementServiceRestricted.getEditAccess(kernelId).getDomainBeanWithoutLock();
            }
            catch (Throwable throwable) {
                RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
                this.domain = runtimeAccess.getDomain();
            }
        }
        return this.domain;
    }

    private boolean isAliveState(String string) {
        return string.equals("ADMIN") || string.equals("RUNNING") || string.equals("RESUMING");
    }

    public boolean isServerAlive(String string) {
        try {
            ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean = this.domainRuntime.lookupServerLifeCycleRuntime(string);
            return this.isAliveState(serverLifeCycleRuntimeMBean.getState());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public AppRuntimeStateRuntimeMBean getAppRuntimeStateMBean() throws Exception {
        return this.appRT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createJarFromDirectory(File file, File file2, File file3, Set set) throws IOException {
        File file4;
        block3: {
            if (file2 == null) {
                file2 = file;
            }
            File file5 = null;
            ZipOutputStream zipOutputStream = null;
            try {
                file5 = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_EXT, file3);
                file5.deleteOnExit();
                zipOutputStream = new JarOutputStream(new FileOutputStream(file5));
                String string = file.toString().replace(File.separatorChar, '/');
                JMXDeployerHelper.addFileOrDirectoryToJar(string.length(), file2, (JarOutputStream)zipOutputStream, set);
                file4 = file5;
                Object var9_8 = null;
                if (zipOutputStream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_9 = null;
                    if (zipOutputStream == null) break block4;
                    zipOutputStream.close();
                }
                throw throwable;
            }
            zipOutputStream.close();
        }
        return file4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addFileOrDirectoryToJar(int n, File file, JarOutputStream jarOutputStream, Set set) throws IOException {
        String string = file.toString().replace(File.separatorChar, '/');
        string = string.length() > n ? string.substring(n + 1) : (string.length() == n && file.isFile() ? file.getName() : "");
        if (file.isDirectory()) {
            if (set != null && set.contains(string)) {
                set.remove(string);
                set = null;
            }
            String[] stringArray = file.list();
            int i = 0;
            while (i < stringArray.length) {
                File file2 = new File(file, stringArray[i]);
                JMXDeployerHelper.addFileOrDirectoryToJar(n, file2, jarOutputStream, set);
                ++i;
            }
            return;
        }
        InputStream inputStream = null;
        try {
            try {
                File file3 = file;
                if (set == null || set.contains(string)) {
                    if (set != null) {
                        set.remove(string);
                    }
                    JarEntry jarEntry = new JarEntry(string);
                    jarEntry.setTime(file3.lastModified());
                    jarOutputStream.putNextEntry(jarEntry);
                    byte[] byArray = new byte[4096];
                    int n2 = 0;
                    inputStream = new BufferedInputStream(new FileInputStream(file3));
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        jarOutputStream.write(byArray, 0, n2);
                    }
                }
                Object var11_15 = null;
                if (inputStream == null) return;
            }
            catch (Exception exception) {
                String string2 = DeployerHelperTextFormatter.getInstance().exceptionArchivingFile(file.toString(), exception.toString());
                if (!(exception instanceof IOException)) throw new IOException(string2);
                throw (IOException)exception;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public DeployerRuntimeMBean getDeployer() throws Throwable {
        return this.deployer;
    }

    public DeploymentTaskRuntimeMBean getTaskMBean(String string) {
        try {
            return this.deployer.query(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void removeTask(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        if (deploymentTaskRuntimeMBean == null) {
            return;
        }
        this.deployer.removeTask(deploymentTaskRuntimeMBean.getId());
    }

    public DeploymentTaskRuntimeMBean getTaskByID(String string) {
        try {
            return this.deployer.query(string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public DeploymentTaskRuntimeMBean[] getAllTasks() {
        try {
            return this.deployer.list();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public ApplicationMBean getApplication(String string) throws InstanceNotFoundException {
        return this.getAppDeployment(string).getAppMBean();
    }

    public AppDeploymentMBean getAppDeployment(String string) throws InstanceNotFoundException {
        AppDeploymentMBean appDeploymentMBean = AppDeploymentHelper.lookupAppOrLib(string, this.getDomain());
        if (appDeploymentMBean == null) {
            throw new InstanceNotFoundException(string);
        }
        return appDeploymentMBean;
    }

    public String getAdminServerName() {
        if (this.domain == null) {
            this.getDomain();
        }
        return this.domain.getAdminServerName();
    }

    public DeploymentNotification getNextNotification(long l) {
        DeploymentNotification deploymentNotification = null;
        long l2 = System.currentTimeMillis() + l;
        do {
            if (this.notifications == null || this.notifications.isEmpty()) {
                long l3 = l2 - System.currentTimeMillis();
                if (l3 <= 0L) {
                    return null;
                }
                try {
                    this.wait(l3);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            deploymentNotification = (DeploymentNotification)this.notifications.remove(0);
        } while (deploymentNotification == null);
        return deploymentNotification;
    }

    public boolean isSourceArchive(String string) {
        File file = new File(string);
        return file.isFile();
    }

    public synchronized void queueNotification(Notification notification) {
        this.notifications.add(notification);
        this.notify();
    }

    public String uploadSource(String string, String string2, String string3, String string4, String[] stringArray, String string5) throws DeployerHelperException {
        String string6 = null;
        String string7 = null;
        try {
            Object object;
            String string8;
            string7 = this.getDSSUrl(string);
            HttpURLConnection httpURLConnection = this.getDSSConnection(string7);
            this.initConnection(string2, string3, string5, httpURLConnection, "app_upload");
            File file = new File(string4);
            String string9 = file.getName();
            if (this.isSourceArchive(string4)) {
                string8 = "true";
            } else {
                string8 = "false";
                string9 = string9.concat(TEMP_FILE_EXT);
            }
            httpURLConnection.setRequestProperty("archive", string8);
            httpURLConnection.setRequestProperty("wl_upload_delta", Boolean.toString(stringArray != null));
            BufferedInputStream bufferedInputStream = this.getInputStreamForSource(string4, stringArray);
            if (UPLOAD_LARGEFILE) {
                httpURLConnection.setChunkedStreamingMode(8192);
                OutputStream outputStream = httpURLConnection.getOutputStream();
                this.transferData(bufferedInputStream, outputStream, string9);
            } else {
                object = new UnsyncByteArrayOutputStream();
                this.transferData(bufferedInputStream, (OutputStream)object, string9);
                httpURLConnection.setRequestProperty("Content-Length", String.valueOf(object.size()));
                OutputStream outputStream = httpURLConnection.getOutputStream();
                object.writeTo(outputStream);
            }
            object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            string6 = ((BufferedReader)object).readLine();
            string6 = this.mimeDecode(string6);
            ((BufferedReader)object).close();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DeployerHelperException(uRISyntaxException.toString(), uRISyntaxException);
        }
        catch (IOException iOException) {
            throw new DeployerHelperException(textFormatter.exceptionUploadingSource(string7, string5, string4), iOException);
        }
        return string6;
    }

    public String uploadPlan(String string, String string2, String string3, String string4, String string5) throws DeployerHelperException {
        String string6 = null;
        String string7 = null;
        try {
            string7 = this.getDSSUrl(string);
            HttpURLConnection httpURLConnection = this.getDSSConnection(string7);
            this.initConnection(string2, string3, string5, httpURLConnection, "plan_upload");
            File file = new File(string4);
            String string8 = file.getName();
            if (file.isDirectory()) {
                httpURLConnection.setRequestProperty("archive", "false");
                string8 = string8.concat(TEMP_FILE_EXT);
            }
            OutputStream outputStream = httpURLConnection.getOutputStream();
            BufferedInputStream bufferedInputStream = this.getInputStreamForSource(string4, null);
            this.transferData(bufferedInputStream, outputStream, string8);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            string6 = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DeployerHelperException(uRISyntaxException.toString(), uRISyntaxException);
        }
        catch (IOException iOException) {
            throw new DeployerHelperException(textFormatter.exceptionUploadingSource(string7, string5, string4), iOException);
        }
        return string6;
    }

    private void transferData(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        int n;
        PrintStream printStream = new PrintStream(outputStream);
        String string2 = "-----------------------------7d01b33320494\r\n";
        string2 = string2 + "Content-Disposition: form-data; name=\"file\"; filename=\"" + JMXDeployerHelper.mimeEncode(string) + "\"\r\n";
        string2 = string2 + "Content-Type: application/x-zip-compressed\r\n";
        string2 = string2 + "\r\n";
        printStream.print(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            dataOutputStream.write(byArray, 0, n);
        }
        printStream.print("\r\n-----------------------------7d01b33320494--");
        printStream.flush();
        printStream.close();
        dataOutputStream.close();
        inputStream.close();
    }

    private void initConnection(String string, String string2, String string3, HttpURLConnection httpURLConnection, String string4) {
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setAllowUserInteraction(true);
        httpURLConnection.setRequestProperty("wl_request_type", JMXDeployerHelper.mimeEncode(string4));
        if (string != null) {
            httpURLConnection.setRequestProperty("username", JMXDeployerHelper.mimeEncode(string));
            httpURLConnection.setRequestProperty("password", JMXDeployerHelper.mimeEncode(string2));
        } else {
            ConnectionSigner.signConnection(httpURLConnection, (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction()));
        }
        if (string3 != null) {
            httpURLConnection.setRequestProperty("wl_upload_application_name", JMXDeployerHelper.mimeEncode(string3));
        }
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=---------------------------7d01b33320494");
    }

    private String getDSSUrl(String string) throws URISyntaxException {
        if (!string.startsWith(HTTP_STRING)) {
            URI uRI = new URI(string);
            URI uRI2 = new URI(this.getHTTPProtocol(uRI.getScheme()), null, uRI.getHost(), uRI.getPort(), null, null, null);
            string = uRI2.toString();
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return string + "bea_wls_deployment_internal/DeploymentService";
    }

    private HttpURLConnection getDSSConnection(String string) throws IOException {
        URL uRL = new URL(string);
        return (HttpURLConnection)uRL.openConnection();
    }

    private String getHTTPProtocol(String string) {
        if (string.equals(HTTPS_STRING) || string.equals(T3S_STRING) || string.equals(IIOPS_STRING)) {
            return HTTPS_STRING;
        }
        return HTTP_STRING;
    }

    BufferedInputStream getInputStreamForSource(String string, String[] stringArray) throws IOException, DeployerHelperException {
        String string2 = string;
        try {
            URL uRL = new URL(string);
            return new BufferedInputStream(uRL.openStream());
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (!file.exists()) {
                throw new DeployerHelperException(textFormatter.exceptionNoSuchSource(string));
            }
            TreeSet<String> treeSet = null;
            if (stringArray != null) {
                treeSet = new TreeSet<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].replace(File.separatorChar, '/');
                    treeSet.add(string3);
                }
            }
            if (file.isDirectory()) {
                file = JMXDeployerHelper.createJarFromDirectory(file, null, null, treeSet);
            }
            if (stringArray != null && treeSet != null && treeSet.size() > 0) {
                throw new DeployerHelperException(textFormatter.exceptionUploadingFiles(((Object)treeSet).toString(), string2));
            }
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    private static String mimeEncode(String string) {
        String string2 = null;
        try {
            string2 = MimeUtility.encodeText((String)string, (String)"UTF-8", null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        return string2;
    }

    private String mimeDecode(String string) {
        try {
            if (string != null) {
                return MimeUtility.decodeText((String)string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }
}

