/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.io.File;
import weblogic.application.internal.library.util.DeweyDecimal;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.deploy.api.internal.utils.ConfigHelper;

public class LibrarySpec {
    private LibraryData lib;
    private boolean mark = false;
    private Object key;

    public LibrarySpec(String string, String string2, String string3, File file) throws IllegalArgumentException {
        try {
            ConfigHelper.checkParam("File", file);
            this.lib = LibraryLoggingUtils.initLibraryData(string, string2, string3, file);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new IllegalArgumentException(loggableLibraryProcessingException);
        }
    }

    public LibraryData getLibraryData() {
        return this.lib;
    }

    public String getName() {
        return this.getLibraryData().getName();
    }

    public String getSpecVersion() {
        DeweyDecimal deweyDecimal = this.getLibraryData().getSpecificationVersion();
        return deweyDecimal == null ? null : deweyDecimal.toString();
    }

    public String getImplVersion() {
        return this.getLibraryData().getImplementationVersion();
    }

    public File getLocation() {
        return this.getLibraryData().getLocation();
    }

    public void mark() {
        this.mark = true;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public void setKey(Object object) {
        this.key = object;
    }

    public Object getKey() {
        return this.key;
    }
}

