/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.internal.utils;

import java.util.Locale;
import weblogic.deploy.api.internal.SPIDeployerLogger;

public class LocaleManager {
    private static Locale defaultLocale;
    private static Locale[] supportedLocales;

    private static void setupLocale(Locale locale) {
        Locale.setDefault(locale);
    }

    public static void setLocale(Locale locale) throws UnsupportedOperationException {
        if (!LocaleManager.isLocaleSupported(locale)) {
            throw new UnsupportedOperationException(SPIDeployerLogger.unsupportedLocale((String)locale.toString()));
        }
        LocaleManager.setupLocale(locale);
    }

    public static boolean isLocaleSupported(Locale locale) {
        Locale[] localeArray = LocaleManager.getSupportedLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!localeArray[i].equals(locale)) continue;
            return true;
        }
        return false;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static Locale getCurrentLocale() {
        return Locale.getDefault();
    }

    public static Locale[] getSupportedLocales() {
        if (supportedLocales == null) {
            supportedLocales = Locale.getAvailableLocales();
        }
        return supportedLocales;
    }

    static {
        supportedLocales = null;
        defaultLocale = Locale.getDefault();
        LocaleManager.setupLocale(defaultLocale);
    }
}

