/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import weblogic.application.ApplicationFileManager;
import weblogic.deploy.api.internal.Closable;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ClassLoaderControl;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.internal.utils.LibrarySpec;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.deploy.api.model.internal.WebLogicDeployableObjectFactoryImpl;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.config.DescriptorParser;
import weblogic.deploy.api.spi.config.DescriptorSupportManager;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.utils.FileUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.jars.VirtualJarFile;

public class WebLogicDeployableObject
implements DeployableObject,
Closable {
    private static final boolean debug = Debug.isDebug("model");
    protected ModuleType moduleType;
    protected File moduleArchive;
    protected WebLogicDeployableObject parent = null;
    protected boolean standalone = true;
    protected List subModules = new ArrayList();
    protected String uri = null;
    protected Map ddMap = new HashMap();
    protected InstallDir installDir = null;
    protected boolean haveAppRoot = false;
    private VirtualJarFile vjf = null;
    protected GenericClassLoader gcl = null;
    protected DescriptorBean beanTree = null;
    protected DDRootFields ddRoot;
    protected boolean lazy = false;
    protected ClassLoaderControl clf = null;
    protected File plan;
    protected File plandir;
    protected DeploymentPlanBean planBean;
    protected LibrarySpec[] libraries = null;
    protected boolean deleteOnClose = false;
    protected ClassFinder resourceFinder;
    protected String contextRoot;

    protected WebLogicDeployableObject(File file, ModuleType moduleType, WebLogicDeployableObject webLogicDeployableObject, String string, String string2, File file2, File file3, File file4) throws IOException {
        ConfigHelper.checkParam("File", file);
        this.setPlan(file3);
        this.setPlanDir(file4);
        this.setParent(webLogicDeployableObject);
        this.setModuleArchive(file);
        this.setModuleType(moduleType);
        this.setUri(string);
        this.setInstallDir(file2);
    }

    public WebLogicDeployableObject(File file, ModuleType moduleType, WebLogicDeployableObject webLogicDeployableObject, String string, String string2, File file2, File file3, File file4, LibrarySpec[] librarySpecArray, boolean bl) throws InvalidModuleException, IOException {
        ConfigHelper.checkParam("File", file);
        ConfigHelper.checkParam("ModuleType", moduleType);
        this.lazy = bl;
        this.setPlan(file3);
        this.setPlanDir(file4);
        this.setLibraries(librarySpecArray);
        if (webLogicDeployableObject == null) {
            DescriptorSupportManager.flush();
        }
        this.setParent(webLogicDeployableObject);
        this.setModuleArchive(file);
        this.setModuleType(moduleType);
        this.setUri(string);
        this.setInstallDir(file2);
        this.setDDBeanRoot(new DDBeanRootImpl(string2, this, moduleType));
        if (!bl) {
            this.getDDBeanRootInternal();
        }
    }

    protected void setLibraries(LibrarySpec[] librarySpecArray) {
        this.libraries = librarySpecArray;
    }

    public File getPlandir() {
        return this.plandir;
    }

    public File getPlan() {
        return this.plan;
    }

    public void setVirtualJarFile(VirtualJarFile virtualJarFile) {
        this.closeVJF();
        this.vjf = virtualJarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentPlanBean getPlanBean() throws IOException {
        if (this.planBean == null && this.plan != null) {
            FileInputStream fileInputStream = new FileInputStream(this.plan);
            try {
                this.planBean = DescriptorParser.parseDeploymentPlan(fileInputStream);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            {
            }
        }
        return this.planBean;
    }

    protected void setPlanDir(File file) {
        this.plandir = file;
        if (file == null && this.planBean != null && this.planBean.getConfigRoot() != null) {
            this.plandir = new File(this.planBean.getConfigRoot());
        }
    }

    protected void setPlan(File file) {
        this.plan = file;
    }

    protected DDBeanRootImpl getDDBeanRootInternal() throws IOException, InvalidModuleException {
        DDBeanRootImpl dDBeanRootImpl;
        if (this.ddRoot == null) {
            this.setDDBeanRoot(new DDBeanRootImpl(null, this, this.moduleType, null, true));
        }
        if ((dDBeanRootImpl = this.ddRoot.getRoot()) != null && dDBeanRootImpl.isInitialized()) {
            return dDBeanRootImpl;
        }
        if (debug) {
            Debug.say("DDBeanRootImpl root for " + dDBeanRootImpl.getFilename() + " is null or not initialized");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream getDDStream(String string, ModuleType moduleType) throws FileNotFoundException {
        InputStream inputStream;
        if (string != null) {
            if (this.parent == null) throw new AssertionError((Object)"Attempt to construct standalone module with altDD");
            inputStream = this.parent.getEntry(string);
            if (inputStream == null) {
                throw new FileNotFoundException(SPIDeployerLogger.noFile((String)string));
            }
        } else {
            if (!this.getArchive().getName().endsWith(".xml")) return this.getEntry(WebLogicModuleType.getDDUri(moduleType.getValue()));
            return new FileInputStream(this.getArchive());
        }
        if (!debug) return inputStream;
        Debug.say("using altdd at " + string);
        return inputStream;
    }

    public ModuleType getType() {
        return this.moduleType;
    }

    public DDBean[] getChildBean(String string) {
        ConfigHelper.checkParam("xpath", string);
        return this.getDDBeanRoot().getChildBean(string);
    }

    public Class getClassFromScope(String string) {
        ConfigHelper.checkParam("className", string);
        try {
            this.gcl = this.getOrCreateGCL();
            return Class.forName(string, false, (ClassLoader)this.gcl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public DDBeanRoot getDDBeanRoot() {
        try {
            return this.getDDBeanRootInternal();
        }
        catch (Exception exception) {
            if (debug) {
                exception.printStackTrace();
            }
            throw new RuntimeException(exception);
        }
    }

    protected void setDDBeanRoot(DDBeanRoot dDBeanRoot) {
        this.ddRoot = new DDRootFields((DDBeanRootImpl)dDBeanRoot);
    }

    public String[] getText(String string) {
        ConfigHelper.checkParam("xpath", string);
        return this.getDDBeanRoot().getText(string);
    }

    public boolean hasDDBean(String string) throws FileNotFoundException {
        DDBeanRootImpl dDBeanRootImpl;
        if (debug) {
            Debug.say("getting ddbean root for : " + string);
        }
        if (string == null) {
            throw new FileNotFoundException(string);
        }
        if (string.equals(".")) {
            string = this.getArchive().getPath();
        }
        if ((dDBeanRootImpl = (DDBeanRootImpl)this.ddMap.get(string)) != null) {
            return dDBeanRootImpl.hasDBean();
        }
        return false;
    }

    public DDBeanRoot getDDBeanRoot(String string) throws FileNotFoundException, DDBeanCreateException {
        DDBeanRootImpl dDBeanRootImpl;
        if (debug) {
            Debug.say("getting ddbean root for : " + string);
        }
        if (string == null) {
            throw new FileNotFoundException(string);
        }
        if (string.equals(".")) {
            string = this.getArchive().getPath();
        }
        if ((dDBeanRootImpl = (DDBeanRootImpl)this.ddMap.get(string)) != null && dDBeanRootImpl.isInitialized()) {
            return dDBeanRootImpl;
        }
        if (debug) {
            Debug.say("DDBeanRootImpl root " + (dDBeanRootImpl == null ? "" : dDBeanRootImpl.getFilename()) + " is null or not initialized");
        }
        return null;
    }

    public InputStream getInputStream(String string) throws FileNotFoundException {
        InputStream inputStream = this.getEntry(string);
        if (inputStream == null && this.haveAppRoot) {
            File file = this.parent == null ? this.getInstallDir().getAppDDFile(string) : this.getInstallDir().getDDFile(this.uri, string);
            if (debug) {
                Debug.say("Looking for dd in config area: " + file.getPath());
            }
            inputStream = new FileInputStream(file);
        }
        return inputStream;
    }

    public Enumeration entries() {
        if (this.getArchive().getName().endsWith(".xml")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.moduleArchive.getPath());
            return Collections.enumeration(arrayList);
        }
        Iterator iterator = this.vjf.entries();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            arrayList.add(((ZipEntry)iterator.next()).getName());
        }
        return Collections.enumeration(arrayList);
    }

    public Enumeration getDDResourceEntries(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string22 = null;
        for (String string22 : this.ddMap.keySet()) {
            if (!string22.endsWith(string)) continue;
            hashSet.add(string22);
        }
        return Collections.enumeration(hashSet);
    }

    public InputStream getEntry(String string) {
        block10: {
            ConfigHelper.checkParam("name", string);
            try {
                ZipEntry zipEntry;
                if (this.getArchive().getName().endsWith(".xml")) {
                    if (string.equals(".")) {
                        return new FileInputStream(this.getArchive());
                    }
                    if (debug) {
                        Debug.say("No entry in document for " + string);
                    }
                    return null;
                }
                if (debug) {
                    Debug.say("in DO : " + this.moduleArchive.getName() + " with uri " + this.uri);
                }
                if (debug) {
                    Debug.say("Getting stream for entry " + string);
                }
                if (this.vjf != null && (zipEntry = this.vjf.getEntry(string)) != null) {
                    return this.vjf.getInputStream(zipEntry);
                }
                if (this.parent != null) {
                    return this.getStreamFromParent(this.uri, string);
                }
                if (debug) {
                    Debug.say("No entry in archive for " + string);
                }
            }
            catch (IOException iOException) {
                if (!debug) break block10;
                Debug.say("No entry in archive for " + string);
            }
        }
        return null;
    }

    protected InputStream getStreamFromParent(String string, String string2) throws IOException {
        ZipEntry zipEntry;
        VirtualJarFile virtualJarFile = this.parent.getVirtualJarFile();
        if (virtualJarFile != null && (zipEntry = virtualJarFile.getEntry(string + "/" + string2)) != null) {
            return virtualJarFile.getInputStream(zipEntry);
        }
        return null;
    }

    public String getModuleDTDVersion() {
        if (!((DDBeanRootImpl)this.getDDBeanRoot()).isSchemaBased()) {
            return this.getDDBeanRoot().getDDBeanRootVersion();
        }
        return null;
    }

    public void setDescriptorBean(DescriptorBean descriptorBean) {
        this.beanTree = descriptorBean;
    }

    public boolean isDBSet() {
        return this.beanTree != null;
    }

    public DescriptorBean getDescriptorBean() throws IOException {
        if (this.beanTree != null) {
            return this.beanTree;
        }
        if (debug) {
            Debug.say("beanTree of WebLogicDeployableObject (" + this.toString() + ") is null.");
        }
        return null;
    }

    public static WebLogicDeployableObject createDeployableObject(File file) throws InvalidModuleException, IOException {
        WebLogicDeployableObjectFactoryImpl webLogicDeployableObjectFactoryImpl = new WebLogicDeployableObjectFactoryImpl();
        return webLogicDeployableObjectFactoryImpl.createDeployableObject(file);
    }

    public static WebLogicDeployableObject createDeployableObject(File file, File file2) throws InvalidModuleException, IOException {
        WebLogicDeployableObjectFactoryImpl webLogicDeployableObjectFactoryImpl = new WebLogicDeployableObjectFactoryImpl();
        return webLogicDeployableObjectFactoryImpl.createDeployableObject(file, file2);
    }

    public static WebLogicDeployableObject createDeployableObject(File file, File file2, File file3, File file4, LibrarySpec[] librarySpecArray) throws IOException, InvalidModuleException, ConfigurationException {
        WebLogicDeployableObjectFactoryImpl webLogicDeployableObjectFactoryImpl = new WebLogicDeployableObjectFactoryImpl();
        return webLogicDeployableObjectFactoryImpl.createDeployableObject(file, file2, file3, file4, librarySpecArray);
    }

    public static WebLogicDeployableObject createLazyDeployableObject(File file, File file2, File file3, File file4, LibrarySpec[] librarySpecArray) throws IOException, InvalidModuleException, ConfigurationException {
        WebLogicDeployableObjectFactoryImpl webLogicDeployableObjectFactoryImpl = new WebLogicDeployableObjectFactoryImpl();
        return webLogicDeployableObjectFactoryImpl.createLazyDeployableObject(file, file2, file3, file4, librarySpecArray);
    }

    public void setDeleteOnClose() {
        this.deleteOnClose = true;
    }

    public LibrarySpec[] getLibraries() {
        return this.libraries;
    }

    public static WebLogicDeployableObject createLazyDeployableObject(File file, File file2) throws InvalidModuleException, IOException {
        WebLogicDeployableObjectFactoryImpl webLogicDeployableObjectFactoryImpl = new WebLogicDeployableObjectFactoryImpl();
        return webLogicDeployableObjectFactoryImpl.createLazyDeployableObject(file, file2, null, null, null);
    }

    public File getArchive() {
        return this.moduleArchive;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.moduleType.toString());
        stringBuffer.append(" Archive: ");
        stringBuffer.append(this.moduleArchive.toString());
        if (this.contextRoot != null) {
            stringBuffer.append(" ContextRoot: ");
            stringBuffer.append(this.contextRoot);
        }
        return stringBuffer.toString();
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDDBeanRoot() != null) {
            stringBuffer.append(this.toString());
            stringBuffer.append("\n");
            stringBuffer.append(this.getDDBeanRoot().toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getFileName(DDBeanRootImpl dDBeanRootImpl) {
        for (String string : this.ddMap.keySet()) {
            DDBeanRootImpl dDBeanRootImpl2 = (DDBeanRootImpl)this.ddMap.get(string);
            if (dDBeanRootImpl2 != dDBeanRootImpl) continue;
            return string;
        }
        return WebLogicModuleType.getDDUri(this.moduleType.getValue());
    }

    public DDBeanRoot[] getDDBeanRoots() {
        return this.ddMap.values().toArray(new DDBeanRoot[0]);
    }

    public File getInstallDirPath() {
        if (this.parent != null) {
            return this.parent.getInstallDirPath();
        }
        return this.getInstallDir().getInstallDir();
    }

    public InstallDir getInstallDir() {
        if (this.parent != null) {
            return this.parent.getInstallDir();
        }
        return this.installDir;
    }

    protected void setInstallDir(File file) throws IOException {
        boolean bl = this.haveAppRoot = file != null;
        if (this.parent != null) {
            return;
        }
        this.installDir = new InstallDir(this.moduleArchive.getName(), file);
    }

    protected void setModuleArchive(File file) throws IOException {
        if (debug) {
            Debug.say("setting module archive: " + file.toString());
        }
        this.moduleArchive = file;
        if (file.getName().endsWith(".xml")) {
            return;
        }
        if (this.vjf == null && file != null) {
            this.vjf = ApplicationFileManager.newInstance(this.moduleArchive).getVirtualJarFile();
        }
    }

    protected void setModuleType(ModuleType moduleType) {
        if (debug) {
            Debug.say("setting module type: " + moduleType);
        }
        this.moduleType = moduleType;
    }

    public void setParent(WebLogicDeployableObject webLogicDeployableObject) {
        this.parent = webLogicDeployableObject;
    }

    public WebLogicDeployableObject getParent() {
        return this.parent;
    }

    public VirtualJarFile getVirtualJarFile() {
        return this.vjf;
    }

    public String getUri() {
        return this.uri;
    }

    protected void setUri(String string) {
        if (debug) {
            Debug.say("setting module uri: " + string);
        }
        this.uri = string;
    }

    public GenericClassLoader getOrCreateGCL() throws IOException {
        if (this.gcl == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (this.moduleArchive.getName().endsWith(".xml")) {
                this.gcl = new GenericClassLoader(NullClassFinder.NULL_FINDER, classLoader);
            } else {
                JarClassFinder jarClassFinder = new JarClassFinder(this.moduleArchive);
                this.gcl = new GenericClassLoader((ClassFinder)new MultiClassFinder(), classLoader);
                this.gcl.addClassFinder((ClassFinder)jarClassFinder);
            }
        }
        return this.gcl;
    }

    public void close() {
        for (WebLogicDeployableObject webLogicDeployableObject : this.subModules) {
            if (webLogicDeployableObject == null) continue;
            webLogicDeployableObject.close();
        }
        this.closeGCL();
        this.closeVJF();
        this.closeResourceFinder();
        if (this.deleteOnClose && !debug) {
            FileUtils.remove((File)this.moduleArchive.getParentFile());
        }
        this.ddMap.clear();
    }

    protected void closeGCL() {
        if (this.gcl != null) {
            this.gcl.close();
        }
        this.gcl = null;
    }

    protected void closeResourceFinder() {
        if (this.resourceFinder != null) {
            this.resourceFinder.close();
        }
        this.resourceFinder = null;
    }

    protected void closeVJF() {
        if (this.vjf != null) {
            try {
                if (debug) {
                    Debug.say("Closing " + this.vjf.getName());
                }
                this.vjf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.vjf = null;
    }

    public void setResourceFinder(ClassFinder classFinder) {
        this.resourceFinder = classFinder;
    }

    public ClassFinder getResourceFinder() {
        return this.resourceFinder;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String string) {
        this.contextRoot = string;
    }

    protected class DDRootFields {
        private DDBeanRootImpl root;

        DDRootFields(DDBeanRootImpl dDBeanRootImpl) {
            this.setRoot(dDBeanRootImpl);
        }

        public DDBeanRootImpl getRoot() {
            return this.root;
        }

        public void setRoot(DDBeanRootImpl dDBeanRootImpl) {
            this.root = dDBeanRootImpl;
        }
    }
}

