/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;

public class WebLogicJ2eeApplicationObject
extends WebLogicDeployableObject
implements J2eeApplicationObject {
    private static final boolean debug = Debug.isDebug("model");
    protected ApplicationBean app;

    public void close() {
        super.close();
    }

    protected WebLogicJ2eeApplicationObject(File file, File file2, File file3, File file4) throws IOException {
        super(file, ModuleType.EAR, null, null, null, file2, file3, file4);
    }

    public void addXpathListener(ModuleType moduleType, String string, XpathListener xpathListener) {
    }

    public void removeXpathListener(ModuleType moduleType, String string, XpathListener xpathListener) {
    }

    public String[] getText(ModuleType moduleType, String string) {
        ConfigHelper.checkParam("ModuleType", moduleType);
        ConfigHelper.checkParam("xpath", string);
        if (moduleType == ModuleType.EAR) {
            return this.getDDBeanRoot().getText(string);
        }
        DeployableObject[] deployableObjectArray = this.getDeployableObjects(moduleType);
        if (deployableObjectArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < deployableObjectArray.length; ++i) {
            DeployableObject deployableObject = deployableObjectArray[i];
            if (deployableObject.getType() != moduleType) continue;
            arrayList.addAll(Arrays.asList((Object[])deployableObject.getText(string)));
        }
        return arrayList.toArray(new String[0]);
    }

    public DDBean[] getChildBean(ModuleType moduleType, String string) {
        ConfigHelper.checkParam("ModuleType", moduleType);
        ConfigHelper.checkParam("xpath", string);
        if (moduleType == ModuleType.EAR) {
            return this.getDDBeanRoot().getChildBean(string);
        }
        DeployableObject[] deployableObjectArray = this.getDeployableObjects(moduleType);
        if (deployableObjectArray == null) {
            return null;
        }
        ArrayList<DDBean> arrayList = new ArrayList<DDBean>();
        for (int i = 0; i < deployableObjectArray.length; ++i) {
            DDBean[] dDBeanArray;
            DeployableObject deployableObject = deployableObjectArray[i];
            if (deployableObject.getType().getValue() != moduleType.getValue() || (dDBeanArray = deployableObject.getChildBean(string)) == null) continue;
            arrayList.addAll(Arrays.asList(dDBeanArray));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new DDBean[0]);
    }

    public String[] getModuleUris() {
        return this.getModuleUris(this.getDeployableObjects());
    }

    public String[] getModuleUris(ModuleType moduleType) {
        ConfigHelper.checkParam("ModuleType", moduleType);
        if (moduleType == ModuleType.EAR) {
            return null;
        }
        return this.getModuleUris(this.getDeployableObjects(moduleType));
    }

    public DeployableObject[] getDeployableObjects() {
        if (this.subModules.size() == 0) {
            return null;
        }
        return this.subModules.toArray(new WebLogicDeployableObject[0]);
    }

    public DeployableObject[] getDeployableObjects(ModuleType moduleType) {
        ConfigHelper.checkParam("ModuleType", moduleType);
        ArrayList<DeployableObject> arrayList = new ArrayList<DeployableObject>();
        if (moduleType == ModuleType.EAR) {
            return new WebLogicDeployableObject[]{this};
        }
        for (DeployableObject deployableObject : this.subModules) {
            if (!deployableObject.getType().equals(moduleType)) continue;
            arrayList.add(deployableObject);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new WebLogicDeployableObject[0]);
    }

    public DeployableObject getDeployableObject(String string) {
        ConfigHelper.checkParam("uri", string);
        DeployableObject[] deployableObjectArray = this.getDeployableObjects();
        WebLogicDeployableObject webLogicDeployableObject = null;
        if (deployableObjectArray != null) {
            for (int i = 0; i < deployableObjectArray.length; ++i) {
                WebLogicDeployableObject webLogicDeployableObject2 = (WebLogicDeployableObject)deployableObjectArray[i];
                if (!string.equals(webLogicDeployableObject2.getUri())) continue;
                webLogicDeployableObject = webLogicDeployableObject2;
                break;
            }
        }
        return webLogicDeployableObject;
    }

    public DeployableObject[] getDeployableObjects(String string) {
        ConfigHelper.checkParam("uri", string);
        ArrayList<WebLogicDeployableObject> arrayList = new ArrayList<WebLogicDeployableObject>();
        DeployableObject[] deployableObjectArray = this.getDeployableObjects();
        Object var4_4 = null;
        if (deployableObjectArray != null) {
            for (int i = 0; i < deployableObjectArray.length; ++i) {
                WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)deployableObjectArray[i];
                if (!string.equals(webLogicDeployableObject.getUri())) continue;
                arrayList.add(webLogicDeployableObject);
            }
        }
        return arrayList.toArray(new WebLogicDeployableObject[0]);
    }

    public DescriptorBean getDescriptorBean() {
        return (DescriptorBean)this.app;
    }

    protected String[] getModuleUris(DeployableObject[] deployableObjectArray) {
        WebLogicDeployableObject webLogicDeployableObject = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (deployableObjectArray != null) {
            for (int i = 0; i < deployableObjectArray.length; ++i) {
                webLogicDeployableObject = (WebLogicDeployableObject)deployableObjectArray[i];
                arrayList.add(webLogicDeployableObject.getUri());
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    public void setDescriptorBean(DescriptorBean descriptorBean) {
        if (!(descriptorBean instanceof ApplicationBean)) {
            if (debug) {
                Thread.dumpStack();
            }
            throw new AssertionError((Object)SPIDeployerLogger.unexpectedDD((String)this.getArchive().getPath()));
        }
        this.app = (ApplicationBean)descriptorBean;
    }

    protected void addModule(ModuleBean moduleBean) throws InvalidModuleException, IOException, URISyntaxException {
        ModuleType moduleType = null;
        String string = null;
        if (debug) {
            Debug.say("Adding embedded module");
        }
        if (moduleBean.getEjb() != null) {
            moduleType = ModuleType.EJB;
            string = moduleBean.getEjb();
        } else if (moduleBean.getJava() != null) {
            moduleType = ModuleType.CAR;
            string = moduleBean.getJava();
        } else if (moduleBean.getWeb() != null) {
            moduleType = ModuleType.WAR;
            string = moduleBean.getWeb().getWebUri();
        } else if (moduleBean.getConnector() != null) {
            moduleType = ModuleType.RAR;
            string = moduleBean.getConnector();
        }
        if (debug) {
            Debug.say("module type is : " + moduleType);
        }
        if (moduleType == null) {
            return;
        }
        if (this.getDeployableObject(string) != null) {
            return;
        }
        File file = this.getModulePath(string);
        this.subModules.add(new WebLogicDeployableObject(file, moduleType, this, string, moduleBean.getAltDd(), this.installDir.getInstallDir(), null, null, null, this.lazy));
    }

    protected File getModulePath(String string) throws URISyntaxException {
        return new File(this.getVirtualJarFile().getEntry(string).toString());
    }
}

