/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model.internal;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.XpathListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.model.WebLogicDDBean;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.xml.xpath.DOMXPath;
import weblogic.xml.xpath.XPathException;

public class DDBeanImpl
implements WebLogicDDBean {
    private static final boolean debug = Debug.isDebug("model");
    protected Node node;
    protected String xpath = null;
    protected WebLogicDeployableObject dObject = null;
    protected String id = null;
    protected List childBeans = new ArrayList();
    private DDBeanRootImpl ddRoot = null;
    NamedNodeMap attrs = null;
    String[] names = null;
    private DDBean parent;
    private String text = null;

    public DDBeanImpl(WebLogicDeployableObject webLogicDeployableObject) {
        this.dObject = webLogicDeployableObject;
    }

    protected void initDD(Node node, String string, DDBean dDBean) {
        this.node = node;
        this.xpath = string;
        if (debug) {
            Debug.say("Creating DDBean with xpath: " + string);
        }
        this.parent = dDBean;
        if (node == null) {
            return;
        }
        this.initAttributes();
    }

    private void initAttributes() {
        this.attrs = this.node.getAttributes();
        if (this.attrs != null) {
            for (int i = 0; i < this.attrs.getLength(); ++i) {
                Node node = this.attrs.item(i);
                if (!node.getNodeName().equals("id")) continue;
                this.id = node.getNodeValue();
                break;
            }
        }
    }

    public String getXpath() {
        return this.xpath;
    }

    public String getText() {
        return this.getNodeText();
    }

    public String getId() {
        return this.id;
    }

    public DDBeanRoot getRoot() {
        return this.ddRoot;
    }

    public DDBean[] getChildBean(String string) {
        DDBean[] dDBeanArray;
        ConfigHelper.checkParam("xpath", string);
        if (debug) {
            Debug.say("[" + this.getXpath() + "] getting nodes with xpath: " + string);
        }
        if ((dDBeanArray = this.findBean(string)).length > 0) {
            return dDBeanArray;
        }
        try {
            DOMXPath dOMXPath = new DOMXPath(string);
            Node node = this.getNode();
            if (node == null) {
                return null;
            }
            Set set = dOMXPath.evaluateAsNodeset(node);
            if (set == null || set.size() == 0) {
                if (debug) {
                    Debug.say("No nodes for xpath: " + string);
                }
                return null;
            }
            Iterator iterator = set.iterator();
            ArrayList<DDBeanImpl> arrayList = new ArrayList<DDBeanImpl>();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                DDBeanImpl dDBeanImpl = new DDBeanImpl(this.dObject);
                dDBeanImpl.initDD(node2, string, this);
                this.addChild(dDBeanImpl);
                arrayList.add(dDBeanImpl);
            }
            return arrayList.toArray(new DDBean[0]);
        }
        catch (XPathException xPathException) {
            if (debug) {
                xPathException.printStackTrace();
            }
            return null;
        }
    }

    public String[] getText(String string) {
        ConfigHelper.checkParam("path", string);
        DDBean[] dDBeanArray = this.getChildBean(string);
        if (dDBeanArray == null) {
            return null;
        }
        String[] stringArray = new String[dDBeanArray.length];
        for (int i = 0; i < dDBeanArray.length; ++i) {
            stringArray[i] = dDBeanArray[i].getText();
        }
        return stringArray;
    }

    public void addXpathListener(String string, XpathListener xpathListener) {
    }

    public void removeXpathListener(String string, XpathListener xpathListener) {
    }

    public String[] getAttributeNames() {
        if (this.names != null) {
            return this.names;
        }
        if (this.attrs == null) {
            return null;
        }
        this.names = new String[this.attrs.getLength()];
        for (int i = 0; i < this.attrs.getLength(); ++i) {
            this.names[i] = this.attrs.item(i).getNodeName();
        }
        return this.names;
    }

    public String getAttributeValue(String string) {
        ConfigHelper.checkParam("attrName", string);
        if (this.attrs == null) {
            return null;
        }
        for (int i = 0; i < this.attrs.getLength(); ++i) {
            Node node = this.attrs.item(i);
            if (!node.getNodeName().equals(string)) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public Node getNode() {
        if (this.node == null) {
            // empty if block
        }
        return this.node;
    }

    public void addChild(DDBeanImpl dDBeanImpl) {
        this.childBeans.add(dDBeanImpl);
        dDBeanImpl.setRoot(this.getRoot());
    }

    protected void setRoot(DDBeanRoot dDBeanRoot) {
        this.ddRoot = (DDBeanRootImpl)dDBeanRoot;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getXpath());
        if (this.getText() != null && this.getText().length() > 0) {
            stringBuffer.append(": <");
            stringBuffer.append(this.getText());
            stringBuffer.append(">");
        }
        if (this.childBeans.size() > 0) {
            Iterator iterator = this.childBeans.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n");
                stringBuffer.append(iterator.next().toString());
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getXpath().hashCode();
    }

    public boolean equals(Object object) {
        Exception exception = new Exception("[DDBeanImpl].equals() expensive equals method");
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object instanceof DDBeanImpl && this.getNode() != null && this.getNode() == ((DDBeanImpl)object).getNode();
    }

    DDBean[] findBean(String string) {
        ArrayList<DDBeanImpl> arrayList = new ArrayList<DDBeanImpl>();
        for (DDBeanImpl dDBeanImpl : this.childBeans) {
            if (string == dDBeanImpl.getXpath()) {
                arrayList.add(dDBeanImpl);
                continue;
            }
            if (string == null || !string.equals(dDBeanImpl.getXpath())) continue;
            arrayList.add(dDBeanImpl);
        }
        return arrayList.toArray(new DDBean[0]);
    }

    private String getNodeText() {
        if (this.text == null && this.getNode() != null) {
            this.text = DDBeanImpl.getTextFromNode(this.node);
        }
        return this.text;
    }

    private static final String getTextFromNode(Node node) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                transformer.transform(new DOMSource(node2), new StreamResult(stringWriter));
            }
            String string = stringWriter.toString();
            return string;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return null;
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }
}

