/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.model.WebLogicDDBeanRoot;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.internal.DDBeanImpl;
import weblogic.deploy.api.spi.config.DescriptorParser;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.deploy.api.spi.config.DescriptorSupportManager;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;

public class DDBeanRootImpl
extends DDBeanImpl
implements WebLogicDDBeanRoot {
    private static final boolean debug = Debug.isDebug("model");
    private Document doc = null;
    private DescriptorParser dom = null;
    private String altdd;
    private ModuleType moduleType;
    private boolean initialized = false;
    private DescriptorBean beanTree = null;
    private boolean schemaBased;

    public DDBeanRootImpl(String string, WebLogicDeployableObject webLogicDeployableObject, ModuleType moduleType) {
        super(webLogicDeployableObject);
        this.altdd = string;
        this.moduleType = moduleType;
        this.setRoot(this);
    }

    public DDBeanRootImpl(String string, WebLogicDeployableObject webLogicDeployableObject, ModuleType moduleType, DescriptorBean descriptorBean, boolean bl) {
        super(webLogicDeployableObject);
        this.altdd = string;
        this.moduleType = moduleType;
        this.beanTree = descriptorBean;
        this.schemaBased = bl;
        this.setRoot(this);
        if (debug && descriptorBean != null) {
            Debug.say("Descriptor bean for " + moduleType + " is not null");
        }
        this.initialize();
        this.initialized = true;
    }

    public synchronized void setupDDBeanRoot(InputStream inputStream) throws DDBeanCreateException {
        if (this.initialized) {
            return;
        }
        try {
            ModuleType moduleType = this.getModuleType();
            DescriptorSupport[] descriptorSupportArray = DescriptorSupportManager.getForModuleType(moduleType);
            DescriptorSupport descriptorSupport = null;
            if (descriptorSupportArray.length >= 1) {
                descriptorSupport = descriptorSupportArray[0];
                if (descriptorSupportArray.length > 1 && (descriptorSupportArray = DescriptorSupportManager.getForBaseURI(this.altdd)).length > 0) {
                    descriptorSupport = descriptorSupportArray[0];
                }
            } else {
                throw new DDBeanCreateException(SPIDeployerLogger.unknownDD((String)this.altdd, (String)this.dObject.getUri()));
            }
            if (inputStream != null) {
                if (debug) {
                    Debug.say("+++++++++++ PARSING " + moduleType.toString());
                }
                this.dom = DescriptorParser.getDescriptorParser(inputStream, null, descriptorSupport);
                this.doc = this.dom.getDocument();
            }
            Document document = this.doc;
            this.initDD(document, "/", null);
            this.initialized = true;
        }
        catch (IOException iOException) {
            DDBeanCreateException dDBeanCreateException = new DDBeanCreateException(iOException.getMessage());
            dDBeanCreateException.initCause((Throwable)iOException);
            throw dDBeanCreateException;
        }
    }

    public String getFilename() {
        return this.dObject.getFileName(this);
    }

    public String getDDBeanRootVersion() {
        return this.getDocumentVersion();
    }

    public ModuleType getType() {
        return this.moduleType;
    }

    public DeployableObject getDeployableObject() {
        return this.dObject;
    }

    public String getModuleDTDVersion() {
        if (this.isSchemaBased()) {
            return null;
        }
        return this.getDDBeanRootVersion();
    }

    public boolean hasDBean() {
        return this.beanTree != null;
    }

    public DescriptorBean getDescriptorBean() throws IOException {
        return this.beanTree;
    }

    public String getDocumentVersion() {
        if (this.dom == null) {
            return null;
        }
        return this.dom.getDocumentVersion();
    }

    public boolean isSchemaBased() {
        return this.schemaBased;
    }

    public Document getDocument() {
        return this.doc;
    }

    public DescriptorParser getDescriptorParser() {
        return this.dom;
    }

    public String getAltdd() {
        return this.altdd;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    private void dumpNode(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                Debug.say("attr: " + this.getNodeData(node));
                break;
            }
            case 4: {
                Debug.say("cdata: " + this.getNodeData(node));
                break;
            }
            case 5: {
                Debug.say("entity ref: " + this.getNodeData(node));
                break;
            }
            case 6: {
                Debug.say("entity: " + this.getNodeData(node));
                break;
            }
            case 7: {
                Debug.say("pi: " + this.getNodeData(node));
                break;
            }
            case 8: {
                Debug.say("comment: " + this.getNodeData(node));
                break;
            }
            case 9: {
                Debug.say("doc: " + this.getNodeData(node));
                break;
            }
            case 10: {
                Debug.say("doctype: " + this.getNodeData(node));
                break;
            }
            case 11: {
                Debug.say("docfrag: " + this.getNodeData(node));
                break;
            }
            case 12: {
                Debug.say("notation: " + this.getNodeData(node));
                break;
            }
            case 3: {
                Debug.say("text: " + this.getNodeData(node));
                break;
            }
            case 1: {
                Debug.say("element: " + this.getNodeData(node));
            }
        }
    }

    private String getNodeData(Node node) {
        return node.getNodeName() + " value: " + node.getNodeValue();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initialize() {
        block23: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            this.xpath = "/";
            if (this.beanTree != null) {
                block22: {
                    if (this.beanTree instanceof WeblogicExtensionBean) {
                        DescriptorSupportManager.registerWebLogicExtensions((WeblogicExtensionBean)this.beanTree, this.altdd);
                    }
                    if (this.moduleType == null) break block22;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    new EditableDescriptorManager().writeDescriptorAsXML(this.beanTree.getDescriptor(), (OutputStream)byteArrayOutputStream);
                    byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    this.setupDDBeanRoot(byteArrayInputStream);
                }
                Object var5_3 = null;
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    break block23;
                }
                catch (IOException iOException) {}
                break block23;
                {
                    catch (IOException iOException) {
                        if (debug) {
                            Debug.say("Marshalling of Descriptor Bean failed. XML view will not be available for this bean  " + iOException);
                        }
                        Object var5_4 = null;
                        try {
                            if (byteArrayOutputStream != null) {
                                byteArrayOutputStream.close();
                            }
                            if (byteArrayInputStream != null) {
                                byteArrayInputStream.close();
                            }
                            break block23;
                        }
                        catch (IOException iOException2) {}
                        break block23;
                    }
                    catch (DDBeanCreateException dDBeanCreateException) {
                        if (debug) {
                            Debug.say("Creation of child DD Beans failed " + (Object)((Object)dDBeanCreateException));
                        }
                        Object var5_5 = null;
                        try {
                            if (byteArrayOutputStream != null) {
                                byteArrayOutputStream.close();
                            }
                            if (byteArrayInputStream != null) {
                                byteArrayInputStream.close();
                            }
                            break block23;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        if (byteArrayOutputStream != null) {
                            byteArrayOutputStream.close();
                        }
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }
}

