/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model.internal;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.EarMerger;
import weblogic.deploy.api.internal.utils.LibrarySpec;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.EditableJ2eeApplicationObject;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObjectFactory;
import weblogic.deploy.api.model.internal.WebLogicDeployableObjectImpl;
import weblogic.deploy.api.model.internal.WebLogicJ2eeApplicationObjectImpl;
import weblogic.deploy.api.model.sca.EditableScaApplicationObject;
import weblogic.deploy.api.model.sca.internal.WebLogicScaApplicationObject;

public class WebLogicDeployableObjectFactoryImpl
implements WebLogicDeployableObjectFactory {
    private File app;
    private File appRoot;
    private File plan;
    private File plandir;
    private String lightWeightAppName = null;

    public WebLogicDeployableObjectFactoryImpl() {
    }

    public WebLogicDeployableObjectFactoryImpl(File file, File file2, File file3, File file4, LibrarySpec[] librarySpecArray) {
        this.app = file;
        this.appRoot = file2;
        this.plan = file3;
        this.plandir = file4;
    }

    public EditableDeployableObject createDeployableObject(String string, String string2, ModuleType moduleType) throws IOException {
        return new WebLogicDeployableObjectImpl(new File(string), moduleType, null, string, string2, this.appRoot, this.plan, this.plandir);
    }

    public EditableJ2eeApplicationObject createApplicationObject() throws IOException {
        return new WebLogicJ2eeApplicationObjectImpl(this.app, this.appRoot, this.plan, this.plandir);
    }

    public EditableScaApplicationObject createScaApplicationObject() throws IOException {
        return new WebLogicScaApplicationObject(this.app, this.appRoot, this.plan, this.plandir);
    }

    public WebLogicDeployableObject createDeployableObject(File file) throws IOException, InvalidModuleException {
        ConfigHelper.checkParam("File", file);
        return this.createDeployableObject(file, null, null, null, null);
    }

    public WebLogicDeployableObject createDeployableObject(File file, File file2) throws IOException, InvalidModuleException {
        return this.createDeployableObject(file, file2, null, null, null);
    }

    public WebLogicDeployableObject createLazyDeployableObject(File file, File file2, File file3, File file4, LibrarySpec[] librarySpecArray) throws IOException, InvalidModuleException {
        return this.createDeployableObject(file, file2, file3, file4, librarySpecArray, true);
    }

    public WebLogicDeployableObject createDeployableObject(File file, File file2, File file3, File file4, LibrarySpec[] librarySpecArray) throws IOException, InvalidModuleException {
        return this.createDeployableObject(file, file2, file3, file4, librarySpecArray, false);
    }

    private WebLogicDeployableObject createDeployableObject(File file, File file2, File file3, File file4, LibrarySpec[] librarySpecArray, boolean bl) throws IOException, InvalidModuleException {
        this.app = file;
        this.appRoot = file2;
        this.plan = file3;
        this.plandir = file4;
        EarMerger earMerger = new EarMerger();
        WebLogicDeployableObject webLogicDeployableObject = earMerger.getMergedApp(file, file3, file4, librarySpecArray, this, bl, this.lightWeightAppName);
        ((EditableDeployableObject)((Object)webLogicDeployableObject)).setAppMerge(earMerger.getAppMerge());
        return webLogicDeployableObject;
    }

    public void setLightWeightAppName(String string) {
        this.lightWeightAppName = string;
    }
}

