/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.compiler.AppMerge;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFile;

public class WebLogicDeployableObjectImpl
extends WebLogicDeployableObject
implements EditableDeployableObject {
    private static final boolean debug = Debug.isDebug("model");
    private AppMerge appMergeToClose = null;
    private String altdd;

    protected WebLogicDeployableObjectImpl(File file, ModuleType moduleType, WebLogicDeployableObject webLogicDeployableObject, String string, String string2, File file2, File file3, File file4) throws IOException {
        super(file, moduleType, webLogicDeployableObject, string, string2, file2, file3, file4);
        this.altdd = string2;
    }

    public void setVirtualJarFile(VirtualJarFile virtualJarFile) {
        super.setVirtualJarFile(virtualJarFile);
        if (this.moduleType == null) {
            this.setModuleType(WebLogicModuleType.getFileModuleType(this.uri, virtualJarFile));
        }
    }

    public void setClassLoader(GenericClassLoader genericClassLoader) {
        this.gcl = genericClassLoader;
    }

    public void setRootBean(DescriptorBean descriptorBean) {
        this.beanTree = descriptorBean;
        this.setDDBeanRoot(new DDBeanRootImpl(this.altdd, this, this.moduleType, descriptorBean, true));
    }

    public void addRootBean(String string, DescriptorBean descriptorBean, ModuleType moduleType) {
        if (descriptorBean == null) {
            return;
        }
        if (debug) {
            Debug.say("Adding " + moduleType + " rootbean to application at " + string + " on wdo: " + this + "\nwith descriptor bean: " + descriptorBean);
        }
        this.ddMap.put(string, new DDBeanRootImpl(string, this, moduleType, descriptorBean, true));
    }

    public void setModuleArchive(File file) {
        this.moduleArchive = file;
    }

    public void setAppMerge(AppMerge appMerge) {
        this.appMergeToClose = appMerge;
    }

    public InputStream getEntry(String string) {
        block8: {
            if (this.resourceFinder == null) {
                if (debug) {
                    Debug.say("Resource finder is null, using virtual jar file from super");
                }
                return super.getEntry(string);
            }
            ConfigHelper.checkParam("name", string);
            try {
                Source source;
                if (debug) {
                    Debug.say("in DO : " + this.moduleArchive.getName() + " with uri " + this.uri);
                }
                if (debug) {
                    Debug.say("Getting stream for entry " + string);
                }
                if ((source = this.resourceFinder.getSource(string)) != null) {
                    return source.getInputStream();
                }
                if (debug) {
                    Debug.say("No entry in archive for " + string);
                }
            }
            catch (IOException iOException) {
                if (!debug) break block8;
                Debug.say("No entry in archive for " + string);
            }
        }
        return null;
    }

    public void close() {
        super.close();
        if (this.appMergeToClose != null) {
            block3: {
                try {
                    this.appMergeToClose.cleanup();
                }
                catch (ToolFailureException toolFailureException) {
                    if (!debug) break block3;
                    Debug.say("Unable to cleanup AppMerge object");
                    toolFailureException.printStackTrace();
                }
            }
            this.appMergeToClose = null;
        }
    }
}

