/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.compiler.AppMerge;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.EditableJ2eeApplicationObject;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.WebLogicJ2eeApplicationObject;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.descriptor.DescriptorBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.Source;
import weblogic.utils.compiler.ToolFailureException;

public class WebLogicJ2eeApplicationObjectImpl
extends WebLogicJ2eeApplicationObject
implements EditableJ2eeApplicationObject {
    private static final boolean debug = Debug.isDebug("model");
    private AppMerge appMergeToClose = null;

    protected WebLogicJ2eeApplicationObjectImpl(File file, File file2, File file3, File file4) throws IOException {
        super(file, file2, file3, file4);
    }

    public void addDeployableObject(EditableDeployableObject editableDeployableObject) {
        ModuleType moduleType;
        WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)((Object)editableDeployableObject);
        if (webLogicDeployableObject.getType() == null) {
            throw new AssertionError((Object)("Unable to determine module type for : " + webLogicDeployableObject.getArchive() + " with uri : " + webLogicDeployableObject.getUri() + " in app " + this.getArchive()));
        }
        if (debug) {
            Debug.say("Adding new deployable object at " + webLogicDeployableObject.getUri() + " of type '" + webLogicDeployableObject.getType() + "' on wdo: " + this);
        }
        if ((moduleType = webLogicDeployableObject.getType()) == ModuleType.EJB || moduleType == ModuleType.CAR || moduleType == ModuleType.WAR || moduleType == ModuleType.RAR) {
            if (debug) {
                Debug.say("adding module : " + webLogicDeployableObject.getArchive() + " with db: " + webLogicDeployableObject.isDBSet());
            }
            webLogicDeployableObject.setParent(this);
            this.subModules.add(webLogicDeployableObject);
        } else {
            block10: {
                try {
                    if (webLogicDeployableObject.isDBSet()) {
                        if (debug) {
                            Debug.say("Adding new ddbeanroot to application at " + webLogicDeployableObject.getUri() + " on wdo: " + this + "\nwith descriptor bean: " + webLogicDeployableObject.getDescriptorBean());
                        }
                        this.ddMap.put(webLogicDeployableObject.getUri(), new DDBeanRootImpl(webLogicDeployableObject.getUri(), this, webLogicDeployableObject.getType(), webLogicDeployableObject.getDescriptorBean(), true));
                    }
                }
                catch (IOException iOException) {
                    if (!debug) break block10;
                    Debug.say("Problem getting descriptor bean from wdo: " + iOException);
                }
            }
            if (debug) {
                Debug.say("WDO is not the standard module type\t" + webLogicDeployableObject.getArchive() + " type : " + moduleType);
            }
            webLogicDeployableObject.close();
        }
    }

    public void setClassLoader(GenericClassLoader genericClassLoader) {
        this.gcl = genericClassLoader;
    }

    public void setRootBean(DescriptorBean descriptorBean) {
        this.setDescriptorBean(descriptorBean);
        this.setDDBeanRoot(new DDBeanRootImpl(null, this, this.moduleType, descriptorBean, true));
    }

    public void addRootBean(String string, DescriptorBean descriptorBean, ModuleType moduleType) {
        if (descriptorBean == null) {
            return;
        }
        if (debug) {
            Debug.say("Adding " + moduleType + " rootbean to application at " + string + " on wdo: " + this + "\nwith descriptor bean: " + descriptorBean);
        }
        this.ddMap.put(string, new DDBeanRootImpl(string, this, moduleType, descriptorBean, true));
    }

    public void setAppMerge(AppMerge appMerge) {
        this.appMergeToClose = appMerge;
    }

    public InputStream getEntry(String string) {
        block6: {
            ConfigHelper.checkParam("name", string);
            try {
                Source source;
                if (debug) {
                    Debug.say("in DO : " + this.moduleArchive.getName() + " with uri " + this.uri);
                }
                if (debug) {
                    Debug.say("Getting stream for entry " + string);
                }
                if (this.resourceFinder != null && (source = this.resourceFinder.getSource(string)) != null) {
                    return source.getInputStream();
                }
                if (debug) {
                    Debug.say("No entry in archive for " + string);
                }
            }
            catch (IOException iOException) {
                if (!debug) break block6;
                Debug.say("No entry in archive for " + string);
            }
        }
        return null;
    }

    public void close() {
        block4: {
            super.close();
            if (this.resourceFinder != null) {
                this.resourceFinder.close();
            }
            this.resourceFinder = null;
            if (this.appMergeToClose == null) {
                throw new AssertionError((Object)"AppMerge not closed leaving possibly open handles");
            }
            try {
                this.appMergeToClose.cleanup();
            }
            catch (ToolFailureException toolFailureException) {
                if (!debug) break block4;
                Debug.say("Unable to cleanup AppMerge object");
                toolFailureException.printStackTrace();
            }
        }
        this.appMergeToClose = null;
    }
}

