/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.model.sca.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.compiler.AppMerge;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.model.EditableDeployableObject;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.deploy.api.model.sca.EditableScaApplicationObject;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;

public class WebLogicScaApplicationObject
extends WebLogicDeployableObject
implements EditableScaApplicationObject {
    private static final boolean debug = Debug.isDebug("model");
    private AppMerge appMergeToClose = null;
    protected GenericClassLoader gcl = null;

    public WebLogicScaApplicationObject(File file, File file2, File file3, File file4) throws IOException {
        super(file, WebLogicModuleType.SCA_COMPOSITE, null, null, null, file2, file3, file4);
    }

    public String[] getModuleUris() {
        return this.getModuleUris(this.getDeployableObjects());
    }

    public String[] getModuleUris(ModuleType moduleType) {
        ConfigHelper.checkParam("ModuleType", moduleType);
        if (moduleType == WebLogicModuleType.SCA_COMPOSITE) {
            return null;
        }
        return this.getModuleUris(this.getDeployableObjects(moduleType));
    }

    public DeployableObject[] getDeployableObjects() {
        if (this.subModules.size() == 0) {
            return null;
        }
        return this.subModules.toArray(new WebLogicDeployableObject[0]);
    }

    public DeployableObject[] getDeployableObjects(ModuleType moduleType) {
        ConfigHelper.checkParam("ModuleType", moduleType);
        ArrayList<DeployableObject> arrayList = new ArrayList<DeployableObject>();
        if (moduleType == WebLogicModuleType.SCA_COMPOSITE) {
            return new WebLogicDeployableObject[]{this};
        }
        for (DeployableObject deployableObject : this.subModules) {
            if (!deployableObject.getType().equals(moduleType)) continue;
            arrayList.add(deployableObject);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new WebLogicDeployableObject[0]);
    }

    public DeployableObject getDeployableObject(String string) {
        ConfigHelper.checkParam("uri", string);
        DeployableObject[] deployableObjectArray = this.getDeployableObjects();
        WebLogicDeployableObject webLogicDeployableObject = null;
        if (deployableObjectArray != null) {
            for (int i = 0; i < deployableObjectArray.length; ++i) {
                WebLogicDeployableObject webLogicDeployableObject2 = (WebLogicDeployableObject)deployableObjectArray[i];
                if (!string.equals(webLogicDeployableObject2.getUri())) continue;
                webLogicDeployableObject = webLogicDeployableObject2;
                break;
            }
        }
        return webLogicDeployableObject;
    }

    public DeployableObject[] getDeployableObjects(String string) {
        ConfigHelper.checkParam("uri", string);
        ArrayList<WebLogicDeployableObject> arrayList = new ArrayList<WebLogicDeployableObject>();
        DeployableObject[] deployableObjectArray = this.getDeployableObjects();
        if (deployableObjectArray != null) {
            for (int i = 0; i < deployableObjectArray.length; ++i) {
                WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)deployableObjectArray[i];
                if (!string.equals(webLogicDeployableObject.getUri())) continue;
                arrayList.add(webLogicDeployableObject);
            }
        }
        return arrayList.toArray(new WebLogicDeployableObject[0]);
    }

    protected String[] getModuleUris(DeployableObject[] deployableObjectArray) {
        WebLogicDeployableObject webLogicDeployableObject = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (deployableObjectArray != null) {
            for (int i = 0; i < deployableObjectArray.length; ++i) {
                webLogicDeployableObject = (WebLogicDeployableObject)deployableObjectArray[i];
                arrayList.add(webLogicDeployableObject.getUri());
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    public void setClassLoader(GenericClassLoader genericClassLoader) {
        this.gcl = genericClassLoader;
    }

    public void setRootBean(DescriptorBean descriptorBean) {
        this.setDescriptorBean(descriptorBean);
        this.setDDBeanRoot(new DDBeanRootImpl(null, this, this.moduleType, descriptorBean, true));
    }

    public void addRootBean(String string, DescriptorBean descriptorBean, ModuleType moduleType) {
        if (descriptorBean == null) {
            return;
        }
        if (debug) {
            Debug.say("Adding " + moduleType + " rootbean to application at " + string + " on wdo: " + this + "\nwith descriptor bean: " + descriptorBean);
        }
        this.ddMap.put(string, new DDBeanRootImpl(string, this, moduleType, descriptorBean, true));
    }

    public void setAppMerge(AppMerge appMerge) {
        this.appMergeToClose = appMerge;
    }

    public void addDeployableObject(EditableDeployableObject editableDeployableObject) {
        WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)((Object)editableDeployableObject);
        if (debug) {
            Debug.say("Adding new deployable object at " + webLogicDeployableObject.getUri() + " of type '" + webLogicDeployableObject.getType() + "' on wdo: " + this);
        }
        webLogicDeployableObject.setParent(this);
        this.subModules.add(webLogicDeployableObject);
    }

    public void close() {
        block4: {
            super.close();
            if (this.resourceFinder != null) {
                this.resourceFinder.close();
            }
            this.resourceFinder = null;
            if (this.appMergeToClose == null) {
                throw new AssertionError((Object)"AppMerge not closed leaving possibly open handles");
            }
            try {
                this.appMergeToClose.cleanup();
            }
            catch (ToolFailureException toolFailureException) {
                if (!debug) break block4;
                Debug.say("Unable to cleanup AppMerge object");
                toolFailureException.printStackTrace();
            }
        }
        this.appMergeToClose = null;
    }
}

