/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.shared;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.shared.CommandType;

public class WebLogicCommandType
extends CommandType {
    private int value;
    private static int base;
    private static int numCmds;
    private static final int WLS_OFFSET = 323;
    public static final WebLogicCommandType DEPLOY;
    public static final WebLogicCommandType UPDATE;
    public static final WebLogicCommandType DEACTIVATE;
    public static final WebLogicCommandType REMOVE;
    public static final WebLogicCommandType ACTIVATE;
    private static final Set moduleCommandsSet;
    private static final String[] stringTable;
    private static String[] strTable;
    private static final WebLogicCommandType[] enumTable;
    private static CommandType[] enumValueTable;

    protected WebLogicCommandType(int n) {
        super(n);
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public String[] getStringTable() {
        if (strTable == null) {
            int n;
            strTable = new String[numCmds];
            String[] stringArray = super.getStringTable();
            for (n = 0; n < base; ++n) {
                WebLogicCommandType.strTable[n] = stringArray[n];
            }
            for (n = 323; n < numCmds; ++n) {
                WebLogicCommandType.strTable[n] = stringTable[n - 323];
            }
        }
        return strTable;
    }

    public CommandType[] getEnumValueTable() {
        if (enumValueTable == null) {
            int n;
            enumValueTable = new CommandType[numCmds];
            CommandType[] commandTypeArray = super.getEnumValueTable();
            for (n = 0; n < base; ++n) {
                WebLogicCommandType.enumValueTable[n] = commandTypeArray[n];
            }
            for (n = 323; n < numCmds; ++n) {
                WebLogicCommandType.enumValueTable[n] = enumTable[n - 323];
            }
        }
        return enumValueTable;
    }

    public static CommandType getCommandType(int n) {
        if (n < base) {
            return CommandType.getCommandType((int)n);
        }
        return enumTable[n - 323];
    }

    public static boolean supportsModuleTargeting(CommandType commandType) {
        return moduleCommandsSet.contains(commandType);
    }

    public String toString() {
        return this.getStringTable()[this.value];
    }

    protected int getOffset() {
        return 323;
    }

    private static int findNextSlot() {
        int n = 0;
        while (true) {
            try {
                CommandType commandType = CommandType.getCommandType((int)n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return n;
            }
            ++n;
        }
    }

    static {
        stringTable = new String[]{"deploy", "update", "deactivate", "remove", "activate"};
        strTable = null;
        enumValueTable = null;
        base = WebLogicCommandType.findNextSlot();
        int n = 323;
        DEPLOY = new WebLogicCommandType(n++);
        UPDATE = new WebLogicCommandType(n++);
        DEACTIVATE = new WebLogicCommandType(n++);
        REMOVE = new WebLogicCommandType(n++);
        ACTIVATE = new WebLogicCommandType(n++);
        numCmds = n;
        enumTable = new WebLogicCommandType[]{DEPLOY, UPDATE};
        moduleCommandsSet = new HashSet();
        moduleCommandsSet.add(START);
        moduleCommandsSet.add(STOP);
        moduleCommandsSet.add(UNDEPLOY);
        moduleCommandsSet.add(REDEPLOY);
        moduleCommandsSet.add(DEPLOY);
        moduleCommandsSet.add(UPDATE);
        moduleCommandsSet.add(DEACTIVATE);
        moduleCommandsSet.add(REMOVE);
        moduleCommandsSet.add(ACTIVATE);
    }
}

