/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.shared;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.application.ApplicationFileManager;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.deploy.api.spi.config.DescriptorSupportManager;
import weblogic.ejb.spi.EJBJarUtils;
import weblogic.utils.application.WarDetector;
import weblogic.utils.jars.VirtualJarFile;

public class WebLogicModuleType
extends ModuleType {
    private int value;
    private static int base;
    private static int numMods;
    private static final int WLS_OFFSET = 323;
    public static final WebLogicModuleType UNKNOWN;
    public static final WebLogicModuleType JMS;
    public static final WebLogicModuleType JDBC;
    public static final WebLogicModuleType INTERCEPT;
    public static final WebLogicModuleType CONFIG;
    public static final WebLogicModuleType SUBMODULE;
    public static final WebLogicModuleType WLDF;
    public static final WebLogicModuleType WSEE;
    public static final WebLogicModuleType SCA_COMPOSITE;
    public static final WebLogicModuleType SCA_JAVA;
    public static final WebLogicModuleType SCA_SPRING;
    public static final WebLogicModuleType SCA_BPEL;
    public static final WebLogicModuleType SCA_EXTENSION;
    public static final WebLogicModuleType COHERENCE_CLUSTER;
    private static final String[] WLStringTable;
    private static String[] stringTable;
    private static final WebLogicModuleType[] WLEnumValueTable;
    private static ModuleType[] enumValueTable;
    private static final String[] WLModuleExtension;
    protected static String[] standardUris;
    protected static String[] wlsUris;
    public static final String MODULETYPE_EAR;
    public static final String MODULETYPE_WAR;
    public static final String MODULETYPE_EJB;
    public static final String MODULETYPE_RAR;
    public static final String MODULETYPE_CAR;
    public static final String MODULETYPE_UNKNOWN;
    public static final String MODULETYPE_JMS;
    public static final String MODULETYPE_JDBC;
    public static final String MODULETYPE_INTERCEPT;
    public static final String MODULETYPE_CONFIG;
    public static final String MODULETYPE_SUBMODULE;
    public static final String MODULETYPE_WLDF;
    public static final String MODULETYPE_WSEE;
    public static final String MODULETYPE_COMPOSITE;
    public static final String MODULETYPE_JAVA;
    public static final String MODULETYPE_SPRING;
    public static final String MODULETYPE_BPEL;
    public static final String MODULETYPE_SCA_EXTENSION;
    public static final String MODULETYPE_COHERENCE_CLUSTER;

    public static ModuleType getTypeFromString(String string) {
        if (string == null) {
            return UNKNOWN;
        }
        Object object = string.equalsIgnoreCase(MODULETYPE_EAR) ? ModuleType.EAR : (string.equalsIgnoreCase(MODULETYPE_EJB) ? ModuleType.EJB : (string.equalsIgnoreCase(MODULETYPE_WAR) ? ModuleType.WAR : (string.equalsIgnoreCase(MODULETYPE_RAR) ? ModuleType.RAR : (string.equalsIgnoreCase(MODULETYPE_CAR) ? ModuleType.CAR : (string.equalsIgnoreCase(MODULETYPE_JMS) ? JMS : (string.equalsIgnoreCase(MODULETYPE_JDBC) ? JDBC : (string.equalsIgnoreCase(MODULETYPE_INTERCEPT) ? INTERCEPT : (string.equalsIgnoreCase(MODULETYPE_CONFIG) ? CONFIG : (string.equalsIgnoreCase(MODULETYPE_SUBMODULE) ? SUBMODULE : (string.equalsIgnoreCase(MODULETYPE_WLDF) ? WLDF : (string.equalsIgnoreCase(MODULETYPE_WSEE) ? WSEE : (string.equalsIgnoreCase(MODULETYPE_COMPOSITE) ? SCA_COMPOSITE : (string.equalsIgnoreCase(MODULETYPE_JAVA) ? SCA_JAVA : (string.equalsIgnoreCase(MODULETYPE_SPRING) ? SCA_SPRING : (string.equalsIgnoreCase(MODULETYPE_BPEL) ? SCA_BPEL : (string.equalsIgnoreCase(MODULETYPE_SCA_EXTENSION) ? SCA_EXTENSION : (string.equalsIgnoreCase(MODULETYPE_COHERENCE_CLUSTER) ? COHERENCE_CLUSTER : UNKNOWN)))))))))))))))));
        return object;
    }

    protected WebLogicModuleType(int n) {
        super(n);
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public String[] getStringTable() {
        if (stringTable == null) {
            int n;
            stringTable = new String[numMods];
            String[] stringArray = super.getStringTable();
            for (n = 0; n < base; ++n) {
                WebLogicModuleType.stringTable[n] = stringArray[n];
            }
            for (n = 323; n < numMods; ++n) {
                WebLogicModuleType.stringTable[n] = WLStringTable[n - 323];
            }
        }
        return stringTable;
    }

    public ModuleType[] getEnumValueTable() {
        if (enumValueTable == null) {
            int n;
            enumValueTable = new ModuleType[numMods];
            ModuleType[] moduleTypeArray = super.getEnumValueTable();
            for (n = 0; n < base; ++n) {
                WebLogicModuleType.enumValueTable[n] = moduleTypeArray[n];
            }
            for (n = 323; n < numMods; ++n) {
                WebLogicModuleType.enumValueTable[n] = WLEnumValueTable[n - 323];
            }
        }
        return enumValueTable;
    }

    public String getModuleExtension() {
        return WLModuleExtension[this.getValue() - this.getOffset()];
    }

    public static ModuleType getModuleType(int n) {
        if (n < base) {
            return ModuleType.getModuleType((int)n);
        }
        if (n >= 323) {
            return WLEnumValueTable[n - 323];
        }
        return null;
    }

    protected int getOffset() {
        return 323;
    }

    private static int findNextSlot() {
        int n = 0;
        while (true) {
            try {
                ModuleType moduleType = ModuleType.getModuleType((int)n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return n;
            }
            ++n;
        }
    }

    public static String getDDUri(int n) {
        ModuleType moduleType = WebLogicModuleType.getModuleType(n);
        DescriptorSupport[] descriptorSupportArray = DescriptorSupportManager.getForModuleType(moduleType);
        if (moduleType != null && descriptorSupportArray.length > 0) {
            return descriptorSupportArray[0].getBaseURI();
        }
        return null;
    }

    public static String[] getWLSDDUri(int n) {
        ModuleType moduleType = WebLogicModuleType.getModuleType(n);
        if (moduleType == null) {
            return new String[0];
        }
        DescriptorSupport[] descriptorSupportArray = DescriptorSupportManager.getForModuleType(moduleType);
        String[] stringArray = new String[descriptorSupportArray.length];
        for (int i = 0; i < descriptorSupportArray.length; ++i) {
            stringArray[i] = descriptorSupportArray[i].getConfigURI();
        }
        return stringArray;
    }

    public boolean equals(ModuleType moduleType) {
        return this.getValue() == moduleType.getValue();
    }

    public static int getModuleTypes() {
        return numMods;
    }

    public String toString() {
        return this.getStringTable()[this.getValue()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ModuleType getFileModuleType(File file) {
        ModuleType moduleType;
        VirtualJarFile virtualJarFile;
        block14: {
            ApplicationFileManager applicationFileManager;
            block12: {
                ModuleType moduleType2;
                block13: {
                    if (file == null) {
                        return null;
                    }
                    if (file.getName().endsWith(".xml")) {
                        return WebLogicModuleType.getWebLogicModuleType(file.getPath());
                    }
                    virtualJarFile = null;
                    applicationFileManager = ApplicationFileManager.newInstance(file);
                    if (!applicationFileManager.isSplitDirectory()) break block12;
                    moduleType2 = ModuleType.EAR;
                    Object var5_7 = null;
                    if (virtualJarFile == null) break block13;
                    try {
                        virtualJarFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return moduleType2;
            }
            virtualJarFile = applicationFileManager.getVirtualJarFile();
            moduleType = WebLogicModuleType.getStandardModuleType(file.toString(), virtualJarFile);
            Object var5_8 = null;
            if (virtualJarFile == null) break block14;
            try {
                virtualJarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return moduleType;
        catch (IOException iOException) {
            ModuleType moduleType3;
            block15: {
                try {
                    SPIDeployerLogger.logAppReadError((String)file.toString(), (String)iOException.toString(), (Exception)iOException);
                    moduleType3 = null;
                    Object var5_9 = null;
                    if (virtualJarFile == null) break block15;
                }
                catch (Throwable throwable) {
                    block16: {
                        Object var5_10 = null;
                        if (virtualJarFile == null) break block16;
                        try {
                            virtualJarFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    virtualJarFile.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
            }
            return moduleType3;
        }
    }

    private static ModuleType getWebLogicModuleType(String string) {
        if (string.endsWith("-jms.xml")) {
            return JMS;
        }
        if (string.endsWith("-jdbc.xml")) {
            return JDBC;
        }
        if (string.endsWith("-interception.xml")) {
            return INTERCEPT;
        }
        if (string.endsWith("-coherence.xml")) {
            return COHERENCE_CLUSTER;
        }
        String string2 = string.replace('\\', '/');
        DescriptorSupport[] descriptorSupportArray = DescriptorSupportManager.getForBaseURI(string2);
        if (descriptorSupportArray.length > 0) {
            return descriptorSupportArray[0].getModuleType();
        }
        if (string.endsWith("weblogic-diagnostics.xml")) {
            return WLDF;
        }
        if (string.endsWith("webservices.xml")) {
            return WSEE;
        }
        if (string.endsWith("web-services.xml")) {
            return WSEE;
        }
        return CONFIG;
    }

    private static ModuleType getStandardModuleType(String string, VirtualJarFile virtualJarFile) {
        if (virtualJarFile.getEntry("META-INF/application.xml") != null || virtualJarFile.getName().endsWith(".ear")) {
            return ModuleType.EAR;
        }
        if (virtualJarFile.getEntry("META-INF/ejb-jar.xml") != null) {
            return ModuleType.EJB;
        }
        if (virtualJarFile.getEntry("WEB-INF/web.xml") != null) {
            return ModuleType.WAR;
        }
        if (virtualJarFile.getEntry("META-INF/ra.xml") != null) {
            return ModuleType.RAR;
        }
        if (virtualJarFile.getEntry("META-INF/weblogic-ra.xml") != null) {
            return ModuleType.RAR;
        }
        if (virtualJarFile.getEntry("META-INF/application-client.xml") != null) {
            return ModuleType.CAR;
        }
        if (virtualJarFile.getEntry("META-INF/weblogic-application-client.xml") != null) {
            return ModuleType.CAR;
        }
        if (WarDetector.instance.suffixed(string)) {
            return ModuleType.WAR;
        }
        try {
            if (EJBJarUtils.isEJB(virtualJarFile)) {
                return ModuleType.EJB;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (virtualJarFile.getEntry("META-INF/sca-contribution.xml") != null) {
            return SCA_COMPOSITE;
        }
        return null;
    }

    public static ModuleType getFileModuleType(String string, VirtualJarFile virtualJarFile) {
        if (string == null && virtualJarFile == null) {
            return null;
        }
        if (string != null && string.endsWith(".xml")) {
            return WebLogicModuleType.getWebLogicModuleType(string);
        }
        if (virtualJarFile != null) {
            return WebLogicModuleType.getStandardModuleType(string, virtualJarFile);
        }
        return null;
    }

    public static String getFileModuleTypeAsString(File file) {
        ConfigHelper.checkParam("File", file);
        ModuleType moduleType = WebLogicModuleType.getFileModuleType(file);
        return moduleType == null ? null : moduleType.toString();
    }

    static {
        WLStringTable = new String[]{"unknown", "jms", "jdbc", "intercept", "config", "submodule", "wldf", "webservice", "sca composite", "sca java", "sca spring", "sca bpel", "sca extension", "coherence cluster"};
        stringTable = null;
        enumValueTable = null;
        WLModuleExtension = new String[]{"", ".xml", ".xml", ".xml", ".xml", "", ".xml", ".xml", "", "", "", "", ""};
        base = WebLogicModuleType.findNextSlot();
        int n = 323;
        UNKNOWN = new WebLogicModuleType(n++);
        JMS = new WebLogicModuleType(n++);
        JDBC = new WebLogicModuleType(n++);
        INTERCEPT = new WebLogicModuleType(n++);
        CONFIG = new WebLogicModuleType(n++);
        SUBMODULE = new WebLogicModuleType(n++);
        WLDF = new WebLogicModuleType(n++);
        WSEE = new WebLogicModuleType(n++);
        SCA_COMPOSITE = new WebLogicModuleType(n++);
        SCA_JAVA = new WebLogicModuleType(n++);
        SCA_SPRING = new WebLogicModuleType(n++);
        SCA_BPEL = new WebLogicModuleType(n++);
        SCA_EXTENSION = new WebLogicModuleType(n++);
        COHERENCE_CLUSTER = new WebLogicModuleType(n++);
        WLEnumValueTable = new WebLogicModuleType[]{UNKNOWN, JMS, JDBC, INTERCEPT, CONFIG, SUBMODULE, WLDF, WSEE, SCA_COMPOSITE, SCA_JAVA, SCA_SPRING, SCA_BPEL, SCA_EXTENSION, COHERENCE_CLUSTER};
        numMods = n;
        MODULETYPE_EAR = ModuleType.EAR.toString();
        MODULETYPE_WAR = ModuleType.WAR.toString();
        MODULETYPE_EJB = ModuleType.EJB.toString();
        MODULETYPE_RAR = ModuleType.RAR.toString();
        MODULETYPE_CAR = ModuleType.CAR.toString();
        MODULETYPE_UNKNOWN = UNKNOWN.toString();
        MODULETYPE_JMS = JMS.toString();
        MODULETYPE_JDBC = JDBC.toString();
        MODULETYPE_INTERCEPT = INTERCEPT.toString();
        MODULETYPE_CONFIG = CONFIG.toString();
        MODULETYPE_SUBMODULE = SUBMODULE.toString();
        MODULETYPE_WLDF = WLDF.toString();
        MODULETYPE_WSEE = WSEE.toString();
        MODULETYPE_COMPOSITE = SCA_COMPOSITE.toString();
        MODULETYPE_JAVA = SCA_JAVA.toString();
        MODULETYPE_SPRING = SCA_SPRING.toString();
        MODULETYPE_BPEL = SCA_BPEL.toString();
        MODULETYPE_SCA_EXTENSION = SCA_EXTENSION.toString();
        MODULETYPE_COHERENCE_CLUSTER = COHERENCE_CLUSTER.toString();
    }
}

