/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.shared;

public class WebLogicTargetType {
    private int value;
    private static final WebLogicTargetType[] enumValueTable;
    private static String[] stringTable;
    public static final WebLogicTargetType SERVER;
    public static final WebLogicTargetType CLUSTER;
    public static final WebLogicTargetType VIRTUALHOST;
    public static final WebLogicTargetType JMSSERVER;
    public static final WebLogicTargetType SAFAGENT;

    protected WebLogicTargetType(int n) {
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    protected String[] getStringTable() {
        return stringTable;
    }

    protected WebLogicTargetType[] getEnumValueTable() {
        return enumValueTable;
    }

    public static WebLogicTargetType getWebLogicTargetType(int n) {
        return enumValueTable[n];
    }

    public String toString() {
        String[] stringArray = this.getStringTable();
        int n = this.value - this.getOffset();
        if (stringArray != null && n >= 0 && n < stringArray.length) {
            return stringArray[n];
        }
        return Integer.toString(this.value);
    }

    protected int getOffset() {
        return 0;
    }

    static {
        SERVER = new WebLogicTargetType(0);
        CLUSTER = new WebLogicTargetType(1);
        VIRTUALHOST = new WebLogicTargetType(2);
        JMSSERVER = new WebLogicTargetType(3);
        SAFAGENT = new WebLogicTargetType(4);
        enumValueTable = new WebLogicTargetType[]{SERVER, CLUSTER, VIRTUALHOST, JMSSERVER, SAFAGENT};
        stringTable = new String[]{"server", "cluster", "virtual host", "JMS server", "SAF agent"};
    }
}

