/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi;

import java.io.Serializable;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.management.security.DeploymentModel;

public final class DeploymentOptions
implements Serializable {
    private static final long serialVersionUID = -8124655104926643928L;
    private boolean useNonexclusiveLock = true;
    private boolean operationInitiatedByAutoDeployPoller = false;
    private boolean testOption = false;
    private int retireTimeOption = -1;
    private boolean retireGracefulPolicy = true;
    private boolean gracefulProductionToAdmin = false;
    private boolean gracefulIgnoreSessions = false;
    private int gracefulRMIGracePeriodSecs = -1;
    private boolean undeployAllVersions = false;
    private String stageOption = STAGE_DEFAULT;
    private String name = null;
    private boolean nameFromLibrary = false;
    private long forceUndeployTimeoutSecs = 0L;
    private boolean disableModuleLevelStartStop = false;
    private long timeout = 0L;
    private int deploymentOrder = 100;
    private String deploymentPrincipalName = null;
    private boolean nameFromSource = false;
    private boolean defaultSubmoduleTargets = true;
    private String altDD = null;
    private String altWlsDD = null;
    private boolean noVersion = false;
    private boolean remote = false;
    private boolean useExpiredLock = false;
    public static final String STAGE_DEFAULT = null;
    public static final String STAGE = "stage";
    public static final String NOSTAGE = "nostage";
    public static final String EXTERNAL_STAGE = "external_stage";
    public static final boolean FULL_ACCESS = false;
    public static final boolean ADMIN_ACCESS = true;
    private String securityModel = null;
    private boolean isSecurityValidationEnabled = false;
    private String archiveVersion = null;
    private String planVersion = null;
    private boolean isLibrary = false;
    private String libSpecVersion = null;
    private String libImplVersion = null;
    public static final int CLUSTER_DEPLOYMENT_TIMEOUT = 3600000;
    private int clusterTimeout = 3600000;

    public boolean usesNonExclusiveLock() {
        return this.useNonexclusiveLock;
    }

    public boolean isOperationInitiatedByAutoDeployPoller() {
        return this.operationInitiatedByAutoDeployPoller;
    }

    public void setOperationInitiatedByAutoDeployPoller(boolean bl) {
        this.operationInitiatedByAutoDeployPoller = bl;
    }

    public void setUseNonexclusiveLock(boolean bl) {
        this.useNonexclusiveLock = bl;
    }

    public String getAltDD() {
        return this.altDD;
    }

    public void setAltDD(String string) {
        this.altDD = string;
    }

    public String getAltWlsDD() {
        return this.altWlsDD;
    }

    public void setAltWlsDD(String string) {
        this.altWlsDD = string;
    }

    public String getSecurityModel() {
        return this.securityModel;
    }

    public void setSecurityModel(String string) throws IllegalArgumentException {
        if (!DeploymentModel.isValidModel(string)) {
            throw new IllegalArgumentException(SPIDeployerLogger.invalidSecurityModel((String)string, (String)"DDOnly|CustomRoles|CustomRolesAndPolicies|Advanced"));
        }
        this.securityModel = string;
    }

    public boolean isSecurityValidationEnabled() {
        return this.isSecurityValidationEnabled;
    }

    public void setSecurityValidationEnabled(boolean bl) {
        this.isSecurityValidationEnabled = bl;
    }

    public String getArchiveVersion() {
        return this.archiveVersion;
    }

    public void setArchiveVersion(String string) {
        this.archiveVersion = string;
    }

    public String getPlanVersion() {
        return this.planVersion;
    }

    public void setPlanVersion(String string) {
        this.planVersion = string;
    }

    public String getVersionIdentifier() {
        return ApplicationVersionUtils.getVersionId(this.archiveVersion, this.planVersion);
    }

    public void setVersionIdentifier(String string) {
        this.archiveVersion = ApplicationVersionUtils.getArchiveVersion(string);
        this.planVersion = ApplicationVersionUtils.getPlanVersion(string);
    }

    public boolean isLibrary() {
        return this.isLibrary;
    }

    public void setLibrary(boolean bl) {
        this.isLibrary = bl;
    }

    public String getLibSpecVersion() {
        return this.libSpecVersion;
    }

    public void setLibSpecVersion(String string) {
        this.libSpecVersion = string;
    }

    public String getLibImplVersion() {
        return this.libImplVersion;
    }

    public void setLibImplVersion(String string) {
        this.libImplVersion = string;
    }

    public boolean isNameFromLibrary() {
        return this.nameFromLibrary;
    }

    public void setNameFromLibrary(boolean bl) {
        this.nameFromLibrary = bl;
    }

    public boolean isNameFromSource() {
        return this.nameFromSource;
    }

    public void setNameFromSource(boolean bl) {
        this.nameFromSource = bl;
    }

    public boolean isTestMode() {
        return this.isAdminMode();
    }

    public void setTestMode(boolean bl) {
        this.setAdminMode(bl);
    }

    public boolean isAdminMode() {
        return this.testOption;
    }

    public void setAdminMode(boolean bl) {
        this.testOption = bl;
    }

    public int getRetireTime() {
        return this.retireTimeOption;
    }

    public void setRetireTime(int n) {
        this.retireTimeOption = n;
        if (this.retireTimeOption != -1) {
            this.setRetireGracefully(false);
        }
    }

    public boolean isRetireGracefully() {
        return this.retireGracefulPolicy;
    }

    public void setRetireGracefully(boolean bl) {
        this.retireGracefulPolicy = bl;
    }

    public boolean isGracefulProductionToAdmin() {
        return this.gracefulProductionToAdmin;
    }

    public void setGracefulProductionToAdmin(boolean bl) {
        this.gracefulProductionToAdmin = bl;
    }

    public boolean isGracefulIgnoreSessions() {
        return this.gracefulIgnoreSessions;
    }

    public void setGracefulIgnoreSessions(boolean bl) {
        this.gracefulIgnoreSessions = bl;
    }

    public int getRMIGracePeriodSecs() {
        return this.gracefulRMIGracePeriodSecs;
    }

    public void setRMIGracePeriodSecs(int n) {
        this.gracefulRMIGracePeriodSecs = n;
    }

    public boolean isUndeployAllVersions() {
        return this.undeployAllVersions;
    }

    public void setUndeployAllVersions(boolean bl) {
        this.undeployAllVersions = bl;
    }

    public String getStageMode() {
        return this.stageOption;
    }

    public void setStageMode(String string) {
        this.stageOption = string;
    }

    public int getClusterDeploymentTimeout() {
        return this.clusterTimeout;
    }

    public void setClusterDeploymentTimeout(int n) {
        this.clusterTimeout = n;
    }

    public long getForceUndeployTimeout() {
        return this.forceUndeployTimeoutSecs;
    }

    public void setForceUndeployTimeout(long l) {
        this.forceUndeployTimeoutSecs = l;
    }

    public boolean usesExpiredLock() {
        return this.useExpiredLock;
    }

    public void setUseExpiredLock(boolean bl) {
        this.useExpiredLock = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{").append("isRetireGracefully=").append(this.isRetireGracefully()).append(",").append("isGracefulProductionToAdmin=").append(this.isGracefulProductionToAdmin()).append(",").append("isGracefulIgnoreSessions=").append(this.isGracefulIgnoreSessions()).append(",").append("rmiGracePeriod=").append(this.getRMIGracePeriodSecs()).append(",").append("retireTimeoutSecs=").append(this.getRetireTime()).append(",").append("undeployAllVersions=").append(this.isUndeployAllVersions()).append(",").append("archiveVersion=").append(this.getArchiveVersion()).append(",").append("planVersion=").append(this.getPlanVersion()).append(",").append("isLibrary=").append(this.isLibrary()).append(",").append("libSpecVersion=").append(this.getLibSpecVersion()).append(",").append("libImplVersion=").append(this.getLibImplVersion()).append(",").append("stageMode=").append(this.getStageMode()).append(",").append("clusterTimeout=").append(this.getClusterDeploymentTimeout()).append(",").append("altDD=").append(this.getAltDD()).append(",").append("altWlsDD=").append(this.getAltWlsDD()).append(",").append("name=").append(this.getName()).append(",").append("securityModel=").append(this.getSecurityModel()).append(",").append("securityValidationEnabled=").append(this.isSecurityValidationEnabled()).append(",").append("versionIdentifier=").append(this.getVersionIdentifier()).append(",").append("isTestMode=").append(this.isTestMode()).append(",").append("forceUndeployTimeout=").append(this.getForceUndeployTimeout()).append(",").append("defaultSubmoduleTargets=").append(this.isDefaultSubmoduleTargets()).append(",").append("timeout=").append(this.getTimeout()).append(",").append("deploymentPrincipalName=").append(this.getDeploymentPrincipalName()).append(",").append("useExpiredLock=").append(this.usesExpiredLock()).append("}");
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isDefaultSubmoduleTargets() {
        return this.defaultSubmoduleTargets;
    }

    public void setDefaultSubmoduleTargets(boolean bl) {
        this.defaultSubmoduleTargets = bl;
    }

    public boolean isNoVersion() {
        return this.noVersion;
    }

    public void setNoVersion(boolean bl) {
        this.noVersion = bl;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public int getDeploymentOrder() {
        return this.deploymentOrder;
    }

    public void setDeploymentOrder(int n) {
        this.deploymentOrder = n;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean bl) {
        this.remote = bl;
    }

    public boolean isDisableModuleLevelStartStop() {
        return this.disableModuleLevelStartStop;
    }

    public void setDisableModuleLevelStartStop(boolean bl) {
        this.disableModuleLevelStartStop = bl;
    }

    public void setDeploymentPrincipalName(String string) {
        this.deploymentPrincipalName = string;
    }

    public String getDeploymentPrincipalName() {
        return this.deploymentPrincipalName;
    }
}

