/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.WebLogicDConfigBean;
import weblogic.deploy.api.spi.config.BasicDConfigBeanRoot;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;

public abstract class BasicDConfigBean
implements WebLogicDConfigBean {
    private static final boolean debug = Debug.isDebug("config");
    protected boolean modified = false;
    protected BasicDConfigBean parent = null;
    protected List pclList = new ArrayList();
    private DDBean ddbean = null;
    protected String[] xpaths;
    private List childList = new ArrayList();
    private String name = "unknown";
    protected DescriptorBean beanTree;
    private String keyName = null;
    private String parentPropertyName;
    private boolean doNotWriteYet;
    private static final String FROM_DCB = "FROM_DCB";

    public BasicDConfigBean(DDBean dDBean) {
        ConfigHelper.checkParam("DDBean", dDBean);
        if (debug) {
            Debug.say("Creating DConfigBean (" + this.getClass().getName() + ") for " + dDBean.getXpath());
        }
        this.setDDBean(dDBean);
        this.setName(this.ddbean.getXpath());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ConfigHelper.checkParam("PropertyChangeListener", propertyChangeListener);
        this.pclList.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n = this.pclList.indexOf(propertyChangeListener);
        if (n >= 0) {
            this.pclList.remove(n);
        }
    }

    public String[] getXpaths() {
        return this.xpaths;
    }

    public void removeDConfigBean(DConfigBean dConfigBean) throws BeanNotFoundException {
        int n = this.childList.indexOf(dConfigBean);
        if (n < 0) {
            String string = SPIDeployerLogger.notAChild((String)((BasicDConfigBean)dConfigBean).getName(), (String)this.getName());
            throw new BeanNotFoundException(string);
        }
        ((BasicDConfigBean)dConfigBean).removeAllChildren();
        this.childList.remove(n);
    }

    public DDBean getDDBean() {
        return this.ddbean;
    }

    public DConfigBean getDConfigBean(DDBean dDBean) throws ConfigurationException {
        DConfigBean dConfigBean2;
        ConfigHelper.checkParam("DDBean", dDBean);
        if (debug) {
            Debug.say(this.getName() + " getting DCB for bean: " + dDBean.getXpath());
        }
        if (this.isEquals(this, dDBean)) {
            if (debug) {
                Debug.say("Found DCB for bean: " + this.getName());
            }
            return this;
        }
        for (DConfigBean dConfigBean2 : this.getChildBeans()) {
            if (!this.isEquals((BasicDConfigBean)dConfigBean2, dDBean)) continue;
            if (debug) {
                Debug.say("Found DCB for bean: " + this.getName());
            }
            return dConfigBean2;
        }
        if (debug) {
            Debug.say("No DCB for bean: " + dDBean.getXpath());
        }
        dConfigBean2 = this.createDConfigBean(dDBean, this);
        return dConfigBean2;
    }

    private boolean isEquals(BasicDConfigBean basicDConfigBean, DDBean dDBean) {
        return basicDConfigBean.getDDBean().equals(dDBean);
    }

    protected String getKeyName() {
        return this.keyName;
    }

    protected void setKeyName(String string) {
        this.keyName = string;
    }

    public void notifyDDChange(XpathEvent xpathEvent) {
    }

    public abstract void validate() throws ConfigurationException;

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ConfigurationException configurationException) {
            return false;
        }
        return true;
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Iterator iterator = this.getListeners().iterator();
        while (iterator.hasNext()) {
            ((PropertyChangeListener)iterator.next()).propertyChange(propertyChangeEvent);
        }
    }

    protected abstract DConfigBean createDConfigBean(DDBean var1, DConfigBean var2) throws ConfigurationException;

    protected String getName() {
        return this.name;
    }

    protected void addDConfigBean(DConfigBean dConfigBean) {
        this.childList.add(dConfigBean);
    }

    public List getChildBeans() {
        return this.childList;
    }

    private List getListeners() {
        return this.pclList;
    }

    public void removeAllChildren() {
        this.childList = new ArrayList();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        if (!this.modified) {
            if (debug) {
                Debug.say("modified dcb: " + this.getClass().getName());
            }
            this.modified = true;
            if (bl && this.parent != null) {
                this.parent.setModified(true);
            }
        }
        if (this.doNotWriteYet) {
            if (debug) {
                Debug.say("set doNotWriteYet to false for dcb " + this);
            }
            this.doNotWriteYet = false;
            ((AbstractDescriptorBean)this.beanTree).setMetaData((Object)FROM_DCB, (Object)new Boolean(false));
        }
    }

    public void setUnmodified() {
        this.modified = false;
    }

    protected void addToList(List list, String string, Object object) {
        int n = list.indexOf(object);
        if (n == -1) {
            list.add(object);
            this.firePropertyChange(new PropertyChangeEvent(this, string, null, null));
            this.setModified(true);
        }
    }

    protected void removeFromList(List list, String string, Object object) {
        int n = list.indexOf(object);
        if (n != -1) {
            list.remove(object);
            this.firePropertyChange(new PropertyChangeEvent(this, string, null, null));
            this.setModified(true);
        }
    }

    protected void replaceList(List list, String string, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        list.clear();
        list.addAll(arrayList);
        this.firePropertyChange(new PropertyChangeEvent(this, string, null, null));
        this.setModified(true);
    }

    public String toString() {
        if (debug) {
            return this.dumpAll(0);
        }
        return this.dump(0);
    }

    public DescriptorBean getDescriptorBean() {
        return this.beanTree;
    }

    protected boolean isMatch(DescriptorBean descriptorBean, DDBean dDBean, String string) {
        String string2 = this.getKeyValue(descriptorBean);
        return string2 != null && string2.equals(string);
    }

    protected String getDDKey(DDBean dDBean, String string) {
        if (string.equals("id")) {
            return dDBean.getId();
        }
        DDBean[] dDBeanArray = dDBean.getChildBean(this.applyNamespace(string));
        if (dDBeanArray != null) {
            return ConfigHelper.getText(dDBeanArray[0]);
        }
        return null;
    }

    protected String lastElementOf(String string) {
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected String getParentXpath(String string) {
        if (debug) {
            Debug.say("get parent of " + string);
        }
        return string.substring(0, string.lastIndexOf("/"));
    }

    public String applyNamespace(String string) {
        BasicDConfigBean basicDConfigBean = this;
        while (!basicDConfigBean.getDDBean().getXpath().equals("/")) {
            basicDConfigBean = basicDConfigBean.getParent();
        }
        String string2 = ((BasicDConfigBeanRoot)basicDConfigBean).getNamespace();
        if (debug) {
            Debug.say("using " + string2 + " as namespace");
        }
        return ConfigHelper.applyNamespace(string2, string);
    }

    public BasicDConfigBean getParent() {
        if (debug) {
            Debug.say("Getting parent...");
        }
        return this.parent;
    }

    public String getParentPropertyName() {
        return this.parentPropertyName;
    }

    public void setParentPropertyName(String string) {
        this.parentPropertyName = string;
    }

    private String getKeyValue(DescriptorBean descriptorBean) {
        if (descriptorBean == null) {
            return null;
        }
        String string = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(descriptorBean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (!Boolean.TRUE.equals(propertyDescriptor.getValue("key"))) continue;
                Method method = propertyDescriptor.getReadMethod();
                string = (String)method.invoke((Object)descriptorBean, new Object[0]);
                break;
            }
        }
        catch (Exception exception) {
            SPIDeployerLogger.logBeanError((String)descriptorBean.getClass().getName(), (Exception)exception);
        }
        return string;
    }

    private String dumpAll(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dump(n));
        Iterator iterator = this.getChildBeans().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((BasicDConfigBean)iterator.next()).dumpAll(n + 1));
        }
        return stringBuffer.toString();
    }

    private String dump(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indenter(n));
        stringBuffer.append("Name: ");
        stringBuffer.append(this.getName());
        stringBuffer.append("\n");
        stringBuffer.append(this.indenter(n));
        stringBuffer.append(this.getDCBProperties());
        return stringBuffer.toString();
    }

    protected abstract String getDCBProperties();

    private String indenter(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private void setDDBean(DDBean dDBean) {
        this.ddbean = dDBean;
    }

    private void setName(String string) {
        this.name = "DConfigBean." + string;
    }

    protected String _getKeyValue(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer = stringBuffer.append(",").append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    protected void processDCB(BasicDConfigBean basicDConfigBean, boolean bl) {
        Boolean bl2;
        BasicDConfigBean basicDConfigBean2 = basicDConfigBean;
        while (basicDConfigBean2.getParent() != null) {
            basicDConfigBean2 = basicDConfigBean2.getParent();
        }
        if (!((BasicDConfigBeanRoot)basicDConfigBean2).isExternal()) {
            return;
        }
        if (basicDConfigBean.beanTree == null || !(basicDConfigBean.beanTree instanceof AbstractDescriptorBean)) {
            return;
        }
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)basicDConfigBean.beanTree;
        if (bl) {
            basicDConfigBean.setUnmodified();
            basicDConfigBean.doNotWriteYet = true;
            abstractDescriptorBean.setMetaData((Object)FROM_DCB, (Object)new Boolean(true));
        } else if (abstractDescriptorBean.getMetaData((Object)FROM_DCB) != null && (bl2 = (Boolean)abstractDescriptorBean.getMetaData((Object)FROM_DCB)).booleanValue()) {
            basicDConfigBean.doNotWriteYet = true;
        }
    }

    void clearUnmodifiedElementsFromDescriptor() {
        if (debug) {
            Debug.say(this.getName() + " clearing unmodified descriptor elements");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (Iterator iterator : this.getChildBeans()) {
            if (debug) {
                Debug.say("Checking child dconfig bean: " + ((BasicDConfigBean)((Object)iterator)).getName());
            }
            if (((BasicDConfigBean)((Object)iterator)).isModified()) {
                ((BasicDConfigBean)((Object)iterator)).clearUnmodifiedElementsFromDescriptor();
                if (((BasicDConfigBean)((Object)iterator)).getParentPropertyName() != null) {
                    treeSet2.add(((BasicDConfigBean)((Object)iterator)).getParentPropertyName());
                }
            }
            if (((BasicDConfigBean)((Object)iterator)).getParentPropertyName() == null || !((BasicDConfigBean)((Object)iterator)).doNotWriteYet) continue;
            if (debug) {
                Debug.say("Child dconfig bean is not modified. Parent property is: " + ((BasicDConfigBean)((Object)iterator)).getParentPropertyName());
            }
            treeSet.add(((BasicDConfigBean)((Object)iterator)).getParentPropertyName());
        }
        if (!treeSet.isEmpty()) {
            if (!treeSet2.isEmpty()) {
                for (String string : treeSet2) {
                    treeSet.remove(string);
                }
            }
            if (!treeSet.isEmpty()) {
                for (String string : treeSet) {
                    this.getDescriptorBean().unSet(string);
                }
            }
        }
    }

    void restoreUnmodifiedElementsToDescriptor() {
        if (debug) {
            Debug.say(this.getName() + " restoring unmodified descriptor elements");
        }
        for (BasicDConfigBean basicDConfigBean : this.getChildBeans()) {
            if (debug) {
                Debug.say("Checking child dconfig bean: " + basicDConfigBean.getName());
            }
            if (basicDConfigBean.isModified()) {
                basicDConfigBean.restoreUnmodifiedElementsToDescriptor();
            }
            if (basicDConfigBean.getParentPropertyName() == null || !(this.getDescriptorBean() instanceof AbstractDescriptorBean) || !basicDConfigBean.doNotWriteYet) continue;
            if (debug) {
                Debug.say("Child dconfig bean is not modified. Parent property is: " + basicDConfigBean.getParentPropertyName());
            }
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDescriptorBean();
            abstractDescriptorBean.markSet(basicDConfigBean.getParentPropertyName());
        }
    }

    public boolean hasCustomInit() {
        return false;
    }
}

