/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDConfigBeanRoot;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.config.BasicDConfigBean;
import weblogic.deploy.api.spi.config.DeploymentConfigurationImpl;
import weblogic.deploy.api.spi.config.DescriptorParser;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.deploy.api.spi.config.DescriptorSupportManager;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.DescriptorHelper;
import weblogic.j2ee.descriptor.EmptyBean;
import weblogic.j2ee.descriptor.wl.ConfigurationSupportBean;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.VariableAssignmentBean;
import weblogic.j2ee.descriptor.wl.VariableBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.logging.Loggable;
import weblogic.utils.ArrayUtils;

public abstract class BasicDConfigBeanRoot
extends BasicDConfigBean
implements WebLogicDConfigBeanRoot,
PropertyChangeListener,
VetoableChangeListener {
    private static final boolean debug = Debug.isDebug("config");
    private static final boolean allowNonConfigurableChanges = Boolean.getBoolean("weblogic.deploy.api.AllowNonConfigurableChanges");
    private static final String FROM_LISTENER = "FROM_LISTENER";
    protected DeployableObject dObject;
    private DescriptorParser dom = null;
    private WebLogicDeploymentConfiguration dc;
    private boolean ddProvided = true;
    private boolean isSchema = true;
    private String name;
    Map secondaryRoots = Collections.synchronizedMap(new HashMap());
    DescriptorSupport myds = null;
    private boolean external = false;
    private String namespace = null;
    private List bl = new ArrayList();
    private DescriptorHelper ddhelper = null;
    private List newBeans = new ArrayList();
    private boolean planBasedDBean = false;

    public BasicDConfigBeanRoot(DDBeanRoot dDBeanRoot, WebLogicDeploymentConfiguration webLogicDeploymentConfiguration, String string, DescriptorSupport descriptorSupport) throws IOException, InvalidModuleException {
        super((DDBean)dDBeanRoot);
        ConfigHelper.checkParam("WebLogicDeploymentConfiguration", webLogicDeploymentConfiguration);
        ConfigHelper.checkParam("name", string);
        ConfigHelper.checkParam("DescriptorSupport", descriptorSupport);
        this.setDescriptorSupport(descriptorSupport);
        this.setNamespace();
        this.dObject = dDBeanRoot.getDeployableObject();
        this.dc = webLogicDeploymentConfiguration;
        this.name = string;
        if (descriptorSupport.supportsConfigModules() || descriptorSupport.isPrimary() && this.isAppRoot()) {
            this.addWebLogicExtensions();
        }
    }

    public void close() {
        for (WebLogicDConfigBeanRoot webLogicDConfigBeanRoot : this.secondaryRoots.values()) {
            if (webLogicDConfigBeanRoot == null) continue;
            webLogicDConfigBeanRoot.close();
        }
        this.deregisterAsListener(this.getDescriptorBean());
        this.secondaryRoots.clear();
    }

    private boolean isAppRoot() {
        return this.dObject.equals(this.dc.getDeployableObject());
    }

    public BasicDConfigBeanRoot(DDBean dDBean) {
        super(dDBean);
    }

    public DConfigBean getDConfigBean(DDBeanRoot dDBeanRoot) {
        ConfigHelper.checkParam("DDBeanRoot", dDBeanRoot);
        if (debug) {
            Debug.say("looking up secondary dcb for " + dDBeanRoot.toString());
        }
        DescriptorSupport descriptorSupport = null;
        DConfigBeanRoot dConfigBeanRoot = (DConfigBeanRoot)this.secondaryRoots.get(dDBeanRoot);
        if (dConfigBeanRoot != null) {
            return dConfigBeanRoot;
        }
        try {
            DescriptorSupport[] descriptorSupportArray;
            String string = ((DeploymentConfigurationImpl)this.dc).getRootTag(dDBeanRoot);
            if (debug) {
                Debug.say("Looking up #2 ds for tag " + string);
            }
            if ((descriptorSupportArray = DescriptorSupportManager.getForSecondaryTag(string)) == null || descriptorSupportArray.length == 0) {
                return null;
            }
            for (int i = 0; i < descriptorSupportArray.length; ++i) {
                if (debug) {
                    Debug.say("Checking " + descriptorSupportArray[i].getBaseURI() + " against " + dDBeanRoot.getFilename());
                }
                if (!descriptorSupportArray[i].getBaseURI().equals(dDBeanRoot.getFilename())) continue;
                descriptorSupport = descriptorSupportArray[i];
                break;
            }
        }
        catch (ConfigurationException configurationException) {
            SPIDeployerLogger.logNoDCB((String)this.name, (String)configurationException.toString());
            return null;
        }
        if (descriptorSupport == null) {
            return null;
        }
        try {
            return this.getDConfigBean(dDBeanRoot, descriptorSupport);
        }
        catch (ConfigurationException configurationException) {
            SPIDeployerLogger.logDDCreateError((String)descriptorSupport.getConfigURI());
            return null;
        }
    }

    private WebLogicDConfigBeanRoot findRoot(DDBeanRoot dDBeanRoot) {
        for (DDBeanRoot dDBeanRoot2 : this.secondaryRoots.keySet()) {
            if (!dDBeanRoot2.equals(dDBeanRoot)) continue;
            return (WebLogicDConfigBeanRoot)this.secondaryRoots.get(dDBeanRoot2);
        }
        return null;
    }

    public DConfigBean getDConfigBean(DDBeanRoot dDBeanRoot, DescriptorSupport descriptorSupport) throws ConfigurationException {
        WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = null;
        try {
            ConfigHelper.checkParam("DDBeanRoot", dDBeanRoot);
            ConfigHelper.checkParam("DescriptorSupport", descriptorSupport);
            webLogicDConfigBeanRoot = this.findRoot(dDBeanRoot);
            if (webLogicDConfigBeanRoot != null) {
                return webLogicDConfigBeanRoot;
            }
            if (debug) {
                Debug.say("Creating secondary DCB for " + this.name + " at " + descriptorSupport.getConfigTag() + " on ddbeanroot: \n" + dDBeanRoot);
            }
            webLogicDConfigBeanRoot = ((DeploymentConfigurationImpl)this.dc).initDConfig(dDBeanRoot, this.name, descriptorSupport);
            this.secondaryRoots.put(dDBeanRoot, webLogicDConfigBeanRoot);
            if (webLogicDConfigBeanRoot != null) {
                ConfigHelper.beanWalker(dDBeanRoot, webLogicDConfigBeanRoot);
                this.dc.addToPlan(webLogicDConfigBeanRoot);
            }
        }
        catch (IOException iOException) {
            throw (ConfigurationException)new ConfigurationException(iOException.getMessage()).initCause((Throwable)iOException);
        }
        catch (InvalidModuleException invalidModuleException) {
            throw (ConfigurationException)new ConfigurationException(invalidModuleException.getMessage()).initCause((Throwable)invalidModuleException);
        }
        return webLogicDConfigBeanRoot;
    }

    public void export(int n) throws IllegalArgumentException {
        if (!this.isSchemaBased()) {
            SPIDeployerLogger.logDTDDDExport((String)this.getDescriptorSupport().getConfigURI(), (String)this.getName());
            return;
        }
        DescriptorHelper descriptorHelper = this.getDescriptorHelper();
        DeploymentPlanBean deploymentPlanBean = this.dc.getPlan();
        ModuleDescriptorBean moduleDescriptorBean = deploymentPlanBean.findModuleDescriptor(this.name, this.myds.getConfigURI());
        DescriptorBean[] descriptorBeanArray = null;
        String[] stringArray = null;
        switch (n) {
            case 0: {
                descriptorBeanArray = descriptorHelper.findDependencies(this.getDescriptorBean().getDescriptor());
                for (int i = 0; i < descriptorBeanArray.length; ++i) {
                    DescriptorBean descriptorBean = descriptorBeanArray[i];
                    stringArray = descriptorHelper.findDependencies(descriptorBean);
                    this.createVariable(stringArray, deploymentPlanBean, moduleDescriptorBean, descriptorBean);
                }
                break;
            }
            case 1: {
                descriptorBeanArray = descriptorHelper.findDeclarations(this.getDescriptorBean().getDescriptor());
                for (int i = 0; i < descriptorBeanArray.length; ++i) {
                    DescriptorBean descriptorBean = descriptorBeanArray[i];
                    stringArray = descriptorHelper.findDeclarations(descriptorBean);
                    this.createVariable(stringArray, deploymentPlanBean, moduleDescriptorBean, descriptorBean);
                }
                break;
            }
            case 2: {
                descriptorBeanArray = descriptorHelper.findConfigurables(this.getDescriptorBean().getDescriptor());
                for (int i = 0; i < descriptorBeanArray.length; ++i) {
                    DescriptorBean descriptorBean = descriptorBeanArray[i];
                    stringArray = descriptorHelper.findConfigurables(descriptorBean);
                    this.createVariable(stringArray, deploymentPlanBean, moduleDescriptorBean, descriptorBean);
                }
                break;
            }
            case 3: {
                descriptorBeanArray = descriptorHelper.findChangables(this.getDescriptorBean().getDescriptor());
                for (int i = 0; i < descriptorBeanArray.length; ++i) {
                    DescriptorBean descriptorBean = descriptorBeanArray[i];
                    stringArray = descriptorHelper.findChangables(descriptorBean);
                    this.createVariable(stringArray, deploymentPlanBean, moduleDescriptorBean, descriptorBean);
                }
                break;
            }
            case 4: {
                descriptorBeanArray = descriptorHelper.findDynamics(this.getDescriptorBean().getDescriptor());
                for (int i = 0; i < descriptorBeanArray.length; ++i) {
                    DescriptorBean descriptorBean = descriptorBeanArray[i];
                    stringArray = descriptorHelper.findDynamics(descriptorBean);
                    this.createVariable(stringArray, deploymentPlanBean, moduleDescriptorBean, descriptorBean);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(SPIDeployerLogger.invalidExport((int)n));
            }
        }
    }

    private DescriptorHelper getDescriptorHelper() {
        if (this.ddhelper == null) {
            this.ddhelper = DescriptorHelper.getInstance();
        }
        return this.ddhelper;
    }

    private void createVariable(String[] stringArray, DeploymentPlanBean deploymentPlanBean, ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            VariableBean variableBean = null;
            try {
                variableBean = deploymentPlanBean.findVariable(moduleDescriptorBean, descriptorBean, string);
                if (debug && variableBean != null) {
                    Debug.say("Variable on Plan is: " + variableBean.getName() + " = " + variableBean.getValue());
                }
                if (variableBean != null) continue;
                variableBean = deploymentPlanBean.findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, this.getPlanBasedDBean());
                variableBean.setValue(null);
                if (!debug) continue;
                Debug.say("Created variable on plan: " + variableBean.getName() + " = " + variableBean.getValue());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void export(DescriptorBean descriptorBean, String[] stringArray) throws IllegalArgumentException {
        ConfigHelper.checkParam("DescriptorBean", descriptorBean);
        DescriptorHelper descriptorHelper = this.getDescriptorHelper();
        DeploymentPlanBean deploymentPlanBean = this.dc.getPlan();
        ModuleDescriptorBean moduleDescriptorBean = deploymentPlanBean.findModuleDescriptor(this.name, this.myds.getConfigURI());
        DescriptorBean[] descriptorBeanArray = descriptorHelper.findChangables(this.getDescriptorBean().getDescriptor());
        for (int i = 0; i < descriptorBeanArray.length; ++i) {
            DescriptorBean descriptorBean2 = descriptorBeanArray[i];
            if (!descriptorBean2.equals(descriptorBean)) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                if (descriptorHelper.isChangable(descriptorBean, string)) continue;
                throw new IllegalArgumentException(SPIDeployerLogger.notChangable((String)string));
            }
            this.createVariable(stringArray, deploymentPlanBean, moduleDescriptorBean, descriptorBean);
            return;
        }
        throw new IllegalArgumentException(SPIDeployerLogger.noSuchBean((String)descriptorBean.toString()));
    }

    public String getDConfigName() {
        return this.name;
    }

    public DConfigBean[] getSecondaryDescriptors() {
        return this.secondaryRoots.values().toArray(new DConfigBean[0]);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSchemaBased() {
        if (this.isSchema) {
            return true;
        }
        if (this.dom == null) {
            return false;
        }
        return this.dom.isSchemaBased();
    }

    public boolean hasDD() {
        return this.ddProvided;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean bl) {
        this.external = bl;
    }

    void setSchemaBased() {
        this.isSchema = true;
    }

    public DescriptorSupport getDescriptorSupport() {
        return this.myds;
    }

    private void setDescriptorSupport(DescriptorSupport descriptorSupport) {
        this.myds = descriptorSupport;
    }

    private void setPlanBasedDBean(boolean bl) {
        this.planBasedDBean = bl;
    }

    private boolean getPlanBasedDBean() {
        return this.planBasedDBean;
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.dc;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.hasDD() && !this.isSchemaBased()) {
            Loggable loggable = SPIDeployerLogger.logDTDDDUpdateLoggable((String)propertyChangeEvent.getPropertyName(), (String)this.getDescriptorSupport().getConfigURI(), (String)this.getName());
            throw new PropertyVetoException(loggable.getMessage(), propertyChangeEvent);
        }
        this.propertyChange(propertyChangeEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicDConfigBean basicDConfigBean;
        this.setModified(true);
        this.setPlanBasedDBean(false);
        DescriptorBean descriptorBean = (DescriptorBean)propertyChangeEvent.getSource();
        if (debug) {
            Debug.say("PropertyChangeEvent : " + propertyChangeEvent);
            Debug.say("PropertyChangeEvent.source : " + descriptorBean);
            Debug.say("PropertyChangeEvent.prop : " + propertyChangeEvent.getPropertyName());
            Debug.say("PropertyChangeEvent.old : " + propertyChangeEvent.getOldValue());
            Debug.say("PropertyChangeEvent.new : " + propertyChangeEvent.getNewValue());
        }
        if (this.hasDD() && !this.isExternal()) {
            this.handleChange(descriptorBean, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if (this.isExternal() && (basicDConfigBean = this.findDConfigBean(this, descriptorBean)) != null) {
            basicDConfigBean.setModified(true);
        }
        this.reregister(descriptorBean);
    }

    public void handleChange(DescriptorBean descriptorBean, String string, Object object, Object object2) {
        if (string != null) {
            Method method;
            Class<?> clazz;
            Class<?> clazz2;
            PropertyDescriptor propertyDescriptor = this.getDescriptorHelper().getPropertyDescriptor(descriptorBean, string);
            if (propertyDescriptor == null) {
                return;
            }
            String string2 = this.getDescriptorHelper().buildKeyXpath(descriptorBean);
            if (debug) {
                Debug.say("xpathKey = " + string2);
            }
            if (this.newBeans.contains(string2)) {
                this.setPlanBasedDBean(true);
                if (debug) {
                    Debug.say("xpathkey found in newbeans");
                }
            } else if (descriptorBean instanceof AbstractDescriptorBean && ((AbstractDescriptorBean)descriptorBean).getMetaData((Object)FROM_LISTENER) != null) {
                this.setPlanBasedDBean(true);
                if (debug) {
                    Debug.say("from listener found in bean");
                }
            }
            if ((clazz2 = (clazz = (method = propertyDescriptor.getReadMethod()).getReturnType())).isArray()) {
                clazz2 = clazz2.getComponentType();
            }
            if (clazz2.isPrimitive() || clazz2.getPackage().getName().equals("java.lang") || EmptyBean.class.isAssignableFrom(clazz2)) {
                if (this.isSchemaBased()) {
                    this.variabilize(descriptorBean, string, object, object2, clazz);
                } else {
                    SPIDeployerLogger.logDTDDDUpdate((String)string, (String)this.getDescriptorSupport().getConfigURI(), (String)this.getName());
                }
            } else {
                if (debug) {
                    Debug.say("Variabilizing object change ");
                }
                if (debug && object2 == null) {
                    Debug.say("New object is null");
                }
                this.variabilize(descriptorBean, string, object, object2, clazz);
            }
        }
    }

    private void reregister(DescriptorBean descriptorBean) {
        this.deregisterAsListener(descriptorBean);
        this.registerAsListener(descriptorBean);
    }

    public String getUri() {
        return this.myds.getConfigURI();
    }

    private void setNamespace() {
        this.namespace = ConfigHelper.getNSPrefix(this.getDDBean(), this.getDescriptorSupport().getBaseNameSpace());
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void registerAsListener(DescriptorBean descriptorBean) {
        if (!this.findBean(descriptorBean) && this.bl.add(descriptorBean)) {
            if (debug) {
                Debug.say("Registering listener for " + descriptorBean.toString());
            }
            this.getDescriptorHelper().addPropertyChangeListener(descriptorBean, (PropertyChangeListener)this);
        }
        Iterator iterator = this.getDescriptorHelper().getChildren(descriptorBean);
        while (iterator.hasNext()) {
            DescriptorBean descriptorBean2 = (DescriptorBean)iterator.next();
            this.registerAsListener(descriptorBean2);
        }
    }

    private boolean findBean(DescriptorBean descriptorBean) {
        Iterator iterator = this.bl.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != descriptorBean) continue;
            return true;
        }
        return false;
    }

    protected void deregisterAsListener(DescriptorBean descriptorBean) {
        if (this.bl.remove(descriptorBean)) {
            if (debug) {
                Debug.say("Deregistering listener for " + descriptorBean.toString());
            }
            this.getDescriptorHelper().removePropertyChangeListener(descriptorBean, (PropertyChangeListener)this);
        }
        Iterator iterator = this.getDescriptorHelper().getChildren(descriptorBean);
        while (iterator.hasNext()) {
            DescriptorBean descriptorBean2 = (DescriptorBean)iterator.next();
            this.deregisterAsListener(descriptorBean2);
        }
    }

    private void variabilize(DescriptorBean descriptorBean, String string, Object object, Object object2, Class clazz) {
        ModuleDescriptorBean moduleDescriptorBean;
        if (debug) {
            Debug.say("Getting module descriptor bean for " + this.getDConfigName() + " and " + this.getDescriptorSupport().getConfigURI() + " for prop " + string);
        }
        if ((moduleDescriptorBean = this.dc.getPlan().findModuleDescriptor(this.getDConfigName(), this.getDescriptorSupport().getConfigURI())) != null) {
            if (debug) {
                Debug.say("Changeable: " + this.getDescriptorHelper().isChangable(descriptorBean, string) + " transient: " + this.getDescriptorHelper().isTransient(descriptorBean, string));
            }
            if ((this.getDescriptorHelper().isChangable(descriptorBean, string) || allowNonConfigurableChanges) && !this.getDescriptorHelper().isTransient(descriptorBean, string)) {
                moduleDescriptorBean.setChanged(true);
                if (object2 instanceof DescriptorBean) {
                    this.variabilizeBean((DescriptorBean)object2);
                    return;
                }
                if (object instanceof DescriptorBean && object2 == null) {
                    this.removeDescriptorBean(moduleDescriptorBean, (DescriptorBean)object);
                    return;
                }
                Object object3 = object2;
                if (!this.isSeparableArray(clazz)) {
                    boolean bl = this.getDescriptorHelper().isKey(descriptorBean, string) || this.getDescriptorHelper().isKeyComponent(descriptorBean, string);
                    Object object4 = bl ? object : null;
                    VariableBean variableBean = null;
                    if (bl && !this.getPlanBasedDBean()) {
                        if (debug) {
                            Debug.say("findOrCreateVariable from is key, old key = " + object4);
                        }
                        variableBean = this.dc.getPlan().findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, this.getPlanBasedDBean(), object4);
                    } else {
                        if (debug) {
                            Debug.say("findOrCreateVariable is plan based = " + this.getPlanBasedDBean());
                        }
                        variableBean = this.dc.getPlan().findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, this.getPlanBasedDBean());
                    }
                    if (object3 == null) {
                        variableBean.setValue(null);
                    } else if (clazz.isArray()) {
                        variableBean.setValue(new String((byte[])object3));
                    } else {
                        variableBean.setValue(object3.toString());
                    }
                } else {
                    VariableBean variableBean = null;
                    if (this.isArrayOfDescriptorBeans(object, object2)) {
                        this.variabilizeDescriptorBeanArray(moduleDescriptorBean, object, object2, false);
                    } else {
                        if (debug) {
                            Debug.say("Variabilize nonbean array");
                        }
                        variableBean = this.dc.getPlan().findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, this.getPlanBasedDBean());
                        String string2 = this.variabilizeArray(object, object2, variableBean);
                        this.updateOperation(string2, variableBean);
                    }
                }
            } else if (this.isArrayOfDescriptorBeans(object, object2)) {
                this.variabilizeDescriptorBeanArray(moduleDescriptorBean, object, object2, true);
            }
        }
    }

    private void variabilizeDescriptorBeanArray(ModuleDescriptorBean moduleDescriptorBean, Object object, Object object2, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2;
        if (debug) {
            Debug.say("variabilizing array of descriptor beans");
        }
        if ((objectArray2 = this.convertArray(object)) == null) {
            objectArray2 = new Object[]{};
        }
        if ((objectArray = this.convertArray(object2)) == null) {
            objectArray = new Object[]{};
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayUtils.computeDiff((Object[])objectArray2, (Object[])objectArray, (ArrayUtils.DiffHandler)this.createDiffHandler(arrayList, arrayList2));
        this.clearLocalCache(arrayList2.iterator());
        if (!bl) {
            this.addDescriptorBeans(arrayList);
        }
        this.removeDescriptorBeans(moduleDescriptorBean, arrayList2);
    }

    private void clearLocalCache(Iterator iterator) {
        while (iterator.hasNext()) {
            this.bl.remove(iterator.next());
        }
    }

    private void addDescriptorBeans(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (debug) {
                Debug.say("Adding a descriptor bean");
            }
            this.variabilizeBean((DescriptorBean)iterator.next());
        }
    }

    private void removeDescriptorBeans(ModuleDescriptorBean moduleDescriptorBean, ArrayList arrayList) {
        for (DescriptorBean descriptorBean : arrayList) {
            this.removeDescriptorBean(moduleDescriptorBean, descriptorBean);
        }
    }

    private void removeDescriptorBean(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean) {
        if (debug) {
            Debug.say("Removing descriptor bean: " + descriptorBean);
        }
        try {
            this.dc.getPlan().findAndRemoveAllBeanVariables(moduleDescriptorBean, descriptorBean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Loggable loggable = SPIDeployerLogger.logUnableToRemoveDescriptorBeanLoggable((String)descriptorBean.toString(), (String)illegalArgumentException.getMessage());
            throw new IllegalArgumentException(loggable.getMessage());
        }
    }

    private void variabilizeBean(DescriptorBean descriptorBean) {
        this.setPlanBasedDBean(true);
        String string = this.getDescriptorHelper().buildKeyXpath(descriptorBean);
        if (debug) {
            Debug.say("xpathKey = " + string);
        }
        this.newBeans.add(string);
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)descriptorBean;
        abstractDescriptorBean.setMetaData((Object)FROM_LISTENER, (Object)new Boolean(true));
        if (debug) {
            Debug.say("Adding properties for new bean: " + abstractDescriptorBean);
        }
        List list = abstractDescriptorBean._getAlreadySetPropertyNames();
        for (String string2 : list) {
            Object object;
            if (debug) {
                Debug.say("Try to set property : " + string2);
            }
            if (this.getDescriptorHelper().isChangable(descriptorBean, string2) && !this.getDescriptorHelper().isTransient(descriptorBean, string2)) {
                try {
                    object = BasicDConfigBeanRoot.invokeAccessor(descriptorBean, string2);
                    if (debug) {
                        Debug.say("Got value: " + object);
                    }
                    this.handleChange(descriptorBean, string2, null, object);
                    continue;
                }
                catch (Exception exception) {
                    throw new AssertionError((Object)("Caught exception trying to invoke accessor on " + descriptorBean + " - called 'get" + string2 + "()'."));
                }
            }
            if (!this.emptyBean(list, descriptorBean, string2)) continue;
            try {
                object = BasicDConfigBeanRoot.invokeAccessor(descriptorBean, string2);
                this.addEmptyBeanKey(descriptorBean, string2, object);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Caught exception trying to invoke accessor on " + descriptorBean + " - called 'get" + string2 + "()'."));
            }
        }
    }

    private void addEmptyBeanKey(DescriptorBean descriptorBean, String string, Object object) {
        ModuleDescriptorBean moduleDescriptorBean = this.dc.getPlan().findModuleDescriptor(this.getDConfigName(), this.getDescriptorSupport().getConfigURI());
        Object object2 = object;
        VariableBean variableBean = this.dc.getPlan().findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, this.getPlanBasedDBean());
        variableBean.setValue(object2.toString());
    }

    private boolean emptyBean(List list, DescriptorBean descriptorBean, String string) {
        if (debug) {
            Debug.say("Checking list size: " + list.size() + " against Bean with prop: " + string);
        }
        return list.size() <= 1 && this.getDescriptorHelper().isKey(descriptorBean, string);
    }

    private static Object invokeAccessor(Object object, String string) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        Class<?> clazz = object.getClass();
        try {
            method = clazz.getMethod("get" + string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = clazz.getMethod("is" + string, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw noSuchMethodException;
            }
        }
        return method.invoke(object, new Object[0]);
    }

    private boolean isArrayOfDescriptorBeans(Object object, Object object2) {
        Object object3;
        int n;
        if (object2 != null && object2.getClass().isArray() && (n = Array.getLength(object2)) > 0 && (object3 = Array.get(object2, 0)) instanceof DescriptorBean) {
            return true;
        }
        return object != null && object.getClass().isArray() && (n = Array.getLength(object)) > 0 && (object3 = Array.get(object, 0)) instanceof DescriptorBean;
    }

    private boolean isSeparableArray(Class clazz) {
        return clazz.isArray() && !Byte.TYPE.isAssignableFrom(clazz.getComponentType());
    }

    private void updateOperation(String string, VariableBean variableBean) {
        if (string != null) {
            VariableAssignmentBean[] variableAssignmentBeanArray = this.dc.getPlan().findVariableAssignments(variableBean);
            for (int i = 0; i < variableAssignmentBeanArray.length; ++i) {
                VariableAssignmentBean variableAssignmentBean = variableAssignmentBeanArray[i];
                variableAssignmentBean.setOperation(string);
            }
        }
    }

    private String variabilizeArray(Object object, Object object2, VariableBean variableBean) {
        Object[] objectArray = this.convertArray(object2);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        return this.handleSetOperation(objectArray, variableBean);
    }

    private Object[] convertArray(Object object) {
        if (object == null) {
            return null;
        }
        int n = Array.getLength(object);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            objectArray[i] = object2.getClass().isPrimitive() ? object2.toString() : object2;
        }
        return objectArray;
    }

    private String handleRemoveOperation(List list, VariableBean variableBean, Object[] objectArray) {
        List list2 = this.extractValues(variableBean);
        if (list2.isEmpty()) {
            this.loadVariable(list, variableBean);
            return "remove";
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!list2.contains(e)) continue;
            list.remove(e);
            int n = list2.indexOf(e);
            list2.remove(n);
        }
        if (list.isEmpty()) {
            this.loadVariable(list2, variableBean);
            return null;
        }
        this.loadVariable(Arrays.asList(objectArray), variableBean);
        return "replace";
    }

    private String handleAddOperation(List list, VariableBean variableBean) {
        List list2 = this.extractValues(variableBean);
        list2.addAll(list);
        this.loadVariable(list2, variableBean);
        return "add";
    }

    private void loadVariable(List list, VariableBean variableBean) {
        String string = new String();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                string = string + ",";
            }
            Object e = list.get(i);
            string = string + "\"" + e.toString() + "\"";
        }
        variableBean.setValue(string);
    }

    private String handleSetOperation(Object[] objectArray, VariableBean variableBean) {
        this.loadVariable(Arrays.asList(objectArray), variableBean);
        return "replace";
    }

    private ArrayUtils.DiffHandler createDiffHandler(final ArrayList arrayList, final ArrayList arrayList2) {
        return new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                arrayList.add(object);
            }

            public void removeObject(Object object) {
                arrayList2.add(object);
            }
        };
    }

    private List extractValues(VariableBean variableBean) {
        if (variableBean.getValue() == null) {
            return new ArrayList(0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(variableBean.getValue(), ",");
        int n = stringTokenizer.countTokens();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private void addWebLogicExtensions() throws InvalidModuleException, IOException {
        Object object;
        Object object2;
        WeblogicExtensionBean weblogicExtensionBean;
        String string;
        block21: {
            if (this.dObject.getType().getValue() == ModuleType.EAR.getValue()) {
                string = "META-INF/weblogic-extension.xml";
            } else if (this.dObject.getType().getValue() == ModuleType.WAR.getValue()) {
                string = "WEB-INF/weblogic-extension.xml";
            } else {
                return;
            }
            weblogicExtensionBean = null;
            if (this.dObject instanceof WebLogicDeployableObject && ((WebLogicDeployableObject)(object2 = (WebLogicDeployableObject)this.dObject)).hasDDBean(string)) {
                try {
                    object = (DDBeanRootImpl)((WebLogicDeployableObject)object2).getDDBeanRoot(string);
                    if (debug) {
                        Debug.say("Getting descriptorbean from ddroot :\n" + object + " of type: " + ((DDBeanRootImpl)object).getType());
                    }
                    weblogicExtensionBean = (WeblogicExtensionBean)((DDBeanRootImpl)object).getDescriptorBean();
                }
                catch (DDBeanCreateException dDBeanCreateException) {
                    if (!debug) break block21;
                    dDBeanCreateException.printStackTrace();
                }
            }
        }
        if (weblogicExtensionBean == null) {
            return;
        }
        try {
            CustomModuleBean[] customModuleBeanArray = weblogicExtensionBean.getCustomModules();
            if (customModuleBeanArray == null) {
                return;
            }
            for (int i = 0; i < customModuleBeanArray.length; ++i) {
                String string2;
                String string3;
                String string4;
                CustomModuleBean customModuleBean = customModuleBeanArray[i];
                ConfigurationSupportBean configurationSupportBean = customModuleBean.getConfigurationSupport();
                if (configurationSupportBean == null) continue;
                object2 = configurationSupportBean.getBaseRootElement();
                if (object2 == null) {
                    throw new InvalidModuleException(SPIDeployerLogger.getMissingExt((String)string, (String)"base-root-element", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                }
                object = configurationSupportBean.getConfigRootElement();
                if (object == null) {
                    object = object2;
                }
                if ((string4 = configurationSupportBean.getBaseNamespace()) == null) {
                    throw new InvalidModuleException(SPIDeployerLogger.getMissingExt((String)string, (String)"base-namespace", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                }
                String string5 = configurationSupportBean.getConfigNamespace();
                if (string5 == null) {
                    string5 = string4;
                }
                if ((string3 = configurationSupportBean.getBaseUri()) == null) {
                    throw new InvalidModuleException(SPIDeployerLogger.getMissingExt((String)string, (String)"base-uri", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                }
                String string6 = configurationSupportBean.getConfigUri();
                if (string6 == null) {
                    string6 = string3;
                }
                if ((string2 = configurationSupportBean.getBasePackageName()) == null) {
                    throw new InvalidModuleException(SPIDeployerLogger.getMissingExt((String)string, (String)"base-package-name", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                }
                String string7 = configurationSupportBean.getConfigPackageName();
                if (string7 == null) {
                    string7 = string2;
                }
                SPIDeployerLogger.logAddDS((String)string3, (String)string6);
                DescriptorSupportManager.add(WebLogicModuleType.CONFIG, (String)object2, (String)object, string4, string5, string3, string6, string2, string7);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidModuleException(illegalArgumentException.toString());
        }
    }

    private BasicDConfigBean findDConfigBean(BasicDConfigBean basicDConfigBean, DescriptorBean descriptorBean) {
        if (descriptorBean == null || basicDConfigBean == null) {
            return null;
        }
        if (basicDConfigBean.getDescriptorBean() == descriptorBean) {
            return basicDConfigBean;
        }
        for (BasicDConfigBean basicDConfigBean2 : basicDConfigBean.getChildBeans()) {
            BasicDConfigBean basicDConfigBean3 = this.findDConfigBean(basicDConfigBean2, descriptorBean);
            if (basicDConfigBean3 == null) continue;
            return basicDConfigBean3;
        }
        return null;
    }
}

