/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.deploy.model.DeployableObject;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;

public final class DeployableObjectClassLoader
extends GenericClassLoader {
    private static final boolean debug = Debug.isDebug("config");
    private final DeployableObject dObject;
    private DeploymentPlanBean plan = null;
    private final File configDir;
    private final String moduleName;
    private final InputStream myIS;
    private final String myUri;

    public DeployableObjectClassLoader(DeployableObject deployableObject, DeploymentPlanBean deploymentPlanBean, File file, String string, ClassFinder classFinder, ClassLoader classLoader) {
        super(classFinder, classLoader);
        this.dObject = deployableObject;
        this.plan = deploymentPlanBean;
        this.configDir = file;
        this.moduleName = string;
        this.myIS = null;
        this.myUri = null;
    }

    public DeployableObjectClassLoader(InputStream inputStream, String string, ClassFinder classFinder, ClassLoader classLoader) {
        super(classFinder, classLoader);
        this.myIS = inputStream;
        this.myUri = string;
        this.dObject = null;
        this.plan = null;
        this.configDir = null;
        this.moduleName = null;
    }

    public InputStream getResourceAsStream(String string) {
        ModuleDescriptorBean moduleDescriptorBean;
        if (debug) {
            Debug.say("Getting stream for " + string);
        }
        if (string.equals(this.myUri)) {
            if (this.myIS == null) {
                return null;
            }
            try {
                this.myIS.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.myIS.mark(1000000);
            return this.myIS;
        }
        InputStream inputStream = super.getResourceAsStream(string);
        if (inputStream == null && this.dObject != null) {
            inputStream = this.dObject.getEntry(string);
        }
        if (inputStream == null && this.plan != null && (moduleDescriptorBean = this.plan.findModuleDescriptor(this.moduleName, string)) != null) {
            File file = this.plan.rootModule(this.moduleName) ? this.configDir : new File(this.configDir, this.moduleName);
            File file2 = new File(file, moduleDescriptorBean.getUri());
            try {
                inputStream = new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return inputStream;
    }
}

