/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ClassLoaderControl;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.InstallDir;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.model.internal.DDBeanRootImpl;
import weblogic.deploy.api.model.sca.ScaApplicationObject;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.WebLogicDConfigBeanRoot;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.config.BasicDConfigBean;
import weblogic.deploy.api.spi.config.BasicDConfigBeanRoot;
import weblogic.deploy.api.spi.config.DeployableObjectKey;
import weblogic.deploy.api.spi.config.DescriptorParser;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.deploy.api.spi.config.DescriptorSupportManager;
import weblogic.deploy.api.spi.config.SPIConfigurationException;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.descriptor.internal.DescriptorHelper;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.EntityDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.PersistenceUseBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicEjbJarBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;

public class DeploymentConfigurationImpl
implements WebLogicDeploymentConfiguration,
PropertyChangeListener {
    private static final boolean debug = Debug.isDebug("config");
    private DeployableObject dObject;
    private ArrayList dObjects = new ArrayList();
    private Map rootMap = new HashMap();
    private Map ddBeanRoots = new HashMap();
    private DeploymentPlanBean plan = null;
    private String appName;
    private InstallDir installDir = null;
    private boolean planRestored = false;
    private boolean extDDWrite = false;
    private DescriptorHelper ddhelper = null;

    public void close() {
        this.unregisterListener(this.plan);
        this.dObject = null;
        this.dObjects.clear();
        this.rootMap.clear();
        for (WebLogicDConfigBeanRoot webLogicDConfigBeanRoot : this.ddBeanRoots.values()) {
            if (webLogicDConfigBeanRoot == null) continue;
            webLogicDConfigBeanRoot.close();
        }
        this.ddBeanRoots.clear();
        this.plan = null;
        this.appName = null;
        this.installDir.resetInstallDir(null);
        this.installDir = null;
    }

    public DeploymentConfigurationImpl(DeployableObject deployableObject) throws InvalidModuleException, IOException {
        ConfigHelper.checkParam("DeployableObject", deployableObject);
        DescriptorSupportManager.flush();
        this.dObject = deployableObject;
        this.initialize();
        this.plan = this.buildPlan();
    }

    public DeployableObject getDeployableObject() {
        return this.dObject;
    }

    private WebLogicDConfigBeanRoot findRoot(DDBeanRoot dDBeanRoot) {
        for (Map.Entry entry : this.ddBeanRoots.entrySet()) {
            DDBeanRoot dDBeanRoot2 = (DDBeanRoot)entry.getKey();
            if (!dDBeanRoot2.equals(dDBeanRoot)) continue;
            return (WebLogicDConfigBeanRoot)entry.getValue();
        }
        return null;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        ConfigHelper.checkParam("DDBeanRoot", dDBeanRoot);
        WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = this.findRoot(dDBeanRoot);
        if (webLogicDConfigBeanRoot == null) {
            DescriptorSupport descriptorSupport = null;
            Iterator iterator = this.rootMap.entrySet().iterator();
            String string = this.getRootTag(dDBeanRoot);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DeployableObjectKey deployableObjectKey = (DeployableObjectKey)entry.getKey();
                String string2 = deployableObjectKey.getName();
                DDBeanRoot dDBeanRoot2 = (DDBeanRoot)entry.getValue();
                if (dDBeanRoot2 == null || !dDBeanRoot2.equals(dDBeanRoot)) continue;
                try {
                    descriptorSupport = DescriptorSupportManager.getForTag(string);
                    if (descriptorSupport == null) {
                        throw new AssertionError((Object)"Inconsistent results from DescriptorSupport");
                    }
                    webLogicDConfigBeanRoot = this.initDConfig(dDBeanRoot, string2, descriptorSupport);
                    if (webLogicDConfigBeanRoot == null) break;
                    DeployableObjectKey deployableObjectKey2 = new DeployableObjectKey(string2, dDBeanRoot.getDeployableObject().getType(), deployableObjectKey.getContextRoot());
                    this.rootMap.put(deployableObjectKey2, dDBeanRoot);
                    this.ddBeanRoots.put(dDBeanRoot, webLogicDConfigBeanRoot);
                    this.addToPlan(webLogicDConfigBeanRoot);
                    this.collectSecondaryConfig(webLogicDConfigBeanRoot);
                    break;
                }
                catch (InvalidModuleException invalidModuleException) {
                    ConfigurationException configurationException = new ConfigurationException(invalidModuleException.toString());
                    configurationException.initCause((Throwable)invalidModuleException);
                    throw configurationException;
                }
                catch (IOException iOException) {
                    ConfigurationException configurationException = new ConfigurationException(SPIDeployerLogger.parseError((String)string2, (String)descriptorSupport.getConfigURI(), (String)iOException.getMessage()));
                    configurationException.initCause((Throwable)iOException);
                    throw configurationException;
                }
            }
            if (webLogicDConfigBeanRoot == null) {
                throw new AssertionError((Object)"DDBeanRoot not part of any DeployableObject");
            }
        }
        return webLogicDConfigBeanRoot;
    }

    public String getModuleName(DDBeanRoot dDBeanRoot) {
        ConfigHelper.checkParam("DDBeanRoot", dDBeanRoot);
        for (Map.Entry entry : this.rootMap.entrySet()) {
            DeployableObjectKey deployableObjectKey = (DeployableObjectKey)entry.getKey();
            String string = deployableObjectKey.getName();
            DDBeanRoot dDBeanRoot2 = (DDBeanRoot)entry.getValue();
            if (!dDBeanRoot.equals(dDBeanRoot2)) continue;
            return string;
        }
        return null;
    }

    public void removeDConfigBean(DConfigBeanRoot dConfigBeanRoot) throws BeanNotFoundException {
        if (dConfigBeanRoot == null) {
            throw new BeanNotFoundException(SPIDeployerLogger.nullDCB());
        }
        Iterator iterator = this.ddBeanRoots.entrySet().iterator();
        Map.Entry entry = null;
        while (iterator.hasNext() && !dConfigBeanRoot.equals((entry = iterator.next()).getValue())) {
            entry = null;
        }
        if (entry == null) {
            this.removeSecondaryDConfigBean((DConfigBean)dConfigBeanRoot);
        }
        ((BasicDConfigBeanRoot)dConfigBeanRoot).removeAllChildren();
        entry.setValue(null);
        this.removeFromPlan((BasicDConfigBeanRoot)dConfigBeanRoot);
        SPIDeployerLogger.logRemoveDCB((String)this.getModuleName((DDBeanRoot)entry.getKey()));
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream inputStream, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        ConfigHelper.checkParam("InputStream", inputStream);
        ConfigHelper.checkParam("DDBeanRoot", dDBeanRoot);
        WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = null;
        WebLogicDConfigBeanRoot webLogicDConfigBeanRoot2 = this.findRoot(dDBeanRoot);
        DeploymentPlanBean deploymentPlanBean = this.plan;
        try {
            DescriptorSupport descriptorSupport;
            String string = null;
            if (webLogicDConfigBeanRoot2 != null) {
                descriptorSupport = webLogicDConfigBeanRoot2.getDescriptorSupport();
            } else {
                string = this.getRootTag(dDBeanRoot);
                descriptorSupport = DescriptorSupportManager.getForTag(string);
            }
            if (descriptorSupport == null) {
                throw new ConfigurationException(SPIDeployerLogger.badDDBean((String)string));
            }
            webLogicDConfigBeanRoot = this.constructDCB(dDBeanRoot, inputStream, descriptorSupport.getDConfigClassName(), this.getModuleName(dDBeanRoot), descriptorSupport);
            this.ddBeanRoots.put(dDBeanRoot, webLogicDConfigBeanRoot);
            this.removeFromPlan((BasicDConfigBeanRoot)webLogicDConfigBeanRoot2);
            this.addToPlan(webLogicDConfigBeanRoot);
            SPIDeployerLogger.logRestoreDCB((String)this.getModuleName(dDBeanRoot));
            return webLogicDConfigBeanRoot;
        }
        catch (Throwable throwable) {
            ConfigurationException configurationException;
            if (throwable instanceof ConfigurationException) {
                configurationException = (ConfigurationException)throwable;
            } else {
                configurationException = new ConfigurationException(throwable.toString());
                configurationException.initCause(throwable);
            }
            this.ddBeanRoots.put(dDBeanRoot, webLogicDConfigBeanRoot2);
            this.plan = deploymentPlanBean;
            throw configurationException;
        }
    }

    public void saveDConfigBean(OutputStream outputStream, DConfigBeanRoot dConfigBeanRoot) throws ConfigurationException {
        ConfigHelper.checkParam("OuputStream", outputStream);
        ConfigHelper.checkParam("DConfigBeanRoot", dConfigBeanRoot);
        try {
            this.toXML(((BasicDConfigBean)dConfigBeanRoot).getDescriptorBean(), outputStream);
            SPIDeployerLogger.logSaveDCB((String)this.getModuleName((DDBeanRoot)dConfigBeanRoot.getDDBean()));
        }
        catch (IOException iOException) {
            ConfigurationException configurationException = new ConfigurationException(SPIDeployerLogger.marshalError((String)((BasicDConfigBeanRoot)dConfigBeanRoot).getName(), (String)iOException.toString()));
            configurationException.initCause((Throwable)iOException);
            throw configurationException;
        }
    }

    public void restore(InputStream inputStream) throws ConfigurationException {
        ConfigHelper.checkParam("InputStream", inputStream);
        this.restore(this.parsePlan(inputStream));
    }

    public void restore(DeploymentPlanBean deploymentPlanBean) throws ConfigurationException {
        ConfigHelper.checkParam("DeploymentPlanBean", deploymentPlanBean);
        if (debug) {
            Debug.say("start restore new plan");
        }
        Map map = this.ddBeanRoots;
        DeploymentPlanBean deploymentPlanBean2 = this.plan;
        String string = this.appName;
        InstallDir installDir = this.installDir;
        ArrayList arrayList = this.dObjects;
        try {
            try {
                this.ddBeanRoots = new HashMap();
                this.dObjects = new ArrayList();
                this.plan = deploymentPlanBean;
                this.planRestored = true;
                this.initialize();
                SPIDeployerLogger.logRestore((String)this.plan.getApplicationName());
            }
            catch (Throwable throwable) {
                ConfigurationException configurationException;
                if (throwable instanceof ConfigurationException) {
                    configurationException = (ConfigurationException)throwable;
                } else {
                    configurationException = new ConfigurationException(SPIDeployerLogger.restoreError((String)throwable.getMessage()));
                    configurationException.initCause(throwable);
                }
                this.dObjects = arrayList;
                this.ddBeanRoots = map;
                this.plan = deploymentPlanBean2;
                this.appName = string;
                this.installDir = installDir;
                throw configurationException;
            }
            Object var10_7 = null;
            this.unregisterListener(deploymentPlanBean2);
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.unregisterListener(deploymentPlanBean2);
            throw throwable;
        }
    }

    private void unregisterListener(DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean != null) {
            this.getDescriptorHelper().removePropertyChangeListener((DescriptorBean)deploymentPlanBean, (PropertyChangeListener)this);
        }
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        ConfigHelper.checkParam("OutputStream", outputStream);
        try {
            this.writeConfig();
            if (debug) {
                Debug.say("Saving following plan: ");
                this.toXML((DescriptorBean)this.plan, System.out);
            }
            this.toXML((DescriptorBean)this.plan, outputStream);
            SPIDeployerLogger.logSave((String)this.appName);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(SPIDeployerLogger.marshalPlanError((String)iOException.toString()));
        }
    }

    private boolean hasExternalDDs() {
        ModuleOverrideBean[] moduleOverrideBeanArray = this.plan.getModuleOverrides();
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
            for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                ModuleDescriptorBean moduleDescriptorBean = moduleDescriptorBeanArray[j];
                if (!moduleDescriptorBean.isExternal()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPlanRestored() {
        return this.planRestored;
    }

    public InstallDir getInstallDir() {
        return this.installDir;
    }

    public void export(int n) throws IllegalArgumentException {
        for (WebLogicDConfigBeanRoot webLogicDConfigBeanRoot : this.ddBeanRoots.values()) {
            if (webLogicDConfigBeanRoot == null) continue;
            webLogicDConfigBeanRoot.export(n);
            DConfigBean[] dConfigBeanArray = webLogicDConfigBeanRoot.getSecondaryDescriptors();
            for (int i = 0; i < dConfigBeanArray.length; ++i) {
                WebLogicDConfigBeanRoot webLogicDConfigBeanRoot2 = (WebLogicDConfigBeanRoot)dConfigBeanArray[i];
                if (webLogicDConfigBeanRoot2 == null) continue;
                webLogicDConfigBeanRoot2.export(n);
            }
        }
    }

    public DeploymentPlanBean getPlan() {
        return this.plan;
    }

    public void addToPlan(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot) {
        String string = webLogicDConfigBeanRoot.getDConfigName();
        ModuleOverrideBean moduleOverrideBean = this.findModuleOverride(string);
        if (moduleOverrideBean == null) {
            if (debug) {
                Debug.say("creating module override for " + string);
            }
            moduleOverrideBean = this.plan.createModuleOverride();
            moduleOverrideBean.setModuleName(string);
            moduleOverrideBean.setModuleType(webLogicDConfigBeanRoot.getDDBean().getRoot().getType().toString());
        }
        String string2 = webLogicDConfigBeanRoot.getDescriptorSupport().getConfigURI();
        if (debug) {
            Debug.say("creating module override descriptor for " + webLogicDConfigBeanRoot + " at " + string2);
        }
        this.addDescriptor(moduleOverrideBean, string2, webLogicDConfigBeanRoot.getDescriptorSupport().getConfigTag(), webLogicDConfigBeanRoot.isExternal());
        string2 = webLogicDConfigBeanRoot.getDescriptorSupport().getBaseURI();
        if (debug) {
            Debug.say("creating module override descriptor for " + webLogicDConfigBeanRoot + " at " + string2);
        }
        this.addDescriptor(moduleOverrideBean, string2, webLogicDConfigBeanRoot.getDescriptorSupport().getBaseTag(), false);
    }

    private void addDescriptor(ModuleOverrideBean moduleOverrideBean, String string, String string2, boolean bl) {
        ModuleDescriptorBean moduleDescriptorBean = this.findModuleDescriptor(moduleOverrideBean, string);
        if (moduleDescriptorBean == null) {
            moduleDescriptorBean = moduleOverrideBean.createModuleDescriptor();
            moduleDescriptorBean.setRootElement(string2);
            moduleDescriptorBean.setUri(string);
            moduleDescriptorBean.setExternal(bl);
        }
    }

    private ModuleOverrideBean findModuleOverride(String string) {
        ModuleOverrideBean[] moduleOverrideBeanArray = this.plan.getModuleOverrides();
        if (moduleOverrideBeanArray == null) {
            return null;
        }
        for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
            ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
            if (!string.equals(moduleOverrideBean.getModuleName())) continue;
            return moduleOverrideBean;
        }
        return null;
    }

    private ModuleDescriptorBean findModuleDescriptor(ModuleOverrideBean moduleOverrideBean, String string) {
        if (moduleOverrideBean == null) {
            return null;
        }
        ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
        if (moduleDescriptorBeanArray == null) {
            return null;
        }
        for (int i = 0; i < moduleDescriptorBeanArray.length; ++i) {
            ModuleDescriptorBean moduleDescriptorBean = moduleDescriptorBeanArray[i];
            if (!string.equals(moduleDescriptorBean.getUri())) continue;
            return moduleDescriptorBean;
        }
        return null;
    }

    private void removeFromPlan(BasicDConfigBeanRoot basicDConfigBeanRoot) {
        String string = basicDConfigBeanRoot.getDConfigName();
        ModuleOverrideBean moduleOverrideBean = this.findModuleOverride(string);
        if (moduleOverrideBean == null) {
            return;
        }
        String string2 = basicDConfigBeanRoot.getDescriptorSupport().getConfigURI();
        ModuleDescriptorBean moduleDescriptorBean = this.findModuleDescriptor(moduleOverrideBean, string2);
        if (moduleDescriptorBean != null) {
            moduleOverrideBean.destroyModuleDescriptor(moduleDescriptorBean);
        }
        if ((moduleDescriptorBean = this.findModuleDescriptor(moduleOverrideBean, string2 = basicDConfigBeanRoot.getDescriptorSupport().getBaseURI())) != null) {
            moduleOverrideBean.destroyModuleDescriptor(moduleDescriptorBean);
        }
        Iterator<Object> iterator = Arrays.asList((Object[])basicDConfigBeanRoot.getSecondaryDescriptors()).iterator();
        while (iterator.hasNext()) {
            this.removeFromPlan((BasicDConfigBeanRoot)iterator.next());
        }
    }

    private boolean writeConfig() throws ConfigurationException {
        boolean bl = false;
        Iterator iterator = this.ddBeanRoots.values().iterator();
        while (iterator.hasNext()) {
            try {
                WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = (WebLogicDConfigBeanRoot)iterator.next();
                if (webLogicDConfigBeanRoot == null) continue;
                if (this.writeConfigToFile(webLogicDConfigBeanRoot)) {
                    bl = true;
                }
                if (!this.writeSecondaryConfig(webLogicDConfigBeanRoot)) continue;
                bl = true;
            }
            catch (IOException iOException) {
                throw new SPIConfigurationException(iOException.toString(), iOException);
            }
        }
        return bl;
    }

    private boolean writeSecondaryConfig(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot) throws IOException {
        boolean bl = false;
        Iterator<Object> iterator = Arrays.asList((Object[])webLogicDConfigBeanRoot.getSecondaryDescriptors()).iterator();
        while (iterator.hasNext()) {
            if (!this.writeConfigToFile((WebLogicDConfigBeanRoot)iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean writeConfigToFile(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot) throws IOException {
        if (webLogicDConfigBeanRoot == null) {
            return false;
        }
        if (debug) {
            Debug.say("hasdd: " + webLogicDConfigBeanRoot.hasDD() + ", is external:" + webLogicDConfigBeanRoot.isExternal() + ", is modified:" + webLogicDConfigBeanRoot.isModified());
        }
        if (webLogicDConfigBeanRoot.hasDD() && !webLogicDConfigBeanRoot.isExternal() || !webLogicDConfigBeanRoot.isModified()) {
            if (debug) {
                SPIDeployerLogger.logNoSave((String)webLogicDConfigBeanRoot.getDConfigName(), (boolean)webLogicDConfigBeanRoot.hasDD(), (!webLogicDConfigBeanRoot.isModified() ? 1 : 0) != 0);
            }
        } else {
            String string = webLogicDConfigBeanRoot.getDescriptorSupport().getConfigURI();
            if (debug) {
                Debug.say("writing dd for module, " + webLogicDConfigBeanRoot.getDConfigName() + ", with uri, " + string);
            }
            try {
                ((BasicDConfigBeanRoot)webLogicDConfigBeanRoot).clearUnmodifiedElementsFromDescriptor();
                File file = this.writeDDToPlanDir(webLogicDConfigBeanRoot, string, webLogicDConfigBeanRoot.getDescriptorBean());
                ((BasicDConfigBeanRoot)webLogicDConfigBeanRoot).restoreUnmodifiedElementsToDescriptor();
                ModuleDescriptorBean moduleDescriptorBean = this.findModuleDescriptor(this.findModuleOverride(webLogicDConfigBeanRoot.getDConfigName()), string);
                if (moduleDescriptorBean != null) {
                    moduleDescriptorBean.setHashCode(Long.toString(System.currentTimeMillis()));
                }
                SPIDeployerLogger.logSaveDD((String)file.getPath());
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException(SPIDeployerLogger.marshalError((String)((BasicDConfigBeanRoot)webLogicDConfigBeanRoot).getName(), (String)iOException.toString()));
                iOException2.initCause(iOException);
                throw iOException2;
            }
        }
        return webLogicDConfigBeanRoot.isExternal();
    }

    private WebLogicDConfigBeanRoot constructDCB(DDBeanRoot dDBeanRoot, Object object, String string, String string2, DescriptorSupport descriptorSupport) throws Throwable {
        Object object2;
        Constructor<?> constructor;
        Class<?> clazz;
        ClassLoaderControl classLoaderControl;
        block9: {
            classLoaderControl = this.pushClassLoader(dDBeanRoot.getDeployableObject());
            clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
            if (debug) {
                Debug.say("name : " + string2);
                Debug.say("Loaded class: " + clazz.getName());
                Debug.say("this class loader: " + clazz.getClassLoader());
                for (constructor = clazz.getClassLoader().getParent(); constructor != null; constructor = ((ClassLoader)((Object)constructor)).getParent()) {
                    Debug.say("parent context loader: " + constructor);
                }
                object2 = Thread.currentThread().getContextClassLoader().getResource("binding.jar");
                if (object2 != null) {
                    Debug.say("binding url: " + object2.toString());
                }
            }
            if (object != null) break block9;
            constructor = clazz.getDeclaredConstructor(DDBeanRoot.class, WebLogicDeploymentConfiguration.class, String.class, DescriptorSupport.class);
            object2 = (WebLogicDConfigBeanRoot)constructor.newInstance(dDBeanRoot, this, string2, descriptorSupport);
            Object var11_11 = null;
            this.popClassLoader(classLoaderControl);
            return object2;
        }
        try {
            constructor = object instanceof DescriptorBean ? clazz.getDeclaredConstructor(DDBeanRoot.class, WebLogicDeploymentConfiguration.class, DescriptorBean.class, String.class, DescriptorSupport.class) : clazz.getDeclaredConstructor(DDBeanRoot.class, WebLogicDeploymentConfiguration.class, Object.class, String.class, DescriptorSupport.class);
            object2 = (WebLogicDConfigBeanRoot)constructor.newInstance(dDBeanRoot, this, object, string2, descriptorSupport);
            Object var11_12 = null;
            this.popClassLoader(classLoaderControl);
            return object2;
        }
        catch (Throwable throwable) {
            try {
                constructor = throwable.getCause();
                if (constructor == null) {
                    throw throwable;
                }
                throw constructor;
            }
            catch (Throwable throwable2) {
                Object var11_13 = null;
                this.popClassLoader(classLoaderControl);
                throw throwable2;
            }
        }
    }

    private void popClassLoader(ClassLoaderControl classLoaderControl) {
        if (classLoaderControl != null) {
            classLoaderControl.restoreClassloader();
        }
    }

    private ClassLoaderControl pushClassLoader(DeployableObject deployableObject) throws IOException {
        if (!(deployableObject instanceof WebLogicDeployableObject)) {
            return null;
        }
        Thread thread2 = Thread.currentThread();
        ClassLoaderControl classLoaderControl = new ClassLoaderControl((WebLogicDeployableObject)deployableObject);
        thread2.setContextClassLoader(classLoaderControl.getClassLoader());
        return classLoaderControl;
    }

    private DeploymentPlanBean buildPlan() {
        if (debug) {
            Debug.say("building deployment plan");
        }
        this.plan = (DeploymentPlanBean)DescriptorParser.getWLSEditableDescriptorBean(DeploymentPlanBean.class);
        this.plan.setApplicationName(this.appName);
        this.plan.setConfigRoot(this.installDir.getConfigDir().getPath());
        for (Map.Entry entry : this.rootMap.entrySet()) {
            DeployableObjectKey deployableObjectKey = (DeployableObjectKey)entry.getKey();
            String string = deployableObjectKey.getName();
            DDBeanRoot dDBeanRoot = (DDBeanRoot)this.rootMap.get(deployableObjectKey);
            WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = (WebLogicDConfigBeanRoot)this.ddBeanRoots.get(dDBeanRoot);
            if (webLogicDConfigBeanRoot == null) continue;
            this.addToPlan(webLogicDConfigBeanRoot);
        }
        return this.plan;
    }

    private void toXML(DescriptorBean descriptorBean, OutputStream outputStream) throws IOException {
        new EditableDescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    WebLogicDConfigBeanRoot initDConfig(DDBeanRoot dDBeanRoot, String string, DescriptorSupport descriptorSupport) throws InvalidModuleException, IOException {
        WebLogicDConfigBeanRoot webLogicDConfigBeanRoot = null;
        String string2 = null;
        try {
            boolean bl;
            block17: {
                String string3 = descriptorSupport.getConfigURI();
                DeployableObject deployableObject = dDBeanRoot.getDeployableObject();
                if (debug) {
                    Debug.say("looking for " + string + " on dobj: " + deployableObject);
                }
                if (!(deployableObject instanceof WebLogicDeployableObject)) return webLogicDConfigBeanRoot;
                bl = false;
                WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)deployableObject;
                if (webLogicDeployableObject.hasDDBean(string3)) {
                    DDBeanRootImpl dDBeanRootImpl = (DDBeanRootImpl)webLogicDeployableObject.getDDBeanRoot(string3);
                    if (debug) {
                        Debug.say("Getting DConfig information from ddroot :\n" + dDBeanRootImpl + " of type: " + dDBeanRootImpl.getType());
                    }
                    DescriptorBean descriptorBean = dDBeanRootImpl.getDescriptorBean();
                    string2 = this.convertImplToDConfig(descriptorBean);
                    if (debug) {
                        Debug.say("will create new " + dDBeanRootImpl.getType() + " dcb, " + string + ", of class, " + string2 + " with existing bean");
                    }
                    webLogicDConfigBeanRoot = this.constructDCB(dDBeanRoot, descriptorBean, string2, string, descriptorSupport);
                    InputStream inputStream = null;
                    try {
                        inputStream = deployableObject.getEntry(string3);
                        if (inputStream == null) {
                            bl = true;
                        }
                        Object var14_15 = null;
                        if (inputStream == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                } else {
                    string2 = descriptorSupport.getDConfigClassName();
                    if (debug) {
                        Debug.say("will create new dcb, " + string + ", of class, " + string2);
                    }
                    webLogicDConfigBeanRoot = this.constructDCB(dDBeanRoot, null, string2, string, descriptorSupport);
                    bl = true;
                }
            }
            webLogicDConfigBeanRoot.setExternal(bl);
            if (webLogicDConfigBeanRoot.getDescriptorBean() == null) return webLogicDConfigBeanRoot;
            ((BasicDConfigBeanRoot)webLogicDConfigBeanRoot).registerAsListener(webLogicDConfigBeanRoot.getDescriptorBean());
            return webLogicDConfigBeanRoot;
        }
        catch (Throwable throwable) {
            if (throwable instanceof InvalidModuleException) {
                throw (InvalidModuleException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (debug) {
                throwable.printStackTrace();
            }
            InvalidModuleException invalidModuleException = new InvalidModuleException(SPIDeployerLogger.invalidClass(string2, (String)throwable.toString()));
            invalidModuleException.initCause(throwable);
            throw invalidModuleException;
        }
    }

    private String convertImplToDConfig(DescriptorBean descriptorBean) {
        String string = descriptorBean.toString();
        if (string.indexOf("Impl") != -1) {
            string = string.substring(0, string.indexOf("Impl"));
        }
        return string + "DConfig";
    }

    private String getNameFromUri(String string) {
        return string;
    }

    private void initEAR() {
        DeployableObject[] deployableObjectArray = ((J2eeApplicationObject)this.dObject).getDeployableObjects();
        String[] stringArray = ((J2eeApplicationObject)this.dObject).getModuleUris();
        if (deployableObjectArray == null || stringArray == null) {
            return;
        }
        for (int i = 0; i < deployableObjectArray.length; ++i) {
            DeployableObject deployableObject;
            this.dObjects.add(deployableObjectArray[i]);
            if (debug) {
                Debug.say("initing roots for " + this.getNameFromUri(stringArray[i]) + " with uri " + stringArray[i]);
            }
            DDBeanRoot dDBeanRoot = deployableObjectArray[i].getDDBeanRoot();
            ModuleType moduleType = dDBeanRoot.getDeployableObject().getType();
            DeployableObjectKey deployableObjectKey = new DeployableObjectKey(this.getNameFromUri(stringArray[i]), moduleType);
            if (moduleType == ModuleType.WAR && (deployableObject = dDBeanRoot.getDeployableObject()) instanceof WebLogicDeployableObject) {
                WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)deployableObject;
                deployableObjectKey.setContextRoot(webLogicDeployableObject.getContextRoot());
            }
            this.rootMap.put(deployableObjectKey, dDBeanRoot);
            this.ddBeanRoots.put(dDBeanRoot, null);
        }
    }

    private void initSCA() {
        ScaApplicationObject scaApplicationObject = (ScaApplicationObject)this.dObject;
        DeployableObject[] deployableObjectArray = scaApplicationObject.getDeployableObjects();
        if (deployableObjectArray == null) {
            return;
        }
        for (int i = 0; i < deployableObjectArray.length; ++i) {
            WebLogicDeployableObject webLogicDeployableObject;
            ModuleType moduleType;
            if (!(deployableObjectArray[i] instanceof WebLogicDeployableObject) || (moduleType = (webLogicDeployableObject = (WebLogicDeployableObject)deployableObjectArray[i]).getType()) != ModuleType.WAR && moduleType != ModuleType.EJB) continue;
            this.dObjects.add(webLogicDeployableObject);
            String string = webLogicDeployableObject.getUri();
            DeployableObjectKey deployableObjectKey = new DeployableObjectKey(this.getNameFromUri(string), moduleType);
            if (moduleType == ModuleType.WAR) {
                deployableObjectKey.setContextRoot(webLogicDeployableObject.getContextRoot());
            }
            DDBeanRoot dDBeanRoot = webLogicDeployableObject.getDDBeanRoot();
            this.rootMap.put(deployableObjectKey, dDBeanRoot);
            this.ddBeanRoots.put(dDBeanRoot, null);
        }
    }

    private void initialize() throws IOException, InvalidModuleException {
        Object object;
        Object object2;
        File file = null;
        this.appName = null;
        if (this.plan != null) {
            object2 = this.plan.findRootModule();
            if (object2 != null) {
                this.appName = object2.getModuleName();
            } else if (this.dObject instanceof WebLogicDeployableObject) {
                object = (WebLogicDeployableObject)this.dObject;
                this.appName = ((WebLogicDeployableObject)object).getArchive().getName();
            } else {
                this.appName = this.plan.getApplicationName();
            }
            file = ConfigHelper.getAppRootFromPlan(this.plan);
        }
        if (file == null && this.dObject instanceof WebLogicDeployableObject) {
            object2 = (WebLogicDeployableObject)this.dObject;
            this.appName = ((WebLogicDeployableObject)object2).getArchive().getName();
            file = ((WebLogicDeployableObject)object2).getInstallDirPath();
        }
        if (this.appName == null) {
            this.appName = "MyApp";
        }
        if (debug) {
            Debug.say("initing roots with " + this.appName);
        }
        if (this.dObject instanceof ScaApplicationObject) {
            this.initSCA();
        } else {
            this.dObjects.add(this.dObject);
            object2 = new DeployableObjectKey(this.appName, this.dObject.getType());
            if (this.dObject.getType() == ModuleType.WAR && this.dObject instanceof WebLogicDeployableObject) {
                object = (WebLogicDeployableObject)this.dObject;
                ((DeployableObjectKey)object2).setContextRoot(((WebLogicDeployableObject)object).getContextRoot());
            }
            this.rootMap.put(object2, this.dObject.getDDBeanRoot());
            this.ddBeanRoots.put(this.dObject.getDDBeanRoot(), null);
            if (this.dObject instanceof J2eeApplicationObject) {
                this.initEAR();
            }
        }
        this.installDir = new InstallDir(this.appName, file);
        this.initPlanArtifacts();
        if (this.plan != null) {
            try {
                this.genDConfigBeans();
            }
            catch (ConfigurationException configurationException) {
                if (debug) {
                    configurationException.printStackTrace();
                }
                object = new InvalidModuleException(configurationException.getMessage());
                object.initCause((Throwable)configurationException);
                throw object;
            }
        }
    }

    private void initPlanArtifacts() {
        if (this.plan != null) {
            ConfigHelper.initPlanDirFromPlan(this.plan, this.installDir);
            this.registerListener(this.plan);
        }
    }

    private void registerListener(DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean != null) {
            this.getDescriptorHelper().addPropertyChangeListener((DescriptorBean)deploymentPlanBean, (PropertyChangeListener)this);
        }
    }

    private DescriptorHelper getDescriptorHelper() {
        if (this.ddhelper == null) {
            this.ddhelper = DescriptorHelper.getInstance();
        }
        return this.ddhelper;
    }

    private DeploymentPlanBean parsePlan(InputStream inputStream) throws ConfigurationException {
        try {
            return DescriptorParser.parseDeploymentPlan(inputStream);
        }
        catch (IOException iOException) {
            Throwable throwable = ManagementException.unWrapExceptions((Throwable)iOException);
            ConfigurationException configurationException = new ConfigurationException(SPIDeployerLogger.badPlan((String)throwable.getMessage()));
            configurationException.initCause(throwable);
            throw configurationException;
        }
    }

    private void genDConfigBeans() throws ConfigurationException {
        for (DDBeanRoot dDBeanRoot : this.ddBeanRoots.keySet()) {
            DConfigBeanRoot dConfigBeanRoot = this.getDConfigBeanRoot(dDBeanRoot);
            this.collectSecondaryConfig((WebLogicDConfigBeanRoot)dConfigBeanRoot);
        }
    }

    private void collectSecondaryConfig(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot) throws ConfigurationException {
        int n;
        DeployableObject deployableObject = webLogicDConfigBeanRoot.getDDBean().getRoot().getDeployableObject();
        if (debug) {
            Debug.say("checking for secondary dd's for " + deployableObject.getType().toString() + ":" + webLogicDConfigBeanRoot.getDConfigName());
        }
        DescriptorSupport descriptorSupport = null;
        DescriptorSupport[] descriptorSupportArray = DescriptorSupportManager.getForModuleType(deployableObject.getType());
        for (n = 0; n < descriptorSupportArray.length; ++n) {
            descriptorSupport = descriptorSupportArray[n];
            if (descriptorSupport.isPrimary()) continue;
            if (debug) {
                Debug.say("found secondary dd candidate: " + descriptorSupport.toString());
            }
            if (descriptorSupport.getBaseTag().equals("weblogic-rdbms-jar")) {
                this.collectSecondaryEjbConfig(webLogicDConfigBeanRoot, deployableObject);
                continue;
            }
            if (!this.filterByType(descriptorSupport)) continue;
            this.addSecondaryModule(deployableObject, webLogicDConfigBeanRoot, descriptorSupport, false);
        }
        this.collectWlsModules(webLogicDConfigBeanRoot, deployableObject);
        if (ModuleType.EJB.equals(deployableObject.getType()) || ModuleType.WAR.equals(deployableObject.getType())) {
            descriptorSupportArray = DescriptorSupportManager.getForModuleType(WebLogicModuleType.WSEE);
            for (n = 0; n < descriptorSupportArray.length; ++n) {
                descriptorSupport = descriptorSupportArray[n];
                if ((!ModuleType.EJB.equals(deployableObject.getType()) || !descriptorSupport.getConfigURI().startsWith("META-INF")) && (!ModuleType.WAR.equals(deployableObject.getType()) || !descriptorSupport.getConfigURI().startsWith("WEB-INF")) || !this.checkForDepenedentDD(deployableObject, descriptorSupport)) continue;
                this.addSecondaryModule(deployableObject, webLogicDConfigBeanRoot, descriptorSupport, false);
            }
        }
        if (ModuleType.EAR.equals(deployableObject.getType()) || ModuleType.WAR.equals(deployableObject.getType())) {
            descriptorSupportArray = DescriptorSupportManager.getForModuleType(WebLogicModuleType.CONFIG);
            for (n = 0; n < descriptorSupportArray.length; ++n) {
                descriptorSupport = descriptorSupportArray[n];
                if (debug) {
                    Debug.say("Adding secondary module to wdo : " + deployableObject + " at " + descriptorSupport.getBaseURI());
                }
                this.addSecondaryModule(deployableObject, webLogicDConfigBeanRoot, descriptorSupport, false);
            }
        }
        this.collectPersistenceDescriptors(webLogicDConfigBeanRoot);
    }

    private void collectPersistenceDescriptors(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot) throws ConfigurationException {
        WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)webLogicDConfigBeanRoot.getDDBean().getRoot().getDeployableObject();
        ArrayList<String> arrayList = Collections.list(webLogicDeployableObject.getDDResourceEntries("META-INF/persistence.xml"));
        ArrayList arrayList2 = Collections.list(webLogicDeployableObject.getDDResourceEntries("META-INF/persistence-configuration.xml"));
        if (arrayList.isEmpty()) {
            return;
        }
        for (String string : arrayList) {
            String string2 = this.getPersistenceConfigURI(string);
            DescriptorSupport descriptorSupport = this.getDescriptorSupportforPersistenceArchive(webLogicDeployableObject.getType(), string, string2);
            this.addSecondaryModule(webLogicDeployableObject, webLogicDConfigBeanRoot, descriptorSupport, false);
        }
    }

    private DescriptorSupport getDescriptorSupportforPersistenceArchive(ModuleType moduleType, String string, String string2) {
        return new DescriptorSupport(moduleType, "persistence", "persistence-configuration", "http://java.sun.com/xml/ns/persistence", "http://bea.com/ns/weblogic/950/persistence", string, string2, "weblogic.j2ee.descriptor.PersistenceBean", "kodo.jdbc.conf.descriptor.PersistenceConfigurationBean", "kodo.jdbc.conf.descriptor.PersistenceConfigurationBeanDConfig", false);
    }

    private String getPersistenceConfigURI(String string) {
        String string2 = string.substring(0, string.length() - "META-INF/persistence.xml".length());
        return string2 + "META-INF/persistence-configuration.xml";
    }

    private boolean checkForDepenedentDD(DeployableObject deployableObject, DescriptorSupport descriptorSupport) {
        if (deployableObject instanceof WebLogicDeployableObject) {
            WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)deployableObject;
            try {
                if (descriptorSupport.getConfigURI().equals("META-INF/weblogic-webservices-policy.xml")) {
                    return webLogicDeployableObject.hasDDBean("META-INF/weblogic-webservices.xml");
                }
                if (descriptorSupport.getConfigURI().equals("WEB-INF/weblogic-webservices-policy.xml")) {
                    return webLogicDeployableObject.hasDDBean("WEB-INF/weblogic-webservices.xml");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    private void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addSecondaryModule(DeployableObject deployableObject, WebLogicDConfigBeanRoot webLogicDConfigBeanRoot, DescriptorSupport descriptorSupport, boolean bl) throws ConfigurationException {
        String string = descriptorSupport.getBaseURI();
        try {
            DDBeanRoot dDBeanRoot;
            DConfigBean dConfigBean;
            if (debug) {
                Debug.say("linking secondary dd at " + string + " on " + deployableObject);
            }
            if ((dConfigBean = webLogicDConfigBeanRoot.getDConfigBean(dDBeanRoot = this.getOrCreateDDBeanRoot(deployableObject, webLogicDConfigBeanRoot, string), descriptorSupport)) != null) {
                this.addToPlan((WebLogicDConfigBeanRoot)dConfigBean);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl) {
                Loggable loggable = SPIDeployerLogger.logMissingDDLoggable((String)string, (String)descriptorSupport.getModuleType().toString());
                throw new ConfigurationException(loggable.getMessage());
            }
            if (debug) {
                Debug.say("no dd found or created for " + string + ": " + fileNotFoundException.toString());
            }
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            throw new ConfigurationException(SPIDeployerLogger.getDDBeanCreateError((String)string, (String)dDBeanCreateException.getMessage()));
        }
    }

    private DDBeanRoot getOrCreateDDBeanRoot(DeployableObject deployableObject, WebLogicDConfigBeanRoot webLogicDConfigBeanRoot, String string) throws FileNotFoundException, DDBeanCreateException {
        DDBeanRoot dDBeanRoot;
        block9: {
            dDBeanRoot = null;
            try {
                dDBeanRoot = deployableObject.getDDBeanRoot(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                DescriptorSupport descriptorSupport;
                if (debug) {
                    Debug.say("Could not get the DDBean root for " + deployableObject + " at uri: " + string);
                }
                if ((descriptorSupport = DescriptorSupportManager.getForceWriteDS(string)) == null) break block9;
                if (debug) {
                    Debug.say("Creating dd for " + string);
                }
                try {
                    String string2 = descriptorSupport.getStandardClassName();
                    string2 = string2.substring(0, string2.length() - 4);
                    DescriptorBean descriptorBean = DescriptorParser.getWLSEditableDescriptorBean(Class.forName(string2));
                    this.writeDDToPlanDir(webLogicDConfigBeanRoot, string, descriptorBean);
                    dDBeanRoot = deployableObject.getDDBeanRoot(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new FileNotFoundException(string);
                }
                catch (IOException iOException) {
                    if (iOException instanceof FileNotFoundException) {
                        throw (FileNotFoundException)iOException;
                    }
                    throw new FileNotFoundException(string);
                }
            }
        }
        if (dDBeanRoot == null) {
            throw new FileNotFoundException(string);
        }
        return dDBeanRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File writeDDToPlanDir(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot, String string, DescriptorBean descriptorBean) throws IOException {
        File file;
        FileOutputStream fileOutputStream = null;
        try {
            file = this.dObject == webLogicDConfigBeanRoot.getDDBean().getRoot().getDeployableObject() ? this.installDir.getAppDDFile(string) : this.installDir.getDDFile(webLogicDConfigBeanRoot.getDConfigName(), string);
            fileOutputStream = this.installDir.getOutputStream(file);
            this.toXML(descriptorBean, fileOutputStream);
            this.extDDWrite = true;
            Object var7_6 = null;
            if (fileOutputStream == null) return file;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
        return file;
    }

    private void collectWlsModules(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot, DeployableObject deployableObject) throws ConfigurationException {
        DescriptorSupport descriptorSupport = DescriptorSupportManager.getForModuleType(WebLogicModuleType.WLDF)[0];
        this.addSecondaryModule(deployableObject, webLogicDConfigBeanRoot, descriptorSupport, false);
        if (deployableObject instanceof J2eeApplicationObject) {
            WeblogicModuleBean[] weblogicModuleBeanArray = ((WeblogicApplicationBean)webLogicDConfigBeanRoot.getDescriptorBean()).getModules();
            descriptorSupport = null;
            if (weblogicModuleBeanArray == null) {
                return;
            }
            for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
                WeblogicModuleBean weblogicModuleBean = weblogicModuleBeanArray[i];
                String string = weblogicModuleBean.getType();
                String string2 = weblogicModuleBean.getPath();
                if ("JDBC".equals(string)) {
                    descriptorSupport = DescriptorSupportManager.getForTag("jdbc-data-source");
                } else if ("JMS".equals(string)) {
                    descriptorSupport = DescriptorSupportManager.getForTag("weblogic-jms");
                } else if ("Interception".equals(string)) {
                    descriptorSupport = DescriptorSupportManager.getForTag("weblogic-interception");
                } else {
                    throw new AssertionError((Object)("ERROR: A module of unknown type " + string + " was found"));
                }
                descriptorSupport.setBaseURI(string2);
                descriptorSupport.setConfigURI(string2);
                if (string2 == null) continue;
                this.addSecondaryModule(deployableObject, webLogicDConfigBeanRoot, descriptorSupport, true);
            }
        }
    }

    private void collectSecondaryEjbConfig(WebLogicDConfigBeanRoot webLogicDConfigBeanRoot, DeployableObject deployableObject) throws ConfigurationException {
        WeblogicEjbJarBean weblogicEjbJarBean = (WeblogicEjbJarBean)webLogicDConfigBeanRoot.getDescriptorBean();
        WeblogicEnterpriseBeanBean[] weblogicEnterpriseBeanBeanArray = weblogicEjbJarBean.getWeblogicEnterpriseBeans();
        if (weblogicEnterpriseBeanBeanArray == null) {
            return;
        }
        for (int i = 0; i < weblogicEnterpriseBeanBeanArray.length; ++i) {
            PersistenceUseBean persistenceUseBean;
            PersistenceBean persistenceBean;
            DescriptorSupport descriptorSupport = null;
            EntityDescriptorBean entityDescriptorBean = weblogicEnterpriseBeanBeanArray[i].getEntityDescriptor();
            if (entityDescriptorBean == null || (persistenceBean = entityDescriptorBean.getPersistence()) == null || (persistenceUseBean = persistenceBean.getPersistenceUse()) == null) continue;
            String string = persistenceUseBean.getTypeIdentifier();
            if (debug) {
                Debug.say("checking pu: " + string);
            }
            if ("WebLogic_CMP_RDBMS".equals(string)) {
                descriptorSupport = DescriptorSupportManager.getForSecondaryTag("weblogic-rdbms-jar")[0];
            }
            if (descriptorSupport == null || persistenceUseBean.getTypeStorage() == null) continue;
            if (debug) {
                Debug.say("changing TypeStorage to " + persistenceUseBean.getTypeStorage());
            }
            descriptorSupport.setBaseURI(persistenceUseBean.getTypeStorage());
            descriptorSupport.setConfigURI(persistenceUseBean.getTypeStorage());
            if ("5.1.0".equals(persistenceUseBean.getTypeVersion())) {
                descriptorSupport.setBaseNameSpace("http://www.bea.com/ns/weblogic/60");
                descriptorSupport.setConfigNameSpace("http://www.bea.com/ns/weblogic/60");
                descriptorSupport.setStandardClassName("weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBeanImpl");
                descriptorSupport.setConfigClassName("weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBeanImpl");
                descriptorSupport.setDConfigClassName("weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBeanDConfig");
            }
            DescriptorSupportManager.add(descriptorSupport);
            this.addSecondaryModule(deployableObject, webLogicDConfigBeanRoot, descriptorSupport, true);
        }
    }

    private boolean filterByType(DescriptorSupport descriptorSupport) {
        return descriptorSupport.getModuleType().getValue() != WebLogicModuleType.CONFIG.getValue();
    }

    private void removeSecondaryDConfigBean(DConfigBean dConfigBean) throws BeanNotFoundException {
    }

    String getRootTag(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        String string = dDBeanRoot.getXpath();
        if (!"/".equals(string)) {
            throw new IllegalArgumentException(SPIDeployerLogger.badRootBean((String)dDBeanRoot.toString()));
        }
        DescriptorSupport[] descriptorSupportArray = DescriptorSupportManager.getForModuleType(dDBeanRoot.getType());
        if (descriptorSupportArray == null || descriptorSupportArray.length == 0) {
            throw new ConfigurationException(SPIDeployerLogger.noTagRegistered((String)dDBeanRoot.getType().toString()));
        }
        if (descriptorSupportArray.length == 1) {
            return descriptorSupportArray[0].getBaseTag();
        }
        for (int i = 0; i < descriptorSupportArray.length; ++i) {
            String string2 = ConfigHelper.getNSPrefix((DDBean)dDBeanRoot, descriptorSupportArray[i].getBaseNameSpace());
            DDBean[] dDBeanArray = dDBeanRoot.getChildBean(ConfigHelper.applyNamespace(string2, descriptorSupportArray[i].getBaseTag()));
            if (dDBeanArray == null) continue;
            return descriptorSupportArray[i].getBaseTag();
        }
        if (dDBeanRoot.getType() == ModuleType.EJB) {
            return DescriptorSupportManager.EJB_DESC_SUPPORT.getBaseTag();
        }
        WebLogicDeployableObject webLogicDeployableObject = (WebLogicDeployableObject)dDBeanRoot.getDeployableObject();
        throw new ConfigurationException(SPIDeployerLogger.noTagFound((String)dDBeanRoot.getType().toString(), (String)webLogicDeployableObject.getUri(), (String)dDBeanRoot.getFilename()));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ConfigRoot".equals(string)) {
            File file = null;
            if (this.plan.getConfigRoot() != null) {
                file = new File(this.plan.getConfigRoot()).getAbsoluteFile();
                file.mkdirs();
            }
            if (file == null || file.exists() && file.isDirectory()) {
                this.installDir.setConfigDir(file);
            } else if (debug) {
                Debug.say("Ignoring invalid change to config root: " + this.plan.getConfigRoot());
            }
        }
    }
}

