/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.application.descriptor.NamespaceURIMunger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.ejb.spi.XMLConstants;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.management.ManagementException;
import weblogic.utils.io.StreamUtils;
import weblogic.utils.io.UnsyncByteArrayInputStream;

public class DescriptorParser {
    private static final boolean ddebug = Debug.isDebug("utils");
    private static final String VERSION = "version";
    private Document doc = null;
    private final ByteArrayCache ddStreamCache;
    private String version = null;
    private boolean hasSchema = true;
    private static EditableDescriptorManager edm = null;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private DescriptorSupport ds;
    private DeploymentPlanBean plan = null;
    private File configDir = null;
    File ddFile = null;
    private static Map map = new HashMap();

    public DescriptorSupport getDescriptorSupport() {
        return this.ds;
    }

    private DescriptorParser(InputStream inputStream, DeploymentPlanBean deploymentPlanBean, DescriptorSupport descriptorSupport) throws IOException {
        this.plan = deploymentPlanBean;
        if (inputStream == null) {
            throw new IOException("Valid Stream is required for descriptor");
        }
        this.ddStreamCache = new ByteArrayCache(inputStream);
        this.ds = descriptorSupport;
        this.checkDocType();
        this.configDir = ConfigHelper.getConfigRootFile(deploymentPlanBean);
    }

    public final InputStream getDDStream() {
        return this.ddStreamCache.getInputStream();
    }

    private static void init() {
        if (edm != null) {
            return;
        }
        edm = new EditableDescriptorManager();
    }

    public static DescriptorParser getDescriptorParser(InputStream inputStream, DeploymentPlanBean deploymentPlanBean, DescriptorSupport descriptorSupport) throws IOException {
        return new DescriptorParser(inputStream, deploymentPlanBean, descriptorSupport);
    }

    public static DescriptorBean getWLSEditableDescriptorBean(Class clazz) {
        return edm.createDescriptorRoot(clazz, DEFAULT_ENCODING).getRootBean();
    }

    public static DeploymentPlanBean parseDeploymentPlan(InputStream inputStream) throws IOException {
        try {
            String[] stringArray = new String[]{"http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/deployment-plan"};
            return (DeploymentPlanBean)edm.createDescriptor((XMLStreamReader)new NamespaceURIMunger(inputStream, "http://xmlns.oracle.com/weblogic/deployment-plan", stringArray), false).getRootBean();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Document getDocument() throws IOException {
        block18: {
            if (this.doc != null) {
                return this.doc;
            }
            var1_1 = null;
            var2_2 = null;
            try {
                block17: {
                    var2_2 = this.getDDStream();
                    var3_3 = DocumentBuilderFactory.newInstance();
                    if (var3_3 == null) break block17;
                    var4_6 = new InputSource(var2_2);
                    var3_3.setNamespaceAware(true);
                    var3_3.setCoalescing(true);
                    var3_3.setIgnoringElementContentWhitespace(true);
                    var3_3.setValidating(false);
                    var5_7 = var3_3.newDocumentBuilder();
                    var5_7.setEntityResolver(new MyEntityResolver());
                    this.doc = var5_7.parse((InputSource)var4_6);
                    this.setDocumentVersion(this.doc);
                }
                var7_8 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var6_16) {
                var7_11 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var8_15) {
                        // empty catch block
                    }
                }
                throw var6_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (IOException var8_12) {}
            }
lbl-1000:
            // 2 sources

            {
                break block18;
                catch (SAXException var3_4) {
                    var1_1 = var3_4;
                    var7_9 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var8_13) {}
                    }
                    break block18;
                }
                catch (ParserConfigurationException var3_5) {
                    var1_1 = var3_5;
                    var7_10 = null;
                    if (var2_2 != null) {
                        try {
                            var2_2.close();
                        }
                        catch (IOException var8_14) {}
                    }
                }
            }
        }
        if (var1_1 != null) {
            if (DescriptorParser.ddebug) {
                var1_1.printStackTrace();
            }
            var3_3 = ManagementException.unWrapExceptions((Throwable)var1_1);
            var4_6 = new IOException(var3_3.toString());
            var4_6.initCause((Throwable)var3_3);
            throw var4_6;
        }
        return this.doc;
    }

    private void setDocumentVersion(Document document) {
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            String string = documentType.getPublicId();
            if (string != null) {
                int n;
                int n2;
                for (n2 = n = string.lastIndexOf("//"); string.charAt(n2) != ' ' && n2 != 0; --n2) {
                }
                if (n2 != 0) {
                    this.version = string.substring(n2 + 1, n);
                }
            }
        } else {
            Element element = document.getDocumentElement();
            this.version = element.getAttribute(VERSION);
        }
        if (ddebug) {
            Debug.say("doc version set to " + this.version + ". isSchema: " + this.hasSchema);
        }
    }

    public String getDocumentVersion() {
        return this.version;
    }

    public boolean isSchemaBased() {
        return this.hasSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkDocType() throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getDDStream();
            byte[] byArray = new byte[1024];
            inputStream.read(byArray, 0, 1024);
            String string = new String(byArray);
            if (string.indexOf("DOCTYPE") != -1) {
                this.hasSchema = false;
            }
            Object var5_4 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public DeploymentPlanBean getDeploymentPlan() {
        return this.plan;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (inputStream == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamUtils.writeTo((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (ddebug) {
                Debug.say(" +++ getBytes = " + new String(byArray2));
            }
            byArray = byArray2;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    static {
        map.putAll(XMLConstants.locations);
        map.put("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "/weblogic/connector/configuration/connector_1_0.dtd");
        map.put("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "/weblogic/j2eeclient/application-client_1_3.dtd");
        map.put("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN", "/weblogic/j2eeclient/application-client_1_2.dtd");
        map.put("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "/weblogic/j2ee/dd/xml/application_1_2.dtd");
        map.put("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "/weblogic/j2ee/dd/xml/application_1_3.dtd");
        map.put("-//Sun Microsystems, Inc.//DTD Web Application 1.2//EN", "/weblogic/servlet/internal/dd/web-jar.dtd");
        map.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/weblogic/servlet/internal/dd/web-jar.dtd");
        map.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/weblogic/servlet/internal/dd/web-jar-23.dtd");
        try {
            DescriptorParser.init();
        }
        catch (Exception exception) {
            if (ddebug) {
                exception.printStackTrace();
            }
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static class ByteArrayCache {
        private final ByteBuffer byteBuffer;
        private final int size;
        private SoftReference cache;

        ByteArrayCache(byte[] byArray) {
            this.size = byArray.length;
            this.byteBuffer = ByteBuffer.allocateDirect(this.size);
            this.byteBuffer.put(byArray);
            this.cache = new SoftReference<byte[]>(byArray);
        }

        ByteArrayCache(InputStream inputStream) throws IOException {
            this(DescriptorParser.readStream(inputStream));
        }

        InputStream getInputStream() {
            return new UnsyncByteArrayInputStream(this.getBytes());
        }

        byte[] getBytes() {
            byte[] byArray = (byte[])this.cache.get();
            if (byArray != null) {
                return byArray;
            }
            byArray = new byte[this.size];
            this.byteBuffer.rewind();
            this.byteBuffer.get(byArray, 0, this.size);
            this.cache = new SoftReference<byte[]>(byArray);
            return byArray;
        }

        long length() {
            return this.size;
        }
    }

    public class MyEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) {
            InputSource inputSource = null;
            String string3 = (String)map.get(string);
            if (ddebug) {
                Debug.say("local dtd for " + string + " is " + string3);
            }
            if (string3 != null) {
                InputStream inputStream = this.getClass().getResourceAsStream(string3);
                if (inputStream == null) {
                    string3 = string3.substring(1);
                    if (ddebug) {
                        Debug.say("now trying " + string3);
                    }
                    inputStream = this.getClass().getResourceAsStream(string3);
                }
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                }
            }
            return inputSource;
        }
    }
}

