/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.descriptor.beangen.XMLHelper;
import weblogic.j2ee.descriptor.wl.ConfigurationSupportBean;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;

public class DescriptorSupportManager {
    private static List ddSupport = new ArrayList();
    private static final boolean debug = Debug.isDebug("config");
    public static final String WEB_ROOT = "web-app";
    public static final String WLS_WEB_ROOT = "weblogic-web-app";
    public static final String WEB_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String WLS_WEB_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String WEB_URI = "WEB-INF/web.xml";
    public static final String WLS_WEB_URI = "WEB-INF/weblogic.xml";
    public static final String EAR_ROOT = "application";
    public static final String WLS_EAR_ROOT = "weblogic-application";
    public static final String EAR_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String WLS_EAR_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String EAR_URI = "META-INF/application.xml";
    public static final String WLS_EAR_URI = "META-INF/weblogic-application.xml";
    public static final String EJB_ROOT = "ejb-jar";
    public static final String WLS_EJB_ROOT = "weblogic-ejb-jar";
    public static final String EJB_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String WLS_EJB_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String EJB_URI = "META-INF/ejb-jar.xml";
    public static final String WLS_EJB_URI = "META-INF/weblogic-ejb-jar.xml";
    public static final String RAR_ROOT = "connector";
    public static final String WLS_RAR_ROOT = "weblogic-connector";
    public static final String RAR_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String WLS_RAR_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String RAR_URI = "META-INF/ra.xml";
    public static final String WLS_RAR_URI = "META-INF/weblogic-ra.xml";
    public static final String CAR_ROOT = "application-client";
    public static final String WLS_CAR_ROOT = "weblogic-application-client";
    public static final String CAR_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String WLS_CAR_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String CAR_URI = "META-INF/application-client.xml";
    public static final String WLS_CAR_URI = "META-INF/weblogic-application-client.xml";
    public static final String WLS_CMP_ROOT = "weblogic-rdbms-jar";
    public static final String WLS_CMP_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String WLS_CMP_URI = "META-INF/weblogic-cmp-rdbms-jar.xml";
    public static final String WLS_CMP11_ROOT = "weblogic-rdbms-jar";
    public static final String WLS_CMP11_NAMESPACE = "http://www.bea.com/ns/weblogic/60";
    public static final String WLS_CMP11_URI = "META-INF/weblogic-cmp-rdbms-jar.xml";
    public static final String WLS_CMP11_CLASS = "weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBeanImpl";
    public static final String WLS_CMP11_DCONFIGCLASS = "weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBeanDConfig";
    public static final String WLS_CMP11_CONFIGCLASS = "weblogic.j2ee.descriptor.wl60.WeblogicRdbmsJarBeanImpl";
    public static final String WLS_JMS_ROOT = "weblogic-jms";
    public static final String WLS_JMS_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String WLS_JDBC_ROOT = "jdbc-data-source";
    public static final String WLS_JDBC_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String WLS_INTERCEPT_ROOT = "weblogic-interception";
    public static final String WLS_INTERCEPT_NAMESPACE = "http://www.bea.com/ns/weblogic/90";
    public static final String WSEE_ROOT_81 = "web-services";
    public static final String WSEE_ROOT = "webservices";
    public static final String WLS_WSEE_ROOT = "weblogic-webservices";
    public static final String WSEE_WEB_URI_81 = "WEB-INF/web-services.xml";
    public static final String WSEE_EJB_URI_81 = "META-INF/web-services.xml";
    public static final String WSEE_WEB_URI = "WEB-INF/webservices.xml";
    public static final String WSEE_EJB_URI = "META-INF/webservices.xml";
    public static final String WLS_WSEE_WEB_URI = "WEB-INF/weblogic-webservices.xml";
    public static final String WLS_WSEE_EJB_URI = "META-INF/weblogic-webservices.xml";
    public static final String WLS_WS_POLICY_WEB_URI = "WEB-INF/weblogic-webservices-policy.xml";
    public static final String WLS_WS_POLICY_EJB_URI = "META-INF/weblogic-webservices-policy.xml";
    public static final String PERSISTENCE_ROOT = "persistence";
    public static final String WLS_PERSISTENCE_ROOT = "persistence-configuration";
    public static final String PERSISTENCE_URI = "META-INF/persistence.xml";
    public static final String WLS_PERSISTENCE_URI = "META-INF/persistence-configuration.xml";
    public static final String PERSISTENCE_NAMESPACE = "http://java.sun.com/xml/ns/persistence";
    public static final String WLS_PERSISTENCE_NAMESPACE = "http://bea.com/ns/weblogic/950/persistence";
    public static final String PERSISTENCE_BEAN_CLASS = "weblogic.j2ee.descriptor.PersistenceBean";
    public static final String WLS_PERSISTENCE_BEAN_CLASS = "kodo.jdbc.conf.descriptor.PersistenceConfigurationBean";
    public static final String WLS_PERSISTENCE_DCONFIG_CLASS = "kodo.jdbc.conf.descriptor.PersistenceConfigurationBeanDConfig";
    public static final String WLS_WLDF_ROOT = "wldf-resource";
    public static final String WLS_WLDF_NAMESPACE = "java:weblogic.diagnostics.descriptor";
    public static final String WLS_WLDF_URI = "META-INF/weblogic-diagnostics.xml";
    public static final String WLS_WLDF_BEAN_CLASS = "weblogic.diagnostics.descriptor.WLDFResourceBeanImpl";
    public static final String WLS_WLDF_DCONFIG_CLASS = "weblogic.diagnostics.descriptor.WLDFResourceBeanDConfig";
    private static Map forceWrites = new HashMap();
    public static final String WLS_EAR_EXT_URI = "META-INF/weblogic-extension.xml";
    public static final String WLS_WEB_EXT_URI = "WEB-INF/weblogic-extension.xml";
    public static final DescriptorSupport EJB_DESC_SUPPORT = new DescriptorSupport(ModuleType.EJB, "ejb-jar", "weblogic-ejb-jar", "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", "META-INF/ejb-jar.xml", "META-INF/weblogic-ejb-jar.xml", "weblogic.j2ee.descriptor.EjbJarBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicEjbJarBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicEjbJarBeanDConfig", true);

    public static void flush() {
        Iterator iterator = ddSupport.iterator();
        while (iterator.hasNext()) {
            DescriptorSupport descriptorSupport = (DescriptorSupport)iterator.next();
            if (!descriptorSupport.isFlush()) continue;
            if (debug) {
                Debug.say("removing DS: " + descriptorSupport.toString());
            }
            iterator.remove();
        }
    }

    public static void add(ModuleType moduleType, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        DescriptorSupportManager.add(new DescriptorSupport(moduleType, string, string2, string3, string4, string5, string6, string7, string8, string9, false));
    }

    public static void add(ModuleType moduleType, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        DescriptorSupportManager.add(moduleType, string, string2, string3, string4, string5, string6, DescriptorSupportManager.createImplClassName(string7, string), DescriptorSupportManager.createImplClassName(string8, string2), DescriptorSupportManager.createDConfigClassName(string8, string2));
    }

    public static void add(DescriptorSupport descriptorSupport) {
        if (!ddSupport.contains(descriptorSupport)) {
            descriptorSupport.setFlush(true);
            ddSupport.add(descriptorSupport);
        }
    }

    private static String createImplClassName(String string, String string2) {
        return string.concat("." + XMLHelper.toPropName((String)string2) + "BeanImpl");
    }

    private static String createDConfigClassName(String string, String string2) {
        return string.concat("." + XMLHelper.toPropName((String)string2) + "BeanDConfig");
    }

    public static DescriptorSupport getForTag(String string) {
        String string2 = DescriptorSupportManager.removeNamespace(string);
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (!descriptorSupport.isPrimary() || !descriptorSupport.getBaseTag().equals(string2)) continue;
            return DescriptorSupportManager.copy(descriptorSupport);
        }
        return null;
    }

    public static DescriptorSupport[] getForSecondaryTag(String string) {
        String string2 = DescriptorSupportManager.removeNamespace(string);
        ArrayList<DescriptorSupport> arrayList = new ArrayList<DescriptorSupport>();
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (descriptorSupport.isPrimary() || !descriptorSupport.getBaseTag().equals(string2)) continue;
            arrayList.add(DescriptorSupportManager.copy(descriptorSupport));
        }
        return arrayList.toArray(new DescriptorSupport[0]);
    }

    public static DescriptorSupport[] getForBaseURI(String string) {
        ArrayList<DescriptorSupport> arrayList = new ArrayList<DescriptorSupport>();
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (!descriptorSupport.getBaseURI().equals(string)) continue;
            arrayList.add(DescriptorSupportManager.copy(descriptorSupport));
        }
        return arrayList.toArray(new DescriptorSupport[0]);
    }

    private static String removeNamespace(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static DescriptorSupport[] getForModuleType(ModuleType moduleType) throws IllegalArgumentException {
        ArrayList<DescriptorSupport> arrayList = new ArrayList<DescriptorSupport>();
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (!descriptorSupport.getModuleType().equals(moduleType)) continue;
            arrayList.add(DescriptorSupportManager.copy(descriptorSupport));
        }
        return arrayList.toArray(new DescriptorSupport[0]);
    }

    public static DescriptorSupport getForDConfigClass(String string) throws IllegalArgumentException {
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (!descriptorSupport.getDConfigClassName().equals(string)) continue;
            return DescriptorSupportManager.copy(descriptorSupport);
        }
        return null;
    }

    public static DescriptorSupport getForConfigClass(String string) throws IllegalArgumentException {
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (!descriptorSupport.getConfigClassName().equals(string)) continue;
            return DescriptorSupportManager.copy(descriptorSupport);
        }
        return null;
    }

    public static DescriptorSupport getForStandardClass(String string) throws IllegalArgumentException {
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (!descriptorSupport.getStandardClassName().equals(string)) continue;
            return DescriptorSupportManager.copy(descriptorSupport);
        }
        return null;
    }

    public static DescriptorSupport getForClass(String string) throws IllegalArgumentException {
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (descriptorSupport.getStandardClassName().equals(string)) {
                return DescriptorSupportManager.copy(descriptorSupport);
            }
            if (!descriptorSupport.getDConfigClassName().equals(string)) continue;
            return DescriptorSupportManager.copy(descriptorSupport);
        }
        return null;
    }

    public static DescriptorSupport[] getForModuleType(String string) throws IllegalArgumentException {
        ArrayList<DescriptorSupport> arrayList = new ArrayList<DescriptorSupport>();
        for (DescriptorSupport descriptorSupport : ddSupport) {
            if (!descriptorSupport.getModuleType().toString().equals(string)) continue;
            arrayList.add(DescriptorSupportManager.copy(descriptorSupport));
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException(SPIDeployerLogger.unsupportedModuleType((String)string.toString()));
        }
        return arrayList.toArray(new DescriptorSupport[0]);
    }

    private static DescriptorSupport copy(DescriptorSupport descriptorSupport) {
        return new DescriptorSupport(descriptorSupport.getModuleType(), descriptorSupport.getBaseTag(), descriptorSupport.getConfigTag(), descriptorSupport.getBaseNameSpace(), descriptorSupport.getConfigNameSpace(), descriptorSupport.getBaseURI(), descriptorSupport.getConfigURI(), descriptorSupport.getStandardClassName(), descriptorSupport.getConfigClassName(), descriptorSupport.getDConfigClassName(), descriptorSupport.isPrimary());
    }

    private static void initDescriptorSupport() {
        try {
            ddSupport.add(new DescriptorSupport(ModuleType.WAR, WEB_ROOT, WLS_WEB_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", WEB_URI, WLS_WEB_URI, "weblogic.j2ee.descriptor.WebAppBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebAppBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebAppBeanDConfig", true));
            ddSupport.add(new DescriptorSupport(ModuleType.EAR, EAR_ROOT, WLS_EAR_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", EAR_URI, WLS_EAR_URI, "weblogic.j2ee.descriptor.ApplicationBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicApplicationBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicApplicationBeanDConfig", true));
            ddSupport.add(EJB_DESC_SUPPORT);
            ddSupport.add(new DescriptorSupport(ModuleType.RAR, RAR_ROOT, WLS_RAR_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", RAR_URI, WLS_RAR_URI, "weblogic.j2ee.descriptor.ConnectorBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicConnectorBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicConnectorBeanDConfig", true));
            ddSupport.add(new DescriptorSupport(ModuleType.CAR, CAR_ROOT, WLS_CAR_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", CAR_URI, WLS_CAR_URI, "weblogic.j2ee.descriptor.ApplicationClientBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicApplicationClientBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicApplicationClientBeanDConfig", true));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.JMS, WLS_JMS_ROOT, WLS_JMS_ROOT, "http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/90", ".", ".", "weblogic.j2ee.descriptor.wl.JMSBeanImpl", "weblogic.j2ee.descriptor.wl.JMSBeanImpl", "weblogic.j2ee.descriptor.wl.JMSBeanDConfig", true));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.JDBC, WLS_JDBC_ROOT, WLS_JDBC_ROOT, "http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/90", ".", ".", "weblogic.j2ee.descriptor.wl.JDBCDataSourceBeanImpl", "weblogic.j2ee.descriptor.wl.JDBCDataSourceBeanImpl", "weblogic.j2ee.descriptor.wl.JDBCDataSourceBeanDConfig", true));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.INTERCEPT, WLS_INTERCEPT_ROOT, WLS_INTERCEPT_ROOT, "http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/90", ".", ".", "weblogic.j2ee.descriptor.wl.InterceptionBeanImpl", "weblogic.j2ee.descriptor.wl.InterceptionBeanImpl", "weblogic.j2ee.descriptor.wl.InterceptionBeanDConfig", true));
            ddSupport.add(new DescriptorSupport(ModuleType.EJB, "weblogic-rdbms-jar", "weblogic-rdbms-jar", "http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/90", "META-INF/weblogic-cmp-rdbms-jar.xml", "META-INF/weblogic-cmp-rdbms-jar.xml", "weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicRdbmsJarBeanDConfig", false));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.WLDF, WLS_WLDF_ROOT, WLS_WLDF_ROOT, WLS_WLDF_NAMESPACE, WLS_WLDF_NAMESPACE, WLS_WLDF_URI, WLS_WLDF_URI, WLS_WLDF_BEAN_CLASS, WLS_WLDF_BEAN_CLASS, WLS_WLDF_DCONFIG_CLASS, false));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.WSEE, WSEE_ROOT, WLS_WSEE_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", WSEE_EJB_URI, WLS_WSEE_EJB_URI, "weblogic.j2ee.descriptor.WebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanDConfig", false));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.WSEE, WSEE_ROOT, WLS_WSEE_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", WSEE_WEB_URI, WLS_WSEE_WEB_URI, "weblogic.j2ee.descriptor.WebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanDConfig", false));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.WSEE, WSEE_ROOT_81, WLS_WSEE_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", WSEE_EJB_URI_81, WLS_WSEE_EJB_URI, "weblogic.j2ee.descriptor.WebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanDConfig", false));
            ddSupport.add(new DescriptorSupport(WebLogicModuleType.WSEE, WSEE_ROOT_81, WLS_WSEE_ROOT, "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", WSEE_WEB_URI_81, WLS_WSEE_WEB_URI, "weblogic.j2ee.descriptor.WebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanImpl", "weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanDConfig", false));
            DescriptorSupport descriptorSupport = new DescriptorSupport(WebLogicModuleType.WSEE, "webservice-policy-ref", "webservice-policy-ref", "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", WLS_WS_POLICY_EJB_URI, WLS_WS_POLICY_EJB_URI, "weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanImpl", "weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanImpl", "weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanDConfig", false);
            ddSupport.add(descriptorSupport);
            forceWrites.put(WLS_WS_POLICY_EJB_URI, descriptorSupport);
            descriptorSupport = new DescriptorSupport(WebLogicModuleType.WSEE, "webservice-policy-ref", "webservice-policy-ref", "http://java.sun.com/xml/ns/j2ee", "http://www.bea.com/ns/weblogic/90", WLS_WS_POLICY_WEB_URI, WLS_WS_POLICY_WEB_URI, "weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanImpl", "weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanImpl", "weblogic.j2ee.descriptor.wl.WebservicePolicyRefBeanDConfig", false);
            ddSupport.add(descriptorSupport);
            forceWrites.put(WLS_WS_POLICY_WEB_URI, descriptorSupport);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AssertionError((Object)exception.toString());
        }
    }

    public static DescriptorSupport getForceWriteDS(String string) {
        return (DescriptorSupport)forceWrites.get(string);
    }

    public static void registerWebLogicExtensions(WeblogicExtensionBean weblogicExtensionBean, String string) {
        block13: {
            if (weblogicExtensionBean == null) {
                return;
            }
            CustomModuleBean[] customModuleBeanArray = weblogicExtensionBean.getCustomModules();
            if (customModuleBeanArray == null) {
                return;
            }
            try {
                for (int i = 0; i < customModuleBeanArray.length; ++i) {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    CustomModuleBean customModuleBean = customModuleBeanArray[i];
                    ConfigurationSupportBean configurationSupportBean = customModuleBean.getConfigurationSupport();
                    if (configurationSupportBean == null) continue;
                    String string9 = configurationSupportBean.getBaseRootElement();
                    if (string9 == null && debug) {
                        Debug.say(SPIDeployerLogger.getMissingExt((String)string, (String)"base-root-element", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                    }
                    if ((string8 = configurationSupportBean.getConfigRootElement()) == null) {
                        string8 = string9;
                    }
                    if ((string7 = configurationSupportBean.getBaseNamespace()) == null && debug) {
                        Debug.say(SPIDeployerLogger.getMissingExt((String)string, (String)"base-namespace", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                    }
                    if ((string6 = configurationSupportBean.getConfigNamespace()) == null) {
                        string6 = string7;
                    }
                    if ((string5 = configurationSupportBean.getBaseUri()) == null && debug) {
                        Debug.say(SPIDeployerLogger.getMissingExt((String)string, (String)"base-uri", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                    }
                    if ((string4 = configurationSupportBean.getConfigUri()) == null) {
                        string4 = string5;
                    }
                    if ((string3 = configurationSupportBean.getBasePackageName()) == null && debug) {
                        Debug.say(SPIDeployerLogger.getMissingExt((String)string, (String)"base-package-name", (String)customModuleBean.getUri(), (String)customModuleBean.getProviderName()));
                    }
                    if ((string2 = configurationSupportBean.getConfigPackageName()) == null) {
                        string2 = string3;
                    }
                    SPIDeployerLogger.logAddDS((String)string5, (String)string4);
                    DescriptorSupportManager.add(WebLogicModuleType.CONFIG, string9, string8, string7, string6, string5, string4, string3, string2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!debug) break block13;
                Debug.say(illegalArgumentException.toString());
            }
        }
    }

    static {
        DescriptorSupportManager.initDescriptorSupport();
    }
}

