/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config.templates;

import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.WebLogicDConfigBean;
import weblogic.deploy.api.spi.config.BasicDConfigBean;
import weblogic.deploy.api.spi.config.BasicDConfigBeanRoot;
import weblogic.deploy.api.spi.config.DescriptorSupport;

public abstract class ConfigListener
implements PropertyChangeListener {
    protected static final boolean debug = Debug.isDebug("config");
    protected WebLogicDConfigBean dcb;
    protected BasicDConfigBeanRoot root;

    protected ConfigListener(WebLogicDConfigBean webLogicDConfigBean) {
        this.dcb = webLogicDConfigBean;
        BasicDConfigBean basicDConfigBean = (BasicDConfigBean)webLogicDConfigBean;
        while (basicDConfigBean.getParent() != null) {
            basicDConfigBean = basicDConfigBean.getParent();
        }
        this.root = (BasicDConfigBeanRoot)basicDConfigBean;
        if (debug) {
            Debug.say("root is " + this.root.toString());
        }
    }

    protected void addDCB(String string, DescriptorSupport descriptorSupport) {
        try {
            DDBeanRoot dDBeanRoot = this.root.getDDBean().getRoot().getDeployableObject().getDDBeanRoot(string);
            if (this.root.getDConfigBean(dDBeanRoot, descriptorSupport) == null && debug) {
                Debug.say("can't create dcb for dd at " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            SPIDeployerLogger.logNoDCB((String)string, (String)fileNotFoundException.getMessage());
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            SPIDeployerLogger.logDDCreateError((String)string);
        }
        catch (ConfigurationException configurationException) {
            SPIDeployerLogger.logNoDCB((String)string, (String)configurationException.getMessage());
        }
    }

    protected void removeDCB(String string) {
        block2: {
            try {
                DDBeanRoot dDBeanRoot = this.root.getDDBean().getRoot().getDeployableObject().getDDBeanRoot(string);
                this.root.getDeploymentConfiguration().removeDConfigBean((DConfigBeanRoot)this.root.getDConfigBean(dDBeanRoot));
            }
            catch (Exception exception) {
                if (!debug) break block2;
                exception.printStackTrace();
            }
        }
    }
}

