/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config.templates;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.DConfigBean;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.config.templates.ModuleListener;
import weblogic.deploy.api.spi.config.templates.TypeStorageListener;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.j2ee.descriptor.wl.AdminObjectGroupBean;
import weblogic.j2ee.descriptor.wl.AdminObjectsBean;
import weblogic.j2ee.descriptor.wl.ApplicationSecurityRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.EntityDescriptorBean;
import weblogic.j2ee.descriptor.wl.MessageDrivenDescriptorBean;
import weblogic.j2ee.descriptor.wl.PersistenceBean;
import weblogic.j2ee.descriptor.wl.PersistenceUseBean;
import weblogic.j2ee.descriptor.wl.SecurityBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBeanDConfig;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBeanDConfig;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBean;
import weblogic.j2ee.descriptor.wl.WeblogicEnterpriseBeanBeanDConfig;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;

public class ConfigTemplate {
    private static final boolean debug = Debug.isDebug("config");

    public static boolean requireEjbRefDConfig(DDBean dDBean, DConfigBean dConfigBean) {
        DDBean[] dDBeanArray;
        return !dDBean.getXpath().endsWith("ejb-ref") && !dDBean.getXpath().endsWith("ejb-local-ref") || (dDBeanArray = dDBean.getChildBean("ejb-link")) == null;
    }

    public static void configureSecurity(WeblogicApplicationBeanDConfig weblogicApplicationBeanDConfig) {
        DDBean dDBean;
        DDBean[] dDBeanArray;
        if (debug) {
            Debug.say("configuring ear security");
        }
        if ((dDBeanArray = (dDBean = weblogicApplicationBeanDConfig.getDDBean()).getChildBean(weblogicApplicationBeanDConfig.applyNamespace("security-role/role-name"))) == null) {
            return;
        }
        SecurityBean securityBean = weblogicApplicationBeanDConfig.getSecurity();
        WeblogicApplicationBean weblogicApplicationBean = (WeblogicApplicationBean)weblogicApplicationBeanDConfig.getDescriptorBean();
        if (securityBean == null) {
            if (debug) {
                Debug.say("Creating SecurityBean");
            }
            securityBean = weblogicApplicationBean.createSecurity();
        }
        ApplicationSecurityRoleAssignmentBean[] applicationSecurityRoleAssignmentBeanArray = securityBean.getSecurityRoleAssignments();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (applicationSecurityRoleAssignmentBeanArray != null) {
            for (int i = 0; i < applicationSecurityRoleAssignmentBeanArray.length; ++i) {
                arrayList.add(applicationSecurityRoleAssignmentBeanArray[i].getRoleName());
            }
        }
        for (int i = 0; i < dDBeanArray.length; ++i) {
            String string = ConfigHelper.getText(dDBeanArray[i]);
            if (debug) {
                Debug.say("Checking role, " + string);
            }
            if (arrayList.contains(string)) continue;
            if (debug) {
                Debug.say("Adding role, " + string);
            }
            ApplicationSecurityRoleAssignmentBean applicationSecurityRoleAssignmentBean = securityBean.createSecurityRoleAssignment();
            applicationSecurityRoleAssignmentBean.setRoleName(string);
        }
    }

    public static void configureEntityDescriptor(WeblogicEnterpriseBeanBeanDConfig weblogicEnterpriseBeanBeanDConfig) {
        DDBean dDBean;
        DDBean[] dDBeanArray;
        if (debug) {
            Debug.say("configuring ejb");
        }
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = (WeblogicEnterpriseBeanBean)weblogicEnterpriseBeanBeanDConfig.getDescriptorBean();
        DDBean dDBean2 = weblogicEnterpriseBeanBeanDConfig.getDDBean();
        if (dDBean2.getXpath().endsWith("entity") && (dDBeanArray = dDBean2.getChildBean(weblogicEnterpriseBeanBeanDConfig.applyNamespace("persistence-type"))) != null && "Container".equals(ConfigHelper.getText(dDBean = dDBeanArray[0]))) {
            PersistenceUseBean persistenceUseBean;
            PersistenceBean persistenceBean;
            EntityDescriptorBean entityDescriptorBean = weblogicEnterpriseBeanBeanDConfig.getEntityDescriptor();
            if (entityDescriptorBean == null) {
                entityDescriptorBean = weblogicEnterpriseBeanBean.createEntityDescriptor();
            }
            if ((persistenceBean = entityDescriptorBean.getPersistence()) == null) {
                persistenceBean = entityDescriptorBean.createPersistence();
            }
            if ((persistenceUseBean = persistenceBean.getPersistenceUse()) == null) {
                persistenceUseBean = persistenceBean.createPersistenceUse();
            }
            if (debug) {
                Debug.say("adding listener");
            }
            ((AbstractDescriptorBean)persistenceUseBean).addPropertyChangeListener((PropertyChangeListener)new TypeStorageListener(weblogicEnterpriseBeanBeanDConfig));
            if (persistenceUseBean.getTypeIdentifier() == null) {
                DDBean[] dDBeanArray2 = dDBean2.getChildBean(weblogicEnterpriseBeanBeanDConfig.applyNamespace("cmp-version"));
                String string = dDBeanArray2 == null ? "2.x" : ConfigHelper.getText(dDBeanArray2[0]);
                if (string.startsWith("2.")) {
                    if (persistenceUseBean.getTypeIdentifier() == null) {
                        persistenceUseBean.setTypeIdentifier("WebLogic_CMP_RDBMS");
                    }
                    if (persistenceUseBean.getTypeVersion() == null) {
                        persistenceUseBean.setTypeVersion("6.0");
                    }
                } else {
                    if (persistenceUseBean.getTypeIdentifier() == null) {
                        persistenceUseBean.setTypeIdentifier("WebLogic_CMP_RDBMS");
                    }
                    if (persistenceUseBean.getTypeVersion() == null) {
                        persistenceUseBean.setTypeVersion("5.1.0");
                    }
                }
            }
        }
    }

    public static void configureMessageDrivenDescriptor(WeblogicEnterpriseBeanBeanDConfig weblogicEnterpriseBeanBeanDConfig) {
        MessageDrivenDescriptorBean messageDrivenDescriptorBean;
        DDBean dDBean;
        DDBean[] dDBeanArray;
        if (debug) {
            Debug.say("configuring mdb");
        }
        WeblogicEnterpriseBeanBean weblogicEnterpriseBeanBean = (WeblogicEnterpriseBeanBean)weblogicEnterpriseBeanBeanDConfig.getDescriptorBean();
        DDBean dDBean2 = weblogicEnterpriseBeanBeanDConfig.getDDBean();
        if (dDBean2.getXpath().endsWith("message-driven") && (dDBeanArray = dDBean2.getChildBean(weblogicEnterpriseBeanBeanDConfig.applyNamespace("message-destination-type"))) != null && ("javax.jms.Queue".equals(ConfigHelper.getText(dDBean = dDBeanArray[0])) || "javax.jms.Topic".equals(ConfigHelper.getText(dDBean))) && (messageDrivenDescriptorBean = weblogicEnterpriseBeanBean.getMessageDrivenDescriptor()) == null) {
            messageDrivenDescriptorBean = weblogicEnterpriseBeanBean.createMessageDrivenDescriptor();
        }
    }

    public static void configureWeblogicApplication(WeblogicApplicationBeanDConfig weblogicApplicationBeanDConfig) {
        WeblogicApplicationBean weblogicApplicationBean;
        WeblogicModuleBean[] weblogicModuleBeanArray;
        if (debug) {
            Debug.say("configuring app");
        }
        if ((weblogicModuleBeanArray = (weblogicApplicationBean = (WeblogicApplicationBean)weblogicApplicationBeanDConfig.getDescriptorBean()).getModules()) != null) {
            for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
                ((AbstractDescriptorBean)weblogicModuleBeanArray[i]).addPropertyChangeListener((PropertyChangeListener)new ModuleListener(weblogicApplicationBeanDConfig));
            }
        }
    }

    public static void configureAdminObj(WeblogicConnectorBeanDConfig weblogicConnectorBeanDConfig) {
        DDBean dDBean;
        DDBean[] dDBeanArray;
        if (debug) {
            Debug.say("Configuring rar admin objects");
        }
        if ((dDBeanArray = (dDBean = weblogicConnectorBeanDConfig.getDDBean()).getChildBean(weblogicConnectorBeanDConfig.applyNamespace("connector/resourceadapter/adminobject/adminobject-interface"))) == null) {
            return;
        }
        AdminObjectsBean adminObjectsBean = weblogicConnectorBeanDConfig.getAdminObjects();
        WeblogicConnectorBean weblogicConnectorBean = (WeblogicConnectorBean)weblogicConnectorBeanDConfig.getDescriptorBean();
        if (adminObjectsBean == null) {
            if (debug) {
                Debug.say("Creating AdminOjbectsBean");
            }
            adminObjectsBean = weblogicConnectorBean.createAdminObjects();
        }
        AdminObjectGroupBean[] adminObjectGroupBeanArray = adminObjectsBean.getAdminObjectGroups();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < adminObjectGroupBeanArray.length; ++i) {
            arrayList.add(adminObjectGroupBeanArray[i].getAdminObjectInterface());
        }
        for (int i = 0; i < dDBeanArray.length; ++i) {
            String string = ConfigHelper.getText(dDBeanArray[i]);
            if (debug) {
                Debug.say("Checking interface, " + string);
            }
            if (arrayList.contains(string)) continue;
            if (debug) {
                Debug.say("Adding admin group for interface, " + string);
            }
            AdminObjectGroupBean adminObjectGroupBean = adminObjectsBean.createAdminObjectGroup();
            adminObjectGroupBean.setAdminObjectInterface(string);
        }
    }
}

