/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.config.templates;

import java.beans.PropertyChangeEvent;
import java.io.FileNotFoundException;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.config.DescriptorSupport;
import weblogic.deploy.api.spi.config.DescriptorSupportManager;
import weblogic.deploy.api.spi.config.templates.ConfigListener;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBeanDConfig;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;

public class ModuleListener
extends ConfigListener {
    private WeblogicModuleBean wmb = null;

    public ModuleListener(WeblogicApplicationBeanDConfig weblogicApplicationBeanDConfig) {
        super(weblogicApplicationBeanDConfig);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!"Path".equals(string)) {
            return;
        }
        this.wmb = (WeblogicModuleBean)propertyChangeEvent.getSource();
        if (debug) {
            Debug.say("caught update");
        }
        String string2 = (String)propertyChangeEvent.getOldValue();
        String string3 = (String)propertyChangeEvent.getNewValue();
        if (debug) {
            Debug.say("old: " + string2 + ", new: " + string3);
        }
        if (string2 != null) {
            this.removeDCB(string2);
        }
        if (string3 != null) {
            this.addDCB(string3, string);
        }
    }

    private void addDCB(String string, String string2) {
        try {
            DDBeanRoot dDBeanRoot = this.root.getDDBean().getRoot().getDeployableObject().getDDBeanRoot(string);
            DescriptorSupport descriptorSupport = null;
            if ("JDBC".equals(this.wmb.getType())) {
                descriptorSupport = DescriptorSupportManager.getForTag("jdbc-data-source");
            } else if ("JMS".equals(this.wmb.getType())) {
                descriptorSupport = DescriptorSupportManager.getForTag("weblogic-jms");
            } else if ("Interception".equals(this.wmb.getType())) {
                descriptorSupport = DescriptorSupportManager.getForTag("weblogic-interception");
            }
            if (descriptorSupport != null) {
                descriptorSupport.setBaseURI(string);
                descriptorSupport.setConfigURI(string);
                this.addDCB(string, descriptorSupport);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            SPIDeployerLogger.logMissingDD((String)string, (String)string2);
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            SPIDeployerLogger.logDDCreateError((String)string);
        }
    }
}

