/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTargetModuleID;
import weblogic.deploy.api.spi.deploy.ServerConnection;
import weblogic.deploy.api.spi.deploy.TargetImpl;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;

public class TargetModuleIDImpl
extends WebLogicTargetModuleID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROP = "Name";
    private static final String TARGET_PROP = "Target";
    private static final String TARGET_TYPE_PROP = "WebLogicTargetType";
    private static final String PARENT_PROP = "Application";
    private static final boolean debug = Debug.isDebug("deploy");
    private String name;
    private Target target;
    private WebLogicTargetModuleID parentTID = null;
    private List childTID = null;
    private transient WebLogicDeploymentManager manager;
    private Set servers = null;
    private boolean targeted = true;
    private Hashtable objectName;
    private String webURL;

    public TargetModuleIDImpl(String string, Target target, TargetModuleID targetModuleID, int n, DeploymentManager deploymentManager) throws IllegalArgumentException {
        super(n);
        this.name = string;
        if (string == null) {
            throw new AssertionError((Object)"No name for TargetModuleID");
        }
        this.target = target;
        this.parentTID = (WebLogicTargetModuleID)targetModuleID;
        this.manager = (WebLogicDeploymentManager)deploymentManager;
        this.objectName = this.setObjectName();
        if (this.parentTID != null) {
            ((TargetModuleIDImpl)this.parentTID).addChildTargetModuleID(this);
        }
    }

    public TargetModuleIDImpl(String string, Target target, TargetModuleID targetModuleID, ModuleType moduleType, DeploymentManager deploymentManager) throws IllegalArgumentException {
        this(string, target, targetModuleID, moduleType.getValue(), deploymentManager);
    }

    public TargetModuleID[] getChildTargetModuleID() {
        if (this.childTID == null || this.childTID.size() == 0) {
            return null;
        }
        return this.childTID.toArray(new TargetModuleID[this.childTID.size()]);
    }

    public Target getTarget() {
        return this.target;
    }

    public String getModuleID() {
        return this.name;
    }

    public String getWebURL() {
        return this.webURL;
    }

    public void setWebURL(String string) {
        this.webURL = string;
    }

    public String toString() {
        return this.objectName.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object instanceof TargetModuleID ? this.hashCode() == object.hashCode() : false;
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }

    public TargetModuleID getParentTargetModuleID() {
        return this.parentTID;
    }

    public String getApplicationName() {
        if (this.parentTID != null) {
            return this.parentTID.getApplicationName();
        }
        return ApplicationVersionUtils.getApplicationName(this.name);
    }

    public String getVersion() {
        if (this.parentTID != null) {
            return this.parentTID.getVersion();
        }
        return ApplicationVersionUtils.getVersionId(this.name);
    }

    public String getArchiveVersion() {
        if (this.parentTID != null) {
            return this.parentTID.getVersion();
        }
        return ApplicationVersionUtils.getArchiveVersion(this.getVersion());
    }

    public String getPlanVersion() {
        if (this.parentTID != null) {
            return this.parentTID.getVersion();
        }
        return ApplicationVersionUtils.getPlanVersion(this.getVersion());
    }

    public Target[] getServers() throws IllegalStateException {
        try {
            Set set = this.getServersForTarget();
            return set.toArray(new Target[set.size()]);
        }
        catch (ServerConnectionException serverConnectionException) {
            if (debug) {
                serverConnectionException.printStackTrace();
            }
            IllegalStateException illegalStateException = new IllegalStateException(SPIDeployerLogger.connectionError());
            illegalStateException.initCause(serverConnectionException.getRootCause());
            throw illegalStateException;
        }
    }

    public boolean isOnVirtualHost() {
        return ((TargetImpl)this.getTarget()).isVirtualHost();
    }

    public boolean isOnServer() {
        return ((TargetImpl)this.getTarget()).isServer();
    }

    public boolean isOnCluster() {
        return ((TargetImpl)this.getTarget()).isCluster();
    }

    public boolean isOnJMSServer() {
        return ((TargetImpl)this.getTarget()).isJMSServer();
    }

    public boolean isOnSAFAgent() {
        return ((TargetImpl)this.getTarget()).isSAFAgent();
    }

    public Set getServersForTarget() throws ServerConnectionException {
        if (this.servers == null) {
            this.setServersForTarget();
        }
        return this.servers;
    }

    void addChildTargetModuleID(TargetModuleID targetModuleID) {
        if (targetModuleID != null) {
            if (this.childTID == null) {
                this.childTID = new ArrayList();
            }
            this.childTID.add(targetModuleID);
        }
    }

    public WebLogicDeploymentManager getManager() {
        return this.manager;
    }

    public boolean isTargeted() {
        return this.targeted;
    }

    public void setTargeted(boolean bl) {
        this.targeted = bl;
    }

    private Hashtable setObjectName() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        if (this.name != null && this.name.length() > 0) {
            hashtable.put(NAME_PROP, this.name);
        }
        hashtable.put(TARGET_PROP, this.target.getName());
        hashtable.put(TARGET_TYPE_PROP, this.target.getDescription());
        if (this.parentTID != null) {
            hashtable.put(PARENT_PROP, this.parentTID.getModuleID());
        }
        return hashtable;
    }

    private void setServersForTarget() throws ServerConnectionException {
        this.servers = new HashSet();
        ServerConnection serverConnection = this.manager.getServerConnection();
        if (this.manager.isConnected()) {
            if (this.isOnServer()) {
                this.servers.add((TargetImpl)this.getTarget());
            } else if (this.isOnCluster()) {
                this.servers.addAll(serverConnection.getServersForCluster((TargetImpl)this.getTarget()));
            } else if (this.isOnVirtualHost()) {
                this.servers.addAll(serverConnection.getServersForHost((TargetImpl)this.getTarget()));
            } else if (this.isOnJMSServer()) {
                this.servers.addAll(serverConnection.getServersForJmsServer((TargetImpl)this.getTarget()));
            } else if (this.isOnSAFAgent()) {
                this.servers.addAll(serverConnection.getServersForSafAgent((TargetImpl)this.getTarget()));
            }
        }
        if (debug) {
            this.dumpServers();
        }
    }

    private void dumpServers() {
        try {
            Debug.say("Servers in target " + this.getTarget().getName() + ":");
            Iterator iterator = this.getServersForTarget().iterator();
            while (iterator.hasNext()) {
                Debug.say("   " + ((TargetImpl)iterator.next()).getName());
            }
        }
        catch (ServerConnectionException serverConnectionException) {
            serverConnectionException.printStackTrace();
        }
    }
}

