/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deploy.api.spi.deploy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import weblogic.deploy.api.internal.SPIDeployerLogger;
import weblogic.deploy.api.internal.utils.ConfigHelper;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.internal.utils.JMXDeployerHelper;
import weblogic.deploy.api.internal.utils.LocaleManager;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.shared.WebLogicTargetType;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.spi.WebLogicTargetModuleID;
import weblogic.deploy.api.spi.config.DeploymentConfigurationImpl;
import weblogic.deploy.api.spi.deploy.ServerConnection;
import weblogic.deploy.api.spi.deploy.TargetImpl;
import weblogic.deploy.api.spi.deploy.TargetModuleIDImpl;
import weblogic.deploy.api.spi.deploy.internal.ActivateOperation;
import weblogic.deploy.api.spi.deploy.internal.DeactivateOperation;
import weblogic.deploy.api.spi.deploy.internal.DeployOperation;
import weblogic.deploy.api.spi.deploy.internal.DistributeOperation;
import weblogic.deploy.api.spi.deploy.internal.DistributeStreamsOperation;
import weblogic.deploy.api.spi.deploy.internal.RedeployDeltaOperation;
import weblogic.deploy.api.spi.deploy.internal.RedeployOperation;
import weblogic.deploy.api.spi.deploy.internal.RedeployStreamsOperation;
import weblogic.deploy.api.spi.deploy.internal.RemoveOperation;
import weblogic.deploy.api.spi.deploy.internal.StartOperation;
import weblogic.deploy.api.spi.deploy.internal.StopOperation;
import weblogic.deploy.api.spi.deploy.internal.UndeployOperation;
import weblogic.deploy.api.spi.deploy.internal.UnprepareOperation;
import weblogic.deploy.api.spi.deploy.internal.UpdateOperation;
import weblogic.deploy.api.spi.exceptions.ServerConnectionException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;

public class WebLogicDeploymentManagerImpl
implements WebLogicDeploymentManager {
    private static final List DCONFIG_VERSIONS;
    private DConfigBeanVersionType dconfigVersion;
    private static final boolean debug;
    private String domain = "weblogic";
    private ServerConnection serverConnection;
    private boolean local;
    private boolean auth;
    private String taskId = null;
    public static final String PREFIX = "app";
    public static final String SUFFIX = ".zip";
    private URI saveUri;
    private String saveUser;
    private String saveClass;
    private String savePword;
    private Thread hook = null;
    private boolean releasing = false;

    public WebLogicDeploymentManagerImpl(String string) throws DeploymentManagerCreationException {
        String string2 = SPIDeployerLogger.noURI();
        if (string == null) {
            throw new DeploymentManagerCreationException(string2);
        }
        this.setCharacteristics(string);
        this.dconfigVersion = (DConfigBeanVersionType)DCONFIG_VERSIONS.get(DCONFIG_VERSIONS.size() - 1);
        if (debug) {
            Debug.say("Constructing DeploymentManager for J2EE version " + this.dconfigVersion.toString() + " deployments");
        }
    }

    public WebLogicDeploymentManagerImpl(String string, String string2, URI uRI, String string3, String string4) throws DeploymentManagerCreationException {
        this(string2);
        try {
            this.saveConnectionArgs(uRI, string3, string, string4);
            this.getNewConnection();
        }
        catch (ServerConnectionException serverConnectionException) {
            this.release();
            DeploymentManagerCreationException deploymentManagerCreationException = new DeploymentManagerCreationException(serverConnectionException.getMessage());
            deploymentManagerCreationException.initCause((Throwable)serverConnectionException);
            throw deploymentManagerCreationException;
        }
        catch (Throwable throwable) {
            this.serverConnection = null;
            if (debug) {
                if (throwable.getCause() != null) {
                    throwable.getCause().printStackTrace();
                } else {
                    throwable.printStackTrace();
                }
            }
            DeploymentManagerCreationException deploymentManagerCreationException = new DeploymentManagerCreationException(SPIDeployerLogger.noClass((String)string, (String)throwable.toString()));
            deploymentManagerCreationException.initCause(throwable);
            throw deploymentManagerCreationException;
        }
    }

    private void saveConnectionArgs(URI uRI, String string, String string2, String string3) {
        this.saveUri = uRI;
        this.saveUser = string;
        this.saveClass = string2;
        this.savePword = string3;
    }

    private void getNewConnection() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (debug) {
            Debug.say("Connecting to admin server at " + this.saveUri.getHost() + ":" + this.saveUri.getPort() + ", as user " + this.saveUser);
        }
        this.serverConnection = (ServerConnection)Class.forName(this.saveClass).newInstance();
        this.serverConnection.init(this.saveUri, this.saveUser, this.savePword, this);
        this.hook = new Thread(){

            public void run() {
                if (debug) {
                    Debug.say("Releasing connection due to user signal");
                }
                WebLogicDeploymentManagerImpl.this.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.hook);
    }

    private void shutdown() {
        try {
            this._release(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeHook() {
        try {
            if (this.hook != null) {
                Runtime.getRuntime().removeShutdownHook(this.hook);
            }
            this.hook = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Target getTarget(String string) throws IllegalStateException {
        return this.serverConnection.getTarget(string);
    }

    public final WebLogicTargetModuleID createTargetModuleID(String string, ModuleType moduleType, Target target) {
        ConfigHelper.checkParam("type", moduleType);
        return this.createTargetModuleID(string, moduleType.getValue(), target);
    }

    private final WebLogicTargetModuleID createTargetModuleID(String string, int n, Target target) {
        return new TargetModuleIDImpl(string, target, null, n, (DeploymentManager)this);
    }

    public final WebLogicTargetModuleID createTargetModuleID(TargetModuleID targetModuleID, String string, ModuleType moduleType) {
        WebLogicTargetModuleID webLogicTargetModuleID;
        ConfigHelper.checkParam("base", targetModuleID);
        ConfigHelper.checkParam("module", string);
        ConfigHelper.checkParam("type", moduleType);
        WebLogicTargetModuleID webLogicTargetModuleID2 = (WebLogicTargetModuleID)targetModuleID;
        while (webLogicTargetModuleID2.getParentTargetModuleID() != null) {
            webLogicTargetModuleID2 = (WebLogicTargetModuleID)webLogicTargetModuleID2.getParentTargetModuleID();
        }
        boolean bl = webLogicTargetModuleID2 == targetModuleID;
        webLogicTargetModuleID2 = this.createTargetModuleID(webLogicTargetModuleID2.getModuleID(), ((TargetModuleIDImpl)webLogicTargetModuleID2).getValue(), webLogicTargetModuleID2.getTarget());
        webLogicTargetModuleID2.setTargeted(false);
        if (!bl) {
            webLogicTargetModuleID = new TargetModuleIDImpl(targetModuleID.getModuleID(), targetModuleID.getTarget(), (TargetModuleID)webLogicTargetModuleID2, ((TargetModuleIDImpl)targetModuleID).getValue(), (DeploymentManager)this);
            webLogicTargetModuleID.setTargeted(false);
        } else {
            webLogicTargetModuleID = webLogicTargetModuleID2;
        }
        new TargetModuleIDImpl(string, webLogicTargetModuleID.getTarget(), (TargetModuleID)webLogicTargetModuleID, moduleType, (DeploymentManager)this);
        return webLogicTargetModuleID2;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public boolean isConnected() {
        try {
            this.testConnection();
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return this.serverConnection != null && !this.releasing;
    }

    public void enableFileUploads() throws IllegalStateException {
        this.checkConnection();
        if (this.local) {
            this.serverConnection.setRemote();
            this.local = false;
        }
    }

    private void checkConnection() throws IllegalStateException {
        if (this.serverConnection == null) {
            throw new IllegalStateException(SPIDeployerLogger.notConnected());
        }
        this.testConnection();
    }

    private void testConnection() throws IllegalStateException {
        if (this.serverConnection == null || this.releasing) {
            return;
        }
        try {
            this.serverConnection.test();
        }
        catch (Throwable throwable) {
            this.release();
            try {
                if (debug) {
                    Debug.say("Attempting to recover lost connection!!!");
                }
                this.getNewConnection();
            }
            catch (IllegalStateException illegalStateException) {
                this.release();
                throw illegalStateException;
            }
            catch (Throwable throwable2) {
                this.release();
                IllegalStateException illegalStateException = new IllegalStateException(SPIDeployerLogger.connectionError());
                illegalStateException.initCause(throwable2);
                throw illegalStateException;
            }
        }
    }

    public String getTaskId() {
        String string = this.taskId;
        this.taskId = null;
        return string;
    }

    public boolean isAuthenticated() {
        return this.auth;
    }

    public void setTaskId(String string) throws IllegalStateException {
        ConfigHelper.checkParam("id", string);
        this.checkConnection();
        this.taskId = string;
    }

    public TargetModuleID[] filter(TargetModuleID[] targetModuleIDArray, String string, String string2, String string3) {
        TargetModuleID targetModuleID;
        ConfigHelper.checkParam("modules", targetModuleIDArray);
        ConfigHelper.checkParam("appName", string);
        if (targetModuleIDArray == null) {
            return null;
        }
        HashSet<TargetModuleID> hashSet = new HashSet<TargetModuleID>();
        for (int i = 0; i < targetModuleIDArray.length; ++i) {
            targetModuleID = targetModuleIDArray[i];
            TargetModuleID targetModuleID2 = targetModuleID.getParentTargetModuleID();
            if (targetModuleID2 == null) {
                if (string2 != null || !targetModuleID.getModuleID().equals(string)) continue;
                hashSet.add(targetModuleID);
                continue;
            }
            if (!targetModuleID.getModuleID().equals(string2) || !string.equals(targetModuleID2.getModuleID())) continue;
            hashSet.add(targetModuleID);
        }
        if (string3 != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                targetModuleID = (TargetModuleID)iterator.next();
                if (string3.equals(((WebLogicTargetModuleID)targetModuleID).getVersion())) continue;
                iterator.remove();
            }
        }
        return hashSet.toArray(new TargetModuleID[0]);
    }

    public TargetModuleID[] getModules(ConfigurationMBean configurationMBean) throws IllegalStateException, IllegalArgumentException {
        ConfigHelper.checkParam("mbean", configurationMBean);
        this.checkConnection();
        try {
            return this.serverConnection.getModules(configurationMBean).toArray(new TargetModuleID[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public JMXDeployerHelper getHelper() {
        return this.serverConnection.getHelper();
    }

    public ServerConnection getServerConnection() {
        return this.serverConnection;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, String[] stringArray, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new RedeployDeltaOperation(this, targetModuleIDArray, file, stringArray, false, deploymentOptions).run();
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray, File file, String[] stringArray, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new RedeployDeltaOperation(this, targetModuleIDArray, file, stringArray, true, deploymentOptions).run();
    }

    public ProgressObject deploy(Target[] targetArray, File file, File file2, DeploymentOptions deploymentOptions) throws TargetException, IllegalStateException {
        return new DeployOperation((WebLogicDeploymentManager)this, targetArray, file, file2, deploymentOptions).run();
    }

    public ProgressObject deploy(TargetModuleID[] targetModuleIDArray, File file, File file2, DeploymentOptions deploymentOptions) throws TargetException, IllegalStateException {
        return new DeployOperation((WebLogicDeploymentManager)this, targetModuleIDArray, file, file2, deploymentOptions).run();
    }

    public ProgressObject update(TargetModuleID[] targetModuleIDArray, File file, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new UpdateOperation((WebLogicDeploymentManager)this, targetModuleIDArray, file, deploymentOptions).run();
    }

    public ProgressObject update(TargetModuleID[] targetModuleIDArray, File file, String[] stringArray, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new UpdateOperation((WebLogicDeploymentManager)this, targetModuleIDArray, file, stringArray, deploymentOptions).run();
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDArray, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new StartOperation(this, targetModuleIDArray, deploymentOptions).run();
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDArray, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new StopOperation(this, targetModuleIDArray, deploymentOptions).run();
    }

    public ProgressObject unprepare(TargetModuleID[] targetModuleIDArray, DeploymentOptions deploymentOptions) {
        return new UnprepareOperation(this, targetModuleIDArray, deploymentOptions).run();
    }

    public ProgressObject deactivate(TargetModuleID[] targetModuleIDArray, DeploymentOptions deploymentOptions) {
        return new DeactivateOperation(this, targetModuleIDArray, deploymentOptions).run();
    }

    public ProgressObject remove(TargetModuleID[] targetModuleIDArray, DeploymentOptions deploymentOptions) {
        return new RemoveOperation(this, targetModuleIDArray, deploymentOptions).run();
    }

    public ProgressObject activate(TargetModuleID[] targetModuleIDArray, File file, File file2, DeploymentOptions deploymentOptions) throws TargetException, IllegalStateException {
        return new ActivateOperation((WebLogicDeploymentManager)this, targetModuleIDArray, file, file2, deploymentOptions).run();
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new UndeployOperation(this, targetModuleIDArray, deploymentOptions).run();
    }

    public ProgressObject distribute(Target[] targetArray, File file, File file2, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new DistributeOperation((WebLogicDeploymentManager)this, targetArray, file, file2, deploymentOptions).run();
    }

    public ProgressObject distribute(TargetModuleID[] targetModuleIDArray, File file, File file2, DeploymentOptions deploymentOptions) throws IllegalStateException, TargetException {
        return new DistributeOperation((WebLogicDeploymentManager)this, targetModuleIDArray, file, file2, deploymentOptions).run();
    }

    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new DistributeStreamsOperation(this, targetArray, null, inputStream, inputStream2, deploymentOptions).run();
    }

    private ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2, DeploymentOptions deploymentOptions) throws IllegalStateException {
        return new DistributeStreamsOperation(this, targetArray, moduleType, inputStream, inputStream2, deploymentOptions).run();
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2, DeploymentOptions deploymentOptions) throws UnsupportedOperationException, IllegalStateException {
        return new RedeployOperation(this, targetModuleIDArray, file, file2, deploymentOptions).run();
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2, DeploymentOptions deploymentOptions) throws UnsupportedOperationException, IllegalStateException {
        return new RedeployStreamsOperation((WebLogicDeploymentManager)this, targetModuleIDArray, inputStream, inputStream2, deploymentOptions).run();
    }

    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        return this.distribute(targetArray, file, file2, new DeploymentOptions());
    }

    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.distribute(targetArray, inputStream, inputStream2, new DeploymentOptions());
    }

    public ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        ConfigHelper.checkParam("moduleType", moduleType);
        return this.distribute(targetArray, moduleType, inputStream, inputStream2, new DeploymentOptions());
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return this.start(targetModuleIDArray, new DeploymentOptions());
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return this.stop(targetModuleIDArray, new DeploymentOptions());
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        return this.undeploy(targetModuleIDArray, new DeploymentOptions());
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        return this.redeploy(targetModuleIDArray, file, file2, new DeploymentOptions());
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws UnsupportedOperationException, IllegalStateException {
        return this.redeploy(targetModuleIDArray, inputStream, inputStream2, new DeploymentOptions());
    }

    public Target[] getTargets() throws IllegalStateException {
        this.checkConnection();
        Target[] targetArray = this.serverConnection.getTargets().toArray(new Target[0]);
        if (targetArray.length == 0) {
            targetArray = null;
        }
        if (debug) {
            if (targetArray == null) {
                Debug.say("Return no targets");
            } else {
                for (int i = 0; i < targetArray.length; ++i) {
                    Target target = targetArray[i];
                    Debug.say("Return target " + target.getName());
                }
            }
        }
        return targetArray;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (debug) {
            Debug.say("getting all running modules of type " + moduleType);
        }
        return this.getModules(moduleType, targetArray, true);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (debug) {
            Debug.say("getting all nonrunning modules of type " + moduleType);
        }
        return this.getModules(moduleType, targetArray, false);
    }

    public TargetModuleID[] getModules(ModuleType moduleType, Target[] targetArray, boolean bl) throws TargetException, IllegalStateException {
        ConfigHelper.checkParam("moduleType", moduleType);
        ConfigHelper.checkParam("targetList", targetArray);
        this.checkConnection();
        TargetModuleID[] targetModuleIDArray = this.getAvailableModules(moduleType, targetArray);
        if (targetModuleIDArray != null) {
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList((Object[])targetModuleIDArray));
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                TargetModuleID targetModuleID = (TargetModuleID)iterator.next();
                if (bl == this.serverConnection.isRunning(targetModuleID)) continue;
                iterator.remove();
            }
            if (hashSet.isEmpty()) {
                return null;
            }
            this.dumpTmidSet(hashSet, bl);
            return hashSet.toArray(new TargetModuleID[0]);
        }
        return null;
    }

    private void dumpTmidSet(Set set, boolean bl) {
        if (debug) {
            Debug.say(bl ? "Running Modules" : "Nonrunning Modules");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Debug.say("   " + iterator.next());
            }
        }
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        ConfigHelper.checkParam("moduleType", moduleType);
        ConfigHelper.checkParam("targetList", targetArray);
        if (debug) {
            Debug.say("getting all available modules of type " + moduleType);
        }
        this.checkConnection();
        this.serverConnection.validateTargets(targetArray);
        List list = this.serverConnection.getModulesForTargets(moduleType, targetArray);
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new TargetModuleID[0]);
    }

    private Set getTargetNames(Target[] targetArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < targetArray.length; ++i) {
            hashSet.add(targetArray[i].getName());
        }
        return hashSet;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        ConfigHelper.checkParam("DeployableObject", deployableObject);
        try {
            return new DeploymentConfigurationImpl(deployableObject);
        }
        catch (IOException iOException) {
            InvalidModuleException invalidModuleException = new InvalidModuleException(SPIDeployerLogger.createError((String)deployableObject.toString()));
            invalidModuleException.initCause((Throwable)iOException);
            throw invalidModuleException;
        }
    }

    public void release() {
        this._release(false);
    }

    private synchronized void _release(boolean bl) {
        if (this.releasing) {
            return;
        }
        if (this.serverConnection != null) {
            this.releasing = true;
            this.serverConnection.close(bl);
        }
        this.releasing = false;
        this.serverConnection = null;
        this.removeHook();
    }

    public Locale getDefaultLocale() {
        return LocaleManager.getDefaultLocale();
    }

    public Locale getCurrentLocale() {
        return LocaleManager.getCurrentLocale();
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        ConfigHelper.checkParam("Locale", locale);
        LocaleManager.setLocale(locale);
        if (this.serverConnection != null) {
            try {
                this.serverConnection.setLocale(locale);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException);
            }
        }
        if (debug) {
            Debug.say("Changed locale to : " + locale.toString());
        }
    }

    public Locale[] getSupportedLocales() {
        return LocaleManager.getSupportedLocales();
    }

    public boolean isLocaleSupported(Locale locale) {
        ConfigHelper.checkParam("Locale", locale);
        return LocaleManager.isLocaleSupported(locale);
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return this.dconfigVersion;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        ConfigHelper.checkParam("DConfigBeanVersionType", dConfigBeanVersionType);
        return DCONFIG_VERSIONS.contains(dConfigBeanVersionType);
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        ConfigHelper.checkParam("DConfigBeanVersionType", dConfigBeanVersionType);
        if (this.isDConfigBeanVersionSupported(dConfigBeanVersionType)) {
            if (!this.dconfigVersion.equals(dConfigBeanVersionType)) {
                this.dconfigVersion = dConfigBeanVersionType;
            }
        } else {
            throw new DConfigBeanVersionUnsupportedException(SPIDeployerLogger.unsupportedVersion((String)dConfigBeanVersionType.toString()));
        }
    }

    private void setCharacteristics(String string) throws DeploymentManagerCreationException {
        if (string.equals("authenticated:deployer:WebLogic")) {
            this.local = true;
            this.auth = true;
        } else if (string.equals("deployer:WebLogic")) {
            this.local = true;
            this.auth = false;
        } else if (string.equals("remote:deployer:WebLogic")) {
            this.local = false;
            this.auth = false;
        } else {
            throw new DeploymentManagerCreationException(SPIDeployerLogger.getInvalidURI((String)string.toString()));
        }
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray, String string) {
        TargetMBean[] targetMBeanArray;
        ConfigHelper.checkParam("targetList", targetArray);
        ConfigHelper.checkParam("applicationName", string);
        if (this.serverConnection == null) {
            return null;
        }
        ArrayList<WebLogicTargetModuleID> arrayList = new ArrayList<WebLogicTargetModuleID>();
        AppRuntimeStateRuntimeMBean appRuntimeStateRuntimeMBean = this.serverConnection.getAppRuntimeStateRuntimeMBean();
        DomainMBean domainMBean = this.serverConnection.getDomainMBean();
        if (appRuntimeStateRuntimeMBean == null || domainMBean == null) {
            return null;
        }
        AppDeploymentMBean appDeploymentMBean = domainMBean.lookupAppDeployment(string);
        if (appDeploymentMBean == null) {
            appDeploymentMBean = domainMBean.lookupLibrary(string);
        }
        if (appDeploymentMBean == null) {
            return null;
        }
        String string2 = appDeploymentMBean.getModuleType();
        ModuleType moduleType2 = WebLogicModuleType.getTypeFromString(string2);
        if ((moduleType == null || moduleType2.getValue() == moduleType.getValue()) && (targetMBeanArray = appDeploymentMBean.getTargets()) != null && targetMBeanArray.length > 0) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                boolean bl = false;
                if (targetArray.length > 0) {
                    for (int j = 0; j < targetArray.length; ++j) {
                        if (!targetMBeanArray[i].getName().equals(targetArray[j].getName())) continue;
                        bl = true;
                    }
                }
                if (!bl) continue;
                String string3 = targetMBeanArray[i].getName();
                TargetImpl targetImpl = new TargetImpl(string3, this.getTypeForTarget(targetMBeanArray[i]), (DeploymentManager)this);
                WebLogicTargetModuleID webLogicTargetModuleID = this.createTargetModuleID(string, moduleType2, (Target)targetImpl);
                arrayList.add(webLogicTargetModuleID);
                String[] stringArray = appRuntimeStateRuntimeMBean.getModuleIds(string);
                if (stringArray == null || stringArray.length <= 0) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    String string4 = appRuntimeStateRuntimeMBean.getModuleType(string, stringArray[j]);
                    ModuleType moduleType3 = WebLogicModuleType.getTypeFromString(string4);
                    TargetModuleIDImpl targetModuleIDImpl = new TargetModuleIDImpl(stringArray[j], (Target)targetImpl, (TargetModuleID)webLogicTargetModuleID, moduleType3.getValue(), (DeploymentManager)this);
                }
            }
        }
        return arrayList.toArray(new TargetModuleID[0]);
    }

    private WebLogicTargetType getTypeForTarget(TargetMBean targetMBean) {
        if (targetMBean instanceof ServerMBean) {
            return WebLogicTargetType.SERVER;
        }
        if (targetMBean instanceof ClusterMBean) {
            return WebLogicTargetType.CLUSTER;
        }
        if (targetMBean instanceof VirtualHostMBean) {
            return WebLogicTargetType.VIRTUALHOST;
        }
        if (targetMBean instanceof JMSServerMBean) {
            return WebLogicTargetType.JMSSERVER;
        }
        if (targetMBean instanceof SAFAgentMBean) {
            return WebLogicTargetType.SAFAGENT;
        }
        return null;
    }

    static {
        debug = Debug.isDebug("deploy");
        DCONFIG_VERSIONS = Arrays.asList((Object[])new DConfigBeanVersionType[]{DConfigBeanVersionType.V1_4});
    }
}

